/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.utils;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.cpd.IncludeExclude;
import com.oracle.cie.gdr.dao.cpd.Selection;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.services.PlatformService;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class StagingFileFilter
implements DirectoryStream.Filter<Path> {
    private List<IncludeExclude> _includes;
    private List<IncludeExclude> _excludes;

    public StagingFileFilter(StagingFileFilter parentFilter, List<IncludeExclude> includes, List<IncludeExclude> excludes) {
        if (parentFilter != null) {
            this._includes = new ArrayList<IncludeExclude>(parentFilter.getIncludes());
            this._excludes = new ArrayList<IncludeExclude>(parentFilter.getExcludes());
        } else {
            this._includes = new ArrayList<IncludeExclude>();
            this._excludes = new ArrayList<IncludeExclude>();
        }
        if (includes != null) {
            this._includes.addAll(includes);
        }
        if (excludes != null) {
            this._excludes.addAll(excludes);
        }
    }

    public List<IncludeExclude> getExcludes() {
        return this._excludes;
    }

    public List<IncludeExclude> getIncludes() {
        return this._includes;
    }

    @Override
    public boolean accept(Path file) {
        List<IncludeExclude> includes = this.getIncludes();
        List<IncludeExclude> excludes = this.getExcludes();
        return StagingFileFilter.accept(file, includes, excludes);
    }

    public static boolean accept(Path file, List<? extends Selection> includes, List<? extends Selection> excludes) {
        boolean emptyExcludes;
        boolean emptyIncludes = includes == null || includes.isEmpty();
        boolean bl = emptyExcludes = excludes == null || excludes.isEmpty();
        if (emptyIncludes && emptyExcludes) {
            return true;
        }
        boolean isDir = Files.isDirectory(file, new LinkOption[0]);
        String name = file.getFileName().toString();
        boolean included = true;
        if (!emptyIncludes) {
            included = isDir;
            for (Selection selection : includes) {
                if (isDir && !selection.isMatchDirs()) continue;
                if (selection.isMatchPath()) {
                    name = file.toString().replace("\\", "/");
                }
                if (selection.matches(name)) {
                    included = true;
                    break;
                }
                if (!isDir) continue;
                included = false;
            }
        }
        if (included && !emptyExcludes) {
            for (Selection selection : excludes) {
                boolean osFamilySet;
                if (isDir && !selection.isMatchDirs()) continue;
                if (selection.isMatchPath()) {
                    name = file.toString().replace("\\", "/");
                }
                boolean bl2 = osFamilySet = selection instanceof IncludeExclude && !StringUtil.isNullOrEmpty((String)((IncludeExclude)selection).getOsFamily());
                if (!selection.matches(name) || osFamilySet) continue;
                included = false;
                break;
            }
        }
        return included;
    }

    public boolean isEmpty() {
        return this.getIncludes().isEmpty() && this.getExcludes().isEmpty();
    }

    public String getOsFamily(File file) {
        return this.getOsFamily(NioHelper.getInstance().getPath(file));
    }

    public String getOsFamily(Path file) {
        String name = file.getFileName().toString();
        if (name.equals("")) {
            return null;
        }
        List<IncludeExclude> includes = this.getIncludes();
        List<IncludeExclude> excludes = this.getExcludes();
        if ((includes == null || includes.isEmpty()) && (excludes == null || excludes.isEmpty())) {
            return null;
        }
        String osFamily = null;
        if (includes != null && !includes.isEmpty()) {
            for (IncludeExclude include : includes) {
                if (StringUtil.isNullOrEmpty((String)include.getOsFamily()) || !include.matches(name)) continue;
                osFamily = include.getOsFamily();
                break;
            }
        }
        if (excludes != null && !excludes.isEmpty()) {
            for (IncludeExclude exclude : excludes) {
                if (StringUtil.isNullOrEmpty((String)exclude.getOsFamily()) || !exclude.matches(name)) continue;
                osFamily = exclude.getOsFamily();
                if (PlatformService.OsFamily.windows == PlatformService.OsFamily.valueOf(osFamily)) {
                    osFamily = PlatformService.OsFamily.unix.name();
                    break;
                }
                osFamily = PlatformService.OsFamily.windows.name();
                break;
            }
        }
        return osFamily;
    }
}

