/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.tools;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.ConsistentProperties;
import com.oracle.cie.nextgen.common.utils.JavaHomeException;
import com.oracle.cie.nextgen.common.utils.JavaHomeHelper;
import com.oracle.cie.nextgen.common.utils.UtilityOps;
import com.oracle.cie.nextgen.common.version.VersionHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Logger;

public class NextGenPropertiesManager {
    private static NextGenPropertiesManager _instance = new NextGenPropertiesManager();
    public static final String PROPERTIES_FILE_NAME = ".globalEnv.properties";
    public static String PROPERTIES_DIRECTORY = "oui";
    private static final String JAVA_HOME_PROP_NAME = "JAVA_HOME";
    private static final String JVM_64_PROP_NAME = "JVM_64";
    private static final String[][] UNSUPPORTED_CHARACTERS = new String[][]{{"=", "\n", "\r"}, {"=", "\\n", "\\r"}};
    private ConsistentProperties _properties;
    private static final String LOG_PROTECTED_VALUE = "<secure value>";
    private String _oraHomePath;
    private Path _propertiesFile;
    private boolean _isPropertiesLoaded = false;
    private static final Logger _log = Logger.getLogger(NextGenPropertiesManager.class.getName());

    private NextGenPropertiesManager() {
    }

    public static synchronized NextGenPropertiesManager getInstance() {
        if (null == _instance) {
            _instance = new NextGenPropertiesManager();
        }
        return _instance;
    }

    public String getVariable(String variable, String oraHome) {
        this.setOraHomePath(oraHome);
        return this.getVariable(variable);
    }

    public String getVariable(String variable) {
        String value = "";
        if (this.isPropertiesFileLoaded()) {
            value = this._properties.getProperty(variable);
        }
        return value != null ? value : "";
    }

    public void addVariable(String variable, String value, String oraHome) throws UnsupportedCharacterException {
        this.addVariable(variable, value, oraHome, false);
    }

    public void addVariable(String variable, String value, String oraHome, boolean secure) throws UnsupportedCharacterException {
        this.setOraHomePath(oraHome);
        this.addVariable(variable, value, secure);
    }

    public void addVariable(String variable, String value) throws UnsupportedCharacterException {
        this.addVariable(variable, value, false);
    }

    public void addVariable(String variable, String value, boolean secure) throws UnsupportedCharacterException {
        this.validate(value);
        if (this.isPropertiesFileLoaded(true)) {
            String prevValue = (String)this._properties.setProperty(variable, value);
            this.savePropertiesFile();
            if (secure) {
                value = LOG_PROTECTED_VALUE;
                if (prevValue != null) {
                    prevValue = LOG_PROTECTED_VALUE;
                }
            }
            if (prevValue != null) {
                _log.fine("Replacing " + variable + "=" + prevValue);
                _log.fine("New value " + variable + "=" + value);
            } else {
                _log.fine("Adding " + variable + "=" + value);
            }
        }
    }

    private void validate(String value) throws UnsupportedCharacterException {
        if (value == null) {
            return;
        }
        String unsupportedCharacters = "";
        int charsCount = 0;
        for (int i = 0; i < UNSUPPORTED_CHARACTERS[0].length; ++i) {
            if (!value.contains(UNSUPPORTED_CHARACTERS[0][i])) continue;
            unsupportedCharacters = unsupportedCharacters + UNSUPPORTED_CHARACTERS[1][i] + " ";
            ++charsCount;
        }
        if (charsCount > 0) {
            throw new UnsupportedCharacterException("Unsupported characters \"" + unsupportedCharacters + "\"  in variable value \"" + value + "\"");
        }
    }

    public void deleteVariable(String variable, String oraHome) {
        this.deleteVariable(variable, oraHome, false);
    }

    public void deleteVariable(String variable, String oraHome, boolean secure) {
        this.setOraHomePath(oraHome);
        this.deleteVariable(variable, secure);
    }

    public void deleteVariable(String variable) {
        this.deleteVariable(variable, false);
    }

    public void deleteVariable(String variable, boolean secure) {
        if (this.isPropertiesFileLoaded()) {
            if (this._properties.getProperty(variable) != null) {
                String value = (String)this._properties.remove(variable);
                this.savePropertiesFile();
                if (secure) {
                    value = LOG_PROTECTED_VALUE;
                }
                _log.fine("Variable " + variable + "=" + value + " was deleted");
                if (this._properties.isEmpty()) {
                    this.deletePropertiesFile();
                }
            } else {
                _log.fine("The variable " + variable + " doesn't exist in properties file: " + this._propertiesFile);
            }
        }
    }

    private void deletePropertiesFile() {
        boolean deleted = false;
        try {
            deleted = Files.deleteIfExists(this._propertiesFile);
        }
        catch (IOException e) {
            _log.fine("An exception occurred while deleting properties file: " + this._propertiesFile);
        }
        if (deleted) {
            _log.fine("Deleting properties file: " + this._propertiesFile);
            this._isPropertiesLoaded = false;
        } else {
            _log.fine("An exception occurred while deleting properties file: " + this._propertiesFile);
        }
    }

    private void savePropertiesFile() {
        try (OutputStream os = Files.newOutputStream(this._propertiesFile, new OpenOption[0]);){
            this._properties.store(os, "This file is automatically generated", UtilityOps.getStoredSessionTimeStampCalendar().getTime());
            os.flush();
        }
        catch (IOException e) {
            _log.fine("An exception occurred while saving properties file: " + this._propertiesFile);
        }
    }

    private boolean createPropertiesFile() throws IOException {
        if (this._propertiesFile == null) {
            _log.severe("_propertiesFile is null");
            throw new IOException(new IllegalStateException("_propertiesFile is null"));
        }
        if (Files.exists(this._propertiesFile, new LinkOption[0])) {
            return true;
        }
        Path parentDir = this._propertiesFile.getParent();
        Files.createDirectories(parentDir, new FileAttribute[0]);
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(this._propertiesFile, StandardCharsets.UTF_8, StandardOpenOption.CREATE);){
            _log.fine("Creating properties file: " + this._propertiesFile);
        }
        return Files.exists(this._propertiesFile, new LinkOption[0]);
    }

    private boolean loadPropertiesFile() throws IOException {
        boolean loaded = false;
        if (Files.exists(this._propertiesFile, new LinkOption[0])) {
            _log.fine("Loading properties file: " + this._propertiesFile);
            this._properties = new ConsistentProperties();
            try (InputStream fis = Files.newInputStream(this._propertiesFile, new OpenOption[0]);){
                this._properties.load(fis);
                loaded = true;
            }
        }
        return loaded;
    }

    private boolean isPropertiesFileLoaded() {
        return this.isPropertiesFileLoaded(false);
    }

    private boolean isPropertiesFileLoaded(boolean createProperties) {
        if (this._propertiesFile == null) {
            _log.severe("_propertiesFile is null");
            return false;
        }
        try {
            if (!Files.exists(this._propertiesFile, new LinkOption[0])) {
                if (createProperties) {
                    this.createPropertiesFile();
                } else {
                    this._isPropertiesLoaded = false;
                }
            }
            if (Files.exists(this._propertiesFile, new LinkOption[0]) && !this._isPropertiesLoaded) {
                this._isPropertiesLoaded = this.loadPropertiesFile();
            }
        }
        catch (IOException e) {
            _log.fine("Properties file: " + this._propertiesFile + " doesn't exist or is not readable.");
        }
        return this._isPropertiesLoaded;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected String getOraHomePath() {
        return this._oraHomePath;
    }

    protected void setOraHomePath(String oraHomePath) {
        if (StringUtil.isNullOrEmpty((String)this._oraHomePath) || !this._oraHomePath.equals(oraHomePath)) {
            _log.fine("Oracle Home: " + oraHomePath);
            this._oraHomePath = oraHomePath;
            this._propertiesFile = NioHelper.getInstance().getPath(this._oraHomePath + File.separator + PROPERTIES_DIRECTORY + File.separator + PROPERTIES_FILE_NAME, new String[0]);
            _log.fine("Properties file: " + this._propertiesFile);
        }
    }

    public String updateJavaHome(String variable, String value, boolean force) throws UnsupportedCharacterException, JavaHomeException {
        String oldVal = this.getVariable(variable);
        try {
            value = JavaHomeHelper.getValidJavaHomeUpdateCandidate((String)variable, (String)oldVal, (String)value, (String)this._oraHomePath);
            this.addVariable(variable, value);
        }
        catch (JavaHomeException e) {
            if (force) {
                _log.warning("Value " + value + " is not valid semantically but setting it anyway because -force is specified");
                this.addVariable(variable, value);
            }
            throw e;
        }
        return value;
    }

    public void populateGlobalEnvPropertiesWithJavaHome(String javaHome, String oraHome) throws UnsupportedCharacterException {
        String javaHomePropVal = this.getVariable(JAVA_HOME_PROP_NAME, oraHome);
        if (StringUtil.isNullOrEmpty((String)javaHomePropVal) || !javaHomePropVal.equals(javaHome)) {
            this.addVariable(JAVA_HOME_PROP_NAME, javaHome, oraHome);
        }
        String fullJavaVersion = JavaHomeHelper.getVersionOfJavaHome((String)javaHome);
        _log.fine("fullJavaVersion=" + fullJavaVersion);
        if (!StringUtil.isNullOrEmpty((String)fullJavaVersion)) {
            String versionPrefix = VersionHelper.getVersionPrefix((String)fullJavaVersion, (int)2);
            _log.fine("versionPrefix=" + versionPrefix);
            if (!StringUtil.isNullOrEmpty((String)versionPrefix)) {
                String javaHomeMajorMinorPropName = "JAVA_HOME_" + versionPrefix.replace('.', '_');
                _log.fine("javaHomeMajorMinorPropName=" + javaHomeMajorMinorPropName);
                String javaHomeMajorMinorPropVal = this.getVariable(javaHomeMajorMinorPropName, oraHome);
                if (StringUtil.isNullOrEmpty((String)javaHomeMajorMinorPropVal) || !javaHomeMajorMinorPropVal.equals(javaHome)) {
                    this.addVariable(javaHomeMajorMinorPropName, javaHome, oraHome);
                }
            }
        }
    }

    public void populateGlobalEnvPropertiesWithJVM64(String jvmD64Flag, String oraHome) throws UnsupportedCharacterException {
        this.addVariable(JVM_64_PROP_NAME, jvmD64Flag, oraHome);
    }

    public class UnsupportedCharacterException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UnsupportedCharacterException() {
        }

        public UnsupportedCharacterException(Throwable cause) {
            super(cause);
        }

        public UnsupportedCharacterException(String message) {
            super(message);
        }

        public UnsupportedCharacterException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

