/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.tools;

import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.util.FileCopy;
import com.oracle.cie.common.util.IOUtil;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.DistributionLoader;
import com.oracle.cie.gdr.DistributionLoaderFactory;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.dao.cmn.QuickReference;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.Components;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.lbm.ComponentMapping;
import com.oracle.cie.gdr.dao.lbm.LabelMap;
import com.oracle.cie.gdr.dao.lbm.LabelMapReference;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.ComponentInfoHelper;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.DistributionInfoHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.LabelMapHelper;
import com.oracle.cie.gdr.services.FileLocatorService;
import com.oracle.cie.gdr.services.TopLevelDirectoryService;
import com.oracle.cie.gdr.tools.GdrLabelPromoterException;
import com.oracle.cie.gdr.tools.GdrMetaDataValidator;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class GdrLabelPromoter {
    private static final Logger _log = Logger.getLogger(GdrLabelPromoter.class.getName());
    public static final String PROMOTION_DIRECTORY = "promotion";
    public static final String DISTRIBUTIONS_PROPERTY = "promotion.distributions";
    public static final String CHOICE_FEATURES_PROPERTY = "promotion.choice.feature.names";
    public static final String BUG_ID_PROPERTY = "bug.id";
    private static final int DEFAULT_EXEC_TIMEOUT = Integer.getInteger("GdrLabelPromoter.default.exec.timeout", 1800) * 1000;
    private File _gdrMetaDataHome;
    private String _promotionName;
    private File _promotionPropertiesFile;
    private File _promotionLogFile;
    private Collection<String> _choicePermittedFeatures;
    private String _bugId;
    private File _prodDir;
    private File _devDir;
    private List<DistributionLoader> _distributionLoaders;
    private LabelMap _devLabelMap;
    private LabelMap _prodLabelMap;
    private Map<File, String> _validationFailures;
    private int _execTimeout = DEFAULT_EXEC_TIMEOUT;

    public static void main(String[] args) {
        File dir = null;
        boolean dryRun = true;
        String promotionName = null;
        Integer execTimeout = null;
        if (args.length != 4 && args.length != 6) {
            GdrLabelPromoter.printUsage("Invalid command line arguments.");
        }
        for (int x = 0; x < args.length; ++x) {
            if (args[x].equals("-dir")) {
                dir = new File(args[++x]);
                continue;
            }
            if (args[x].equals("-name")) {
                promotionName = args[++x];
                continue;
            }
            if (args[x].equals("-dryRun")) {
                dryRun = !"false".equalsIgnoreCase(args[++x]);
                continue;
            }
            if (args[x].equals("-execTimeout")) {
                execTimeout = new Integer(args[++x]);
                continue;
            }
            GdrLabelPromoter.printUsage("Invalid command line argument: " + args[x]);
        }
        if (dir == null) {
            GdrLabelPromoter.printUsage("The \"-dir\" argument is required.");
        }
        if (StringUtil.isNullOrEmpty(promotionName, (boolean)true)) {
            GdrLabelPromoter.printUsage("The \"-name\" argument is required.");
        }
        try {
            GdrLabelPromoter promoter = new GdrLabelPromoter(dir, promotionName);
            if (execTimeout != null) {
                promoter.setExecTimeout(execTimeout);
            }
            promoter.promote(dryRun);
        }
        catch (GdrLabelPromoterException e) {
            if (e.isValidationException()) {
                System.out.println(e.getMessage());
            } else {
                e.printStackTrace();
            }
            System.exit(-1);
        }
    }

    public static void printUsage(String message) {
        if (!StringUtil.isNullOrEmpty((String)message, (boolean)true)) {
            System.out.println(message);
        }
        System.out.println("Usage: " + GdrLabelPromoter.class.getName() + "-dir <gdr-metadata-dir> -name <promotion-name> -dryRun <true/false>");
        System.exit(1);
    }

    public GdrLabelPromoter(File gdrMetaDataHome, String promotionName) throws GdrLabelPromoterException {
        LogManager.getLogManager().reset();
        Logger logger = Logger.getLogger("com.oracle.cie");
        logger.setLevel(Level.FINEST);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.parse(System.getProperty("GdrLabelPromoter.logLevel", "INFO")));
        logger.addHandler(consoleHandler);
        this._gdrMetaDataHome = gdrMetaDataHome;
        if (this._gdrMetaDataHome == null) {
            throw new GdrLabelPromoterException("The GDR meta-data home directory specified was null.");
        }
        if (!this._gdrMetaDataHome.isDirectory()) {
            throw new GdrLabelPromoterException("The GDR meta-data home directory specified did not exit or was not a directory.");
        }
        if (StringUtil.isNullOrEmpty((String)promotionName, (boolean)true)) {
            throw new GdrLabelPromoterException("The promotion name specified was or empty.");
        }
        this._promotionName = promotionName;
        this._prodDir = new File(this._gdrMetaDataHome, "prod");
        this._devDir = new File(this._gdrMetaDataHome, "dev");
        if (!this._prodDir.exists() && !this._devDir.exists()) {
            throw new GdrLabelPromoterException("The GDR meta-data directory was invalid.  Unable to locate \"prod\" or \"dev\" in root dir " + this._gdrMetaDataHome);
        }
        this._promotionLogFile = new File(this._prodDir, PROMOTION_DIRECTORY + File.separator + this._promotionName + ".log");
        this._promotionLogFile.getParentFile().mkdirs();
        try {
            FileHandler fileHandler = new FileHandler(this._promotionLogFile.getPath());
            fileHandler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return new Date() + " " + record.getLevel() + " " + record.getSourceClassName() + " " + record.getSourceMethodName() + " - " + record.getMessage() + "\n";
                }
            });
            fileHandler.setLevel(Level.parse(System.getProperty("GdrLabelPromoter.logFileLevel", "FINER")));
            logger.addHandler(fileHandler);
        }
        catch (IOException e) {
            throw new GdrLabelPromoterException("Failed to configure logging to " + this._promotionLogFile, e);
        }
        if (_log.isLoggable(Level.FINE)) {
            _log.fine("Using GDR meta-data home " + gdrMetaDataHome);
        }
        if (_log.isLoggable(Level.FINE)) {
            _log.fine("Using promotion name " + promotionName);
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Using prod directory " + this._prodDir);
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Using dev directory " + this._devDir);
        }
        this._promotionPropertiesFile = new File(this._devDir, PROMOTION_DIRECTORY + File.separator + this._promotionName + ".properties");
        if (!this._promotionPropertiesFile.exists() || !this._promotionPropertiesFile.isFile()) {
            throw new GdrLabelPromoterException("The promotion properties file did not exist " + this._promotionPropertiesFile);
        }
        this.loadMetaData();
    }

    public int getExecTimeout() {
        return this._execTimeout;
    }

    public void setExecTimeout(int execTimeout) {
        this._execTimeout = execTimeout;
    }

    public Map<File, String> getValidationFailures() {
        return this._validationFailures;
    }

    public void loadMetaData() throws GdrLabelPromoterException {
        Properties properties = new Properties();
        try {
            if (_log.isLoggable(Level.FINE)) {
                _log.fine("Loading promotion properties file " + this._promotionPropertiesFile);
            }
            FileInputStream fis = new FileInputStream(this._promotionPropertiesFile);
            properties.load(fis);
            fis.close();
        }
        catch (IOException e) {
            throw new GdrLabelPromoterException("Error loading the promotion properties file " + this._promotionPropertiesFile);
        }
        String property = properties.getProperty(DISTRIBUTIONS_PROPERTY);
        if (_log.isLoggable(Level.FINEST)) {
            _log.finest("Using \"promotion.distributions\" property value " + property);
        }
        if (StringUtil.isNullOrEmpty((String)property, (boolean)true)) {
            throw new GdrLabelPromoterException("The promotion properties file is missing the required property \"promotion.distributions\" : " + this._promotionPropertiesFile);
        }
        String[] split = property.split(",");
        Reference[] distributionRefs = new Reference[split.length];
        int y = 0;
        for (String s : split) {
            String[] nameVersion = s.split(":");
            if (nameVersion.length != 2) {
                throw new GdrLabelPromoterException("The \"promotion.distributions\" property value specified was incorrectly formatted." + property);
            }
            distributionRefs[y++] = new QuickReference(nameVersion[0].trim(), nameVersion[1].trim());
        }
        property = properties.getProperty(CHOICE_FEATURES_PROPERTY);
        if (_log.isLoggable(Level.FINEST)) {
            _log.finest("Using \"promotion.choice.feature.names\" property value " + property);
        }
        if (!StringUtil.isNullOrEmpty((String)property, (boolean)true)) {
            this._choicePermittedFeatures = new ArrayList<String>();
            for (String s : split = property.split(",")) {
                this._choicePermittedFeatures.add(s.trim());
            }
        }
        this._bugId = properties.getProperty(BUG_ID_PROPERTY);
        if (StringUtil.isNullOrEmpty((String)this._bugId, (boolean)true)) {
            _log.warning("The \"bug.id\" property was not provided for use when beginning the transaction.");
        } else if (_log.isLoggable(Level.FINEST)) {
            _log.finest("Using \"bug.id\" property value " + this._bugId);
        }
        if (distributionRefs == null || distributionRefs.length < 1) {
            throw new GdrLabelPromoterException("No distribution references were specified.");
        }
        ArrayList<File> gdrOnlyLocations = new ArrayList<File>();
        gdrOnlyLocations.add(this._prodDir);
        gdrOnlyLocations.add(this._devDir);
        FileLocatorService fileLocatorService = DistributionHelper.getInstance().getFileLocatorService(this._gdrMetaDataHome);
        fileLocatorService.setLocations(gdrOnlyLocations);
        try {
            MetaDataHome metaDataHome = new MetaDataHome(this._gdrMetaDataHome);
            ArrayList<Distribution> distributions = new ArrayList<Distribution>();
            for (String string : distributionRefs) {
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Loading distribution definition for " + string);
                }
                Distribution distribution = DistributionHelper.getInstance().getDistribution(this._gdrMetaDataHome, ((Reference)((Object)string)).getName(), ((Reference)((Object)string)).getVersion());
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Loaded distribution definition for " + distribution + " from " + distribution.getDistributionFileLocation());
                }
                distributions.add(distribution);
            }
            this._distributionLoaders = new ArrayList<DistributionLoader>();
            for (Distribution distribution : distributions) {
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Creating distribution loader for " + distribution);
                }
                DistributionLoader distributionLoader = DistributionLoaderFactory.getDistributionLoader(metaDataHome, distribution);
                this._distributionLoaders.add(distributionLoader);
            }
            File labelMapFile = new File(this._devDir, LabelMapHelper.getInstance().getPath() + File.separator + "label-map.xml");
            this._devLabelMap = LabelMapHelper.getInstance().getRootWrapper(labelMapFile);
            labelMapFile = new File(this._prodDir, LabelMapHelper.getInstance().getPath() + File.separator + "label-map.xml");
            if (labelMapFile.exists()) {
                this._prodLabelMap = LabelMapHelper.getInstance().getRootWrapper(labelMapFile);
            } else {
                this._prodLabelMap = (LabelMap)LabelMapHelper.getInstance().getRootWrapper();
                this._prodLabelMap.setLabelMapLocation(labelMapFile);
            }
        }
        catch (Exception e) {
            throw new GdrLabelPromoterException(e);
        }
    }

    public void promote(boolean dryRun) throws GdrLabelPromoterException {
        this.promote(dryRun, false);
    }

    public void promote(boolean dryRun, boolean testRun) throws GdrLabelPromoterException {
        try {
            File prodFile;
            Object resourceProdJar;
            File devLocation;
            File prodLocation;
            this.invokeCommand(testRun, "ade", "pwv");
            LinkedHashMap<File, File> filesToPromote = new LinkedHashMap<File, File>();
            LinkedHashMap<File, Object> filesToCopy = new LinkedHashMap<File, Object>();
            LinkedHashMap<Object, Object> dirsToPromote = new LinkedHashMap<Object, Object>();
            LinkedHashSet<FeatureSet> features = new LinkedHashSet<FeatureSet>();
            for (DistributionLoader distributionLoader : this._distributionLoaders) {
                File prodLocation2 = new File(this._prodDir, DistributionHelper.getInstance().getPath() + File.separator + DistributionHelper.getInstance().getDistributionFileName(distributionLoader.getDistributionName(), distributionLoader.getDistributionVersion()));
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Checking prod area for distribution definition " + distributionLoader + " at " + prodLocation2);
                }
                if (prodLocation2.exists()) {
                    throw new GdrLabelPromoterException("The distribution " + distributionLoader + " was found already in the promoted area at " + prodLocation2);
                }
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Distribution definition " + distributionLoader + " not found in " + "prod" + " area.");
                }
                File devLocation2 = new File(this._devDir, DistributionHelper.getInstance().getPath() + File.separator + DistributionHelper.getInstance().getDistributionFileName(distributionLoader.getDistributionName(), distributionLoader.getDistributionVersion()));
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Checking dev area for distribution definition " + distributionLoader + " at " + devLocation2);
                }
                if (!devLocation2.exists()) {
                    throw new GdrLabelPromoterException("Unable to locate distribution definition for " + distributionLoader + " under " + "prod" + " or " + "dev" + " area of meta-data home directory " + this._gdrMetaDataHome);
                }
                if (!devLocation2.equals(distributionLoader.getDistribution().getDistributionFileLocation())) {
                    throw new GdrLabelPromoterException("The loaded location and meta-data home location of the distribution definition did not match. [" + distributionLoader.getDistribution().getDistributionFileLocation() + "] vs. [" + devLocation2 + "]");
                }
                _log.info("Adding distribution file for promotion from [" + devLocation2 + "] to [" + prodLocation2 + "]");
                filesToPromote.put(devLocation2, prodLocation2);
                File distributionInfoDevLocation = new File(this._devDir, DistributionInfoHelper.getInstance().getPath() + File.separator + DistributionInfoHelper.getInstance().getDistributionInfoFileName(distributionLoader.getDistributionName(), distributionLoader.getDistributionVersion()));
                if (!distributionInfoDevLocation.exists()) {
                    throw new GdrLabelPromoterException("Unable to locate corresponding distribution info file " + distributionInfoDevLocation);
                }
                File distributionInfoProdLocation = new File(this._prodDir, DistributionInfoHelper.getInstance().getPath() + File.separator + DistributionInfoHelper.getInstance().getDistributionInfoFileName(distributionLoader.getDistributionName(), distributionLoader.getDistributionVersion()));
                if (distributionInfoProdLocation.exists()) {
                    throw new GdrLabelPromoterException("Found distribution info file already in promoted area " + distributionInfoDevLocation);
                }
                _log.info("Adding distribution info file for promotion from [" + distributionInfoDevLocation + "] to [" + distributionInfoProdLocation + "]");
                filesToPromote.put(distributionInfoDevLocation, distributionInfoProdLocation);
                File resourcesDevDir = new File(this._devDir, DistributionHelper.getInstance().getPath() + File.separator + "resources" + File.separator + DistributionHelper.getFormattedNameVersion(distributionLoader.getDistributionName(), distributionLoader.getDistributionVersion()));
                if (!resourcesDevDir.isDirectory()) {
                    throw new GdrLabelPromoterException("Unable to locate corresponding distribution resources directory " + resourcesDevDir);
                }
                Set resourceFiles = IOUtil.getFiles((File)resourcesDevDir, (FileFilter)ComponentHelper.getInstance().getGlobalExcludeFileFilter());
                if (resourceFiles == null || resourceFiles.isEmpty()) {
                    throw new GdrLabelPromoterException("Unable to locate any resource files under corresponding distribution resources directory " + resourcesDevDir);
                }
                File resourcesProdDir = new File(this._prodDir, DistributionHelper.getInstance().getPath() + File.separator + "resources" + File.separator + DistributionHelper.getFormattedNameVersion(distributionLoader.getDistributionName(), distributionLoader.getDistributionVersion()));
                if (resourcesProdDir.exists()) {
                    throw new GdrLabelPromoterException("Found distribution resources directory already in promoted area " + resourcesProdDir);
                }
                _log.info("Adding distribution resources directory for promotion from [" + resourcesDevDir + "] to [" + resourcesProdDir + "]");
                dirsToPromote.put(resourcesDevDir, resourcesProdDir);
                for (File resourceFile : resourceFiles) {
                    File resourceProdFile;
                    String prodPath = resourceFile.getPath();
                    if (prodPath.contains("\\")) {
                        prodPath = prodPath.replace("\\", "/");
                    }
                    if ((resourceProdFile = new File(prodPath = prodPath.replaceFirst("/dev/", "/prod/"))).exists()) {
                        throw new GdrLabelPromoterException("Found distribution resources file already in promoted area " + resourceProdFile);
                    }
                    _log.info("Adding distribution resources file/directory for promotion from [" + resourceFile + "] to [" + resourceProdFile + "]");
                    if (resourceFile.isDirectory()) {
                        dirsToPromote.put(resourceFile, resourceProdFile);
                        continue;
                    }
                    filesToPromote.put(resourceFile, resourceProdFile);
                }
                File resourceDevJar = new File(this._devDir, DistributionHelper.getInstance().getPath() + File.separator + DistributionHelper.getInstance().getResourceLocation(distributionLoader.getDistributionName(), distributionLoader.getDistributionVersion()));
                if (!resourceDevJar.exists()) {
                    throw new GdrLabelPromoterException("Unable to locate resource jar " + resourceDevJar);
                }
                File resourceProdJar2 = new File(this._prodDir, DistributionHelper.getInstance().getPath() + File.separator + DistributionHelper.getInstance().getResourceLocation(distributionLoader.getDistributionName(), distributionLoader.getDistributionVersion()));
                _log.info("Adding distribution resources jar for copy from [" + resourceDevJar + "] to [" + resourceProdJar2 + "]");
                filesToCopy.put(resourceDevJar, resourceProdJar2);
                Set<FeatureSet> featureSets = distributionLoader.getFeatureSets();
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Adding " + featureSets.size() + " feature sets from distribution " + distributionLoader);
                }
                features.addAll(featureSets);
            }
            HashSet<ComponentReference> componentReferences = new HashSet<ComponentReference>();
            for (FeatureSet feature : features) {
                prodLocation = new File(this._prodDir, FeatureSetHelper.getInstance().getPath() + File.separator + FeatureSetHelper.getInstance().getFeatureSetFileName(feature.getName(), feature.getVersion()));
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Checking prod area for feature set definition " + feature + " at " + prodLocation);
                }
                if (prodLocation.exists()) {
                    _log.info("Found feature set file " + prodLocation + " already in promoted area, skipping...");
                    continue;
                }
                componentReferences.addAll(feature.getComponentReferences());
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Feature set definition " + feature.toString(false) + " not found in " + "prod" + " area.");
                }
                devLocation = new File(this._devDir, FeatureSetHelper.getInstance().getPath() + File.separator + FeatureSetHelper.getInstance().getFeatureSetFileName(feature.getName(), feature.getVersion()));
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Checking dev area for feature set definition " + feature + " at " + devLocation);
                }
                if (!devLocation.exists()) {
                    throw new GdrLabelPromoterException("Unable to locate feature set definition for " + feature.toString(false) + " under " + "prod" + " or " + "dev" + " area of meta-data home directory " + this._gdrMetaDataHome);
                }
                if (!devLocation.equals(feature.getFeatureSetFileLocation())) {
                    throw new GdrLabelPromoterException("The loaded location and meta-data home location of the feature set definition did not match. [" + feature.getFeatureSetFileLocation() + "] vs. [" + devLocation + "]");
                }
                _log.info("Adding feature set file for promotion from [" + devLocation + "] to [" + prodLocation + "]");
                filesToPromote.put(devLocation, prodLocation);
                File resourcesDevDir = new File(this._devDir, FeatureSetHelper.getInstance().getPath() + File.separator + "resources" + File.separator + FeatureSetHelper.getFormattedNameVersion(feature.getName(), feature.getVersion()));
                if (!resourcesDevDir.isDirectory()) {
                    throw new GdrLabelPromoterException("Unable to locate corresponding feature set resources directory " + resourcesDevDir);
                }
                Set resourceFiles = IOUtil.getFiles((File)resourcesDevDir, (FileFilter)ComponentHelper.getInstance().getGlobalExcludeFileFilter());
                if (resourceFiles == null || resourceFiles.isEmpty()) {
                    throw new GdrLabelPromoterException("Unable to locate any resource files under corresponding feature set resources directory " + resourcesDevDir);
                }
                File resourcesProdDir = new File(this._prodDir, FeatureSetHelper.getInstance().getPath() + File.separator + "resources" + File.separator + FeatureSetHelper.getFormattedNameVersion(feature.getName(), feature.getVersion()));
                if (resourcesProdDir.exists()) {
                    throw new GdrLabelPromoterException("Found feature set resources directory already in promoted area " + resourcesProdDir);
                }
                _log.info("Adding feature set resources directory for promotion from [" + resourcesDevDir + "] to [" + resourcesProdDir + "]");
                dirsToPromote.put(resourcesDevDir, resourcesProdDir);
                for (File resourceFile : resourceFiles) {
                    File resourceProdFile;
                    String resourcePath = resourceFile.getPath();
                    if (resourcePath.contains("\\")) {
                        resourcePath = resourcePath.replace("\\", "/");
                    }
                    if ((resourceProdFile = new File(resourcePath.replaceFirst("/dev/", "/prod/"))).exists()) {
                        throw new GdrLabelPromoterException("Found feature set resources file already in promoted area " + resourceProdFile);
                    }
                    _log.info("Adding feature set resources file/directory for promotion from [" + resourceFile + "] to [" + resourceProdFile + "]");
                    if (resourceFile.isDirectory()) {
                        dirsToPromote.put(resourceFile, resourceProdFile);
                        continue;
                    }
                    filesToPromote.put(resourceFile, resourceProdFile);
                }
                File resourceDevJar = new File(this._devDir, FeatureSetHelper.getInstance().getPath() + File.separator + FeatureSetHelper.getInstance().getResourceLocation(feature.getName(), feature.getVersion()));
                if (!resourceDevJar.exists()) {
                    throw new GdrLabelPromoterException("Unable to locate resource jar " + resourceDevJar);
                }
                resourceProdJar = new File(this._prodDir, FeatureSetHelper.getInstance().getPath() + File.separator + FeatureSetHelper.getInstance().getResourceLocation(feature.getName(), feature.getVersion()));
                _log.info("Adding feature set resources jar for copy from [" + resourceDevJar + "] to [" + resourceProdJar + "]");
                filesToCopy.put(resourceDevJar, resourceProdJar);
            }
            if (filesToPromote.isEmpty()) {
                throw new GdrLabelPromoterException("Unable to locate any files to promote.");
            }
            for (ComponentReference componentReference : componentReferences) {
                prodLocation = new File(this._prodDir, ComponentInfoHelper.getInstance().getPath() + File.separator + ComponentInfoHelper.getInstance().getComponentInfoFileName(componentReference.getName(), componentReference.getVersion()));
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Checking prod area for component-info definition " + (Object)((Object)componentReference) + " at " + prodLocation);
                }
                if (prodLocation.exists()) {
                    _log.info("Found component-info file " + prodLocation + " already in promoted area, skipping...");
                    continue;
                }
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Component-info definition " + (Object)((Object)componentReference) + " not found in " + "prod" + " area.");
                }
                devLocation = new File(this._devDir, ComponentInfoHelper.getInstance().getPath() + File.separator + ComponentInfoHelper.getInstance().getComponentInfoFileName(componentReference.getName(), componentReference.getVersion()));
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Checking dev area for component-info definition " + (Object)((Object)componentReference) + " at " + devLocation);
                }
                if (devLocation.exists()) {
                    _log.info("Adding component-info file for promotion from [" + devLocation + "] to [" + prodLocation + "]");
                    filesToPromote.put(devLocation, prodLocation);
                    continue;
                }
                if (!_log.isLoggable(Level.FINER)) continue;
                _log.finer("Unable to locate component-info definition for " + (Object)((Object)componentReference) + " under " + "prod" + " or " + "dev" + " area of meta-data home directory " + this._gdrMetaDataHome);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            List<ComponentMapping> prodMappings = this._prodLabelMap.getMappings();
            List<ComponentMapping> devMappings = this._devLabelMap.getMappings();
            ArrayList<ComponentMapping> removeDevMappings = new ArrayList<ComponentMapping>();
            for (ComponentReference componentReference : componentReferences) {
                Iterator mappings = LabelMapHelper.getInstance().getMappingsForComponent(this._devLabelMap, componentReference);
                Collection<ComponentMapping> mappings2 = LabelMapHelper.getInstance().getMappingsForComponent(this._prodLabelMap, componentReference);
                if (!mappings.isEmpty() && !mappings2.isEmpty()) {
                    arrayList.add("Found entry for already promoted label-map component reference " + (Object)((Object)componentReference) + " in both dev and prod label map.");
                    continue;
                }
                if (mappings.isEmpty()) {
                    if (mappings2.isEmpty()) {
                        arrayList.add("Unable to locate entry for component " + (Object)((Object)componentReference) + " in dev or prod label map.");
                        continue;
                    }
                    _log.info("Found existing entry for component [" + (Object)((Object)componentReference) + "] in promoted label-map, skipping...");
                    continue;
                }
                resourceProdJar = mappings.iterator();
                while (resourceProdJar.hasNext()) {
                    ComponentMapping mapping = resourceProdJar.next();
                    ComponentMapping matching = LabelMapHelper.getInstance().getMatchingComponentMapping(mapping, prodMappings);
                    if (matching == null) {
                        matching = new ComponentMapping(mapping);
                        prodMappings.add(matching);
                    }
                    LabelMapReference labelMapReference = LabelMapHelper.getInstance().getLabelMapReference(mapping, componentReference);
                    _log.info("Moving label-map component reference [" + (Object)((Object)labelMapReference) + "] in mapping [" + (Object)((Object)mapping) + "] from dev to prod.");
                    matching.addComponent(labelMapReference);
                    mapping.removeComponent(labelMapReference);
                    if (!mapping.getComponents().isEmpty()) continue;
                    removeDevMappings.add(mapping);
                }
            }
            devMappings.removeAll(removeDevMappings);
            this._devLabelMap.setMappings(devMappings);
            this._prodLabelMap.setMappings(prodMappings);
            if (!arrayList.isEmpty()) {
                dryRun = true;
            }
            String qualifier = new SimpleDateFormat("yyMMdd.HHmm").format(Calendar.getInstance().getTime());
            String transactionName = "promote_" + this._promotionName.toLowerCase() + "_" + qualifier;
            _log.info("Using transaction name " + transactionName);
            if (!StringUtil.isNullOrEmpty((String)this._bugId, (boolean)true)) {
                this.invokeCommand(dryRun, "ade", "begintrans", "-bug", this._bugId, transactionName);
            } else {
                this.invokeCommand(dryRun, "ade", "begintrans", transactionName);
            }
            if (this._prodLabelMap.getLabelMapLocation().exists()) {
                this.invokeCommand(dryRun, "ade", "co", "-nc", this._prodLabelMap.getLabelMapLocation().getPath());
                this._prodLabelMap.getLabelMapLocation().delete();
            } else {
                this._prodLabelMap.getLabelMapLocation().getParentFile().mkdirs();
                this.invokeCommand(dryRun, "ade", "mkelem", "-nc", "-recursive", this._prodLabelMap.getLabelMapLocation().getPath());
            }
            LabelMapHelper.getInstance().save((IDataHandlerWrapper)this._prodLabelMap, this._prodLabelMap.getLabelMapLocation());
            this.invokeCommand(dryRun, "ade", "co", "-nc", this._devLabelMap.getLabelMapLocation().getPath());
            this._devLabelMap.getLabelMapLocation().delete();
            LabelMapHelper.getInstance().save((IDataHandlerWrapper)this._devLabelMap, this._devLabelMap.getLabelMapLocation());
            for (File devDir : dirsToPromote.keySet()) {
                File prodDir = (File)dirsToPromote.get(devDir);
                _log.info("Promoting directory " + prodDir);
                this.invokeCommand(dryRun, "ade", "mkdir", "-nc", "-recursive", prodDir.getPath());
                if (!dryRun) continue;
                prodDir.mkdirs();
            }
            for (File devFile : filesToPromote.keySet()) {
                prodFile = (File)filesToPromote.get(devFile);
                _log.info("Promoting file from " + devFile + " to " + prodFile);
                this.invokeCommand(dryRun, "ade", "mkelem", "-nc", "-recursive", prodFile.getPath());
                FileCopy.copy((File)devFile, (File)prodFile);
            }
            for (File devFile : filesToCopy.keySet()) {
                prodFile = (File)filesToCopy.get(devFile);
                this.invokeCommand(dryRun, "ade", "mkelem", "-nc", "-recursive", prodFile.getPath());
                _log.info("Copying and promoting file from " + devFile + " to " + prodFile);
                FileCopy.copy((File)devFile, (File)prodFile);
                GdrLabelPromoter.delete(devFile);
                if (!devFile.exists()) continue;
                throw new GdrLabelPromoterException("File in dev area still exists after attempting to move " + devFile);
            }
            for (File devDir : dirsToPromote.keySet()) {
                _log.info("Deleting directory " + devDir);
                this.invokeCommand(dryRun, "ade", "rm", "-force", devDir.getPath());
                if (dryRun) {
                    GdrLabelPromoter.delete(devDir);
                }
                if (!devDir.exists()) continue;
                throw new GdrLabelPromoterException("Directory in dev area still exists after attempting to move " + devDir);
            }
            for (File devFile : filesToPromote.keySet()) {
                if (!devFile.exists()) continue;
                _log.info("Deleting file " + devFile);
                this.invokeCommand(dryRun, "ade", "rm", "-force", devFile.getPath());
                if (dryRun) {
                    GdrLabelPromoter.delete(devFile);
                }
                if (!devFile.exists()) continue;
                throw new GdrLabelPromoterException("File in dev area still exists after attempting to move " + devFile);
            }
            DistributionLoaderFactory.clearCache();
            _log.info("Running standard GDR meta-data validation.");
            String gdrMetaDataValidatorFailure = null;
            GdrMetaDataValidator validator = new GdrMetaDataValidator(this._gdrMetaDataHome);
            try {
                validator.validate();
            }
            catch (GdrException e) {
                ByteArrayOutputStream failures = new ByteArrayOutputStream();
                Iterator<File> ps = new PrintStream(failures);
                GdrMetaDataValidator.printReport(validator, (PrintStream)((Object)ps));
                gdrMetaDataValidatorFailure = failures.toString();
            }
            _log.info("Standard GDR promotion validation successful.");
            _log.info("Running GDR promotion validation.");
            boolean validationClean = this.validate();
            if (!arrayList.isEmpty() || gdrMetaDataValidatorFailure != null || !validationClean) {
                String errorMessage = "Validation failed, promotion aborted!\n\n";
                if (!arrayList.isEmpty()) {
                    for (String failure : arrayList) {
                        errorMessage = errorMessage + failure + "\n\n";
                    }
                }
                if (gdrMetaDataValidatorFailure != null) {
                    errorMessage = errorMessage + "Pre-promotion GDR meta-data validation failed for the following issues:\n" + gdrMetaDataValidatorFailure;
                    errorMessage = errorMessage + "\n\n";
                }
                if (!validationClean) {
                    for (File f : this._validationFailures.keySet()) {
                        errorMessage = errorMessage + "The feature set file " + f + " failed validation because it " + this._validationFailures.get(f) + ".\n";
                    }
                }
                GdrLabelPromoterException e = new GdrLabelPromoterException(errorMessage);
                e.setValidationException(true);
                throw e;
            }
            _log.info("GDR promotion validation successful.");
            File promotedPropertiesFile = new File(this._prodDir, PROMOTION_DIRECTORY + File.separator + this._promotionName + ".properties");
            this.invokeCommand(dryRun, "ade", "mkelem", "-nc", "-recursive", promotedPropertiesFile.getPath());
            FileCopy.copy((File)this._promotionPropertiesFile, (File)promotedPropertiesFile);
            _log.info("Deleting file " + this._promotionPropertiesFile);
            this.invokeCommand(dryRun, "ade", "rm", "-force", this._promotionPropertiesFile.getPath());
            if (dryRun) {
                GdrLabelPromoter.delete(this._promotionPropertiesFile);
            }
            if (this._promotionPropertiesFile.exists()) {
                throw new GdrLabelPromoterException("File in dev area still exists after attempting to move " + this._promotionPropertiesFile);
            }
            _log.info("The following items were affected by this promotion run:\nDirectories:" + dirsToPromote.values() + "\nFiles:" + filesToPromote.values() + filesToCopy.values());
            List<String> result = this.invokeCommand(dryRun, "ade", "describetrans");
            _log.info("Transaction description " + result);
            this.invokeCommand(dryRun, "ade", "mkelem", "-nc", "-recursive", this._promotionLogFile.getPath());
        }
        catch (Exception e) {
            GdrLabelPromoterException exception = e instanceof GdrLabelPromoterException ? (GdrLabelPromoterException)((Object)e) : new GdrLabelPromoterException(e);
            try {
                this.invokeCommand(dryRun, "ade", "aborttrans", "-force");
            }
            catch (IOException e1) {
                _log.log(Level.WARNING, "Failed to abort the transaction", e1);
            }
            throw exception;
        }
        try {
            this.invokeCommand(dryRun, "ade", "ciall");
        }
        catch (Exception e) {
            throw new GdrLabelPromoterException("A failure occurred while executing the \"ade ciall\" command. The promotion processing has been completed at this point and based on the cause of this failure it may not be fatal.  It may still be possible to manually run \"ade ciall\" and merge the transaction as you normally would.", e);
        }
        _log.info("Please merge the transaction manually");
    }

    public static boolean delete(File file) {
        if (file != null) {
            File[] files;
            if (!file.exists()) {
                return file.delete();
            }
            if (file.isDirectory() && (files = file.listFiles()) != null && files.length > 0) {
                for (File file1 : files) {
                    GdrLabelPromoter.delete(file1);
                }
            }
            if (!file.delete()) {
                return false;
            }
        }
        return true;
    }

    private List<String> invokeCommand(boolean dryRun, String ... command) throws IOException {
        if (!dryRun) {
            _log.info("Executing command " + Arrays.toString(command));
            List<String> result = TopLevelDirectoryService.getCommandOutput(this.getExecTimeout(), command);
            _log.info("Result " + result);
            return result;
        }
        _log.info("Skipping command execution of " + Arrays.toString(command) + " due to dry run.");
        return null;
    }

    public boolean validate() {
        this._validationFailures = new LinkedHashMap<File, String>();
        HashSet<FeatureSet> features = new HashSet<FeatureSet>();
        for (DistributionLoader distributionLoader : this._distributionLoaders) {
            features.addAll(distributionLoader.getFeatureSets());
        }
        for (FeatureSet feature : features) {
            List<Components> components = feature.getComponents();
            if (components == null || components.isEmpty()) continue;
            for (Components comps : components) {
                List<ComponentReference> componentReferences;
                if ("choice".equals(comps.getConstraint()) && (this._choicePermittedFeatures == null || !this._choicePermittedFeatures.contains(feature.getName()))) {
                    this.addValidationFailure(feature.getFeatureSetFileLocation(), "contains choice constraint");
                }
                if ((componentReferences = comps.getComponentReferences()) == null || componentReferences.isEmpty()) continue;
                for (ComponentReference componentReference : componentReferences) {
                    if (!componentReference.isOptional()) continue;
                    this.addValidationFailure(feature.getFeatureSetFileLocation(), "contains optional component");
                }
            }
        }
        return this._validationFailures.isEmpty();
    }

    private void addValidationFailure(File file, String failure) {
        String cause = "";
        if (this._validationFailures.containsKey(file)) {
            cause = this._validationFailures.get(file) + " and ";
        }
        cause = cause + failure;
        this._validationFailures.put(file, cause);
    }
}

