/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.tools;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cmn.QuickReference;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.dbd.InstallType;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.installation.InstallationValidator;
import com.oracle.cie.gdr.session.DistributionSession;
import com.oracle.cie.gdr.session.DistributionSessionImpl;
import com.oracle.cie.gdr.utils.DistributionCompatibilityException;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DistributionCompatibilityAnalyzer {
    private static final Logger _log = Logger.getLogger(DistributionCompatibilityAnalyzer.class.getName());
    private List<MetaDataHome> _metaDataHomes;
    private List<Reference> _distributions;
    private List<CompatibilityResult> _results;

    public DistributionCompatibilityAnalyzer(File metaDataHome) throws GdrException {
        File[] fileArray;
        if (metaDataHome != null) {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = metaDataHome;
        } else {
            fileArray = null;
        }
        this(fileArray);
    }

    public DistributionCompatibilityAnalyzer(File ... metaDataHomes) throws GdrException {
        this(DistributionCompatibilityAnalyzer.getMetaDataHomes(metaDataHomes));
    }

    public DistributionCompatibilityAnalyzer(List<MetaDataHome> metaDataHomes) throws GdrException {
        if (metaDataHomes == null) {
            throw new GdrException("The meta-data home(s) provided was null.");
        }
        if (metaDataHomes.isEmpty()) {
            throw new GdrException("No meta-data home was provided.");
        }
        this._metaDataHomes = metaDataHomes;
    }

    private static List<MetaDataHome> getMetaDataHomes(File[] metaDataHomeDirs) throws GdrException {
        if (metaDataHomeDirs == null) {
            throw new GdrException("The meta-data home(s) provided was null.");
        }
        ArrayList<MetaDataHome> metaDataHomes = new ArrayList<MetaDataHome>();
        for (File metaDataHomeDir : metaDataHomeDirs) {
            MetaDataHome metaDataHome = new MetaDataHome(metaDataHomeDir);
            if (metaDataHomes.contains(metaDataHome)) continue;
            metaDataHomes.add(metaDataHome);
        }
        return metaDataHomes;
    }

    public void setDistributions(List<Reference> distributions) {
        this._distributions = distributions;
    }

    public List<CompatibilityResult> getResults() {
        return this._results;
    }

    public void analyze() throws IOException, DataHandlerException, GdrException, DependencyException {
        DistributionSessionImpl distributionSession;
        this._results = new ArrayList<CompatibilityResult>();
        ArrayList<DistributionSessionImpl> distributionSessions = new ArrayList<DistributionSessionImpl>();
        Reference specificDistribution = this._distributions != null && this._distributions.size() == 1 ? this._distributions.get(0) : null;
        DistributionSessionImpl specificDistributionSession = null;
        boolean compareSelf = true;
        if (this._distributions == null || this._distributions.isEmpty() || specificDistribution != null) {
            for (MetaDataHome metaDataHome : this._metaDataHomes) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("Loading all distributions from " + metaDataHome);
                }
                Set<Distribution> distributions = DistributionHelper.getInstance().getDistributions(metaDataHome.getGdrMetaDataHomePath());
                for (Distribution distribution : distributions) {
                    if (_log.isLoggable(Level.FINEST)) {
                        _log.finest("Creating distribution session for " + this.getDistributionName(distribution));
                    }
                    distributionSession = new DistributionSessionImpl(null, metaDataHome, distribution, Mode.INSTALL);
                    distributionSessions.add(distributionSession);
                    if (specificDistribution == null || !DistributionHelper.getFormattedName(specificDistribution.getName()).equals(DistributionHelper.getFormattedName(distribution.getName())) || !specificDistribution.getVersion().equals(distribution.getVersion())) continue;
                    specificDistributionSession = new DistributionSessionImpl(null, metaDataHome, distribution, Mode.INSTALL);
                }
            }
        } else {
            compareSelf = false;
            for (Reference distributionReference : this._distributions) {
                Distribution distribution = null;
                for (MetaDataHome metaDataHome : this._metaDataHomes) {
                    if (_log.isLoggable(Level.FINEST)) {
                        _log.finest("Attempting to load distribution " + this.getDistributionName(distribution) + " from " + metaDataHome);
                    }
                    if ((distribution = DistributionHelper.getInstance().getDistribution(metaDataHome, distributionReference.getName(), distributionReference.getVersion())) == null) continue;
                    if (_log.isLoggable(Level.FINEST)) {
                        _log.finest("Found distribution " + this.getDistributionName(distribution) + " in meta-data home " + metaDataHome);
                    }
                    if (_log.isLoggable(Level.FINEST)) {
                        _log.finest("Creating distribution session for " + this.getDistributionName(distribution));
                    }
                    distributionSession = new DistributionSessionImpl(null, metaDataHome, distribution, Mode.INSTALL);
                    distributionSessions.add(distributionSession);
                    break;
                }
                if (distribution != null) continue;
                throw new GdrException("Unable to locate distribution " + (Object)((Object)distributionReference) + " in any of the meta-data homes supplied " + this._metaDataHomes);
            }
        }
        if (specificDistribution != null && specificDistributionSession == null) {
            throw new GdrException("Unable to locate specific distribution " + (Object)((Object)specificDistribution));
        }
        if (specificDistributionSession != null) {
            this.analyzeDistribution(specificDistributionSession, distributionSessions, compareSelf);
        } else {
            Iterator it = distributionSessions.iterator();
            while (it.hasNext()) {
                DistributionSessionImpl nextSession = (DistributionSessionImpl)it.next();
                DistributionSessionImpl distributionSession2 = new DistributionSessionImpl(null, nextSession.getMetaDataHome(), nextSession.getDistributionLoader().getDistribution(), Mode.INSTALL);
                this.analyzeDistribution(distributionSession2, distributionSessions, compareSelf);
                it.remove();
            }
        }
    }

    protected void analyzeDistribution(final DistributionSessionImpl distributionSession, ArrayList<DistributionSessionImpl> distributionSessions, boolean compareSelf) throws DependencyException, GdrException {
        String distributionName = this.getDistributionName(distributionSession.getDistributionLoader().getDistribution());
        Set<InstallType> installTypes = distributionSession.getInstallTypes();
        for (InstallType installType : installTypes) {
            distributionSession.setInstallType(installType);
            for (final DistributionSessionImpl targetSession : distributionSessions) {
                if (!compareSelf && distributionSession.equals(targetSession)) continue;
                Set<InstallType> targetInstallTypes = targetSession.getInstallTypes();
                for (InstallType targetInstallType : targetInstallTypes) {
                    CompatibilityResult result;
                    block10: {
                        InstallationValidator installationValidator;
                        block9: {
                            if (_log.isLoggable(Level.FINE)) {
                                _log.fine("Checking distribution: " + distributionName + " install-type: " + installType.getName() + " vs. distribution: " + this.getDistributionName(targetSession.getDistributionLoader().getDistribution()) + " install-type:" + targetInstallType.getName());
                            }
                            targetSession.setInstallType(targetInstallType);
                            installationValidator = new InstallationValidator(distributionSession.getDistributionLoader(), distributionSession.getSelectedFeatures()){

                                @Override
                                public Set<FeatureSet> getInstalledFeatureSets(boolean federated) {
                                    Set<FeatureSet> selectedFeatures = targetSession.getSelectedFeatures();
                                    List installedFeatures = targetSession.getFeatureSelectionTarget().getInstalledItems();
                                    Set<FeatureSet> externalFeatures = distributionSession.getDistributionLoader().getDistributionTarget().getDummyExternalFeatureSets();
                                    if (installedFeatures != null && !installedFeatures.isEmpty()) {
                                        selectedFeatures.addAll(installedFeatures);
                                    }
                                    if (externalFeatures != null && !externalFeatures.isEmpty()) {
                                        selectedFeatures.addAll(externalFeatures);
                                    }
                                    return selectedFeatures;
                                }

                                @Override
                                public Collection<DistributionTarget> getInstalledDistributions(boolean federated) {
                                    ArrayList<DistributionTarget> installedDistributions = new ArrayList<DistributionTarget>();
                                    installedDistributions.add(targetSession.getDistributionLoader().getDistributionTarget());
                                    return installedDistributions;
                                }

                                @Override
                                public Set<FeatureSet> getInstalledFeatureSets(DistributionTarget distributionTarget, boolean federated) {
                                    return this.getInstalledFeatureSets(federated);
                                }
                            };
                            result = new CompatibilityResult(distributionSession, installType, targetSession, targetInstallType);
                            try {
                                installationValidator.validateDependencies();
                            }
                            catch (DependencyException e) {
                                result.addIncompatible("dependency", (Exception)((Object)e));
                                if (!_log.isLoggable(Level.FINEST)) break block9;
                                _log.log(Level.FINEST, result.toString(), e);
                            }
                        }
                        try {
                            installationValidator.validateFeatureCompatibility();
                        }
                        catch (DistributionCompatibilityException e) {
                            result.addIncompatible("compatibility", (Exception)((Object)e));
                            if (!_log.isLoggable(Level.FINEST)) break block10;
                            _log.log(Level.FINEST, result.toString(), (Throwable)((Object)e));
                        }
                    }
                    if (_log.isLoggable(Level.FINEST)) {
                        _log.log(Level.FINEST, result.toString());
                    }
                    this._results.add(result);
                }
            }
        }
    }

    private String getDistributionName(Distribution distribution) {
        return distribution.getName() + " " + distribution.getVersion();
    }

    public static void main(String[] args) {
        String log = System.getProperty("DistributionCompatibilityAnalyzer.log");
        String logLevel = System.getProperty("DistributionCompatibilityAnalyzer.logLevel", "INFO");
        LogFactory.getFactory().setupLogging(log, logLevel, new String[0]);
        try {
            DistributionCompatibilityAnalyzer analyzer = new DistributionCompatibilityAnalyzer(new File(args[0]));
            if (args.length > 1) {
                ArrayList<Reference> distributions = new ArrayList<Reference>();
                for (int x = 1; x < args.length; x += 2) {
                    distributions.add(new QuickReference(args[x], args[x + 1]));
                }
                analyzer.setDistributions(distributions);
            }
            analyzer.analyze();
            boolean verbose = Boolean.getBoolean("DistributionCompatibilityAnalyzer.verbose");
            for (CompatibilityResult result : analyzer.getResults()) {
                System.out.println(result.toString(verbose));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public class CompatibilityResult {
        private DistributionSession _sourceDistribution;
        private InstallType _sourceInstallType;
        private DistributionSession _targetDistribution;
        private InstallType _targetInstallType;
        private Map<String, Exception> _incompatible = new LinkedHashMap<String, Exception>();

        public CompatibilityResult(DistributionSession sourceDistribution, InstallType sourceInstallType, DistributionSession targetDistribution, InstallType targetInstallType) {
            this._sourceDistribution = sourceDistribution;
            this._sourceInstallType = sourceInstallType;
            this._targetDistribution = targetDistribution;
            this._targetInstallType = targetInstallType;
        }

        public DistributionSession getSourceDistribution() {
            return this._sourceDistribution;
        }

        public InstallType getSourceInstallType() {
            return this._sourceInstallType;
        }

        public DistributionSession getTargetDistribution() {
            return this._targetDistribution;
        }

        public InstallType getTargetInstallType() {
            return this._targetInstallType;
        }

        public Set<String> getTypes() {
            return this._incompatible.keySet();
        }

        public Collection<Exception> getCauses() {
            return this._incompatible.values();
        }

        public boolean isIncompatible() {
            return !this._incompatible.isEmpty();
        }

        void addIncompatible(String type, Exception cause) {
            this._incompatible.put(type, cause);
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean verbose) {
            String distributionName = DistributionCompatibilityAnalyzer.this.getDistributionName(this.getSourceDistribution().getDistributionLoader().getDistribution());
            if (!this.isIncompatible()) {
                return "Compatible! distribution: " + distributionName + " install-type: " + this.getSourceInstallType().getName() + " vs. distribution: " + DistributionCompatibilityAnalyzer.this.getDistributionName(this.getTargetDistribution().getDistributionLoader().getDistribution()) + " install-type: " + this.getTargetInstallType().getName();
            }
            String types = null;
            for (String type : this.getTypes()) {
                types = types == null ? "" : types + " & ";
                types = types + type;
            }
            String s = "Incompatible (" + types + ")! distribution: " + distributionName + " install-type: " + this.getSourceInstallType().getName() + " vs. distribution: " + DistributionCompatibilityAnalyzer.this.getDistributionName(this.getTargetDistribution().getDistributionLoader().getDistribution()) + " install-type: " + this.getTargetInstallType().getName();
            if (verbose) {
                String causes = null;
                for (Exception e : this.getCauses()) {
                    causes = causes == null ? "" : " & ";
                    causes = causes + e.getMessage().replaceAll("\n", " ").trim();
                }
                s = s + " [reason: " + causes + "]";
            }
            return s;
        }
    }
}

