/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.session;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.nfo.InstallerInfo;
import com.oracle.cie.gdr.external.InstallType;
import com.oracle.cie.gdr.helpers.DistributionInfoHelper;
import com.oracle.cie.gdr.installation.ComponentArchiveInstallationSession;
import com.oracle.cie.gdr.installation.DistributionInstallationSession;
import com.oracle.cie.gdr.installation.FeatureArchiveInstallationSession;
import com.oracle.cie.gdr.installation.InstallationSession;
import com.oracle.cie.gdr.services.RepositoryService;
import com.oracle.cie.gdr.services.VariableResolverService;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.repository.resolver.RepositoryVersionResolver;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InstallerSessionFactory {
    public static DistributionInstallationSession getRepositoryDistributionInstallerSession(RepositoryVersionResolver repositoryVersionResolver, Reference distributionReference, Path homeDir, Set<Integer> platforms, Set<Integer> locales, String installTypeName, InstallerInfo installerInfo, Collection<Path> federatedHomes, Map<Reference, Component> previouslyLoadedComponents) throws GdrException, DependencyException, IOException, DataHandlerException {
        DistributionInstallationSession installerSession = new DistributionInstallationSession(InstallerSessionFactory.getRepositoryMetaDataHome(repositoryVersionResolver), homeDir, distributionReference, platforms, locales, installerInfo, previouslyLoadedComponents);
        installerSession.setFederatedHomePaths(federatedHomes);
        if (!StringUtil.isNullOrEmpty((String)installTypeName, (boolean)true)) {
            Set<InstallType> installTypes = installerSession.getInstallTypes();
            for (InstallType type : installTypes) {
                if (!installTypeName.equalsIgnoreCase(type.getName())) continue;
                installerSession.setInstallType(type);
                break;
            }
        }
        return installerSession;
    }

    public static ComponentArchiveInstallationSession getRepositoryComponentArchiveInstallerSession(RepositoryVersionResolver repositoryVersionResolver, Set<Reference> componentRefs, Path homeDir, Set<Integer> platforms, Set<Integer> locales, DirectoryMap directoryMap, InstallerInfo installerInfo, Collection<Path> federatedHomes, List<String> productFamilies, Map<Reference, Component> previouslyLoadedComponents) throws GdrException, DependencyException, IOException, DataHandlerException {
        ComponentArchiveInstallationSession installerSession = new ComponentArchiveInstallationSession(InstallerSessionFactory.getRepositoryMetaDataHome(repositoryVersionResolver), homeDir, null, componentRefs, directoryMap, platforms, locales, installerInfo, previouslyLoadedComponents);
        installerSession.setFederatedHomePaths(federatedHomes);
        InstallerSessionFactory.configureProductFamilies(installerSession, productFamilies);
        return installerSession;
    }

    public static ComponentArchiveInstallationSession getRepositoryFeatureSetInstallerSession(RepositoryVersionResolver repositoryVersionResolver, Set<Reference> featureSetRefs, Path homeDir, Set<Integer> platforms, Set<Integer> locales, DirectoryMap directoryMap, InstallerInfo installerInfo, Collection<Path> federatedHomes, List<String> productFamilies, Map<Reference, Component> previouslyLoadedComponents) throws GdrException, DependencyException, IOException, DataHandlerException {
        ComponentArchiveInstallationSession installerSession = new ComponentArchiveInstallationSession(InstallerSessionFactory.getRepositoryMetaDataHome(repositoryVersionResolver), homeDir, featureSetRefs, null, directoryMap, platforms, locales, installerInfo, previouslyLoadedComponents);
        installerSession.setFederatedHomePaths(federatedHomes);
        InstallerSessionFactory.configureProductFamilies(installerSession, productFamilies);
        return installerSession;
    }

    public static FeatureArchiveInstallationSession getFeatureArchiveInstallerSession(Path featureArchive, Path homeDir, Set<Integer> platforms, Set<Integer> locales, DirectoryMap directoryMap, InstallerInfo installerInfo, Collection<Path> federatedHomes, boolean forced) throws GdrException, DependencyException, IOException, DataHandlerException {
        FeatureArchiveInstallationSession installerSession = new FeatureArchiveInstallationSession(featureArchive, homeDir, directoryMap, platforms, locales, installerInfo, forced);
        installerSession.setFederatedHomePaths(federatedHomes);
        return installerSession;
    }

    private static MetaDataHome getRepositoryMetaDataHome(RepositoryVersionResolver repositoryVersionResolver) throws GdrException {
        RepositoryService repositoryService = new RepositoryService(VariableResolverService.getVariableResolverService(), repositoryVersionResolver);
        return new MetaDataHome(repositoryService);
    }

    private static void configureProductFamilies(InstallationSession installationSession, List<String> productFamilies) {
        if (productFamilies != null && !productFamilies.isEmpty()) {
            installationSession.setDistributionInfo(DistributionInfoHelper.getInstance().createDistributionInfo(installationSession.getDistributionTarget().getDistributionName(), installationSession.getDistributionTarget().getDistributionVersion(), productFamilies));
        }
    }
}

