/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.services;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class PatchTrackerService {
    public static String PATCH_APPLIED_FILE_EXTENSION = ".applied";
    private Path _patchesDir;
    private Map<String, PatchStatus> _patchStatuses = new LinkedHashMap<String, PatchStatus>();
    private Map<String, Path> _patchIdDirs = new LinkedHashMap<String, Path>();

    public static PatchTrackerService getPatchApplicationTrackerService(File patchesDir) throws IOException {
        return new PatchTrackerService(patchesDir);
    }

    public static PatchTrackerService getPatchApplicationTrackerService(Path patchesDir) throws IOException {
        return new PatchTrackerService(patchesDir);
    }

    protected PatchTrackerService(File patchesDir) throws IOException {
        this(NioHelper.getInstance().getPath(patchesDir));
    }

    protected PatchTrackerService(Path patchesDir) throws IOException {
        this._patchesDir = patchesDir;
        this.init();
    }

    private void init() throws IOException {
        String patchId;
        Path patchDir = this.getPatchesDirPath();
        if (patchDir == null) {
            throw new IOException("The patch directory specified was null.");
        }
        if (!Files.isDirectory(patchDir, new LinkOption[0])) {
            throw new IOException("The patch directory specified either did not exist or was not a directory " + this.getPatchesDirPath());
        }
        HashSet<String> appliedPatches = new HashSet<String>();
        try (DirectoryStream<Path> patchAppliedFiles = Files.newDirectoryStream(patchDir, "*" + PATCH_APPLIED_FILE_EXTENSION);){
            for (Path patchAppliedFile : patchAppliedFiles) {
                patchId = patchAppliedFile.getFileName().toString();
                patchId = patchId.substring(0, patchId.lastIndexOf("."));
                appliedPatches.add(patchId);
            }
        }
        try (DirectoryStream<Path> files = Files.newDirectoryStream(patchDir);){
            for (Path file : files) {
                if (!Files.isDirectory(file, new LinkOption[0]) || !FileUtils.isDirectoryEmpty(file)) continue;
                Files.delete(file);
            }
        }
        try (DirectoryStream<Path> patchIdDirs = Files.newDirectoryStream(patchDir, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path pathname) throws IOException {
                if (Files.isDirectory(pathname, new LinkOption[0])) {
                    return !FileUtils.isDirectoryEmpty(pathname);
                }
                return false;
            }
        });){
            for (Path patchIdDir : patchIdDirs) {
                patchId = patchIdDir.getFileName().toString();
                PatchStatus status = appliedPatches.remove(patchId) ? PatchStatus.APPLIED : PatchStatus.NOT_APPLIED;
                this._patchStatuses.put(patchId, status);
                this._patchIdDirs.put(patchId, patchIdDir);
            }
        }
        if (!appliedPatches.isEmpty()) {
            for (String patchId2 : appliedPatches) {
                this.patchRemoved(patchId2);
            }
        }
    }

    public File getPatchesDir() {
        return this.getPatchesDirPath() != null ? this.getPatchesDirPath().toFile() : null;
    }

    public Path getPatchesDirPath() {
        return this._patchesDir;
    }

    public Set<String> getPatchIds() {
        return new TreeSet<String>(this._patchStatuses.keySet());
    }

    public boolean statusChanged() {
        for (PatchStatus status : this._patchStatuses.values()) {
            if (status.isApplied()) continue;
            return true;
        }
        return false;
    }

    public Map<String, PatchStatus> getPatchStatuses() {
        return this._patchStatuses;
    }

    public Set<String> getAppliedPatches() {
        return this.getPatchesWithStatus(PatchStatus.APPLIED);
    }

    public Set<String> getRemovedPatches() {
        return this.getPatchesWithStatus(PatchStatus.REMOVED);
    }

    public Set<String> getNotAppliedPatches() {
        return this.getPatchesWithStatus(PatchStatus.NOT_APPLIED);
    }

    public Set<String> getPatchesWithStatus(PatchStatus status) {
        return PatchTrackerService.getPatchesWithStatus(status, this.getPatchStatuses());
    }

    public static Set<String> getPatchesWithStatus(PatchStatus status, Map<String, PatchStatus> patchStatuses) {
        LinkedHashSet<String> patches = new LinkedHashSet<String>();
        if (patchStatuses != null && !patchStatuses.isEmpty()) {
            for (Map.Entry<String, PatchStatus> entry : patchStatuses.entrySet()) {
                if (entry.getValue() != status) continue;
                patches.add(entry.getKey());
            }
        }
        return patches;
    }

    public boolean isPatchApplied(String patchId) {
        return this._patchStatuses.get(patchId).isApplied();
    }

    public boolean isPatchRemoved(String patchId) {
        return this._patchStatuses.get(patchId).isRemoved();
    }

    public File getPatchIdDir(String patchId) {
        return this.getPatchIdDirPath(patchId) != null ? this.getPatchIdDirPath(patchId).toFile() : null;
    }

    public Path getPatchIdDirPath(String patchId) {
        return this._patchIdDirs.get(patchId);
    }

    public Collection<File> getPatchIdDirs() {
        HashSet<File> patchIdDirs = new HashSet<File>();
        for (Path patchIdDir : this.getPatchIdDirPaths()) {
            patchIdDirs.add(patchIdDir.toFile());
        }
        return patchIdDirs;
    }

    public Collection<Path> getPatchIdDirPaths() {
        return new HashSet<Path>(this._patchIdDirs.values());
    }

    public void patchesApplied() throws IOException {
        for (Map.Entry<String, PatchStatus> entry : this._patchStatuses.entrySet()) {
            String patchId = entry.getKey();
            if (entry.getValue().isRemoved()) continue;
            this.patchApplied(patchId);
        }
    }

    public void patchApplied(String patchId) throws IOException {
        if (StringUtil.isNullOrEmpty((String)patchId)) {
            throw new IOException("The patch id specified was null or empty.");
        }
        Path patchIdDir = this._patchIdDirs.get(patchId);
        if (patchIdDir == null) {
            throw new FileNotFoundException("Unable to find patch directory corresponding to patch id " + patchId);
        }
        Path patchAppliedFile = this.getPatchAppliedFilePath(patchId);
        if (!Files.exists(patchAppliedFile, new LinkOption[0])) {
            Files.createFile(patchAppliedFile, new FileAttribute[0]);
        }
        this._patchStatuses.put(patchId, PatchStatus.APPLIED);
    }

    public void patchRemoved(String patchId) throws IOException {
        this.deletePatchAppliedFile(patchId);
        this._patchStatuses.put(patchId, PatchStatus.REMOVED);
    }

    public void resetStatuses() throws IOException {
        if (!this._patchIdDirs.isEmpty()) {
            for (Map.Entry<String, PatchStatus> entry : this._patchStatuses.entrySet()) {
                String patchId = entry.getKey();
                if (entry.getValue().isRemoved()) continue;
                this._patchStatuses.put(patchId, PatchStatus.NOT_APPLIED);
                this.deletePatchAppliedFile(patchId);
            }
        }
    }

    private void deletePatchAppliedFile(String patchId) throws IOException {
        Path patchAppliedFile = this.getPatchAppliedFilePath(patchId);
        if (Files.exists(patchAppliedFile, new LinkOption[0])) {
            Files.delete(patchAppliedFile);
            if (Files.exists(patchAppliedFile, new LinkOption[0])) {
                throw new IOException("Unable to delete patch applied file " + patchAppliedFile);
            }
        }
    }

    private Path getPatchAppliedFilePath(String patchId) throws IOException {
        if (StringUtil.isNullOrEmpty((String)patchId)) {
            throw new IOException("The patch id specified was null or empty.");
        }
        return this._patchesDir.resolve(patchId + PATCH_APPLIED_FILE_EXTENSION);
    }

    public static enum PatchStatus {
        APPLIED,
        NOT_APPLIED,
        REMOVED;


        public boolean isApplied() {
            return this == APPLIED;
        }

        public boolean isNotApplied() {
            return this == NOT_APPLIED;
        }

        public boolean isRemoved() {
            return this == REMOVED;
        }
    }
}

