/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.repository;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.Module;
import com.oracle.cie.dependency.mgmt.Version;
import com.oracle.cie.gdr.FeatureLoader;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.dao.cmn.ResourceBundleInfo;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.GdrHelper;
import com.oracle.cie.gdr.nio.NioCopy;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.repository.common.exceptions.RepositoryCommonException;
import com.oracle.cie.repository.resolver.RepositoryVersionResolver;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RestHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RepositoryFeatureLoader
extends FeatureLoader {
    private static final Logger _log = Logger.getLogger(RepositoryFeatureLoader.class.getName());
    private RestHandler _restHandler;
    private RepositoryVersionResolver _versionResolver;
    private List<Artifact> _artifacts = new ArrayList<Artifact>();
    private List<Repository> _remoteRepositories;
    private boolean _gendeps = false;
    private boolean _copyToMetaDataHome = true;
    private boolean _retrieveDependencyFiles = true;

    public RepositoryFeatureLoader(File metaDataDir, Set<FeatureSetReference> featureRefs, boolean loadFeatureDependencies, RestHandler restHandler, RepositoryVersionResolver versionResolver, List<Repository> remoteRepositories, boolean gendeps, boolean copyToMetaDataHome, boolean retrieveDependencyFiles) throws GdrException, IOException, DataHandlerException {
        this(metaDataDir != null ? new MetaDataHome(metaDataDir) : null, featureRefs, loadFeatureDependencies, restHandler, versionResolver, remoteRepositories, gendeps, copyToMetaDataHome, retrieveDependencyFiles);
    }

    public RepositoryFeatureLoader(MetaDataHome metaDataHome, Set<FeatureSetReference> featureRefs, boolean loadFeatureDependencies, RestHandler restHandler, RepositoryVersionResolver versionResolver, List<Repository> remoteRepositories, boolean gendeps, boolean copyToMetaDataHome, boolean retrieveDependencyFiles) throws GdrException, IOException, DataHandlerException {
        this._metaDataHome = metaDataHome;
        this._loadFeatureDependencies = loadFeatureDependencies;
        this._restHandler = restHandler;
        this._versionResolver = versionResolver;
        this._remoteRepositories = remoteRepositories;
        this._gendeps = gendeps;
        this._copyToMetaDataHome = copyToMetaDataHome;
        this._retrieveDependencyFiles = retrieveDependencyFiles;
        this.validate();
        this.init(featureRefs, null);
    }

    @Override
    protected void validate() throws GdrException {
        if (this._copyToMetaDataHome && this._metaDataHome == null) {
            GdrException ex = new GdrException("The meta-data home provided was null.");
            _log.throwing(FeatureLoader.class.getName(), "validate", ex);
            throw ex;
        }
    }

    @Override
    protected FeatureSet loadFeatureSet(MetaDataHome metaDataHome, FeatureSetReference featureRef) throws IOException, DataHandlerException, GdrException {
        try {
            FeatureSet featureSet;
            if (featureRef == null) {
                throw new GdrException("The feature ref provided was null.");
            }
            String featureName = featureRef.getName();
            String featureVersion = featureRef.getVersion();
            Version version = this._versionResolver.getFeatureSetVersion(featureName, featureVersion);
            Artifact featureSetArtifact = DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.featureset", featureName, version, "xml");
            this._artifacts.add(featureSetArtifact);
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Working with feature set " + featureSetArtifact);
            }
            Path featureFile = NioHelper.getInstance().getPath(this._restHandler.retrieveArtifact(featureSetArtifact, this._remoteRepositories, true));
            if (this._retrieveDependencyFiles) {
                Version depVersion = null;
                try {
                    depVersion = this._versionResolver.getFeatureSetDependencyVersion(featureName, version.getVersion());
                }
                catch (RepositoryCommonException e) {
                    _log.finest(e.getMessage());
                }
                if (depVersion != null) {
                    Artifact featureSetDepArtifact = DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.featureset.dependencies", featureName, depVersion, "xml");
                    this._artifacts.add(featureSetDepArtifact);
                    File featureDepFile = this._restHandler.retrieveArtifact(featureSetDepArtifact, this._remoteRepositories, true);
                    Module featureDepModule = DependencyManagementFactory.getInstance().getDependencyFileHandler().readDependenciesFile(featureDepFile);
                    this._versionResolver.addDependencyModule(featureDepModule);
                    if (_log.isLoggable(Level.FINER)) {
                        _log.finer("Working with feature set dependencies " + featureSetDepArtifact);
                    }
                } else if (_log.isLoggable(Level.FINER)) {
                    _log.finer("No feature set dependencies file found for " + featureSetArtifact);
                }
                if (depVersion == null && this._gendeps) {
                    try {
                        Version latestDepVersion = this._versionResolver.getFeatureSetDependencyVersion(featureName, version.getVersion(), true, false);
                        Artifact latestFeatureSetDepsArtifact = DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.featureset.dependencies", featureName, latestDepVersion, "xml");
                        this._restHandler.retrieveArtifact(latestFeatureSetDepsArtifact, this._remoteRepositories, true);
                        if (_log.isLoggable(Level.FINER)) {
                            _log.finer("Adding latest feature set dependency file to consumed artifacts for gendeps processing : " + latestFeatureSetDepsArtifact);
                        }
                        this._artifacts.add(latestFeatureSetDepsArtifact);
                    }
                    catch (RepositoryCommonException e) {
                        _log.finest(e.getMessage());
                    }
                }
            }
            Path featureResourcesFile = null;
            Artifact featureResourcesArtifact = null;
            Version featureResourceVersion = null;
            try {
                featureResourceVersion = this._versionResolver.getFeatureSetResourcesVersion(featureName, version.getBaseVersion());
            }
            catch (RepositoryCommonException e) {
                _log.log(Level.FINEST, e.getMessage(), e);
            }
            if (featureResourceVersion == null) {
                _log.warning("Could not resolve feature set resources version for " + featureName + " : " + version.getBaseVersion());
            } else {
                featureResourcesArtifact = DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.featureset.resources", featureName, featureResourceVersion, "jar");
                this._artifacts.add(featureResourcesArtifact);
                _log.finest("Using feature set resources artifact " + featureResourcesArtifact);
                featureResourcesFile = NioHelper.getInstance().getPath(this._restHandler.retrieveArtifact(featureResourcesArtifact, this._remoteRepositories, true));
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Working with feature set resources " + featureResourcesArtifact);
                }
            }
            if (this._copyToMetaDataHome) {
                Path featureFileDest = metaDataHome.getGdrMetaDataHomePath().resolve("featuresets" + File.separator + FeatureSetHelper.getInstance().getFeatureSetFileName(featureName, featureSetArtifact.getBaseVersion()));
                NioCopy.copyFile((Path)featureFile, (Path)featureFileDest);
                if (featureResourcesFile != null) {
                    Path featureResourcesFileDest = this._metaDataHome.getGdrMetaDataHomePath().resolve("featuresets" + File.separator + FeatureSetHelper.getInstance().getResourceLocation(featureName, featureResourcesArtifact.getBaseVersion()));
                    NioCopy.copyFile((Path)featureResourcesFile, (Path)featureResourcesFileDest);
                }
                featureSet = FeatureSetHelper.getInstance().getFeatureSet(featureFileDest);
            } else {
                featureSet = FeatureSetHelper.getInstance().getFeatureSet(featureFile, false);
                if (featureResourcesFile != null) {
                    featureSet.setResourceBundleInfo(new ResourceBundleInfo(featureResourcesFile, featureSet.getName(), featureSet.getVersion(), (GdrHelper)FeatureSetHelper.getInstance()));
                }
            }
            featureSet.setFeatureRefAttributes(featureRef);
            return featureSet;
        }
        catch (Exception e) {
            throw new GdrException((Throwable)e);
        }
    }

    @Override
    protected Set<FeatureSet> sortFeatureSets(Set<FeatureSet> featureSets) {
        return featureSets;
    }

    public List<Artifact> getArtifacts() {
        return this._artifacts;
    }
}

