/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.patch.cin;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.di.DistributionInfo;
import com.oracle.cie.gdr.helpers.DistributionInfoHelper;
import com.oracle.cie.gdr.helpers.PlatformInfoHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.platform.PlatformInfoHolder;
import com.oracle.cie.gdr.utils.OraparamException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.glcm.common.inventory.api.Home;

public class HomeImpl
implements Home {
    private static final Logger _log = Logger.getLogger(HomeImpl.class.getName());
    private static final String INVENTORY_DIR = "inventory";
    private final String name;
    private final String location;
    private final int index;

    private HomeImpl(String name, String location, int index) {
        this.name = name;
        this.location = location;
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public String getARUIDDescription() {
        PlatformInfoHolder piHolder = PlatformInfoHelper.getInstance().getPlatformInfoHolder(this.getPlatformId());
        return piHolder == null ? null : piHolder.getARUDesc();
    }

    public int getIndex() {
        return this.index;
    }

    public String getHomeProperty(String key) {
        String property;
        block10: {
            property = null;
            if (StringUtil.isNullOrEmpty((String)key, (boolean)true)) {
                return null;
            }
            try {
                DistributionInfoHelper diHelper = DistributionInfoHelper.getInstance();
                Path dinfoDir = NioHelper.getInstance().getPath(this.location, new String[]{INVENTORY_DIR, DistributionInfoHelper.DISTRIBUTION_INFO_DIR});
                if (dinfoDir == null || !Files.isDirectory(dinfoDir, new LinkOption[0])) break block10;
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(dinfoDir);){
                    for (Path distInfoFileItem : stream) {
                        DistributionInfo info;
                        String[] values;
                        if (!Files.isRegularFile(distInfoFileItem, new LinkOption[0]) || (values = diHelper.getPropertyValue(info = diHelper.getDistributionInfo(distInfoFileItem, true), "shiphomeproperties", this.name)) == null || values.length <= 0) continue;
                        property = values[0];
                        break;
                    }
                }
            }
            catch (OraparamException | IOException e) {
                String message = "Reading Home Distribution info shiphomeproperties FAILED: " + e.toString();
                _log.warning(message);
                if (!_log.isLoggable(Level.FINEST)) break block10;
                _log.log(Level.FINEST, message, e);
            }
        }
        return property;
    }

    public String getLocalNode() {
        return null;
    }

    public List<String> getNodes() {
        return null;
    }

    public boolean isNextGen() {
        return true;
    }

    public boolean isCRSHome() {
        return false;
    }

    public int getPlatformId() {
        return PlatformInfoHelper.getInstance().getCurrentPlatformId();
    }

    public static HomeImplBuilder getHomeImplBuilder(String name, String location) {
        return new HomeImplBuilder().name(name).location(location);
    }

    public String toString() {
        return HomeImpl.class.getName() + " [name=" + this.name + ", location=" + this.location + ", index=" + this.index + "]";
    }

    public static class HomeImplBuilder {
        private String nestedName;
        private String nestedLocation;
        private int nestedIndex;

        private HomeImplBuilder() {
        }

        public HomeImplBuilder name(String name) {
            this.nestedName = name;
            return this;
        }

        public HomeImplBuilder location(String location) {
            this.nestedLocation = location;
            return this;
        }

        public HomeImplBuilder index(int index) {
            this.nestedIndex = index;
            return this;
        }

        public HomeImpl build() {
            return new HomeImpl(this.nestedName, this.nestedLocation, this.nestedIndex);
        }
    }
}

