/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.packaging;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.packaging.Packager;
import com.oracle.cie.gdr.services.ServiceHolder;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class CommonPackager
implements Packager {
    private MetaDataHome _metaDataHome;
    protected ServiceHolder _serviceHolder;

    public CommonPackager(MetaDataHome metaDataHome, Set<Integer> platforms, Set<Integer> locales, Map<String, String> variableMap) throws IOException, DataHandlerException, GdrException {
        this._metaDataHome = metaDataHome;
        this._serviceHolder = new ServiceHolder(platforms, locales, variableMap);
        if (variableMap == null || !variableMap.containsKey("SRCHOME")) {
            this._serviceHolder.getVariableResolverService().set("SRCHOME", metaDataHome.getSrchome().getPath());
        }
    }

    @Override
    public abstract Map<FeatureSet, Collection<Component>> getComponentsMap();

    @Override
    public MetaDataHome getMetaDataHome() {
        return this._metaDataHome;
    }

    @Override
    public File getMetaDataHomeDir() {
        return this.getMetaDataHome().getComponentMetaDataHome();
    }

    public ServiceHolder getServiceHolder() {
        return this._serviceHolder;
    }

    @Override
    public Set<Component> getComponents() {
        LinkedHashSet<Component> components = new LinkedHashSet<Component>();
        Map<FeatureSet, Collection<Component>> compMap = this.getComponentsMap();
        for (Collection<Component> comps : compMap.values()) {
            for (Component component : comps) {
                components.add(component);
            }
        }
        return components;
    }

    @Override
    public Set<Component> getSelectedComponents() {
        return this.getComponents();
    }
}

