/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.merger;

import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.dbd.Mapping;
import com.oracle.cie.gdr.dao.dbd.RootMapping;
import com.oracle.cie.gdr.libraries.LibraryGenerator;
import com.oracle.cie.gdr.merger.MergeException;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.services.TopLevelDirectoryService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Properties;

public class SilentJarMerger {
    private static final String PROPERTIES_ARG = "-props";
    private static final String SRC_ARG = "-srcHome";
    private static final String NAME_ARG = "name";
    private static final String VERSION_ARG = "version";
    private static final String TYPE_ARG = "type";
    private static final String SRCHOME_ARG = "src_home";
    private static final String DEST_DIR_ARG = "dest_dir";
    private static final String SYMBOLS_ARG = "symbols";
    private static final String DIRECTORY_ARG = "directory";
    private static final String MAPPING_LIST_ARG = "mapping_list";
    private static final String GDR_PATH_ARG = "gdr_path";
    private static final String TYPE_DISTRIBUTION = "distribution";
    private static final String TYPE_FEATURESET = "featureset";
    private static final String TYPE_COMPONENT = "component";
    private static String _mergerName = "";
    private static String _mergerVersion = "12.0.0.0.0";
    private static LibraryGenerator.InputType _mergerType;
    private static String _mergerSrcHome;
    private static String _mergerDestDir;
    private static String[] _mergerSymbols;
    private static String _mergerDirectory;
    private static String[] _mergerMapping;
    private static Path _srchome;
    private static Path _destDir;

    public static void main(String[] args) throws Exception {
        SilentJarMerger.processArgs(args);
        SilentJarMerger.validateArgs();
        MetaDataHome metaDataHome = new MetaDataHome(TopLevelDirectoryService.getGdrLabelTopLevelDirectory(_srchome.toFile()), false);
        LibraryGenerator generator = new LibraryGenerator(_mergerName, _mergerVersion, _mergerType, _destDir, SilentJarMerger.createDirMap(_mergerSymbols, _mergerDirectory, _mergerMapping), metaDataHome);
        generator.run();
    }

    public static DirectoryMap createDirMap(String[] rootSymbols, String directory, String[] mapSymbols) {
        DirectoryMap dirMap = new DirectoryMap();
        RootMapping rootMap = new RootMapping();
        rootMap.setSymbols(rootSymbols);
        dirMap.setRootMapping(rootMap);
        Mapping map = new Mapping();
        map.setDirectory(directory);
        map.setSymbols(mapSymbols);
        dirMap.setMappings(Arrays.asList(map));
        return dirMap;
    }

    private static void validateArgs() throws Exception {
        if (_mergerName == null || _mergerName.isEmpty()) {
            throw new Exception("Name null or empty");
        }
        if (_mergerVersion == null || _mergerVersion.isEmpty()) {
            _mergerVersion = "12.0.0.0.0";
        }
        if (_mergerSrcHome == null || _mergerSrcHome.isEmpty()) {
            _mergerSrcHome = System.getProperty("SRCHOME");
        }
        _srchome = NioHelper.getInstance().getPath(_mergerSrcHome, new String[0]);
        if (_mergerDestDir == null || _mergerDestDir.isEmpty()) {
            _mergerDestDir = _srchome.resolve("oracle_home").toString();
        } else {
            SilentJarMerger.replaceWildcards();
        }
        _destDir = NioHelper.getInstance().getPath(_mergerDestDir, new String[0]);
        if (_mergerType != LibraryGenerator.InputType.DISTRIBUTION) {
            if (_mergerSymbols == null || _mergerSymbols.length <= 0) {
                throw new MergeException("The attribute symbols is mandatory");
            }
            if (_mergerMapping == null || _mergerMapping.length <= 0) {
                throw new MergeException("The attribute mapping_list is mandatory");
            }
            if (_mergerDirectory == null || _mergerDirectory.isEmpty()) {
                throw new MergeException("The attribute directory is mandatory");
            }
        }
    }

    private static void replaceWildcards() {
        String temp = SilentJarMerger.getWildcard(_mergerDestDir);
        if (temp.toLowerCase().equals(SRCHOME_ARG)) {
            _mergerDestDir = _mergerDestDir.replace("%" + temp + "%", _srchome.toString());
        }
    }

    private static String getWildcard(String source) {
        StringBuilder temp = new StringBuilder();
        if (_mergerDestDir.contains("%")) {
            boolean begin = false;
            for (int index = 0; index < _mergerDestDir.length(); ++index) {
                if (begin) {
                    _mergerDestDir.charAt(index);
                    if (_mergerDestDir.charAt(index) == '%') {
                        return temp.toString();
                    }
                    temp.append(_mergerDestDir.charAt(index));
                    continue;
                }
                if (_mergerDestDir.charAt(index) != '%') continue;
                begin = true;
            }
        }
        return temp.toString();
    }

    private static void processArgs(String[] args) throws MergeException {
        for (int i = 0; i < args.length; i += 2) {
            if (args[i].equals(PROPERTIES_ARG)) {
                Path propertiesFile = NioHelper.getInstance().getPath(args[i + 1], new String[0]);
                if (Files.exists(propertiesFile, new LinkOption[0]) && Files.isRegularFile(propertiesFile, new LinkOption[0])) {
                    SilentJarMerger.processProperties(propertiesFile);
                    continue;
                }
                throw new MergeException("The properties file is need");
            }
            if (!args[i].equals(SRC_ARG)) continue;
            System.setProperty("SRCHOME", args[i + 1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processProperties(Path propFile) {
        Properties properties = new Properties();
        InputStream propStream = null;
        try {
            String temp = "";
            propStream = Files.newInputStream(propFile, new OpenOption[0]);
            properties.load(propStream);
            _mergerName = properties.getProperty(NAME_ARG);
            _mergerVersion = properties.getProperty(VERSION_ARG);
            SilentJarMerger.setType(properties.getProperty(TYPE_ARG).toLowerCase());
            _mergerSrcHome = properties.getProperty(SRCHOME_ARG);
            temp = properties.getProperty(GDR_PATH_ARG);
            if (temp != null && !temp.isEmpty()) {
                System.setProperty(TopLevelDirectoryService.GDR_PATH_PROPERTY, temp);
            }
            _mergerDestDir = properties.getProperty(DEST_DIR_ARG);
            temp = properties.getProperty(SYMBOLS_ARG);
            if (temp != null && !temp.isEmpty()) {
                _mergerSymbols = temp.split(",");
            }
            _mergerDirectory = properties.getProperty(DIRECTORY_ARG);
            temp = properties.getProperty(MAPPING_LIST_ARG);
            if (temp != null && !temp.isEmpty()) {
                _mergerMapping = temp.split(",");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MergeException e) {
            e.printStackTrace();
        }
        finally {
            if (propStream != null) {
                try {
                    propStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static void setType(String type) throws MergeException {
        if (type == null || type.isEmpty()) {
            throw new MergeException("The type " + type + "was not recognized");
        }
        if (TYPE_DISTRIBUTION.equals(type = type.toLowerCase())) {
            _mergerType = LibraryGenerator.InputType.DISTRIBUTION;
        } else if (TYPE_FEATURESET.equals(type)) {
            _mergerType = LibraryGenerator.InputType.FEATURESET;
        } else if (TYPE_COMPONENT.equals(type)) {
            _mergerType = LibraryGenerator.InputType.COMPONENT;
        } else {
            throw new MergeException("The type " + type + "was not recognized");
        }
    }

    static {
        _mergerSrcHome = "";
        _mergerDestDir = "";
        _mergerDirectory = "";
    }
}

