/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.merger;

import com.oracle.cie.gdr.merger.EntryDescriptor;
import com.oracle.cie.gdr.merger.EntryDescriptorCollection;
import com.oracle.cie.gdr.merger.IFileConflictResolver;
import com.oracle.cie.gdr.merger.MergeException;
import com.oracle.cie.gdr.utils.FileUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class AppendFileResolver
implements IFileConflictResolver {
    @Override
    public void resolve(EntryDescriptorCollection entryCollection, List<EntryDescriptor> conflictList, Path destFilePath, Path tempDir) throws MergeException {
        try {
            Files.createDirectories(destFilePath.getParent(), new FileAttribute[0]);
            if (!Files.exists(destFilePath.getParent(), new LinkOption[0])) {
                throw new MergeException("Failed to create parent directories for file " + destFilePath.toAbsolutePath());
            }
            for (int i = 0; i < conflictList.size(); ++i) {
                EntryDescriptor entry = conflictList.get(i);
                Path entryFile = tempDir.resolve(entry.getEntry().getName() + i);
                try {
                    entry.getLibraryJar().getJar().extract(entry.getEntry(), entryFile.toFile());
                    FileUtils.appendContents(entryFile, destFilePath);
                    continue;
                }
                catch (Exception e) {
                    throw new MergeException(e);
                }
            }
            entryCollection.removeConflict(conflictList.get(0).getEntry().getName());
        }
        catch (Exception e) {
            throw new MergeException(e);
        }
    }
}

