/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.libraries;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.libraries.JarLibraryHandler;
import com.oracle.cie.gdr.libraries.LibraryEntryLocation;
import com.oracle.cie.gdr.libraries.LibraryHandlerException;
import com.oracle.cie.gdr.libraries.LibraryKey;
import com.oracle.cie.gdr.libraries.LibraryType;
import com.oracle.cie.gdr.nio.NioHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.logging.Logger;

public class ManifestLibraryHandler
extends JarLibraryHandler {
    private static final Logger _log = Logger.getLogger(ManifestLibraryHandler.class.getName());
    public static final String EXTERNAL_JAR_LOCATION = "modules/features";
    public static final String INTERNAL_JAR_LOCATION = "modules/internal/features";

    @Override
    public LibraryType getLibraryType() {
        return LibraryType.manifest;
    }

    @Override
    protected Collection<Path> generate(Home home, Set<LibraryEntryLocation> entryLocations, String productHome, List<String> jarLocations, Attributes manifestAttribs) throws LibraryHandlerException {
        if (home == null) {
            LibraryHandlerException ex = new LibraryHandlerException("The home provided was null.");
            _log.throwing(this.getClass().getName(), "handle", (Throwable)((Object)ex));
            throw ex;
        }
        ArrayList<Path> created = new ArrayList<Path>();
        if (!StringUtil.isNullOrEmpty((String)productHome, (boolean)true)) {
            for (String jarLocation : jarLocations) {
                String classpath = this.getClasspathString(entryLocations, jarLocation, productHome);
                Path cpJar = NioHelper.getInstance().getPath(this.getFullJarLocation(productHome + File.separator + jarLocation), new String[0]);
                try {
                    _log.finest("Creating manifest classpath jar at " + cpJar + " with classpath " + classpath);
                    this.cleanLibraryDirectory(cpJar);
                    ManifestLibraryHandler.createManifestJar(cpJar, classpath, manifestAttribs);
                }
                catch (IOException e) {
                    throw new LibraryHandlerException(e);
                }
                created.add(cpJar);
            }
        } else {
            _log.finest("No " + (Object)((Object)this.getLibraryType()) + " jars were created for " + jarLocations + " because no product home directories were provided.");
        }
        return created;
    }

    @Override
    public String getInternalJarLocation() {
        return INTERNAL_JAR_LOCATION;
    }

    @Override
    public String getExternalJarLocation() {
        return EXTERNAL_JAR_LOCATION;
    }

    @Override
    public String getComponentJarName(Component component, LibraryKey key, boolean suppressPrefix, boolean suppressVersion) {
        return this.getJarName(component.getName(), key, suppressPrefix, suppressVersion);
    }

    @Override
    public String getFeatureJarName(FeatureSet feature, LibraryKey key, boolean suppressPrefix, boolean suppressVersion) {
        return this.getJarName(feature.getName(), key, suppressPrefix, suppressVersion);
    }

    private String getJarName(String name, LibraryKey key, boolean suppressPrefix, boolean suppressVersion) {
        String jarName = "";
        if (!suppressPrefix) {
            jarName = name + "_";
        }
        jarName = jarName + key.getName();
        if (!suppressVersion) {
            jarName = jarName + "_" + key.getVersion();
        }
        jarName = jarName + "." + (Object)((Object)key.getExtension());
        return jarName;
    }

    @Override
    public boolean isThreadable() {
        return true;
    }
}

