/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.libraries;

import com.oracle.cie.gdr.libraries.LibraryHandler;
import java.lang.reflect.InvocationTargetException;

public enum LibraryType {
    runtime("runtime", "Runtime"),
    manifest("manifest", "Manifest"),
    client("client", "Client"),
    mergedJar("mergedJar", "MergedJar"),
    none("none", "None");

    private String _name;
    private String _classPrefix;

    public static LibraryType getLibraryType(String name) {
        for (LibraryType type : LibraryType.values()) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        throw new IllegalArgumentException("No enum constant " + client.getName() + " for " + name);
    }

    private LibraryType(String name, String classPrefix) {
        this._name = name;
        this._classPrefix = classPrefix;
    }

    public String getName() {
        return this._name;
    }

    public String getClassPrefix() {
        return this._classPrefix;
    }

    public Class<?> getHandlerClass() throws ClassNotFoundException {
        return Class.forName(LibraryType.class.getPackage().getName() + "." + this.getClassPrefix() + LibraryHandler.class.getSimpleName());
    }

    public LibraryHandler getHandler() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        return (LibraryHandler)this.getHandlerClass().getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public boolean isNone() {
        return this == none;
    }

    public boolean isManifest() {
        return this == manifest;
    }

    public boolean isRuntime() {
        return this == runtime;
    }
}

