/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.libraries;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.DistributionLoader;
import com.oracle.cie.gdr.DistributionLoaderFactory;
import com.oracle.cie.gdr.FeatureLoader;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.Version;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.LabelMapHelper;
import com.oracle.cie.gdr.installation.Installer;
import com.oracle.cie.gdr.libraries.LibraryProcessor;
import com.oracle.cie.gdr.libraries.LibraryProcessorManager;
import com.oracle.cie.gdr.libraries.LibraryTargetHolder;
import com.oracle.cie.gdr.merger.IFileConflictResolver;
import com.oracle.cie.gdr.merger.IManifestConflictResolver;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.services.ServiceHolder;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class LibraryGenerator {
    private static final Logger _log = Logger.getLogger(LibraryGenerator.class.getName());
    private String _name;
    private String _version;
    private InputType _inputType;
    private DirectoryMap _dirMap;
    private Map<String, String> _props = null;
    private Set<Integer> _platforms = null;
    private Set<Integer> _locales = null;
    private Path _destDir;
    private MetaDataHome _metaDataHome;
    private Installer _installer = null;
    private IFileConflictResolver conflictResolver = null;
    private IManifestConflictResolver manifestResolver = null;

    public LibraryGenerator(String name, String version, InputType inputType, File destDir, MetaDataHome metaDataHome) throws GdrException {
        this.init(name, version, inputType, NioHelper.getInstance().getPath(destDir), null, metaDataHome, null);
    }

    public LibraryGenerator(String name, String version, InputType inputType, Path destDir, MetaDataHome metaDataHome) throws GdrException {
        this.init(name, version, inputType, destDir, null, metaDataHome, null);
    }

    public LibraryGenerator(String name, String version, InputType inputType, File destDir, Installer installer) throws GdrException {
        this.init(name, version, inputType, NioHelper.getInstance().getPath(destDir), null, installer.getMetaDataHome(), installer);
    }

    public LibraryGenerator(String name, String version, InputType inputType, Path destDir, Installer installer) throws GdrException {
        this.init(name, version, inputType, destDir, null, installer.getMetaDataHome(), installer);
    }

    public LibraryGenerator(String name, String version, InputType inputType, File destDir, DirectoryMap dirMap, MetaDataHome metaDataHome) throws GdrException {
        this.init(name, version, inputType, NioHelper.getInstance().getPath(destDir), dirMap, metaDataHome, null);
    }

    public LibraryGenerator(String name, String version, InputType inputType, Path destDir, DirectoryMap dirMap, MetaDataHome metaDataHome) throws GdrException {
        this.init(name, version, inputType, destDir, dirMap, metaDataHome, null);
    }

    public LibraryGenerator(String name, String version, InputType inputType, File destDir, DirectoryMap dirMap, Installer installer) throws GdrException {
        this.init(name, version, inputType, NioHelper.getInstance().getPath(destDir), dirMap, installer.getMetaDataHome(), installer);
    }

    public LibraryGenerator(String name, String version, InputType inputType, Path destDir, DirectoryMap dirMap, Installer installer) throws GdrException {
        this.init(name, version, inputType, destDir, dirMap, installer.getMetaDataHome(), installer);
    }

    public void run() throws GdrException, IOException, DataHandlerException, DependencyException {
        _log.info("Start Library Generator");
        ServiceHolder serviceHolder = new ServiceHolder(this._platforms, this._locales, this._props);
        this.addSrchHomeToserviceHolder(this._metaDataHome, serviceHolder);
        FeatureLoader featureLoader = this.processFeatureLoader(this._metaDataHome);
        Set<FeatureSet> featureSets = featureLoader.getFeatureSets();
        Mode mode = Boolean.getBoolean("ComponentHelper.shiphome.packaging.load.unexpanded.components") ? Mode.PACKAGE_SHIPHOME : Mode.INSTALL;
        ComponentLoader componentLoader = new ComponentLoader(this._metaDataHome, serviceHolder, mode, featureSets, this._dirMap, null, LabelMapHelper.getInstance().getLabelMap(this._metaDataHome.getGdrMetaDataHomePath()));
        Set<Component> comps = componentLoader.getComponents();
        if (mode.isPackagingMode()) {
            for (Component component : comps) {
                ComponentHelper.getInstance().expandLibrary(component);
                component.setGdrVersion(Version.getVersion());
            }
        }
        Home home = Home.getHome(this._destDir);
        Map<FeatureSet, LibraryTargetHolder> featureLibs = FeatureSetHelper.getInstance().getLibraryTargets(featureSets, home, componentLoader.getComponentsMap(), serviceHolder, this._dirMap);
        for (FeatureSet f : featureSets) {
            LibraryProcessor.process(featureLibs.get(f), home, this._installer, mode);
        }
        LibraryProcessorManager.processLibraries();
        _log.info("End Library Generator");
    }

    private FeatureLoader processFeatureLoader(MetaDataHome metaDataHome) throws GdrException, IOException, DataHandlerException {
        if (this._inputType == InputType.DISTRIBUTION) {
            DistributionLoader distLoader = DistributionLoaderFactory.getDistributionLoader(metaDataHome, this._name, this._version);
            this._dirMap = distLoader.getDirectoryMap();
            return distLoader.getFeatureLoader();
        }
        if (this._inputType == InputType.FEATURESET) {
            FeatureSetReference featureRef = new FeatureSetReference(this._name, this._version);
            LinkedHashSet<FeatureSetReference> featureRefs = new LinkedHashSet<FeatureSetReference>();
            featureRefs.add(featureRef);
            return new FeatureLoader(metaDataHome, featureRefs);
        }
        HashSet<Reference> componentReferences = new HashSet<Reference>();
        componentReferences.add(new Reference(this._name, this._version));
        return new FeatureLoader(metaDataHome, FeatureSetHelper.getInstance().convertReferences(null), this.createDummyFeatureSet(metaDataHome, componentReferences));
    }

    private void addSrchHomeToserviceHolder(MetaDataHome metaDataHome, ServiceHolder serviceHolder) {
        if (this._props == null || !this._props.containsKey("SRCHOME")) {
            serviceHolder.getVariableResolverService().set("SRCHOME", metaDataHome.getSrchome().getPath());
        }
    }

    protected void init(String name, String version, InputType type, Path destDir, DirectoryMap dirMap, MetaDataHome metaDataHome, Installer installer) throws GdrException {
        this._name = name;
        this._version = version;
        this._inputType = type;
        this._metaDataHome = metaDataHome;
        this._destDir = destDir;
        this._installer = installer;
        this._dirMap = dirMap;
        if (this._name == null || this._name.isEmpty()) {
            GdrException ex = new GdrException("Name is null or empty");
            _log.throwing(LibraryGenerator.class.getName(), "init", ex);
            throw ex;
        }
        if (this._version == null || this._version.isEmpty()) {
            GdrException ex = new GdrException("Version is null or empty");
            _log.throwing(LibraryGenerator.class.getName(), "init", ex);
            throw ex;
        }
        if (this._inputType == null) {
            GdrException ex = new GdrException("Type is null");
            _log.throwing(LibraryGenerator.class.getName(), "init", ex);
            throw ex;
        }
        switch (this._inputType) {
            case FEATURESET: 
            case COMPONENT: {
                if (this._dirMap != null) break;
                GdrException ex = new GdrException("DirectoryMap is null");
                _log.throwing(LibraryGenerator.class.getName(), "init", ex);
                throw ex;
            }
        }
    }

    public IFileConflictResolver getConflictResolver() {
        return this.conflictResolver;
    }

    public void setConflictResolver(IFileConflictResolver conflictResolver) {
        this.conflictResolver = conflictResolver;
    }

    public IManifestConflictResolver getManifestResolver() {
        return this.manifestResolver;
    }

    public void setManifestResolver(IManifestConflictResolver manifestResolver) {
        this.manifestResolver = manifestResolver;
    }

    private Set<FeatureSet> createDummyFeatureSet(MetaDataHome metaDataHome, Set<Reference> componentReferences) throws IOException, DataHandlerException, GdrException {
        if (componentReferences == null || componentReferences.isEmpty()) {
            GdrException ex = new GdrException("Failed to install component archives because no components were found under " + componentReferences);
            _log.throwing(LibraryGenerator.class.getName(), "createDummyFeatureSet", ex);
            throw ex;
        }
        HashSet<FeatureSet> dummyFeature = new HashSet<FeatureSet>();
        dummyFeature.add(FeatureSetHelper.getInstance().createFeatureSet(this._name, this._version, componentReferences));
        return dummyFeature;
    }

    public void setMetaDataHome(MetaDataHome metaDataHome) {
        this._metaDataHome = metaDataHome;
    }

    public void setProperties(Map<String, String> props) {
        this._props = props;
    }

    public void setPlatforms(Set<Integer> platforms) {
        this._platforms = platforms;
    }

    public void setLocales(Set<Integer> locales) {
        this._locales = locales;
    }

    public static enum InputType {
        DISTRIBUTION,
        FEATURESET,
        COMPONENT;

    }
}

