/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.installation;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.FeatureLoader;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.nfo.ExternalFeatureReference;
import com.oracle.cie.gdr.dao.rgy.ComponentInfo;
import com.oracle.cie.gdr.dao.rgy.DistributionInfo;
import com.oracle.cie.gdr.dao.rgy.FeatureInfo;
import com.oracle.cie.gdr.dao.rgy.Registry;
import com.oracle.cie.gdr.dao.rgy.SessionAction;
import com.oracle.cie.gdr.dao.rgy.SessionInfo;
import com.oracle.cie.gdr.dao.rgy.TargetInfo;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.installation.CommonInstaller;
import com.oracle.cie.gdr.installation.DistributionInstaller;
import com.oracle.cie.gdr.installation.PatchComponentArchiveInstallationSession;
import com.oracle.cie.gdr.libraries.LibraryException;
import com.oracle.cie.gdr.libraries.LibraryTargetHolder;
import com.oracle.cie.gdr.selection.Status;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class PatchComponentArchiveInstaller
extends CommonInstaller {
    private static final Logger _log = Logger.getLogger(PatchComponentArchiveInstaller.class.getName());
    private PatchComponentArchiveInstallationSession _patchComponentArchiveInstallationSession;
    private Registry _lockedRegistry;
    private String _patchId;

    public PatchComponentArchiveInstaller(PatchComponentArchiveInstallationSession installerSession, Map<String, String> variableMap, Registry registry, String patchId, SessionInfo sessionInfo) throws IOException, DataHandlerException, GdrException, DependencyException {
        super(installerSession, variableMap);
        this._lockedRegistry = registry;
        this._registrySession = sessionInfo;
        this._patchComponentArchiveInstallationSession = installerSession;
        this._patchComponentArchiveInstallationSession.validateInstallation();
        this._patchId = patchId;
    }

    @Override
    public Set<FeatureSet> getFeatureSets() {
        return this.getFeatureLoader().getFeatureSets();
    }

    public FeatureLoader getFeatureLoader() {
        return this.getPatchComponentArchiveInstallationSession().getFeatureLoader();
    }

    public PatchComponentArchiveInstallationSession getPatchComponentArchiveInstallationSession() {
        return this._patchComponentArchiveInstallationSession;
    }

    @Override
    public Map<ExternalFeatureReference, List<Reference>> getExternalDistributions() {
        return null;
    }

    @Override
    public Set<FeatureSet> getSelectedFeatures() {
        return FeatureSetHelper.getInstance().getSortedByDiskOrder(this.getFeatureSets(), this.getComponentsMap());
    }

    @Override
    public Map<FeatureSet, Collection<Component>> getComponentsMap() {
        return this.getComponentLoader().getComponentsMap();
    }

    public ComponentLoader getComponentLoader() {
        return this.getPatchComponentArchiveInstallationSession().getComponentLoader();
    }

    @Override
    public void saveHomeMetadata(Path dir) throws GdrException, DataHandlerException, IOException {
    }

    @Override
    public Distribution getDistribution() {
        return this.getPatchComponentArchiveInstallationSession().getDistributions().iterator().next();
    }

    @Override
    protected Registry getLockedRegistry() throws IOException, DataHandlerException, GdrException {
        return this._lockedRegistry;
    }

    @Override
    protected void unlockRegistry() throws IOException, DataHandlerException, GdrException {
    }

    @Override
    protected void updateRegistry(Registry registry, SessionInfo session, Distribution distribution, Map<FeatureSet, Collection<Component>> compMap, Set<FeatureSet> selectedFeatures, boolean dynamic) throws GdrException {
        if (distribution == null) {
            GdrException ex = new GdrException("The distribution provided was null.");
            _log.throwing(DistributionInstaller.class.getName(), "updateRegistry", ex);
            throw ex;
        }
        session.addPatchId(this._patchId);
        session.setOriginatingPatchId(this._patchId);
        session.setAction(SessionAction.install);
        DistributionInfo dinfo = this.getHome().getRegistryHelper().getDistributionInfo(registry, distribution.getName(), distribution.getVersion());
        List<DistributionInfo> distributionInfos = registry.getDistributions();
        distributionInfos.remove(dinfo);
        Collection<ComponentInfo> otherInstalledComponentInfos = this.getHome().getRegistryHelper().getInstalledComponentInfos(distributionInfos);
        List<FeatureInfo> finfos = dinfo.getFeatures();
        for (FeatureSet feature : compMap.keySet()) {
            FeatureInfo finfo = this.getHome().getRegistryHelper().getFeatureInfo(finfos, feature.getName(), feature.getVersion());
            if (finfo == null || !finfo.getStatus().isInstalled()) {
                throw new GdrException("The feature: " + feature.getName() + " " + feature.getVersion() + " is not installed in the oracle home.");
            }
            if (feature.isSingleton()) {
                finfo.setSingleton(true);
            }
            this.updateCompInfos(finfo, feature.getComponentReferences(), compMap.get(feature), otherInstalledComponentInfos, session, dynamic, true);
        }
    }

    @Override
    protected SessionInfo getRegistrySession(Registry preRegistry) throws GdrException {
        return this._registrySession;
    }

    @Override
    public Map<FeatureSet, LibraryTargetHolder> getLibraryTargets() throws DependencyException, IOException, DataHandlerException, GdrException {
        throw new UnsupportedOperationException("Library geretation is not supported for PatchComponentArchiveInstaller");
    }

    @Override
    public void completeFeatureInstall(FeatureSet feature) throws GdrException {
    }

    @Override
    public boolean startFeatureInstall(FeatureSet feature) throws GdrException {
        return true;
    }

    @Override
    protected void regenerateLibaries() throws LibraryException {
    }

    @Override
    protected void updateCompInfos(FeatureInfo finfo, List<ComponentReference> compRefs, Collection<Component> components, Collection<ComponentInfo> otherInstalledComponentInfos, SessionInfo session, boolean dynamic, boolean featureSelected) {
        List<ComponentInfo> cinfos = finfo.getComponents();
        for (ComponentReference compRef : compRefs) {
            Collection<Component> replaces;
            Collection<ComponentTarget> targets;
            Component component = ComponentHelper.getInstance().getComponent(components, compRef);
            ComponentInfo cinfo = this.getHome().getRegistryHelper().getComponentInfo(cinfos, compRef.getName(), compRef.getOriginalVersion(), true);
            if (cinfo == null) {
                cinfo = new ComponentInfo(this.getHome().getClassLoader(), compRef.getName(), compRef.getVersion(), component != null ? component.getPatchLevel() : null);
                if (dynamic) {
                    cinfo.setDynamic(true);
                }
                finfo.addComponent(cinfo);
            }
            if (component != null && component.isSingleton()) {
                cinfo.setSingleton(true);
            }
            if (!featureSelected || component == null) continue;
            if (!cinfo.getStatus().isInstalled()) {
                cinfo.setStatus(Status.installed);
                cinfo.addSession(session);
            }
            if ((targets = component.getComponentTargets()) != null && !targets.isEmpty()) {
                List<TargetInfo> tinfos = cinfo.getTargets();
                for (ComponentTarget target : targets) {
                    TargetInfo tinfo = this.getHome().getRegistryHelper().getTargetInfo(tinfos, target.getReferenceQualifier());
                    if (tinfo == null) {
                        tinfo = new TargetInfo(this.getHome().getClassLoader(), target);
                        cinfo.addTarget(tinfo);
                    }
                    if (tinfo.getStatus().isInstalled()) continue;
                    tinfo.setStatus(Status.installed);
                    tinfo.addSession(session);
                }
            }
            if ((replaces = component.getReplaces()) == null || replaces.isEmpty()) continue;
            for (Component replaced : replaces) {
                List<ComponentInfo> replacedComponents = this.getHome().getRegistryHelper().getComponentInfos(otherInstalledComponentInfos, replaced.getName(), replaced.getVersion(), false);
                if (replacedComponents == null || replacedComponents.isEmpty()) continue;
                for (ComponentInfo replacedComponent : replacedComponents) {
                    replacedComponent.setStatus(Status.upgraded);
                    replacedComponent.setSingleton(component.isSingleton());
                    String currentVersion = component.getVersion();
                    String originalVersion = replacedComponent.getVersion();
                    if (!replacedComponent.isOriginalVersionSet()) {
                        replacedComponent.setOriginalVersion(originalVersion);
                    }
                    replacedComponent.setVersion(currentVersion);
                    replacedComponent.setPatchLevel(component.getPatchLevel());
                    SessionInfo upgradeSession = session.copy();
                    upgradeSession.setAction(SessionAction.upgrade);
                    upgradeSession.setVersion(currentVersion);
                    upgradeSession.setPreviousVersion(originalVersion);
                    if (originalVersion.equals(currentVersion)) {
                        upgradeSession.setPreviousPatchLevel(replaced.getPatchLevel());
                    }
                    upgradeSession.setPatchLevel(component.getPatchLevel());
                    replacedComponent.addSession(upgradeSession);
                    replacedComponent.setTargets(cinfo.getTargets());
                }
            }
        }
    }
}

