/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.DistributionLoader;
import com.oracle.cie.gdr.FeatureLoader;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.pch.Patch;
import com.oracle.cie.gdr.dao.rgy.BaseInfoReference;
import com.oracle.cie.gdr.dao.rgy.ComponentInfo;
import com.oracle.cie.gdr.dao.rgy.DistributionInfo;
import com.oracle.cie.gdr.dao.rgy.FeatureInfo;
import com.oracle.cie.gdr.dao.rgy.PatchInfo;
import com.oracle.cie.gdr.dao.rgy.Registry;
import com.oracle.cie.gdr.dao.rgy.SessionAction;
import com.oracle.cie.gdr.dao.rgy.SessionInfo;
import com.oracle.cie.gdr.dao.rgy.TargetInfo;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.GdrHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.selection.Status;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.nextgen.common.utils.UtilityOps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class RegistryHelper
extends GdrHelper<Registry> {
    private static final Logger _log = Logger.getLogger(RegistryHelper.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/gdr/rgy";
    public static final String REGISTRY = "registry";
    public static final String REGISTRY_FILE_NAME = "registry.xml";
    public static final String PREREGISTRY_FILE_NAME = "registry.pre";
    private static RegistryHelper _instance;

    public static RegistryHelper getInstance() {
        if (_instance == null) {
            _instance = new RegistryHelper(null);
        }
        return _instance;
    }

    public static RegistryHelper getInstance(ClassLoader classLoader) {
        if (classLoader == null) {
            return RegistryHelper.getInstance();
        }
        return new RegistryHelper(classLoader);
    }

    private RegistryHelper(ClassLoader classLoader) {
        super(Registry.class, classLoader);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getRootElement() {
        return REGISTRY;
    }

    public String getPath() {
        return "";
    }

    public Registry getRegistry(File registryFile) throws IOException, DataHandlerException, GdrException {
        if (registryFile == null || !registryFile.isFile()) {
            GdrException ex = new GdrException("Registry file specified was invalid: " + registryFile);
            _log.throwing(RegistryHelper.class.getName(), "getRegistry", ex);
            throw ex;
        }
        return this.getRegistry(NioHelper.getInstance().getPath(registryFile));
    }

    public Registry getRegistry(Path regitryPath) throws IOException, DataHandlerException, GdrException {
        if (regitryPath == null) {
            throw new NullPointerException("The path specified was null.");
        }
        if (!Files.isRegularFile(regitryPath, new LinkOption[0])) {
            GdrException ex = new GdrException("Registry path specified was invalid: " + regitryPath);
            _log.throwing(RegistryHelper.class.getName(), "getRegistry", ex);
            throw ex;
        }
        if (!Files.exists(regitryPath, new LinkOption[0])) {
            throw new FileNotFoundException("The path specified did not exist " + regitryPath);
        }
        return (Registry)this.getRootWrapper(regitryPath);
    }

    public Registry getRegistry(FileChannel registryFile) throws IOException, DataHandlerException, GdrException {
        return (Registry)this.getRootWrapper(registryFile);
    }

    public Set<FeatureInfo> getLastInstalledFeatureSets(Registry registry) {
        HashSet<FeatureInfo> fiSet = new HashSet<FeatureInfo>();
        int currentSession = registry.getSessions();
        List<DistributionInfo> distInfoList = registry.getDistributions();
        for (DistributionInfo dbi : distInfoList) {
            if (dbi.getStatus() == null || !dbi.getStatus().isInstalled()) continue;
            for (FeatureInfo fi : dbi.getFeatures()) {
                if (fi.getStatus() == null || !fi.getStatus().isInstalled()) continue;
                for (SessionInfo sInfo : fi.getSessions()) {
                    if (sInfo.getId() != currentSession) continue;
                    fiSet.add(fi);
                }
            }
        }
        return fiSet;
    }

    public DistributionInfo getDistributionInfo(Registry registry, String name, String version) {
        List<DistributionInfo> dinfos;
        if (registry != null && (dinfos = registry.getDistributions()) != null && !dinfos.isEmpty()) {
            for (DistributionInfo dinfo : dinfos) {
                if (!dinfo.getName().equals(name) || !dinfo.getVersion().equals(version)) continue;
                return dinfo;
            }
        }
        return null;
    }

    public FeatureInfo getFeatureInfo(Collection<FeatureInfo> featureInfos, String name, String version) {
        return this.getFeatureInfo(featureInfos, name, version, false);
    }

    public FeatureInfo getFeatureInfo(Collection<FeatureInfo> featureInfos, String name, String version, boolean useOriginalVersion) {
        if (featureInfos != null && !featureInfos.isEmpty()) {
            for (FeatureInfo fi : featureInfos) {
                String infoVersion;
                String string = infoVersion = useOriginalVersion ? fi.getOriginalVersion() : fi.getVersion();
                if (!fi.getName().equals(name) || !infoVersion.equals(version)) continue;
                return fi;
            }
        }
        return null;
    }

    public List<FeatureInfo> getFeatureInfos(Collection<FeatureInfo> featureInfos, String name, String version, boolean useOriginalVersion) {
        ArrayList<FeatureInfo> matching = new ArrayList<FeatureInfo>();
        if (featureInfos != null && !featureInfos.isEmpty()) {
            for (FeatureInfo fi : featureInfos) {
                String infoVersion;
                String string = infoVersion = useOriginalVersion ? fi.getOriginalVersion() : fi.getVersion();
                if (!fi.getName().equals(name) || !infoVersion.equals(version)) continue;
                matching.add(fi);
            }
        }
        return matching;
    }

    public List<FeatureInfo> getAllFeatureInfos(Registry registry) {
        ArrayList<FeatureInfo> featureInfos = new ArrayList<FeatureInfo>();
        for (DistributionInfo distributionInfo : registry.getDistributions()) {
            featureInfos.addAll(distributionInfo.getFeatures());
        }
        return featureInfos;
    }

    public List<ComponentInfo> getAllComponentInfos(Registry registry) {
        ArrayList<ComponentInfo> componentInfos = new ArrayList<ComponentInfo>();
        for (DistributionInfo distributionInfo : registry.getDistributions()) {
            for (FeatureInfo featureInfo : distributionInfo.getFeatures()) {
                componentInfos.addAll(featureInfo.getComponents());
            }
        }
        return componentInfos;
    }

    public PatchInfo getPatchInfo(Collection<PatchInfo> patchInfos, String patchId) {
        if (patchInfos != null && !patchInfos.isEmpty()) {
            for (PatchInfo pi : patchInfos) {
                if (!pi.getPatchId().equals(patchId)) continue;
                return pi;
            }
        }
        return null;
    }

    public ComponentInfo getComponentInfo(Collection<ComponentInfo> componentInfos, String name, String version) {
        return this.getComponentInfo(componentInfos, name, version, false);
    }

    public ComponentInfo getComponentInfo(Collection<ComponentInfo> componentInfos, String name, String version, boolean useOriginalVersion) {
        if (componentInfos != null && !componentInfos.isEmpty()) {
            for (ComponentInfo ci : componentInfos) {
                String infoVersion;
                String string = infoVersion = useOriginalVersion ? ci.getOriginalVersion() : ci.getVersion();
                if (!ci.getName().equals(name) || !infoVersion.equals(version)) continue;
                return ci;
            }
        }
        return null;
    }

    public List<ComponentInfo> getComponentInfos(Collection<ComponentInfo> componentInfos, String name, String version, boolean useOriginalVersion) {
        ArrayList<ComponentInfo> matching = new ArrayList<ComponentInfo>();
        if (componentInfos != null && !componentInfos.isEmpty()) {
            for (ComponentInfo ci : componentInfos) {
                String infoVersion;
                String string = infoVersion = useOriginalVersion ? ci.getOriginalVersion() : ci.getVersion();
                if (!ci.getName().equals(name) || !infoVersion.equals(version)) continue;
                matching.add(ci);
            }
        }
        return matching;
    }

    public Collection<ComponentInfo> getInstalledComponentInfos(Registry registry) {
        return this.getInstalledComponentInfos(registry.getDistributions());
    }

    public Collection<ComponentInfo> getInstalledComponentInfos(List<DistributionInfo> distributionInfos) {
        ArrayList<ComponentInfo> componentInfos = new ArrayList<ComponentInfo>();
        if (distributionInfos != null && !distributionInfos.isEmpty()) {
            for (DistributionInfo distributionInfo : distributionInfos) {
                componentInfos.addAll(this.getInstalledComponentInfos(distributionInfo));
            }
        }
        return componentInfos;
    }

    public Collection<ComponentInfo> getInstalledComponentInfos(DistributionInfo distributionInfo) {
        ArrayList<ComponentInfo> componentInfos = new ArrayList<ComponentInfo>();
        Collection<FeatureInfo> featureInfos = this.getInstalledFeatureInfos(distributionInfo);
        if (featureInfos != null && !featureInfos.isEmpty()) {
            for (FeatureInfo featureInfo : featureInfos) {
                List<ComponentInfo> cinfos = featureInfo.getComponents();
                if (cinfos == null || cinfos.isEmpty()) continue;
                for (ComponentInfo cinfo : cinfos) {
                    if (!cinfo.getStatus().isInstalled()) continue;
                    componentInfos.add(cinfo);
                }
            }
        }
        return componentInfos;
    }

    public Collection<ComponentInfo> getComponentInfos(List<DistributionInfo> distributionInfos) {
        ArrayList<ComponentInfo> componentInfos = new ArrayList<ComponentInfo>();
        if (distributionInfos != null && !distributionInfos.isEmpty()) {
            for (DistributionInfo distributionInfo : distributionInfos) {
                componentInfos.addAll(this.getComponentInfos(distributionInfo));
            }
        }
        return componentInfos;
    }

    public Collection<ComponentInfo> getComponentInfos(DistributionInfo distributionInfo) {
        ArrayList<ComponentInfo> componentInfos = new ArrayList<ComponentInfo>();
        Collection<FeatureInfo> featureInfos = this.getInstalledFeatureInfos(distributionInfo);
        if (featureInfos != null && !featureInfos.isEmpty()) {
            for (FeatureInfo featureInfo : featureInfos) {
                List<ComponentInfo> cinfos = featureInfo.getComponents();
                if (cinfos == null || cinfos.isEmpty()) continue;
                componentInfos.addAll(cinfos);
            }
        }
        return componentInfos;
    }

    public Collection<ComponentInfo> getAllComponentInfos(List<DistributionInfo> distributionInfos) {
        ArrayList<ComponentInfo> componentInfos = new ArrayList<ComponentInfo>();
        if (distributionInfos != null && !distributionInfos.isEmpty()) {
            for (DistributionInfo distributionInfo : distributionInfos) {
                componentInfos.addAll(this.getAllComponentInfos(distributionInfo));
            }
        }
        return componentInfos;
    }

    public Collection<ComponentInfo> getAllComponentInfos(DistributionInfo distributionInfo) {
        ArrayList<ComponentInfo> componentInfos = new ArrayList<ComponentInfo>();
        List<FeatureInfo> featureInfos = distributionInfo.getFeatures();
        if (featureInfos != null && !featureInfos.isEmpty()) {
            for (FeatureInfo featureInfo : featureInfos) {
                List<ComponentInfo> cinfos = featureInfo.getComponents();
                if (cinfos == null || cinfos.isEmpty()) continue;
                componentInfos.addAll(cinfos);
            }
        }
        return componentInfos;
    }

    public Collection<FeatureInfo> getInstalledFeatureInfos(List<DistributionInfo> distributionInfos) {
        ArrayList<FeatureInfo> installedFeatureInfos = new ArrayList<FeatureInfo>();
        if (distributionInfos != null && !distributionInfos.isEmpty()) {
            for (DistributionInfo distributionInfo : distributionInfos) {
                installedFeatureInfos.addAll(this.getInstalledFeatureInfos(distributionInfo));
            }
        }
        return installedFeatureInfos;
    }

    public Collection<FeatureInfo> getInstalledFeatureInfos(DistributionInfo distributionInfo) {
        List<FeatureInfo> featureInfos;
        ArrayList<FeatureInfo> installedFeatureInfos = new ArrayList<FeatureInfo>();
        if (distributionInfo != null && distributionInfo.getStatus().isInstalled() && (featureInfos = distributionInfo.getFeatures()) != null && !featureInfos.isEmpty()) {
            for (FeatureInfo featureInfo : featureInfos) {
                if (!featureInfo.getStatus().isInstalled()) continue;
                installedFeatureInfos.add(featureInfo);
            }
        }
        return installedFeatureInfos;
    }

    public TargetInfo getTargetInfo(Collection<TargetInfo> targetInfos, String source) {
        if (targetInfos != null && !targetInfos.isEmpty()) {
            for (TargetInfo ti : targetInfos) {
                if (!ti.getQualifier().equals(source)) continue;
                return ti;
            }
        }
        return null;
    }

    public void setInstallationStatus(Home home, DistributionLoader distLoader) throws GdrException {
        this.setInstallationStatus(home, distLoader, true);
    }

    public void setInstallationStatus(Home home, DistributionLoader distLoader, boolean replaceUpgraded) throws GdrException {
        List<DistributionInfo> distributions;
        if (distLoader != null) {
            this.resetInstallationStatus(distLoader);
        }
        if (home != null && distLoader != null && (distributions = home.getRegistry().getDistributions()) != null && !distributions.isEmpty()) {
            for (DistributionInfo distInfo : distributions) {
                if (!distInfo.equals((Object)new Reference(distLoader.getDistributionName(), distLoader.getDistributionVersion(), home.getClassLoader())) || !distInfo.getStatus().isInstalled()) continue;
                Set<FeatureSet> featureSets = distLoader.getFeatureSets();
                List<FeatureInfo> registryFeatures = distInfo.getFeatures();
                if (registryFeatures == null) continue;
                block4: for (FeatureSet feature : featureSets) {
                    String featureName = feature.getName();
                    String featureVersion = feature.getVersion();
                    for (FeatureInfo finfo : registryFeatures) {
                        HashSet<String> versions = new HashSet<String>();
                        versions.add(finfo.getVersion());
                        versions.add(finfo.getOriginalVersion());
                        Status featureStatus = finfo.getStatus();
                        if (featureStatus.isUpgraded()) {
                            for (SessionInfo featureSessionInfo : this.getSessionInfos(finfo, SessionAction.upgrade)) {
                                String previousVersion = featureSessionInfo.getPreviousVersion();
                                if (StringUtil.isNullOrEmpty((String)previousVersion, (boolean)true)) continue;
                                versions.add(previousVersion);
                            }
                        }
                        if (!finfo.getName().equals(featureName) || !versions.contains(featureVersion)) continue;
                        boolean useOriginalVersions = true;
                        if (replaceUpgraded && featureStatus.isUpgraded()) {
                            FeatureSet upgrade;
                            try {
                                upgrade = FeatureSetHelper.getInstance(home.getClassLoader()).getFeatureSet(home.getMetaDataHome(), featureName, finfo.getVersion());
                                for (SessionInfo featureSessionInfo : this.getSessionInfos(finfo, SessionAction.upgrade)) {
                                    String previousVersion = featureSessionInfo.getPreviousVersion();
                                    if (previousVersion == null || previousVersion.equals(feature.getVersion())) continue;
                                    FeatureSet intermediateUpgrade = FeatureSetHelper.getInstance(home.getClassLoader()).getFeatureSet(home.getMetaDataHome(), featureName, previousVersion);
                                    upgrade.addUpgrades(intermediateUpgrade);
                                    intermediateUpgrade.setSuperseded(upgrade);
                                }
                            }
                            catch (IOException e) {
                                throw new GdrException("Failed to load upgrade feature set " + finfo, (Throwable)e);
                            }
                            catch (DataHandlerException e) {
                                throw new GdrException("Failed to load upgrade feature set " + finfo, (Throwable)e);
                            }
                            distLoader.getDistributionTarget().upgradeFeature(feature, upgrade);
                            feature = upgrade;
                            useOriginalVersions = false;
                        }
                        feature.setStatus(featureStatus);
                        List<ComponentReference> compRefs = feature.getComponentReferences();
                        List<ComponentInfo> registryComponents = finfo.getComponents();
                        block8: for (ComponentReference compRef : compRefs) {
                            for (ComponentInfo cinfo : registryComponents) {
                                List<PatchInfo> registryPatches;
                                List<TargetInfo> targets;
                                if (!cinfo.getName().equals(compRef.getName()) || (!useOriginalVersions || !cinfo.getOriginalVersion().equals(compRef.getOriginalVersion())) && (useOriginalVersions || !cinfo.getVersion().equals(compRef.getVersion()))) continue;
                                Status status = cinfo.getStatus();
                                compRef.setStatus(status);
                                compRef.setSingleton(cinfo.isSingleton());
                                compRef.setPatchLevel(cinfo.getPatchLevel());
                                if (replaceUpgraded && status.isUpgraded()) {
                                    compRef.setOriginalVersion(cinfo.getOriginalVersion());
                                    compRef.setVersion(cinfo.getVersion());
                                }
                                if ((targets = cinfo.getTargets()) != null && !targets.isEmpty()) {
                                    for (TargetInfo target : targets) {
                                        compRef.setComponentTargetStatus(target.getQualifier(), target.getStatus());
                                    }
                                }
                                if ((registryPatches = cinfo.getPatches()) == null) continue block8;
                                for (PatchInfo pinfo : registryPatches) {
                                    Patch pch = distLoader.getPatchLoader().getPatch(pinfo.getPatchId());
                                    if (pch == null) continue;
                                    pch.setStatus(pinfo.getStatus());
                                }
                                continue block8;
                            }
                        }
                        continue block4;
                    }
                }
            }
        }
    }

    public void resetInstallationStatus(DistributionLoader distributionLoader) {
        Set<FeatureSet> featureSets;
        if (distributionLoader != null && (featureSets = distributionLoader.getFeatureSets()) != null) {
            for (FeatureSet feature : featureSets) {
                if (feature.isOriginalSet()) {
                    FeatureSet originalFeatureSet = feature.getOriginalFeatureSet();
                    distributionLoader.getDistributionTarget().replaceFeature(feature, originalFeatureSet);
                    feature.setStatus(Status.notinstalled);
                    feature = originalFeatureSet;
                    feature.setUpgrades(null);
                }
                if (feature.isUpgrades()) {
                    Collection<FeatureSet> upgrades = feature.getUpgrades();
                    feature.setUpgrades(null);
                    for (FeatureSet upgrade : upgrades) {
                        upgrade.setSuperseded(null);
                    }
                }
                feature.setStatus(Status.notinstalled);
                List<ComponentReference> components = feature.getComponentReferences();
                if (components == null) continue;
                for (ComponentReference component : components) {
                    component.resetState();
                }
            }
        }
    }

    public SessionInfo getRegistrySession(Registry registry, Mode mode) throws GdrException {
        return this.getRegistrySession(registry, mode.isDeInstallMode() ? SessionAction.deinstall : SessionAction.install);
    }

    public SessionInfo getRegistrySession(Registry registry, SessionAction sessionAction) throws GdrException {
        if (registry == null) {
            GdrException ex = new GdrException("Registry may not be null.");
            _log.throwing(RegistryHelper.class.getName(), "getRegistrySession", ex);
            throw ex;
        }
        int id = registry.getSessions();
        registry.setSessions(++id);
        SessionInfo session = new SessionInfo(this.getClassLoader(), id);
        session.setDate(UtilityOps.getStoredSessionTimeStampCalendar());
        session.setAction(sessionAction);
        return session;
    }

    public Set<FeatureSet> getDynamicFeatureSets(DistributionInfo distInfo, MetaDataHome metaDataDir) throws IOException, DataHandlerException, GdrException {
        List<FeatureInfo> featureInfos;
        if (distInfo != null && (featureInfos = distInfo.getFeatures()) != null && !featureInfos.isEmpty()) {
            LinkedHashMap<FeatureSetReference, FeatureInfo> references = new LinkedHashMap<FeatureSetReference, FeatureInfo>();
            for (FeatureInfo featureInfo : featureInfos) {
                if (!featureInfo.isDynamic()) continue;
                references.put(new FeatureSetReference(featureInfo.getName(), featureInfo.getVersion()), featureInfo);
            }
            if (!references.isEmpty()) {
                FeatureLoader featureLoader = new FeatureLoader(metaDataDir, references.keySet(), null, false);
                for (Map.Entry entry : references.entrySet()) {
                    FeatureSetReference reference = (FeatureSetReference)((Object)entry.getKey());
                    FeatureSet featureSet = featureLoader.getFeatureSet(reference.getName(), reference.getVersion());
                    featureSet.setStatus(((FeatureInfo)entry.getValue()).getStatus());
                }
                return featureLoader.getFeatureSets();
            }
        }
        return new HashSet<FeatureSet>();
    }

    public void updatePatch(Home home, String componentName, String componentVersion, Patch patch) throws IOException, DataHandlerException, GdrException {
        Registry registry = home.lockRegistry();
        List<DistributionInfo> dInfos = registry.getDistributions();
        for (DistributionInfo distInfo : dInfos) {
            for (FeatureInfo ftrInfo : distInfo.getFeatures()) {
                for (ComponentInfo compInfo : ftrInfo.getComponents()) {
                    if (!compInfo.getName().equals(componentName) || !compInfo.getVersion().equals(componentVersion)) continue;
                    if (compInfo.getPatches().contains((Object)patch)) {
                        compInfo.removePatches(Arrays.asList(patch));
                    }
                    compInfo.addPatch(patch);
                }
            }
        }
        home.unlockRegistry();
    }

    public ComponentInfo getComponentInfoFromDist(Collection<DistributionInfo> distInfos, String name, String version) {
        for (DistributionInfo dist : distInfos) {
            for (FeatureInfo feature : dist.getFeatures()) {
                for (ComponentInfo cinfo : feature.getComponents()) {
                    if (!cinfo.getName().equals(name) || !cinfo.getVersion().equals(version)) continue;
                    return cinfo;
                }
            }
        }
        return null;
    }

    public List<SessionInfo> getSessionInfos(BaseInfoReference baseInfoReference, SessionAction ... sessionActions) {
        List<SessionInfo> sessionInfos = baseInfoReference != null ? baseInfoReference.getSessions() : null;
        return this.filterSessionInfos(sessionInfos, sessionActions);
    }

    public List<SessionInfo> filterSessionInfos(List<SessionInfo> sessionInfos, SessionAction ... sessionActions) {
        if (sessionInfos != null && sessionActions != null && sessionActions.length > 0) {
            List<SessionAction> actions = Arrays.asList(sessionActions);
            Iterator it = sessionInfos.iterator();
            while (it.hasNext()) {
                SessionInfo sessionInfo = (SessionInfo)((Object)it.next());
                if (actions.contains((Object)sessionInfo.getAction())) continue;
                it.remove();
            }
        }
        return sessionInfos == null ? new ArrayList() : sessionInfos;
    }

    public int getLatestSessionId(List<SessionInfo> sessionInfos) {
        int latestId = -1;
        if (sessionInfos != null) {
            for (SessionInfo sessionInfo : sessionInfos) {
                int id = sessionInfo.getId();
                if (id <= latestId) continue;
                latestId = id;
            }
        }
        return latestId;
    }

    public DistributionInfo getDistributionInfoOwningInstalledComponent(Collection<DistributionInfo> distInfos, String name, String version) {
        for (DistributionInfo dist : distInfos) {
            Collection<ComponentInfo> components = this.getInstalledComponentInfos(dist);
            for (ComponentInfo component : components) {
                if (!component.getName().equals(name) || !component.getVersion().equals(version)) continue;
                return dist;
            }
        }
        return null;
    }

    public void persistSessionFederatedHomes(Registry registry, Home home) throws IOException {
        Collection<Path> sessionFederatedHomes = home.getSessionFederatedHomes();
        if (sessionFederatedHomes != null && !sessionFederatedHomes.isEmpty()) {
            List<String> federatedHomes = registry.getFederatedHomes();
            for (Path sessionFederatedHome : sessionFederatedHomes) {
                if (federatedHomes.contains(sessionFederatedHome.toAbsolutePath())) continue;
                federatedHomes.add(sessionFederatedHome.toAbsolutePath().toString());
            }
            registry.setFederatedHomes(federatedHomes);
        }
    }

    public List<ComponentInfo> getComponentInfosForPatchId(Registry registry, String patchId) {
        ArrayList<ComponentInfo> results = new ArrayList<ComponentInfo>();
        if (registry != null && !StringUtil.isNullOrEmpty((String)patchId, (boolean)true)) {
            Collection<ComponentInfo> componentInfos = this.getAllComponentInfos(registry.getDistributions());
            block0: for (ComponentInfo componentInfo : componentInfos) {
                List<PatchInfo> patches = componentInfo.getPatches();
                if (patches == null || patches.isEmpty()) continue;
                for (PatchInfo patch : patches) {
                    if (!patch.getPatchId().equals(patchId)) continue;
                    results.add(componentInfo);
                    continue block0;
                }
            }
        }
        return results;
    }

    public List<ComponentInfo> getComponentInfosForPatch(Registry registry, String patchId) {
        return this.getComponentInfosForPatch(registry, patchId, false);
    }

    public List<ComponentInfo> getComponentInfosForPatch(Registry registry, String patchId, boolean includeAllComponentInfos) {
        ArrayList<ComponentInfo> results = new ArrayList<ComponentInfo>();
        if (registry != null && !StringUtil.isNullOrEmpty((String)patchId, (boolean)true)) {
            Collection<ComponentInfo> componentInfos = includeAllComponentInfos ? this.getAllComponentInfos(registry.getDistributions()) : this.getComponentInfos(registry.getDistributions());
            for (ComponentInfo componentInfo : componentInfos) {
                if (this.getSessionInfoForPatch(componentInfo, patchId) == null) continue;
                results.add(componentInfo);
            }
        }
        return results;
    }

    public Map<ComponentInfo, SessionInfo> getComponentInfosSessionMapForPatch(Registry registry, String patchId) {
        HashMap<ComponentInfo, SessionInfo> results = new HashMap<ComponentInfo, SessionInfo>();
        if (registry != null && !StringUtil.isNullOrEmpty((String)patchId, (boolean)true)) {
            Collection<ComponentInfo> componentInfos = this.getComponentInfos(registry.getDistributions());
            for (ComponentInfo componentInfo : componentInfos) {
                SessionInfo sessionInfo = this.getSessionInfoForPatch(componentInfo, patchId);
                if (sessionInfo == null) continue;
                results.put(componentInfo, sessionInfo);
            }
        }
        return results;
    }

    public Map<ComponentInfo, SessionInfo> getAllComponentInfosSessionMapForPatch(Registry registry, String patchId) {
        HashMap<ComponentInfo, SessionInfo> results = new HashMap<ComponentInfo, SessionInfo>();
        if (registry != null && !StringUtil.isNullOrEmpty((String)patchId, (boolean)true)) {
            Collection<ComponentInfo> componentInfos = this.getAllComponentInfos(registry.getDistributions());
            for (ComponentInfo componentInfo : componentInfos) {
                SessionInfo sessionInfo = this.getSessionInfoForPatch(componentInfo, patchId);
                if (sessionInfo == null) continue;
                results.put(componentInfo, sessionInfo);
            }
        }
        return results;
    }

    public List<FeatureInfo> getFeatureInfosForPatch(Registry registry, String patchId) {
        return this.getFeatureInfosForPatch(registry, patchId, false);
    }

    public List<FeatureInfo> getFeatureInfosForPatch(Registry registry, String patchId, boolean includeOriginatingPatches) {
        ArrayList<FeatureInfo> results = new ArrayList<FeatureInfo>();
        if (registry != null && !StringUtil.isNullOrEmpty((String)patchId, (boolean)true)) {
            List<FeatureInfo> featureInfos = this.getAllFeatureInfos(registry);
            for (FeatureInfo featureInfo : featureInfos) {
                if (this.getSessionInfoForPatch(featureInfo, patchId, includeOriginatingPatches) == null) continue;
                results.add(featureInfo);
            }
        }
        return results;
    }

    public List<DistributionInfo> getDistributionInfosForPatch(Registry registry, String patchId) {
        ArrayList<DistributionInfo> results = new ArrayList<DistributionInfo>();
        if (registry != null && !StringUtil.isNullOrEmpty((String)patchId, (boolean)true)) {
            List<DistributionInfo> distributionInfos = registry.getDistributions();
            for (DistributionInfo di : distributionInfos) {
                if (this.getSessionInfoForPatch(di, patchId) == null) continue;
                results.add(di);
            }
        }
        return results;
    }

    public SessionInfo getSessionInfoForPatch(BaseInfoReference baseInfoReference, String patchId) {
        return this.getSessionInfoForPatch(baseInfoReference, patchId, false);
    }

    public SessionInfo getSessionInfoForPatch(BaseInfoReference baseInfoReference, String patchId, boolean includeOriginatingPatches) {
        return baseInfoReference != null ? this.getSessionInfoForPatch(baseInfoReference.getSessions(), patchId, includeOriginatingPatches) : null;
    }

    public SessionInfo getSessionInfoForPatch(List<SessionInfo> sessionInfos, String patchId) {
        return this.getSessionInfoForPatch(sessionInfos, patchId, false);
    }

    public SessionInfo getSessionInfoForPatch(List<SessionInfo> sessionInfos, String patchId, boolean includeOriginatingPatches) {
        SessionInfo sessionInfo = null;
        if (sessionInfos != null && !sessionInfos.isEmpty() && !StringUtil.isNullOrEmpty((String)patchId, (boolean)true)) {
            patchId = patchId.trim();
            for (SessionInfo si : sessionInfos) {
                if (!si.getPatchIdsSet().contains(patchId) && (!includeOriginatingPatches || !patchId.equals(si.getOriginatingPatchId()))) continue;
                sessionInfo = si;
                break;
            }
        }
        return sessionInfo;
    }
}

