/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.gdr.dao.pmd.PatchMetadata;
import com.oracle.cie.gdr.helpers.GdrHelper;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class PatchMetadataHelper
extends GdrHelper<PatchMetadata> {
    private static final Logger _log = Logger.getLogger(PatchMetadataHelper.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/gdr/pmd";
    public static final String PATCH_METADATA = "patch-metadata";
    public static final String PATCH_METADATA_FILE_NAME = "patch-metadata.xml";
    private static PatchMetadataHelper _instance;

    public static PatchMetadataHelper getInstance() {
        if (_instance == null) {
            _instance = new PatchMetadataHelper(null);
        }
        return _instance;
    }

    public static PatchMetadataHelper getInstance(ClassLoader classLoader) {
        if (classLoader == null) {
            return PatchMetadataHelper.getInstance();
        }
        return new PatchMetadataHelper(classLoader);
    }

    protected PatchMetadataHelper(ClassLoader classLoader) {
        super(PatchMetadata.class, classLoader);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getRootElement() {
        return PATCH_METADATA;
    }

    public String getPath() {
        return null;
    }

    public PatchMetadata getPatchMetadata(File PatchMetadataFile) throws IOException, DataHandlerException, GdrException {
        if (PatchMetadataFile == null || !PatchMetadataFile.isFile()) {
            GdrException ex = new GdrException("Patch metadata file specified was invalid: " + PatchMetadataFile);
            _log.throwing(PatchMetadata.class.getName(), "getPatchMetadata", ex);
            throw ex;
        }
        return (PatchMetadata)this.getRootWrapper(PatchMetadataFile);
    }
}

