/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.nfo.Bug;
import com.oracle.cie.gdr.dao.nfo.BugInfo;
import com.oracle.cie.gdr.dao.nfo.ExternalDeps;
import com.oracle.cie.gdr.dao.nfo.ExternalFeatureReference;
import com.oracle.cie.gdr.dao.nfo.InstallerComponentInfo;
import com.oracle.cie.gdr.dao.nfo.InstallerDistributionInfo;
import com.oracle.cie.gdr.dao.nfo.InstallerFeatureInfo;
import com.oracle.cie.gdr.dao.nfo.InstallerInfo;
import com.oracle.cie.gdr.dao.nfo.InstallerPackageInfo;
import com.oracle.cie.gdr.dao.nfo.InstallerSizeInfo;
import com.oracle.cie.gdr.dao.nfo.RegexReference;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.GdrHelper;
import com.oracle.cie.gdr.helpers.PlatformInfoHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class InstallerInfoHelper
extends GdrHelper<InstallerInfo> {
    private static final Logger _log = Logger.getLogger(InstallerInfoHelper.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/gdr/nfo";
    public static final String EXTERNAL_DEPS = "installer-info";
    public static final String INSTALLER_INFO_FILE_NAME = "installer-info.xml";
    public static final String INSTALLER_INFO_DIR = "info";
    private static InstallerInfoHelper _instance;

    public static InstallerInfoHelper getInstance() {
        if (_instance == null) {
            _instance = new InstallerInfoHelper(null);
        }
        return _instance;
    }

    public static InstallerInfoHelper getInstance(ClassLoader classLoader) {
        if (classLoader == null) {
            return InstallerInfoHelper.getInstance();
        }
        return new InstallerInfoHelper(classLoader);
    }

    private InstallerInfoHelper(ClassLoader classLoader) {
        super(InstallerInfo.class, classLoader);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getRootElement() {
        return EXTERNAL_DEPS;
    }

    public String getPath() {
        return INSTALLER_INFO_DIR;
    }

    public ExternalDeps getExternalDeps(Map<FeatureSetReference, Set<Distribution>> externaldists) {
        ExternalDeps extDeps = new ExternalDeps();
        if (externaldists != null && !externaldists.isEmpty()) {
            ArrayList<ExternalFeatureReference> externalFeatures = new ArrayList<ExternalFeatureReference>();
            for (FeatureSetReference feature : externaldists.keySet()) {
                ExternalFeatureReference extftr = new ExternalFeatureReference(feature.getName(), feature.getVersion());
                Set<Distribution> dists = externaldists.get((Object)feature);
                ArrayList<Reference> distRefs = new ArrayList<Reference>();
                for (Distribution dist : dists) {
                    distRefs.add(new Reference(dist.getName(), dist.getVersion()));
                }
                extftr.setDistributions(distRefs);
                externalFeatures.add(extftr);
            }
            extDeps.setFeatures(externalFeatures);
        }
        return extDeps;
    }

    public InstallerInfo getInstallerInfo(File installerInfoFile) throws IOException, DataHandlerException, GdrException {
        return this.getInstallerInfo(NioHelper.getInstance().getPath(installerInfoFile));
    }

    public InstallerInfo getInstallerInfo(Path installerInfoFile) throws IOException, DataHandlerException, GdrException {
        if (installerInfoFile == null || !Files.exists(installerInfoFile, new LinkOption[0]) || Files.isDirectory(installerInfoFile, new LinkOption[0])) {
            GdrException ex = new GdrException("Installer info file specified was invalid: " + installerInfoFile);
            _log.throwing(InstallerInfoHelper.class.getName(), "getInstallerInfo", ex);
            throw ex;
        }
        return (InstallerInfo)this.getRootWrapper(installerInfoFile);
    }

    public InstallerInfo getInstallerInfo(RandomAccessFile installerInfoFile) throws IOException, DataHandlerException, GdrException {
        return (InstallerInfo)this.getRootWrapper(installerInfoFile);
    }

    public InstallerDistributionInfo getInstallerDistributionInfo(InstallerInfo installerInfo, String name, String version) {
        InstallerPackageInfo packageInfo;
        if (installerInfo != null && (packageInfo = installerInfo.getInstallerPackageInfo()) != null) {
            List<InstallerDistributionInfo> dinfos = packageInfo.getInstallerDistributionInfo();
            for (InstallerDistributionInfo dinfo : dinfos) {
                if (!this.isNameVersionMatch(dinfo, name, version)) continue;
                return dinfo;
            }
        }
        return null;
    }

    public InstallerDistributionInfo getInstallerDistributionInfo(InstallerInfo installerInfo) {
        List<InstallerDistributionInfo> dinfos;
        InstallerPackageInfo packageInfo;
        if (installerInfo != null && (packageInfo = installerInfo.getInstallerPackageInfo()) != null && (dinfos = packageInfo.getInstallerDistributionInfo()) != null && !dinfos.isEmpty()) {
            return dinfos.get(0);
        }
        return null;
    }

    public InstallerFeatureInfo getInstallerFeatureInfo(InstallerDistributionInfo distributionInfo, String name, String version) {
        List<InstallerFeatureInfo> finfos;
        if (distributionInfo != null && (finfos = distributionInfo.getInstallerFeatureInfo()) != null && !finfos.isEmpty()) {
            for (InstallerFeatureInfo finfo : finfos) {
                if (!this.isNameVersionMatch(finfo, name, version)) continue;
                return finfo;
            }
        }
        return null;
    }

    public InstallerComponentInfo getInstallerComponentInfo(InstallerFeatureInfo featureInfo, String name, String version) {
        List<InstallerComponentInfo> cinfos;
        if (featureInfo != null && (cinfos = featureInfo.getInstallerComponentInfo()) != null && !cinfos.isEmpty()) {
            for (InstallerComponentInfo cinfo : cinfos) {
                if (!this.isNameVersionMatch(cinfo, name, version)) continue;
                return cinfo;
            }
        }
        return null;
    }

    public boolean isNameVersionMatch(RegexReference reference, String name, String version) {
        boolean nameMatches = reference.isNameRegex() ? name.matches(reference.getName()) : name.equals(reference.getName());
        boolean versionMatches = reference.isVersionRegex() ? version.matches(reference.getVersion()) : version.equals(reference.getVersion());
        return nameMatches & versionMatches;
    }

    public InstallerComponentInfo getInstallerComponentInfo(InstallerDistributionInfo distributionInfo, FeatureSet feature, ComponentReference component) {
        InstallerFeatureInfo finfo;
        if (distributionInfo != null && feature != null && component != null && (finfo = this.getInstallerFeatureInfo(distributionInfo, feature.getName(), feature.getVersion())) != null) {
            return this.getInstallerComponentInfo(finfo, component.getName(), component.getVersion());
        }
        return null;
    }

    public long getInstallerFeatureSize(InstallerDistributionInfo distributionInfo, String name, String version) {
        long size = 0L;
        InstallerFeatureInfo finfo = this.getInstallerFeatureInfo(distributionInfo, name, version);
        if (finfo != null) {
            String currentPlatform = PlatformInfoHelper.getInstance().getCurrentPlatformName();
            List<InstallerComponentInfo> cinfos = finfo.getInstallerComponentInfo();
            if (cinfos != null && !cinfos.isEmpty()) {
                for (InstallerComponentInfo cinfo : cinfos) {
                    List<InstallerSizeInfo> sinfos;
                    if (!cinfo.isPackaged() || (sinfos = cinfo.getInstallerSizeInfo()) == null || sinfos.isEmpty()) continue;
                    for (InstallerSizeInfo sinfo : sinfos) {
                        String platform = sinfo.getPlatform();
                        if (platform != null && !platform.equals("ALL_PLATFORMS") && !platform.equals(currentPlatform)) continue;
                        size += sinfo.getSize();
                    }
                }
            }
            size += finfo.getFeatureLibrariesSizeInfo();
        }
        return size;
    }

    public InstallerDistributionInfo createInstallerDistributionInfo(String distName, String distVersion, Map<FeatureSet, Collection<Component>> compMap) {
        ArrayList<InstallerFeatureInfo> finfos = new ArrayList<InstallerFeatureInfo>();
        ArrayList<Bug> bugList = new ArrayList<Bug>();
        for (FeatureSet feature : compMap.keySet()) {
            long featureLibsSize;
            InstallerFeatureInfo finfo = new InstallerFeatureInfo(feature.getName(), feature.getVersion());
            finfos.add(finfo);
            List<ComponentReference> compRefs = feature.getComponentReferences();
            if (compRefs != null && !compRefs.isEmpty()) {
                ArrayList<InstallerComponentInfo> cinfos = new ArrayList<InstallerComponentInfo>();
                for (ComponentReference compRef : compRefs) {
                    InstallerComponentInfo cinfo = new InstallerComponentInfo(compRef.getName(), compRef.getVersion());
                    boolean packaged = compRef.isPackaged();
                    cinfo.setPackaged(packaged);
                    cinfos.add(cinfo);
                    if (!packaged) continue;
                    Collection<Component> components = compMap.get(feature);
                    Component component = ComponentHelper.getInstance(this.getClassLoader()).getComponent(components, compRef);
                    if (component == null) continue;
                    String patchLevel = component.getPatchLevel();
                    if (!StringUtil.isNullOrEmpty((String)patchLevel, (boolean)true)) {
                        cinfo.setPatchLevel(patchLevel);
                    }
                    Collection<ComponentTarget> targets = component.getComponentTargets();
                    HashMap<String, Long> platSizes = new HashMap<String, Long>();
                    if (targets != null && !targets.isEmpty()) {
                        for (ComponentTarget componentTarget : targets) {
                            Set<String> platforms = componentTarget.getPlatforms();
                            if (platforms == null || platforms.isEmpty()) {
                                long size = platSizes.containsKey("ALL_PLATFORMS") ? (Long)platSizes.get("ALL_PLATFORMS") : 0L;
                                platSizes.put("ALL_PLATFORMS", size + componentTarget.getSize());
                                continue;
                            }
                            for (String platform : platforms) {
                                long size = platSizes.containsKey(platform) ? (Long)platSizes.get(platform) : 0L;
                                platSizes.put(platform, size + componentTarget.getSize());
                            }
                        }
                    }
                    if (!platSizes.isEmpty()) {
                        ArrayList<InstallerSizeInfo> sizeInfos = new ArrayList<InstallerSizeInfo>();
                        for (String platform : platSizes.keySet()) {
                            InstallerSizeInfo sizeInfo = new InstallerSizeInfo();
                            sizeInfo.setPlatform(platform);
                            sizeInfo.setSize((Long)platSizes.get(platform));
                            sizeInfos.add(sizeInfo);
                        }
                        cinfo.setInstallerSizeInfo(sizeInfos);
                    }
                    if (component.getBugInfo() == null) continue;
                    for (com.oracle.cie.gdr.dao.cpd.Bug bug : component.getBugInfo().getBugInfoList()) {
                        Bug aBug = new Bug();
                        aBug.setNumber(bug.getNumber());
                        aBug.setDescription(bug.getDescription());
                        if (bugList.contains((Object)bug)) continue;
                        bugList.add(aBug);
                    }
                }
                finfo.setInstallerComponentInfo(cinfos);
            }
            if ((featureLibsSize = FeatureSetHelper.getInstance(this.getClassLoader()).getFeatureLibrariesSize(feature)) <= 0L) continue;
            finfo.setFeatureLibrariesSizeInfo(featureLibsSize);
        }
        InstallerDistributionInfo dinfo = new InstallerDistributionInfo(distName, distVersion);
        dinfo.setInstallerFeatureInfo(finfos);
        if (!bugList.isEmpty()) {
            BugInfo bugInfo = new BugInfo();
            bugInfo.setBugInfoList(bugList);
            dinfo.setBugInfo(bugInfo);
        }
        return dinfo;
    }

    public void updateInstallerInfo(InstallerInfo installerInfo, String distName, String distVersion, Map<FeatureSet, Collection<Component>> compMap) {
        InstallerDistributionInfo distInfo;
        if (installerInfo != null && (distInfo = this.getInstallerDistributionInfo(installerInfo, distName, distVersion)) != null) {
            for (FeatureSet feature : compMap.keySet()) {
                InstallerFeatureInfo featureInfo = this.getInstallerFeatureInfo(distInfo, feature.getName(), feature.getVersion());
                if (featureInfo == null) continue;
                Collection<Component> components = compMap.get(feature);
                for (Component component : components) {
                    int disk;
                    InstallerComponentInfo componentInfo = this.getInstallerComponentInfo(featureInfo, component.getName(), component.getVersion());
                    if (componentInfo == null || (disk = component.getDisk()) == componentInfo.getDisk()) continue;
                    componentInfo.setDisk(disk);
                }
            }
        }
    }

    public InstallerInfo createComponentFilterInstallerInfo(Set<Reference> components) {
        InstallerInfo installerInfo = new InstallerInfo();
        if (components != null && !components.isEmpty()) {
            ArrayList<InstallerComponentInfo> cinfos = new ArrayList<InstallerComponentInfo>();
            for (Reference ref : components) {
                InstallerComponentInfo cinfo = new InstallerComponentInfo(ref.getName(), ref.getVersion());
                cinfo.setPackaged(false);
                cinfos.add(cinfo);
            }
            InstallerFeatureInfo finfo = new InstallerFeatureInfo(".*", ".*");
            finfo.setNameRegex(true);
            finfo.setVersionRegex(true);
            finfo.setInstallerComponentInfo(cinfos);
            ArrayList<InstallerFeatureInfo> finfos = new ArrayList<InstallerFeatureInfo>();
            finfos.add(finfo);
            InstallerDistributionInfo dinfo = new InstallerDistributionInfo(".*", ".*");
            dinfo.setNameRegex(true);
            dinfo.setVersionRegex(true);
            dinfo.setInstallerFeatureInfo(finfos);
            ArrayList<InstallerDistributionInfo> dinfos = new ArrayList<InstallerDistributionInfo>();
            dinfos.add(dinfo);
            installerInfo.getInstallerPackageInfo(true).setInstallerDistributionInfo(dinfos);
        }
        return installerInfo;
    }

    public Collection<Reference> getFilteredComponents(InstallerInfo installerInfo) {
        List<InstallerDistributionInfo> installerDistributionInfos;
        InstallerPackageInfo installerPackageInfo;
        ArrayList<Reference> filteredComponents = new ArrayList<Reference>();
        if (installerInfo != null && (installerPackageInfo = installerInfo.getInstallerPackageInfo()) != null && (installerDistributionInfos = installerPackageInfo.getInstallerDistributionInfo()) != null && !installerDistributionInfos.isEmpty()) {
            for (InstallerDistributionInfo installerDistributionInfo : installerDistributionInfos) {
                List<InstallerFeatureInfo> installerFeatureInfos = installerDistributionInfo.getInstallerFeatureInfo();
                if (installerFeatureInfos == null || installerFeatureInfos.isEmpty()) continue;
                for (InstallerFeatureInfo installerFeatureInfo : installerFeatureInfos) {
                    List<InstallerComponentInfo> installerComponentInfos = installerFeatureInfo.getInstallerComponentInfo();
                    if (installerComponentInfos == null || installerComponentInfos.isEmpty()) continue;
                    for (InstallerComponentInfo installerComponentInfo : installerComponentInfos) {
                        if (installerComponentInfo.isPackaged()) continue;
                        filteredComponents.add(installerComponentInfo);
                    }
                }
            }
        }
        return filteredComponents;
    }

    public void mergeInstallerInfoPackagingStates(InstallerInfo shiphomeInstallerInfo, InstallerInfo ouiConfigInstallerInfo) {
        if (shiphomeInstallerInfo != null && ouiConfigInstallerInfo != null) {
            InstallerPackageInfo ouiConfigPackagingInfo = ouiConfigInstallerInfo.getInstallerPackageInfo();
            InstallerPackageInfo shiphomePackagingInfo = shiphomeInstallerInfo.getInstallerPackageInfo();
            if (ouiConfigPackagingInfo != null && shiphomePackagingInfo != null) {
                List<InstallerDistributionInfo> ouiConfigDistInfos = ouiConfigPackagingInfo.getInstallerDistributionInfo();
                List<InstallerDistributionInfo> shiphomeDistInfos = shiphomePackagingInfo.getInstallerDistributionInfo();
                if (ouiConfigDistInfos != null && !ouiConfigDistInfos.isEmpty() && shiphomeDistInfos != null && !shiphomeDistInfos.isEmpty()) {
                    for (InstallerDistributionInfo ouiConfigDistInfo : ouiConfigDistInfos) {
                        for (InstallerDistributionInfo shiphomeDistInfo : shiphomeDistInfos) {
                            if (!this.isNameVersionMatch(ouiConfigDistInfo, shiphomeDistInfo.getName(), shiphomeDistInfo.getVersion())) continue;
                            List<InstallerFeatureInfo> ouiConfigFeatureInfos = ouiConfigDistInfo.getInstallerFeatureInfo();
                            List<InstallerFeatureInfo> shiphomeFeatureInfos = shiphomeDistInfo.getInstallerFeatureInfo();
                            if (ouiConfigFeatureInfos == null || ouiConfigFeatureInfos.isEmpty() || shiphomeFeatureInfos == null || shiphomeFeatureInfos.isEmpty()) continue;
                            for (InstallerFeatureInfo ouiConfigFeatureInfo : ouiConfigFeatureInfos) {
                                for (InstallerFeatureInfo shiphomeFeatureInfo : shiphomeFeatureInfos) {
                                    if (!this.isNameVersionMatch(ouiConfigFeatureInfo, shiphomeFeatureInfo.getName(), shiphomeFeatureInfo.getVersion())) continue;
                                    List<InstallerComponentInfo> ouiConfigComponentInfos = ouiConfigFeatureInfo.getInstallerComponentInfo();
                                    List<InstallerComponentInfo> shiphomeComponentInfos = shiphomeFeatureInfo.getInstallerComponentInfo();
                                    if (ouiConfigComponentInfos == null || ouiConfigComponentInfos.isEmpty() || shiphomeComponentInfos == null || shiphomeComponentInfos.isEmpty()) continue;
                                    for (InstallerComponentInfo ouiConfigComponentInfo : ouiConfigComponentInfos) {
                                        for (InstallerComponentInfo shiphomeComponentInfo : shiphomeComponentInfos) {
                                            if (!this.isNameVersionMatch(ouiConfigComponentInfo, shiphomeComponentInfo.getName(), shiphomeComponentInfo.getVersion())) continue;
                                            shiphomeComponentInfo.setPackaged(ouiConfigComponentInfo.isPackaged());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

