/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.dependency.dao.DependencyRef;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.FeatureLoader;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.lbm.LabelMap;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.services.ServiceHolder;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class HomeHelper {
    public static Map<FeatureSet, Collection<Component>> getInstalledComponents(DistributionTarget installedDistribution, ServiceHolder serviceHolder, MetaDataHome metaDataHome) throws GdrException, IOException, DataHandlerException {
        ComponentLoader componentLoader = new ComponentLoader(metaDataHome, serviceHolder, Mode.DEINSTALL, installedDistribution.getFeatureSets(), installedDistribution.getDirectoryMap(), null, (LabelMap)null);
        return componentLoader.getComponentsMap();
    }

    public static Set<FeatureSet> getInstalledFeaturesets(DistributionTarget installedDistribution, FeatureSetHelper featureHelper, Set<FeatureSet> allFeaturesets) throws GdrException, IOException, DataHandlerException {
        HashSet<FeatureSet> installedFeaturesets = new HashSet<FeatureSet>();
        HashSet<FeatureSet> dependencyFeaturesets = new HashSet<FeatureSet>();
        ArrayList<FeatureSet> allFeatureSetsList = new ArrayList<FeatureSet>(allFeaturesets);
        for (FeatureSet distInstalledFeatureset : installedDistribution.getInstalledFeatureSets()) {
            FeatureSet allInstalledFeatureSet;
            int index = allFeatureSetsList.indexOf(distInstalledFeatureset);
            if (index > -1 && (allInstalledFeatureSet = (FeatureSet)allFeatureSetsList.get(index)).isUpgrades()) {
                distInstalledFeatureset = allInstalledFeatureSet;
            }
            installedFeaturesets.add(distInstalledFeatureset);
        }
        for (FeatureSet featureset : installedFeaturesets) {
            HomeHelper.getFeatureSetDependencies(featureset, allFeaturesets, installedFeaturesets, dependencyFeaturesets, featureHelper);
        }
        installedFeaturesets.addAll(dependencyFeaturesets);
        return installedFeaturesets;
    }

    public static Set<FeatureSet> getFederatedFeatureDependencies(final Home home, Set<FeatureSet> currentHomeFeatureSets) throws GdrException, IOException, DataHandlerException {
        final HashSet<FeatureSet> federatedDeps = new HashSet<FeatureSet>();
        if (home != null && home.isFederatedHome() && currentHomeFeatureSets != null && !currentHomeFeatureSets.isEmpty()) {
            home.disableLazyLoad();
            MetaDataHome metaDataHome = null;
            if (!home.getInstalledDistributions().isEmpty()) {
                metaDataHome = home.getMetaDataHome();
            }
            new FeatureLoader(metaDataHome, null, new HashSet<FeatureSet>(currentHomeFeatureSets)){

                @Override
                protected void validate() throws GdrException {
                }

                @Override
                protected void loadMetaData(Set<FeatureSetReference> featuresRefs, Set<FeatureSet> features) throws GdrException, IOException, DataHandlerException {
                    try {
                        this.addFeatureDependencies(features, new HashSet<FeatureSetReference>(), this.getMetaDataHome());
                    }
                    catch (DependencyException e) {
                        throw new GdrException((Throwable)e);
                    }
                }

                @Override
                protected FeatureSet getLoadedFeatureDependency(DependencyRef ref, Set<FeatureSet> featureSets, MetaDataHome metaDataHome) throws GdrException, IOException, DataHandlerException {
                    FeatureSet featureSet = FeatureSetHelper.getInstance(metaDataHome != null ? metaDataHome.getClassLoader() : null).getFeatureDependency(ref, home.getInstalledFeatures());
                    if (featureSet == null) {
                        ArrayList<FeatureSet> matchingFeatureSets = new ArrayList<FeatureSet>();
                        for (Home federatedHome : home.getChainedFederatedHomes(false)) {
                            for (DistributionTarget distributionTarget : federatedHome.getInstalledDistributions()) {
                                FeatureSet foundFeatureSet = FeatureSetHelper.getInstance(federatedHome.getClassLoader()).getFeatureDependency(ref, distributionTarget.getInstalledFeatureSets());
                                if (foundFeatureSet == null) continue;
                                matchingFeatureSets.add(foundFeatureSet);
                            }
                        }
                        if (!matchingFeatureSets.isEmpty()) {
                            for (FeatureSet matchingFeatureSet : matchingFeatureSets) {
                                if (featureSet == null) {
                                    featureSet = matchingFeatureSet;
                                    continue;
                                }
                                Collection<FeatureSet> upgrades1 = featureSet.getUpgrades();
                                Collection<FeatureSet> upgrades2 = matchingFeatureSet.getUpgrades();
                                if ((upgrades1 != null || upgrades2 == null) && (upgrades1 == null || upgrades2 == null || upgrades2.size() <= upgrades1.size())) continue;
                                featureSet = matchingFeatureSet;
                            }
                            if (featureSet != null) {
                                federatedDeps.add(featureSet);
                            }
                        }
                    }
                    return featureSet;
                }

                @Override
                protected boolean swapUpgradesFeatureSet(Set<FeatureSet> featureSets, FeatureSet featureSet) {
                    boolean swap = false;
                    FeatureSet existingFeatureSet = null;
                    for (FeatureSet feature : featureSets) {
                        if (!feature.equals(featureSet)) continue;
                        existingFeatureSet = feature;
                        break;
                    }
                    if (existingFeatureSet != null) {
                        Collection<FeatureSet> existingFeatureUpgrades = existingFeatureSet.getUpgrades();
                        Collection<FeatureSet> foundFeatureUpgrades = featureSet.getUpgrades();
                        if (foundFeatureUpgrades != null) {
                            if (existingFeatureUpgrades == null) {
                                existingFeatureSet.setUpgrades(foundFeatureUpgrades);
                            } else {
                                for (FeatureSet upgrade : foundFeatureUpgrades) {
                                    existingFeatureSet.addUpgrades(upgrade);
                                }
                            }
                            swap = true;
                        }
                    }
                    return swap;
                }
            };
        }
        return FeatureSetHelper.getInstance().getClonedExternalFeatures(federatedDeps);
    }

    public static Set<FeatureSet> getExternalDummyFeatures(Collection<DistributionTarget> distributionTargets) {
        HashSet<FeatureSet> externalDummyFeatures = new HashSet<FeatureSet>();
        if (distributionTargets != null) {
            for (DistributionTarget distributionTarget : distributionTargets) {
                externalDummyFeatures.addAll(distributionTarget.getDummyExternalFeatureSets());
            }
        }
        return externalDummyFeatures;
    }

    private static Set<FeatureSet> getFeatures(DistributionTarget installedDists) throws GdrException {
        ArrayList<FeatureSet> installed = new ArrayList<FeatureSet>();
        ArrayList<FeatureSet> copied = new ArrayList<FeatureSet>();
        for (FeatureSet featureSet : installedDists.getInstalledFeatureSets()) {
            int index = installed.indexOf(featureSet);
            if (index > -1) {
                Collection<FeatureSet> upgrades;
                if (!featureSet.isUpgrades()) continue;
                FeatureSet existing = (FeatureSet)installed.get(index);
                if (!copied.contains(existing)) {
                    FeatureSet copy = existing.copy();
                    copied.add(copy);
                    installed.remove(index);
                    installed.add(copy);
                    existing = copy;
                }
                if ((upgrades = featureSet.getUpgrades()) != null) {
                    for (FeatureSet upgraded : upgrades) {
                        existing.addUpgrades(upgraded);
                    }
                }
                if ((upgrades = featureSet.getUpgradesInHome()) == null) continue;
                for (FeatureSet upgraded : upgrades) {
                    existing.addUpgradesInHome(upgraded);
                }
                continue;
            }
            installed.add(featureSet);
        }
        return new HashSet<FeatureSet>(installed);
    }

    private static void getFeatureSetDependencies(FeatureSet featureset, Set<FeatureSet> allFeaturesets, Set<FeatureSet> installedFeaturesets, Set<FeatureSet> dependencyFeaturesets, FeatureSetHelper featureHelper) throws GdrException, IOException, DataHandlerException {
        for (DependencyRef depRef : featureHelper.getFeatureDependencies(featureset)) {
            FeatureSet dependency = featureHelper.getFeatureDependency(depRef, allFeaturesets);
            if (dependency == null || installedFeaturesets.contains(dependency) || dependencyFeaturesets.contains(dependency)) continue;
            dependencyFeaturesets.add(dependency);
            HomeHelper.getFeatureSetDependencies(dependency, allFeaturesets, installedFeaturesets, dependencyFeaturesets, featureHelper);
        }
    }

    public static boolean isLegacyHome(File directory) {
        return HomeHelper.isLegacyHome(NioHelper.getInstance().getPath(directory));
    }

    public static boolean isLegacyHome(Path directory) {
        return !Home.isValidHome(directory) && directory != null && Files.isDirectory(directory, new LinkOption[0]) && Files.isDirectory(directory.resolve("inventory").resolve("ContentsXML"), new LinkOption[0]) && Files.exists(directory.resolve("inventory").resolve("ContentsXML").resolve("comps.xml"), new LinkOption[0]);
    }

    public static boolean isLegacyFederatedHome(Path homeDirPath) {
        return Files.exists(homeDirPath.resolve("inventory").resolve("ContentsXML").resolve("federated"), new LinkOption[0]);
    }

    public static Set<String> getLegacyProductFamilies(Path homeDirPath) throws IOException {
        HashSet<String> productFamilies = new HashSet<String>();
        Path fohMarker = homeDirPath.resolve("inventory").resolve("ContentsXML").resolve("federated");
        if (Files.exists(fohMarker, new LinkOption[0])) {
            Properties properties = new Properties();
            try (FileChannel channel = FileChannel.open(fohMarker, StandardOpenOption.READ);
                 FileLock lock = channel.lock(0L, Long.MAX_VALUE, true);){
                properties.load(Channels.newInputStream(channel));
            }
            for (String family : properties.getProperty("PRODUCT_FAMILY").split(",")) {
                productFamilies.add(family);
            }
        }
        return productFamilies;
    }

    public static List<String> getFederatesHomesForLegacyHome(Path homeDirPath) throws IOException {
        ArrayList<String> federatesHomes = new ArrayList<String>();
        Path fohMarker = homeDirPath.resolve("inventory").resolve("ContentsXML").resolve("federated");
        if (Files.exists(fohMarker, new LinkOption[0])) {
            Properties properties = new Properties();
            try (FileChannel channel = FileChannel.open(fohMarker, StandardOpenOption.READ);
                 FileLock lock = channel.lock(0L, Long.MAX_VALUE, true);){
                properties.load(Channels.newInputStream(channel));
            }
            for (String foh : properties.getProperty("FEDERATED_ORACLE_HOMES").split(",")) {
                federatesHomes.add(foh);
            }
        }
        return federatesHomes;
    }
}

