/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.util.FileCopy;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.dependency.VersionHelper;
import com.oracle.cie.dependency.dao.ConditionalOp;
import com.oracle.cie.dependency.dao.Dependency;
import com.oracle.cie.dependency.dao.DependencyRef;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.Version;
import com.oracle.cie.gdr.dao.cmn.QuickReference;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cmn.ResourceBundleInfo;
import com.oracle.cie.gdr.dao.cmn.ResourceBundleInfoHolder;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.FileMap;
import com.oracle.cie.gdr.dao.cpd.Library;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.dbd.FeatureSetGroup;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.dbd.Mapping;
import com.oracle.cie.gdr.dao.dbd.MappingSymbol;
import com.oracle.cie.gdr.dao.dei.DeInstallInfo;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.Components;
import com.oracle.cie.gdr.dao.ftr.FeatureLibrary;
import com.oracle.cie.gdr.dao.ftr.FeatureLibraryInclude;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.ftr.FeatureSetDependency;
import com.oracle.cie.gdr.dao.lbm.LabelMap;
import com.oracle.cie.gdr.dao.nfo.InstallerComponentInfo;
import com.oracle.cie.gdr.dao.nfo.InstallerDistributionInfo;
import com.oracle.cie.gdr.deinstallation.DeInstallerComponentTarget;
import com.oracle.cie.gdr.dependency.FeatureSelectionTarget;
import com.oracle.cie.gdr.dependency.FeatureSelectionTargetFactory;
import com.oracle.cie.gdr.external.FederatedRelationship;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.GdrHelper;
import com.oracle.cie.gdr.helpers.HomeHelper;
import com.oracle.cie.gdr.helpers.InstallerInfoHelper;
import com.oracle.cie.gdr.installation.InstallerComponentTarget;
import com.oracle.cie.gdr.libraries.JarLibraryHandler;
import com.oracle.cie.gdr.libraries.LibraryHandlerException;
import com.oracle.cie.gdr.libraries.LibraryTarget;
import com.oracle.cie.gdr.libraries.LibraryTargetHolder;
import com.oracle.cie.gdr.libraries.LibraryType;
import com.oracle.cie.gdr.libraries.LibraryVisibility;
import com.oracle.cie.gdr.nio.NioCopy;
import com.oracle.cie.gdr.nio.NioDeleteOnExitHook;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.packaging.PackagerComponentTarget;
import com.oracle.cie.gdr.services.RepositoryService;
import com.oracle.cie.gdr.services.ServiceHolder;
import com.oracle.cie.gdr.utils.FileUtils;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RepositoryType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FeatureSetHelper
extends GdrHelper<FeatureSet> {
    private static final Logger _log = Logger.getLogger(FeatureSetHelper.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/gdr/ftr";
    public static final String FEATURE_SET_DEF = "feature-set-def";
    public static final String FEATURE_SETS_DIR = "featuresets";
    public static final String FEATURE_SETS_PATCHES_DIR = "patches";
    public static final String FEATURE_SETS_PATCHES_UPGRADES_DIR = "upgrades";
    public static final String FEATURE_SETS_PATCHES_INSTALL_DIR = "install";
    public static final String FEATURE_SETS_PATCHES_DEINSTALL_DIR = "deinstall";
    public static final String RESOURCE_BASENAME = "featureset";
    public static final String CHOICE_CONSTRAINT = "choice";
    private static FeatureSetHelper _instance;

    public static FeatureSetHelper getInstance() {
        if (_instance == null) {
            _instance = new FeatureSetHelper(null);
        }
        return _instance;
    }

    public static FeatureSetHelper getInstance(ClassLoader classLoader) {
        if (classLoader == null) {
            return FeatureSetHelper.getInstance();
        }
        return new FeatureSetHelper(classLoader);
    }

    private FeatureSetHelper(ClassLoader classLoader) {
        super(FeatureSet.class, classLoader);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getRootElement() {
        return FEATURE_SET_DEF;
    }

    public String getPath() {
        return FEATURE_SETS_DIR;
    }

    @Override
    public String getDefaultResourceBundleBaseName() {
        return RESOURCE_BASENAME;
    }

    public FeatureSet getFeatureSet(File metaDataDir, FeatureSetReference ref) throws IOException, DataHandlerException, GdrException {
        MetaDataHome metaDataHome = new MetaDataHome(metaDataDir, false);
        metaDataHome.setClassLoader(this.getClassLoader());
        return this.getFeatureSet(metaDataHome, ref);
    }

    public FeatureSet getFeatureSet(MetaDataHome metaDataHome, FeatureSetReference ref) throws IOException, DataHandlerException, GdrException {
        FeatureSet feature = this.getFeatureSet(metaDataHome, ref.getName(), ref.getVersion());
        feature.setFeatureRefAttributes(ref);
        return feature;
    }

    public FeatureSet getFeatureSet(File metaDataDir, String name, String version) throws IOException, DataHandlerException, GdrException {
        MetaDataHome metaDataHome = new MetaDataHome(metaDataDir, false);
        metaDataHome.setClassLoader(this.getClassLoader());
        return this.getFeatureSet(metaDataHome, name, version);
    }

    public FeatureSet getFeatureSet(Path metaDataDir, String name, String version) throws IOException, DataHandlerException, GdrException {
        MetaDataHome metaDataHome = new MetaDataHome(metaDataDir, false);
        metaDataHome.setClassLoader(this.getClassLoader());
        return this.getFeatureSet(metaDataHome, name, version);
    }

    public FeatureSet getFeatureSet(MetaDataHome metaDataHome, String name, String version) throws IOException, DataHandlerException, GdrException {
        FeatureSet feature;
        if (metaDataHome == null) {
            GdrException ex = new GdrException("The specified meta-data home was null.");
            _log.throwing(FeatureSetHelper.class.getName(), "getFeatureSet", ex);
            throw ex;
        }
        if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            GdrException ex = new GdrException("The specified feature set name was null or empty.");
            _log.throwing(FeatureSetHelper.class.getName(), "getFeatureSet", ex);
            throw ex;
        }
        if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
            GdrException ex = new GdrException("The specified feature set version was null or empty.");
            _log.throwing(FeatureSetHelper.class.getName(), "getFeatureSet", ex);
            throw ex;
        }
        if (name.contains(" ")) {
            GdrException ex = new GdrException("The specified feature set name was invalid.  Feature sets names may not contain spaces: \"" + name + "\"");
            _log.throwing(FeatureSetHelper.class.getName(), "getFeatureSet", ex);
            throw ex;
        }
        Path patchedFeatureResources = null;
        if (metaDataHome.isArchive()) {
            JarHelper jarHelper = new JarHelper(metaDataHome.getGdrMetaDataHome());
            String entryPath = this.getPath() + "/" + this.getFeatureSetFileName(name, version);
            feature = this.getFeatureSetFromJar(jarHelper, entryPath);
            jarHelper.close();
            if (feature == null) {
                throw new GdrException("Unable to locate feature set " + this.getFeatureSetFileName(name, version) + " in meta-data archive " + metaDataHome.getGdrMetaDataHomePath());
            }
        } else {
            Path featurePath = null;
            Artifact featureSetArtifact = null;
            if (metaDataHome.isRepository()) {
                try {
                    featureSetArtifact = metaDataHome.getRepositoryService().getRepositoryVersionResolver().getFeatureSetArtifact(name, version);
                }
                catch (Exception e) {
                    GdrException ex = new GdrException("Unable to resolve feature set " + name + " " + version, (Throwable)e);
                    _log.throwing(DistributionHelper.class.getName(), "getFeatureSet", ex);
                    throw ex;
                }
                featurePath = NioHelper.getInstance().getPath(metaDataHome.getRepositoryService().getArtifactLocation(featureSetArtifact));
            } else {
                Path patchesDir = metaDataHome.getGdrMetaDataHomePath().resolve(this.getPath() + File.separator + FEATURE_SETS_PATCHES_DIR);
                if (Files.isDirectory(patchesDir, new LinkOption[0])) {
                    Path featureSetPatchDir = patchesDir.resolve(this.getFeatureSetBaseFileName(name, version));
                    featurePath = featureSetPatchDir.resolve(this.getFeatureSetFileName(name, version));
                    if (Files.exists(featurePath, new LinkOption[0])) {
                        _log.fine("Using patched feature set definition found at " + featurePath);
                    } else {
                        featurePath = null;
                    }
                    patchedFeatureResources = featureSetPatchDir.resolve(this.getResourceLocation(name, version));
                    if (Files.exists(patchedFeatureResources, new LinkOption[0])) {
                        _log.fine("Using patched feature set resources found at " + patchedFeatureResources);
                    } else {
                        patchedFeatureResources = null;
                    }
                }
                if (featurePath == null) {
                    featurePath = this.getFileLocatorService(metaDataHome.getGdrMetaDataHomePath()).getPath(this.getPath(), this.getFeatureSetFileName(name, version));
                    _log.fine("Using feature set definition found at " + featurePath);
                }
            }
            feature = (FeatureSet)this.getRootWrapper(featurePath);
            feature.setFeatureSetLocation(featurePath.toUri().toURL());
            feature.setFeatureSetArtifact(featureSetArtifact);
            FeatureSetDependency featureSetDependency = metaDataHome.getFeatureDependencyManager().getFeatureSetDependency(name, version);
            if (featureSetDependency != null) {
                feature.setFeatureSetDependency(featureSetDependency);
            }
        }
        if (!name.equals(feature.getName()) || !version.equals(feature.getVersion())) {
            GdrException ex = new GdrException("The internal feature name and version is incorrect.  Expected: " + name + " " + version + " Defined: " + feature.getName() + " " + feature.getVersion());
            _log.throwing(FeatureSetHelper.class.getName(), "getFeatureSet", ex);
            throw ex;
        }
        if (patchedFeatureResources != null) {
            this.setResourcesBundleInfoJarFile((ResourceBundleInfoHolder)feature, patchedFeatureResources);
        } else if (metaDataHome.isRepository()) {
            Artifact resourceArtifact = null;
            try {
                resourceArtifact = metaDataHome.getRepositoryService().getRepositoryVersionResolver().getFeatureSetResourcesArtifact(name, version);
            }
            catch (Exception e) {
                _log.log(Level.FINEST, "Failed to locate feature set resource artifact for " + name + " " + version + " under " + metaDataHome.getRepositoryService().getLocalCacheRepositoryLocation());
            }
            if (resourceArtifact != null) {
                this.setResourcesBundleInfo(feature, metaDataHome, resourceArtifact);
            }
        } else {
            this.setResourcesBundleInfo((ResourceBundleInfoHolder)feature, metaDataHome);
        }
        return feature;
    }

    private FeatureSet getFeatureSetFromJar(JarHelper jarHelper, String entry) throws IOException, DataHandlerException, GdrException {
        String jarFile = jarHelper.getJar().getName();
        InputStream is = jarHelper.getInputStream(entry);
        if (is == null) {
            GdrException ex = new GdrException("Unable to locate feature set entry " + entry + " in archive " + jarFile);
            _log.throwing(FeatureSetHelper.class.getName(), "getFeatureSet", ex);
            throw ex;
        }
        FeatureSet feature = (FeatureSet)this.getRootWrapper(is);
        feature.setFeatureSetLocation(new URL("jar:" + new File(jarFile).toURI().toURL() + "!/" + entry));
        return feature;
    }

    public List<File> getFeatureSetFiles(File metaDataDir) {
        List<Path> paths = this.getFeatureSetFiles(NioHelper.getInstance().getPath(metaDataDir));
        ArrayList<File> files = new ArrayList<File>();
        for (Path path : paths) {
            files.add(path.toFile());
        }
        return files;
    }

    public List<Path> getFeatureSetFiles(Path metaDataDir) {
        return this.getFeatureSetPaths(metaDataDir);
    }

    public List<Path> getFeatureSetPaths(Path metaDataDir) {
        ArrayList<Path> paths = new ArrayList<Path>();
        if (metaDataDir != null && Files.isDirectory(metaDataDir, new LinkOption[0])) {
            paths.addAll(this.getFileLocatorService(metaDataDir).getPathsUnderPath(this.getPath()));
            Iterator it = paths.iterator();
            while (it.hasNext()) {
                Path path = (Path)it.next();
                if (Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".xml")) continue;
                it.remove();
            }
        }
        return paths;
    }

    public FeatureSet getFeatureSet(File featureSetFile) throws IOException, DataHandlerException, GdrException {
        return this.getFeatureSet(NioHelper.getInstance().getPath(featureSetFile), true);
    }

    public FeatureSet getFeatureSet(Path featureSetFile) throws IOException, DataHandlerException, GdrException {
        return this.getFeatureSet(featureSetFile, true);
    }

    public FeatureSet getFeatureSet(File featureSetFile, boolean validateFileName) throws IOException, DataHandlerException, GdrException {
        return this.getFeatureSet(NioHelper.getInstance().getPath(featureSetFile), validateFileName);
    }

    public FeatureSet getFeatureSet(Path featureSetFile, boolean validateFileName) throws IOException, DataHandlerException, GdrException {
        Path metaDataRoot;
        FeatureSet featureSet;
        if (featureSetFile != null) {
            featureSet = (FeatureSet)this.getRootWrapper(featureSetFile);
            featureSet.setFeatureSetLocation(featureSetFile.toUri().toURL());
            if (validateFileName && !featureSetFile.getFileName().toString().equals(this.getFeatureSetFileName(featureSet))) {
                GdrException ex = new GdrException("The internal feature name and version is incorrect.  File name should be: " + this.getFeatureSetFileName(featureSet) + " File name is: " + featureSetFile.getFileName());
                _log.throwing(FeatureSetHelper.class.getName(), "getFeatureSet", ex);
                throw ex;
            }
            if (featureSet.getName().contains(" ")) {
                GdrException ex = new GdrException("The feature set file " + featureSetFile + " contains an invalid name.  Feature sets names may not contain spaces: \"" + featureSet.getName() + "\"");
                _log.throwing(FeatureSetHelper.class.getName(), "getFeatureSet", ex);
                throw ex;
            }
            metaDataRoot = featureSetFile.getParent();
            if (metaDataRoot != null) {
                metaDataRoot = metaDataRoot.getParent();
            }
        } else {
            GdrException ex = new GdrException("The specified feature set file was null.");
            _log.throwing(FeatureSetHelper.class.getName(), "getFeatureSet", ex);
            throw ex;
        }
        this.setResourcesBundleInfo((ResourceBundleInfoHolder)featureSet, metaDataRoot);
        return featureSet;
    }

    public Set<FeatureSet> getFeatureSets(MetaDataHome metaDataHome) throws IOException, DataHandlerException, GdrException {
        LinkedHashSet<FeatureSet> featureSets;
        if (metaDataHome.isArchive()) {
            featureSets = new LinkedHashSet();
            JarHelper jarHelper = new JarHelper(metaDataHome.getGdrMetaDataHome());
            Collection entries = jarHelper.getEntries();
            for (String entry : entries) {
                String[] split = entry.replaceAll("\\\\", "/").split("/");
                if (split.length != 2 || !split[0].equals(this.getPath()) || !split[1].endsWith(".xml")) continue;
                FeatureSet feature = this.getFeatureSetFromJar(jarHelper, entry);
                this.setResourcesBundleInfo((ResourceBundleInfoHolder)feature, metaDataHome);
                featureSets.add(feature);
            }
            jarHelper.close();
        } else {
            featureSets = this.getFeatureSets(metaDataHome.getGdrMetaDataHomePath(), false);
        }
        return featureSets;
    }

    public Set<FeatureSet> getFeatureSets(Path metaDataDir) throws IOException, DataHandlerException, GdrException {
        return this.getFeatureSets(metaDataDir, false);
    }

    public Set<FeatureSet> getFeatureSets(File metaDataDir) throws IOException, DataHandlerException, GdrException {
        return this.getFeatureSets(metaDataDir, false);
    }

    public Set<FeatureSet> getFeatureSets(File metaDataDir, boolean ignoreParsingFailures) throws IOException, DataHandlerException, GdrException {
        return this.getFeatureSets(NioHelper.getInstance().getPath(metaDataDir), ignoreParsingFailures);
    }

    public Set<FeatureSet> getFeatureSets(Path metaDataDir, boolean ignoreParsingFailures) throws IOException, DataHandlerException, GdrException {
        LinkedHashSet<FeatureSet> featureSets = new LinkedHashSet<FeatureSet>();
        if (metaDataDir != null && Files.isDirectory(metaDataDir, new LinkOption[0])) {
            for (Path f : this.getFeatureSetFiles(metaDataDir)) {
                FeatureSet feature;
                try {
                    feature = this.getFeatureSet(f);
                }
                catch (DataHandlerException dhe) {
                    if (!ignoreParsingFailures) {
                        throw dhe;
                    }
                    _log.log(Level.WARNING, "Error parsing feature set file " + f, dhe);
                    continue;
                }
                featureSets.add(feature);
            }
        }
        return featureSets;
    }

    public void saveFeatureSets(Collection<FeatureSet> features, File directory) throws GdrException, DataHandlerException, IOException {
        this.saveFeatureSets(features, NioHelper.getInstance().getPath(directory));
    }

    public void saveFeatureSets(Collection<FeatureSet> features, Path directory) throws GdrException, DataHandlerException, IOException {
        this.saveFeatureSets(features, directory, false);
    }

    public void saveFeatureSets(Collection<FeatureSet> features, File directory, boolean reconstituteResources) throws GdrException, DataHandlerException, IOException {
        this.saveFeatureSets(features, NioHelper.getInstance().getPath(directory), reconstituteResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFeatureSets(Collection<FeatureSet> features, Path directory, boolean reconstituteResources) throws GdrException, DataHandlerException, IOException {
        if (features == null) {
            GdrException ex = new GdrException("The features specified were null.");
            _log.throwing(DistributionHelper.class.getName(), "saveFeatureSets", ex);
            throw ex;
        }
        if (directory == null) {
            GdrException ex = new GdrException("The directory specified was null.");
            _log.throwing(DistributionHelper.class.getName(), "saveFeatureSets", ex);
            throw ex;
        }
        if (!Files.exists(directory, new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
            if (!Files.exists(directory, new LinkOption[0])) {
                GdrException ex = new GdrException("The directory specified did not exist and could not be created: " + directory);
                _log.throwing(FeatureSetHelper.class.getName(), "saveFeatureSets", ex);
                throw ex;
            }
        } else if (!Files.isDirectory(directory, new LinkOption[0])) {
            GdrException ex = new GdrException("The directory specified was not a directory: " + directory);
            _log.throwing(FeatureSetHelper.class.getName(), "saveFeatureSets", ex);
            throw ex;
        }
        HashMap<Path, JarHelper> resourceJarCache = null;
        try {
            for (FeatureSet feature : features) {
                Path resourceLocation;
                ResourceBundleInfo rbi;
                this.save((IDataHandlerWrapper)feature, directory.resolve(this.getFeatureSetFileName(feature)));
                if (feature.hasFeatureDependency()) {
                    FeatureSetDependency featureSetDependency = feature.getFeatureSetDependency();
                    this.save(featureSetDependency.getDataHandler(), directory.resolve("dependencies" + File.separator + this.getFeatureSetFileName(featureSetDependency.getName(), featureSetDependency.getVersion())));
                }
                if ((rbi = feature.getResourceBundleInfo()) == null || (resourceLocation = rbi.getResourceLocationPath()) == null || !Files.exists(resourceLocation, new LinkOption[0]) || !Files.isRegularFile(resourceLocation, new LinkOption[0])) continue;
                Path destLocation = directory.resolve(this.getResourceLocation(feature.getName(), feature.getVersion()));
                if (reconstituteResources) {
                    JarHelper sourceJar;
                    JarHelper jarHelper = sourceJar = resourceJarCache != null ? (JarHelper)resourceJarCache.get(resourceLocation) : null;
                    if (sourceJar == null) {
                        sourceJar = new JarHelper(resourceLocation.toFile());
                        if (resourceJarCache == null) {
                            resourceJarCache = new HashMap<Path, JarHelper>();
                        }
                        resourceJarCache.put(resourceLocation, sourceJar);
                    }
                    JarHelper destJar = null;
                    try {
                        String resourcePath = "resources/" + FeatureSetHelper.getFormattedNameVersion(feature.getName(), feature.getVersion()) + "/";
                        HashSet<String> resourceEntries = new HashSet<String>();
                        Collection sourceEntries = sourceJar.getEntries();
                        if (sourceEntries != null && !sourceEntries.isEmpty()) {
                            for (String sourceEntry : sourceEntries) {
                                if (!sourceEntry.startsWith(resourcePath) || sourceEntry.length() <= resourcePath.length()) continue;
                                resourceEntries.add(sourceEntry);
                            }
                        }
                        if (resourceEntries.isEmpty()) continue;
                        Path parent = destLocation.getParent();
                        if (parent != null) {
                            Files.createDirectories(parent, new FileAttribute[0]);
                        }
                        destJar = new JarHelper(destLocation.toFile(), 1, sourceJar.getManifest());
                        for (String resourceEntry : resourceEntries) {
                            InputStream is = sourceJar.getInputStream(resourceEntry);
                            destJar.append(resourceEntry, is);
                        }
                        continue;
                    }
                    finally {
                        if (destJar != null) {
                            destJar.close();
                        }
                        continue;
                    }
                }
                NioCopy.copyFile((Path)resourceLocation, (Path)destLocation);
            }
        }
        finally {
            if (resourceJarCache != null && !resourceJarCache.isEmpty()) {
                for (JarHelper jarHelper : resourceJarCache.values()) {
                    jarHelper.close();
                }
            }
        }
    }

    public void saveFeatureSets(Collection<FeatureSet> features, Repository repository) throws GdrException, DataHandlerException, IOException {
        if (features == null) {
            GdrException ex = new GdrException("The features specified were null.");
            _log.throwing(DistributionHelper.class.getName(), "saveFeatureSets", ex);
            throw ex;
        }
        if (repository == null) {
            GdrException ex = new GdrException("The repository specified was null.");
            _log.throwing(DistributionHelper.class.getName(), "saveFeatureSets", ex);
            throw ex;
        }
        if (!repository.getType().isCache()) {
            throw new GdrException("The repository specified is not of type \"" + RepositoryType.CACHE + "\". Cannot save feature set in repository of type \"" + repository.getType() + "\".");
        }
        File repositoryDir = repository.getCacheLocation();
        if (!repositoryDir.exists() && !repositoryDir.mkdirs()) {
            GdrException ex = new GdrException("The repository directory specified did not exist and could not be created: " + repositoryDir);
            _log.throwing(DistributionHelper.class.getName(), "saveFeatureSets", ex);
            throw ex;
        }
        if (!repositoryDir.isDirectory()) {
            GdrException ex = new GdrException("The repository directory specified was not a directory: " + repositoryDir);
            _log.throwing(DistributionHelper.class.getName(), "saveFeatureSets", ex);
            throw ex;
        }
        for (FeatureSet feature : features) {
            Artifact artifact = feature.getFeatureSetArtifact();
            if (artifact == null) {
                artifact = DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.featureset", feature.getName(), feature.getVersion(), "xml", new String[]{RepositoryService.getVersionQualifier()});
            }
            FileCopy.copy((File)feature.getFeatureSetFileLocation(), (File)artifact.getLocalLocation(repository.getCacheLocation()));
            ResourceBundleInfo rbi = feature.getResourceBundleInfo();
            if (rbi == null) continue;
            File resourceLocation = rbi.getResourceLocation();
            Artifact resourceArtifact = rbi.getResourceArtifact();
            if (resourceLocation == null || !resourceLocation.exists() || !resourceLocation.isFile() || resourceArtifact == null) continue;
            File destLocation = resourceArtifact.getLocalLocation(repositoryDir);
            FileCopy.copy((File)resourceLocation, (File)destLocation);
        }
    }

    public void removeFeatureSets(Collection<FeatureSet> features, File metaDataRoot) {
        this.removeFeatureSets(features, NioHelper.getInstance().getPath(metaDataRoot));
    }

    public void removeFeatureSets(Collection<FeatureSet> features, Path metaDataRoot) {
        if (metaDataRoot != null) {
            Path featuresDir = metaDataRoot.resolve(FEATURE_SETS_DIR);
            if (features != null && !features.isEmpty()) {
                for (FeatureSet feature : features) {
                    Path featureFile = featuresDir.resolve(this.getFeatureSetFileName(feature));
                    try {
                        if (Files.exists(featureFile, new LinkOption[0])) {
                            Files.delete(featureFile);
                            if (Files.exists(featureFile, new LinkOption[0])) {
                                _log.warning("Unable to delete feature file " + featureFile);
                                NioDeleteOnExitHook.add((Path)featureFile);
                            }
                        }
                    }
                    catch (IOException e) {
                        _log.warning("Unable to delete feature file " + featureFile);
                        NioDeleteOnExitHook.add((Path)featureFile);
                    }
                    Path featureDepFile = featuresDir.resolve("dependencies").resolve(this.getFeatureSetFileName(feature));
                    try {
                        if (Files.exists(featureDepFile, new LinkOption[0])) {
                            Files.delete(featureDepFile);
                            if (Files.exists(featureDepFile, new LinkOption[0])) {
                                NioDeleteOnExitHook.add((Path)featureDepFile);
                            }
                        }
                    }
                    catch (IOException e) {
                        NioDeleteOnExitHook.add((Path)featureDepFile);
                    }
                    Path resourceJarLocation = featuresDir.resolve(this.getResourceLocation(feature.getName(), feature.getVersion()));
                    try {
                        if (!Files.exists(resourceJarLocation, new LinkOption[0])) continue;
                        Files.delete(resourceJarLocation);
                        if (!Files.exists(resourceJarLocation, new LinkOption[0])) continue;
                        NioDeleteOnExitHook.add((Path)resourceJarLocation);
                    }
                    catch (IOException e) {
                        NioDeleteOnExitHook.add((Path)resourceJarLocation);
                    }
                }
            }
            Path p = featuresDir.resolve("resources").resolve("modules");
            try {
                if (Files.exists(p, new LinkOption[0]) && FileUtils.isDirectoryEmpty(p)) {
                    Files.delete(p);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            p = featuresDir.resolve("resources");
            try {
                if (Files.exists(p, new LinkOption[0]) && FileUtils.isDirectoryEmpty(p)) {
                    Files.delete(p);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                Files.delete(featuresDir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getFeatureSetFileName(FeatureSet feature) {
        return this.getFeatureSetFileName(feature.getName(), feature.getVersion());
    }

    public String getFeatureSetFileName(String name, String version) {
        return this.getFeatureSetBaseFileName(name, version) + ".xml";
    }

    public String getFeatureSetBaseFileName(String name, String version) {
        return FeatureSetHelper.getFormattedNameVersion(name, version);
    }

    public Map<FeatureSet, Collection<Component>> getPackagerComponentMap(Mode mode, Collection<FeatureSet> featureSets, LabelMap labelMap, DirectoryMap dirMap, InstallerDistributionInfo distributionInfo, ServiceHolder serviceHolder, MetaDataHome metaDataHome) throws IOException, DataHandlerException, GdrException {
        return this.getPackagerComponentMap(mode, featureSets, labelMap, dirMap, distributionInfo, serviceHolder, metaDataHome, null);
    }

    public Map<FeatureSet, Collection<Component>> getPackagerComponentMap(Mode mode, Collection<FeatureSet> featureSets, LabelMap labelMap, DirectoryMap dirMap, InstallerDistributionInfo distributionInfo, ServiceHolder serviceHolder, MetaDataHome metaDataHome, Set<Reference> componentFilter) throws IOException, DataHandlerException, GdrException {
        LinkedHashMap<FeatureSet, Collection<Component>> components = new LinkedHashMap<FeatureSet, Collection<Component>>();
        if (featureSets != null && !featureSets.isEmpty()) {
            if (metaDataHome == null) {
                GdrException ex = new GdrException("The meta-date home provided was null.");
                _log.throwing(FeatureSetHelper.class.getName(), "getPackagerComponentMap", ex);
                throw ex;
            }
            if (!metaDataHome.isShiphome() && !metaDataHome.isRepository() && labelMap == null) {
                GdrException ex = new GdrException("LabelMap provided was null.");
                _log.throwing(FeatureSetHelper.class.getName(), "getPackagerComponentMap", ex);
                throw ex;
            }
            for (FeatureSet feature : featureSets) {
                LinkedHashSet<Component> comps = new LinkedHashSet<Component>();
                components.put(feature, comps);
                List<Components> fsComps = feature.getComponents();
                if (fsComps == null || fsComps.isEmpty()) continue;
                block4: for (Components fsComp : fsComps) {
                    boolean choiceConstraint = CHOICE_CONSTRAINT.equalsIgnoreCase(fsComp.getConstraint());
                    List<ComponentReference> refs = fsComp.getComponentReferences();
                    if (refs == null || refs.isEmpty()) continue;
                    for (int x = 0; x < refs.size(); ++x) {
                        GdrException ex;
                        Component baseComp;
                        ComponentReference ref = refs.get(x);
                        if (componentFilter != null && !componentFilter.contains((Object)ref)) {
                            ref.setPackaged(false);
                            continue;
                        }
                        InstallerComponentInfo cinfo = InstallerInfoHelper.getInstance(this.getClassLoader()).getInstallerComponentInfo(distributionInfo, feature, ref);
                        if (!feature.isGeneric() && serviceHolder.getPlatformService().isGeneric() || metaDataHome.isShiphome() && cinfo != null && !cinfo.isPackaged()) {
                            ref.setPackaged(false);
                            continue;
                        }
                        boolean foundLoadedComponent = false;
                        for (Collection loadedComponents : components.values()) {
                            for (Component loadedComponent : loadedComponents) {
                                if (!loadedComponent.getName().equals(ref.getName()) || !loadedComponent.getVersion().equals(ref.getVersion())) continue;
                                comps.add(loadedComponent);
                                foundLoadedComponent = true;
                                break;
                            }
                            if (!foundLoadedComponent) continue;
                            break;
                        }
                        if (foundLoadedComponent) {
                            if (!choiceConstraint) continue;
                            for (int y = x + 1; y < refs.size(); ++y) {
                                refs.get(y).setPackaged(false);
                            }
                            continue block4;
                        }
                        try {
                            baseComp = ComponentHelper.getInstance(this.getClassLoader()).getComponent(metaDataHome, labelMap, ref, cinfo, mode);
                            baseComp.setUnstaged(true);
                        }
                        catch (FileNotFoundException fnfe) {
                            if (ref.isOptional()) {
                                _log.info("Skipping optional component because it was not found: " + (Object)((Object)ref));
                                ref.setPackaged(false);
                                continue;
                            }
                            if (choiceConstraint && x != refs.size() - 1) {
                                _log.info("Skipping choice component because it was not found: " + (Object)((Object)ref));
                                ref.setPackaged(false);
                                continue;
                            }
                            throw fnfe;
                        }
                        catch (GdrException e) {
                            if (metaDataHome.isRepository()) continue;
                            throw e;
                        }
                        if (baseComp == null) continue;
                        if (comps.contains(baseComp)) {
                            ex = new GdrException("Encountered duplicate components: " + baseComp);
                            _log.throwing(FeatureSetHelper.class.getName(), "getPackagerComponentMap", ex);
                            throw ex;
                        }
                        if (feature.isSingleton() && baseComp.isReplicable()) {
                            ex = new GdrException("Encountered singleton feature " + feature + " which contained replicable component " + (Object)((Object)ref) + ". Singleton features may not contain replicable components.");
                            _log.throwing(FeatureSetHelper.class.getName(), "getPackagerComponentMap", ex);
                            throw ex;
                        }
                        Collection<ComponentTarget> targets = this.getComponentTargets(mode, baseComp, dirMap, serviceHolder);
                        if (targets != null && !targets.isEmpty()) {
                            baseComp.setComponentTargets(targets);
                            comps.add(baseComp);
                            ref.setPackaged(true);
                        } else {
                            ref.setPackaged(false);
                        }
                        if (!choiceConstraint) continue;
                        for (int y = x + 1; y < refs.size(); ++y) {
                            refs.get(y).setPackaged(false);
                        }
                        continue block4;
                    }
                }
            }
        }
        return components;
    }

    public Map<FeatureSet, Collection<Component>> getInstallerComponentMap(Collection<FeatureSet> featureSets, LabelMap labelMap, DirectoryMap dirMap, InstallerDistributionInfo distributionInfo, ServiceHolder serviceHolder, MetaDataHome metaDataHome) throws IOException, DataHandlerException, GdrException {
        return this.getInstallerComponentMap(featureSets, labelMap, dirMap, distributionInfo, serviceHolder, metaDataHome, null);
    }

    public Map<FeatureSet, Collection<Component>> getInstallerComponentMap(Collection<FeatureSet> featureSets, LabelMap labelMap, DirectoryMap dirMap, InstallerDistributionInfo distributionInfo, ServiceHolder serviceHolder, MetaDataHome metaDataHome, Set<Reference> componentFilter) throws IOException, DataHandlerException, GdrException {
        return this.getInstallerComponentMap(Mode.INSTALL, featureSets, labelMap, dirMap, distributionInfo, serviceHolder, metaDataHome, componentFilter);
    }

    public Map<FeatureSet, Collection<Component>> getInstallerComponentMap(Mode mode, Collection<FeatureSet> featureSets, LabelMap labelMap, DirectoryMap dirMap, InstallerDistributionInfo distributionInfo, ServiceHolder serviceHolder, MetaDataHome metaDataHome, Set<Reference> componentFilter) throws IOException, DataHandlerException, GdrException {
        return this.getInstallerComponentMap(mode, featureSets, labelMap, dirMap, distributionInfo, serviceHolder, metaDataHome, componentFilter, null);
    }

    public Map<FeatureSet, Collection<Component>> getInstallerComponentMap(Mode mode, Collection<FeatureSet> featureSets, LabelMap labelMap, DirectoryMap dirMap, InstallerDistributionInfo distributionInfo, ServiceHolder serviceHolder, MetaDataHome metaDataHome, Set<Reference> componentFilter, Map<Reference, Component> previouslyLoadedComponents) throws IOException, DataHandlerException, GdrException {
        LinkedHashMap<FeatureSet, Collection<Component>> components = new LinkedHashMap<FeatureSet, Collection<Component>>();
        if (featureSets != null && !featureSets.isEmpty()) {
            if (metaDataHome == null) {
                GdrException ex = new GdrException("The meta-data home provided was null.");
                _log.throwing(FeatureSetHelper.class.getName(), "getInstallerComponentMap", ex);
                throw ex;
            }
            for (FeatureSet feature : featureSets) {
                LinkedHashSet<Component> comps = new LinkedHashSet<Component>();
                components.put(feature, comps);
                List<Components> fsComps = feature.getComponents();
                if (fsComps == null || fsComps.isEmpty()) continue;
                block3: for (Components fsComp : fsComps) {
                    boolean choiceConstraint = CHOICE_CONSTRAINT.equalsIgnoreCase(fsComp.getConstraint());
                    List<ComponentReference> refs = fsComp.getComponentReferences();
                    if (refs == null || refs.isEmpty()) continue;
                    for (int x = 0; x < refs.size(); ++x) {
                        Component comp;
                        ComponentReference ref = refs.get(x);
                        InstallerComponentInfo cinfo = InstallerInfoHelper.getInstance(this.getClassLoader()).getInstallerComponentInfo(distributionInfo, feature, ref);
                        if (cinfo != null && !cinfo.isPackaged()) {
                            ref.setPackaged(false);
                            continue;
                        }
                        if (componentFilter != null && !componentFilter.contains((Object)ref)) continue;
                        Component component = comp = previouslyLoadedComponents != null ? previouslyLoadedComponents.get((Object)ref) : null;
                        if (comp != null) {
                            comp = comp.copy();
                        } else {
                            try {
                                comp = ComponentHelper.getInstance(this.getClassLoader()).getComponent(metaDataHome, metaDataHome.isShiphome() ? null : labelMap, ref, cinfo, mode);
                            }
                            catch (FileNotFoundException fnfe) {
                                if (ref.isOptional()) {
                                    _log.info("Skipping optional component because it was not found: " + (Object)((Object)ref));
                                    if (_log.isLoggable(Level.FINEST)) {
                                        _log.log(Level.FINEST, fnfe.getMessage(), fnfe);
                                    }
                                    ref.setPackaged(false);
                                    continue;
                                }
                                if (choiceConstraint && x != refs.size() - 1) {
                                    _log.info("Skipping choice component because it was not found: " + (Object)((Object)ref));
                                    ref.setPackaged(false);
                                    continue;
                                }
                                throw fnfe;
                            }
                        }
                        if (feature.isSingleton() && comp.isReplicable()) {
                            GdrException ex = new GdrException("Encountered singleton feature " + feature + " which contained replicable component " + (Object)((Object)ref) + ". Singleton features may not contain replicable components.");
                            _log.throwing(FeatureSetHelper.class.getName(), "getInstallerComponentMap", ex);
                            throw ex;
                        }
                        Collection<ComponentTarget> targets = this.getComponentTargets(mode, comp, dirMap, serviceHolder);
                        if (targets != null && !targets.isEmpty()) {
                            comp.setComponentTargets(targets);
                            comp.setComponentReference(ref);
                            comps.add(comp);
                        } else {
                            ref.setPackaged(false);
                        }
                        if (!choiceConstraint) continue;
                        for (int y = x + 1; y < refs.size(); ++y) {
                            refs.get(y).setPackaged(false);
                        }
                        continue block3;
                    }
                }
            }
        }
        return components;
    }

    public Map<FeatureSet, Collection<Component>> getDeInstallerComponentMap(Collection<FeatureSet> featureSets, DirectoryMap dirMap, ServiceHolder serviceHolder, DeInstallInfo deInstallInfo, MetaDataHome metaDataHome) throws IOException, DataHandlerException, GdrException {
        return this.getDeInstallerComponentMap(featureSets, dirMap, serviceHolder, deInstallInfo, metaDataHome, null);
    }

    public Map<FeatureSet, Collection<Component>> getDeInstallerComponentMap(Collection<FeatureSet> featureSets, DirectoryMap dirMap, ServiceHolder serviceHolder, DeInstallInfo deInstallInfo, MetaDataHome metaDataHome, Set<Reference> componentFilter) throws IOException, DataHandlerException, GdrException {
        LinkedHashMap<FeatureSet, Collection<Component>> components = new LinkedHashMap<FeatureSet, Collection<Component>>();
        if (featureSets != null && !featureSets.isEmpty()) {
            if (metaDataHome == null) {
                GdrException ex = new GdrException("The meta-data home provided was null.");
                _log.throwing(FeatureSetHelper.class.getName(), "getDeInstallerComponentMap", ex);
                throw ex;
            }
            for (FeatureSet feature : featureSets) {
                LinkedHashSet<Component> comps = new LinkedHashSet<Component>();
                components.put(feature, comps);
                List<ComponentReference> refs = feature.getComponentReferences();
                if (refs == null || refs.isEmpty()) continue;
                for (ComponentReference ref : refs) {
                    Component comp;
                    if (ref.getStatus().isNotInstalled() || componentFilter != null && !componentFilter.contains((Object)ref)) continue;
                    try {
                        comp = this.getDeInstallerComponent(ref, dirMap, serviceHolder, deInstallInfo, metaDataHome);
                    }
                    catch (FileNotFoundException fnfe) {
                        if (ref.isOptional()) {
                            _log.info("Skipping optional component because it was not found: " + (Object)((Object)ref));
                            if (_log.isLoggable(Level.FINEST)) {
                                _log.log(Level.FINEST, fnfe.getMessage(), fnfe);
                            }
                            ref.setPackaged(false);
                            continue;
                        }
                        throw new FileNotFoundException(fnfe.getMessage());
                    }
                    comps.add(comp);
                }
            }
        }
        return components;
    }

    public Component getDeInstallerComponent(ComponentReference componentReference, DirectoryMap dirMap, ServiceHolder serviceHolder, DeInstallInfo deInstallInfo, MetaDataHome metaDataHome) throws IOException, DataHandlerException, GdrException {
        Component comp = ComponentHelper.getInstance(this.getClassLoader()).getComponent(metaDataHome, componentReference, Mode.DEINSTALL);
        comp.setComponentTargets(this.getComponentTargets(Mode.DEINSTALL, comp, dirMap, serviceHolder, deInstallInfo));
        comp.setComponentReference(componentReference);
        return comp;
    }

    public Collection<ComponentTarget> getComponentTargets(Mode mode, Component component, DirectoryMap dirMap, ServiceHolder serviceHolder) throws GdrException {
        return this.getComponentTargets(mode, component, dirMap, serviceHolder, null);
    }

    public Collection<ComponentTarget> getComponentTargets(Mode mode, Component component, DirectoryMap dirMap, ServiceHolder serviceHolder, DeInstallInfo deInstallInfo) throws GdrException {
        ArrayList<ComponentTarget> targets = new ArrayList<ComponentTarget>();
        targets.addAll(this.getComponentTargets(mode, component, component, dirMap, serviceHolder, deInstallInfo));
        if (component.hasComponentExtensions()) {
            ArrayList<ComponentTarget> extTargets = new ArrayList<ComponentTarget>();
            for (Component extComponent : component.getComponentExtensions()) {
                extTargets.addAll(this.getComponentTargets(mode, component, extComponent, dirMap, serviceHolder, deInstallInfo));
            }
            if (!component.isCarb()) {
                this.adjustComponentSources(component);
            }
            targets.addAll(extTargets);
        }
        return targets;
    }

    private Collection<ComponentTarget> getComponentTargets(Mode mode, Component baseComponent, Component component, DirectoryMap dirMap, ServiceHolder serviceHolder, DeInstallInfo deInstallInfo) throws GdrException {
        ArrayList<ComponentTarget> targets = new ArrayList<ComponentTarget>();
        int componentRootDirsSize = -1;
        List<FileMap> fileMaps = component.getFileMaps();
        for (FileMap fileMap : fileMaps) {
            Set<String> fileMapLocales;
            GdrException ex;
            String symbol = fileMap.getSymbol();
            if (StringUtil.isNullOrEmpty((String)symbol)) {
                GdrException ex2 = new GdrException("File map in component " + component + " missing symbol: " + (Object)((Object)fileMap));
                _log.throwing(ComponentHelper.class.getName(), "getComponentTargets", ex2);
                throw ex2;
            }
            Collection<Mapping> componentRootDirs = null;
            if (dirMap != null) {
                componentRootDirs = DistributionHelper.getInstance(this.getClassLoader()).getRootDirsMappingsForSymbol(dirMap, symbol);
                if (componentRootDirs == null || componentRootDirs.isEmpty()) {
                    ex = new GdrException("Unable to locate directory mapping for component: " + component + " symbol: " + symbol);
                    _log.throwing(ComponentHelper.class.getName(), "getComponentTargets", ex);
                    throw ex;
                }
                if (component.isReplicable()) {
                    if (componentRootDirsSize > -1 && componentRootDirsSize != componentRootDirs.size()) {
                        ex = new GdrException("Replicable component has symbols which have not been consistently mapped: " + component + " symbol: " + symbol);
                        _log.throwing(ComponentHelper.class.getName(), "getComponentTargets", ex);
                        throw ex;
                    }
                    componentRootDirsSize = componentRootDirs.size();
                } else if (componentRootDirs.size() > 1) {
                    ex = new GdrException("Component which is not replicable has symbol mapped to multiple dirs: " + component + " symbol: " + symbol);
                    _log.throwing(ComponentHelper.class.getName(), "getComponentTargets", ex);
                    throw ex;
                }
            } else if (!mode.isPackagingMode() && !mode.isQueryInstallMode()) {
                ex = new GdrException("The directory map may not be null when building component targets for installation.");
                _log.throwing(ComponentHelper.class.getName(), "getComponentTargets", ex);
                throw ex;
            }
            Set<String> fileMapPlatforms = fileMap.getPlatforms();
            if (fileMapPlatforms != null && !fileMapPlatforms.isEmpty()) {
                boolean found = false;
                for (String string : fileMapPlatforms) {
                    if (!serviceHolder.getPlatformService().containsName(string)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    fileMap.setPackaged(false);
                    continue;
                }
                if (!serviceHolder.getPlatformService().containsAllNames(fileMapPlatforms) && _log.isLoggable(Level.FINE)) {
                    _log.fine("The following file-map was defined for multiple platforms, but we are not building for all the platforms it defines: " + (Object)((Object)fileMap));
                }
            }
            if ((fileMapLocales = fileMap.getLocales()) != null && !fileMapLocales.isEmpty()) {
                boolean found = false;
                for (String locale : fileMapLocales) {
                    if (!serviceHolder.getLocaleService().contains(locale)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    fileMap.setPackaged(false);
                    continue;
                }
            }
            if (mode.isPackagingMode()) {
                if (componentRootDirs == null) {
                    targets.add(new PackagerComponentTarget(baseComponent, component, fileMap, serviceHolder, mode));
                    continue;
                }
                for (Mapping mapping : componentRootDirs) {
                    targets.add(new PackagerComponentTarget(baseComponent, component, fileMap, serviceHolder, mapping, mode));
                }
                continue;
            }
            if (mode.isInstallMode()) {
                if (mode.isQueryInstallMode()) {
                    if (componentRootDirs == null) {
                        componentRootDirs = new ArrayList<Mapping>();
                    }
                    if (componentRootDirs.isEmpty()) {
                        componentRootDirs.add(new Mapping(baseComponent.getNamespace()));
                    }
                }
                for (Mapping mapping : componentRootDirs) {
                    targets.add(new InstallerComponentTarget(baseComponent, fileMap, serviceHolder, mapping));
                }
                continue;
            }
            if (!mode.isDeInstallMode()) continue;
            for (Mapping mapping : componentRootDirs) {
                targets.add(new DeInstallerComponentTarget(baseComponent, fileMap, serviceHolder, mapping, deInstallInfo));
            }
        }
        for (ComponentTarget target : targets) {
            target.setArchiveLocation(component.getArchiveLocationPath());
            target.getSourceFilePath();
        }
        return targets;
    }

    private void adjustComponentSources(Component component) throws GdrException {
        if (component != null && component.hasComponentExtensions()) {
            String source;
            int highestJarNumber = 0;
            List<FileMap> fileMaps = component.getFileMaps();
            if (fileMaps != null && !fileMaps.isEmpty()) {
                for (FileMap fileMap : fileMaps) {
                    int jarNumber;
                    source = fileMap.getSource();
                    if (StringUtil.isNullOrEmpty((String)source, (boolean)true) || (jarNumber = this.getSourceJarNumber(source)) <= highestJarNumber) continue;
                    highestJarNumber = jarNumber;
                }
            }
            fileMaps = new ArrayList<FileMap>();
            for (Component extComponent : component.getComponentExtensions()) {
                List<FileMap> extFileMaps = extComponent.getFileMaps();
                if (extFileMaps == null || extFileMaps.isEmpty()) continue;
                fileMaps.addAll(extFileMaps);
            }
            for (FileMap fileMap : fileMaps) {
                source = fileMap.getSource();
                if (StringUtil.isNullOrEmpty((String)source, (boolean)true)) continue;
                String[] split = source.split("\\d+");
                if (split.length != 2) {
                    GdrException ex = new GdrException("Encountered invalid file-map source attribute format for component " + component);
                    _log.throwing(ComponentHelper.class.getName(), "adjustComponentTargetSources", ex);
                    throw ex;
                }
                fileMap.setSource(split[0] + ++highestJarNumber + split[1]);
            }
        }
    }

    public int getSourceJarNumber(String source) throws GdrException {
        int jarNumber = 0;
        if (!StringUtil.isNullOrEmpty((String)source, (boolean)true)) {
            String[] split = source.split("\\d+");
            try {
                int i = source.length() - (split[0].length() + split[1].length());
                jarNumber = Integer.parseInt(source.substring(split[0].length(), split[0].length() + i));
            }
            catch (Exception e) {
                GdrException ex = new GdrException("Encountered invalid file-map source attribute format " + source, (Throwable)e);
                _log.throwing(ComponentHelper.class.getName(), "getSourceJarNumber", ex);
                throw ex;
            }
        }
        return jarNumber;
    }

    public Map<ComponentReference, List<ComponentReference>> getMatchingComponents(FeatureSet srcFeature, FeatureSet destFeature, Mode mode) {
        ArrayList<Object> srcComponents = new ArrayList<Object>();
        ArrayList<ComponentReference> destComponents = new ArrayList<ComponentReference>();
        List<Components> srcFeatureComponents = srcFeature.getComponents();
        for (Components components : srcFeatureComponents) {
            boolean choice = CHOICE_CONSTRAINT.equals(components.getConstraint());
            List<ComponentReference> list = components.getComponentReferences();
            if (list == null) continue;
            if (choice && list.size() > 1) {
                for (Object ref : list) {
                    if (!ref.isPackaged() && !ref.getStatus().isInstalled()) continue;
                    srcComponents.add(ref);
                }
                continue;
            }
            srcComponents.addAll(list);
        }
        List<Components> destFeatureComponents = destFeature.getComponents();
        for (Components destFeatureComponent : destFeatureComponents) {
            boolean bl = CHOICE_CONSTRAINT.equals(destFeatureComponent.getConstraint());
            List<ComponentReference> refs = destFeatureComponent.getComponentReferences();
            if (refs == null) continue;
            if (bl && refs.size() > 1) {
                for (ComponentReference ref : refs) {
                    if ((!mode.isPackagingMode() || !ref.isPackaged()) && (!mode.isInstallMode() || !ref.getStatus().isInstalled())) continue;
                    destComponents.add(ref);
                }
                continue;
            }
            destComponents.addAll(refs);
        }
        LinkedHashMap<ComponentReference, List<ComponentReference>> linkedHashMap = new LinkedHashMap<ComponentReference, List<ComponentReference>>();
        for (ComponentReference componentReference : srcComponents) {
            for (ComponentReference destRef : destComponents) {
                if (!componentReference.isMatching(destRef)) continue;
                ArrayList<ComponentReference> matching = (ArrayList<ComponentReference>)linkedHashMap.get((Object)componentReference);
                if (matching == null) {
                    matching = new ArrayList<ComponentReference>();
                    linkedHashMap.put(componentReference, matching);
                }
                matching.add(destRef);
            }
        }
        return linkedHashMap;
    }

    public Map<FeatureSetGroup, List<FeatureSet>> getFeatureSetGroupMap(Collection<FeatureSetGroup> featureGroups, Collection<FeatureSet> features) {
        LinkedHashMap<FeatureSetGroup, List<FeatureSet>> featureSetGroupMap = new LinkedHashMap<FeatureSetGroup, List<FeatureSet>>();
        for (FeatureSetGroup group : featureGroups) {
            ArrayList<FeatureSet> groupFeatures = (ArrayList<FeatureSet>)featureSetGroupMap.get((Object)group);
            if (groupFeatures == null) {
                groupFeatures = new ArrayList<FeatureSet>();
                featureSetGroupMap.put(group, groupFeatures);
            }
            List<FeatureSetReference> refs = group.getFeatures();
            for (FeatureSetReference ref : refs) {
                if (ref.isExternal()) {
                    _log.fine("Skipping external feature set " + (Object)((Object)ref));
                    continue;
                }
                FeatureSet feature = null;
                block2: for (FeatureSet f : features) {
                    if (f.matchesReference(ref)) {
                        feature = f;
                        break;
                    }
                    if (!f.isUpgrades()) continue;
                    for (FeatureSet upgrade : f.getUpgrades()) {
                        if (!upgrade.matchesReference(ref)) continue;
                        feature = f;
                        continue block2;
                    }
                }
                if (feature != null) {
                    groupFeatures.add(feature);
                    continue;
                }
                IllegalStateException ex = new IllegalStateException("Missing feature set " + (Object)((Object)ref));
                _log.throwing(FeatureSetHelper.class.getName(), "getFeatureSetGroupMap", ex);
                throw ex;
            }
        }
        return featureSetGroupMap;
    }

    public FeatureSet createFeatureSet(String featureName, String featureVersion, Set<? extends Reference> compRefs) {
        FeatureSet feature = new FeatureSet(featureName, featureVersion);
        ArrayList<ComponentReference> refs = new ArrayList<ComponentReference>();
        for (Reference reference : compRefs) {
            if (reference instanceof ComponentReference) {
                refs.add((ComponentReference)reference);
                continue;
            }
            refs.add(new ComponentReference(reference.getName(), reference.getVersion()));
        }
        feature.setComponentReferences(refs);
        return feature;
    }

    public Set<FeatureSetReference> convertReferences(Set<Reference> references) {
        LinkedHashSet<FeatureSetReference> featureRefs = null;
        if (references != null) {
            featureRefs = new LinkedHashSet<FeatureSetReference>();
            for (Reference ref : references) {
                if (ref instanceof FeatureSetReference) {
                    featureRefs.add((FeatureSetReference)ref);
                    continue;
                }
                featureRefs.add(new FeatureSetReference(ref.getName(), ref.getVersion()));
            }
        }
        return featureRefs;
    }

    public Set<FeatureSet> getSortedByReverseDependencyOrder(Set<FeatureSet> featureSets) {
        FeatureSelectionTarget target = FeatureSelectionTargetFactory.getFeatureSelectionTarget(featureSets, null);
        List ordered = target.getOrderedItems();
        return new LinkedHashSet<FeatureSet>(ordered);
    }

    public Set<FeatureSet> getSortedByDiskOrder(Set<FeatureSet> selectedFeatures, Map<FeatureSet, Collection<Component>> componentMap) {
        HashMap<Integer, ArrayList<FeatureSet>> map = new HashMap<Integer, ArrayList<FeatureSet>>();
        for (FeatureSet feature : selectedFeatures) {
            ArrayList<FeatureSet> features;
            Collection<Component> components = ComponentHelper.getInstance(this.getClassLoader()).getSortedByDiskOrder(componentMap.get(feature));
            int disk = -1;
            if (components != null && !components.isEmpty()) {
                for (Component component : components) {
                    int d = component.getDisk();
                    if (d < 1) {
                        d = 1;
                    }
                    if (disk == -1) {
                        disk = d * 100;
                        continue;
                    }
                    if (d * 100 <= disk) continue;
                    disk += d;
                }
            } else {
                disk = 100;
            }
            if ((features = (ArrayList<FeatureSet>)map.get(disk)) == null) {
                features = new ArrayList<FeatureSet>();
                map.put(disk, features);
            }
            features.add(feature);
        }
        LinkedHashSet<FeatureSet> ordered = new LinkedHashSet<FeatureSet>();
        TreeSet sortedSet = new TreeSet(map.keySet());
        for (Integer i : sortedSet) {
            ordered.addAll((Collection)map.get(i));
        }
        return ordered;
    }

    public List<FeatureSet> getResolvedFeatureDependencies(Set<FeatureSet> featureSets, FeatureSet feature) throws DependencyException, GdrException {
        return this.getResolvedFeatureDependencies(featureSets, null, feature);
    }

    public List<FeatureSet> getResolvedFeatureDependencies(Set<FeatureSet> featureSets, Set<FeatureSet> installedFeatureSets, FeatureSet feature) throws DependencyException, GdrException {
        FeatureSelectionTarget selectionTarget = FeatureSelectionTargetFactory.getFeatureSelectionTarget(featureSets, installedFeatureSets);
        return this.getResolvedFeatureDependencies(selectionTarget, feature);
    }

    public List<FeatureSet> getResolvedFeatureDependencies(FeatureSelectionTarget selectionTarget, FeatureSet feature) throws DependencyException, GdrException {
        if (selectionTarget == null) {
            GdrException ex = new GdrException("The feature selection target provided was null.");
            _log.throwing(FeatureSetHelper.class.getName(), "getResolvedFeatureDependencies", ex);
            throw ex;
        }
        if (feature == null) {
            GdrException ex = new GdrException("The feature provided was null.");
            _log.throwing(FeatureSetHelper.class.getName(), "getResolvedFeatureDependencies", ex);
            throw ex;
        }
        selectionTarget.unselectAll();
        selectionTarget.selectWithPrerequisites(feature, true);
        List selectedFeatures = selectionTarget.getOrderedSelection();
        Collections.reverse(selectedFeatures);
        return selectedFeatures;
    }

    public Set<FeatureSet> getResolvedFeatureSetDependenciesFiltered(FeatureSet featureSet, Set<FeatureSet> dependencyFeatures, Set<FeatureSet> installedFeatureSets, Set<FeatureSet> filterFeatures) throws GdrException {
        List<FeatureSet> featureSetDeps;
        try {
            featureSetDeps = this.getResolvedFeatureDependencies(dependencyFeatures, installedFeatureSets, featureSet);
        }
        catch (DependencyException e) {
            throw new GdrException("Failed to determine dependencies of superseding feature set: " + featureSet, (Throwable)e);
        }
        if (filterFeatures != null) {
            featureSetDeps.removeAll(filterFeatures);
        }
        return new LinkedHashSet<FeatureSet>(featureSetDeps);
    }

    public Map<FeatureSet, LibraryTargetHolder> getLibraryTargets(Set<FeatureSet> featureSets, Home home, Map<FeatureSet, Collection<Component>> componentMap, ServiceHolder serviceHolder, DirectoryMap dirMap) throws DependencyException, IOException, DataHandlerException, GdrException {
        return this.getLibraryTargets(featureSets, null, home, componentMap, serviceHolder, dirMap);
    }

    public Map<FeatureSet, LibraryTargetHolder> getLibraryTargets(Set<FeatureSet> featureSets, Set<FeatureSet> externalDummyFeatureSets, Home home, Map<FeatureSet, Collection<Component>> componentMap, ServiceHolder serviceHolder, DirectoryMap dirMap) throws DependencyException, IOException, DataHandlerException, GdrException {
        LinkedHashMap<FeatureSet, LibraryTargetHolder> libraryTargets = new LinkedHashMap<FeatureSet, LibraryTargetHolder>();
        if (externalDummyFeatureSets != null) {
            Iterator<FeatureSet> it = externalDummyFeatureSets.iterator();
            Set<Home> federatedHomes = home.getChainedFederatedHomes(false);
            while (it.hasNext()) {
                boolean foundFeature = false;
                FeatureSet dummyFeature = it.next();
                for (Home federatedHome : federatedHomes) {
                    federatedHome.disableLazyLoad();
                    if (federatedHome.getInstalledFeature(new Reference(dummyFeature.getName(), dummyFeature.getVersion())) == null) continue;
                    foundFeature = true;
                    break;
                }
                if (foundFeature) continue;
                it.remove();
            }
            featureSets.addAll(externalDummyFeatureSets);
        }
        FeatureSelectionTarget selectionTarget = FeatureSelectionTargetFactory.getFeatureSelectionTarget(featureSets, null);
        List features = selectionTarget.getOrderedItems();
        ArrayList<FeatureSet> installedFeatures = new ArrayList<FeatureSet>();
        if (home != null) {
            installedFeatures.addAll(home.getInstalledFeatures());
        }
        HashMap<Home, FeatureSelectionTarget> federatedHomeSelectionTargets = new HashMap<Home, FeatureSelectionTarget>();
        LinkedHashMap<Home, Map<FeatureSet, LibraryTargetHolder>> federatedLibraryTargets = new LinkedHashMap<Home, Map<FeatureSet, LibraryTargetHolder>>();
        for (FeatureSet feature : features) {
            Collection<Component> components;
            if (feature.isDummy() || libraryTargets.containsKey(feature)) continue;
            LinkedHashSet<LibraryTargetHolder> depTargets = this.getLibraryTargetDependencies(selectionTarget, feature, home, serviceHolder, libraryTargets, dirMap, federatedHomeSelectionTargets, federatedLibraryTargets);
            int index = installedFeatures.indexOf(feature);
            if (componentMap.containsKey(feature) && (feature.hasReplaces() || index < 0 || feature.getStatus().isInstalled())) {
                components = componentMap.get(feature);
                for (Component comp : components) {
                    if (comp.getComponentTargets() != null && !comp.getComponentTargets().isEmpty()) continue;
                    comp.setComponentTargets(this.getComponentTargets(Mode.INSTALL, comp, dirMap, serviceHolder));
                }
            } else {
                FeatureSet installedFeature = index > -1 ? (FeatureSet)installedFeatures.get(index) : feature;
                components = this.getInstalledComponents(installedFeature, home, serviceHolder);
            }
            LibraryTargetHolder target = new LibraryTargetHolder(feature, depTargets, components == null ? null : new LinkedHashSet<Component>(components), dirMap, home);
            libraryTargets.put(feature, target);
        }
        return libraryTargets;
    }

    public Set<FeatureSet> getClonedExternalFeatures(Set<FeatureSet> externalFeatures) throws GdrException {
        HashSet<FeatureSet> externalCopies = new HashSet<FeatureSet>();
        if (externalFeatures != null) {
            for (FeatureSet externalFeature : externalFeatures) {
                externalCopies.add(this.getClonedExternalFeature(externalFeature));
            }
        }
        return externalCopies;
    }

    public FeatureSet getClonedExternalFeature(FeatureSet externalFeature) throws GdrException {
        FeatureSet featureCopy = null;
        if (externalFeature != null) {
            featureCopy = externalFeature.copy();
            featureCopy.setExternal(true);
        }
        return featureCopy;
    }

    private LinkedHashSet<LibraryTargetHolder> getLibraryTargetDependencies(FeatureSelectionTarget selectionTarget, FeatureSet nfeature, Home home, ServiceHolder serviceHolder, Map<FeatureSet, LibraryTargetHolder> libraryTargets, DirectoryMap dirMap, Map<Home, FeatureSelectionTarget> federatedHomeSelectionTargets, Map<Home, Map<FeatureSet, LibraryTargetHolder>> federatedLibraryTargets) throws DependencyException, GdrException, IOException, DataHandlerException {
        Stack<FeatureSet> dependencyStack = new Stack<FeatureSet>();
        dependencyStack.push(nfeature);
        LinkedHashSet<LibraryTargetHolder> depTargets = new LinkedHashSet<LibraryTargetHolder>();
        while (!dependencyStack.isEmpty()) {
            FeatureSet feature = (FeatureSet)dependencyStack.pop();
            selectionTarget.unselectAll();
            selectionTarget.selectWithPrerequisites(feature, true);
            List dependencies = selectionTarget.getSelectedDirectDependencies(feature);
            if (dependencies == null) continue;
            Collections.reverse(dependencies);
            dependencies.remove(feature);
            if (dependencies.isEmpty()) continue;
            ArrayList<FeatureSet> dep = new ArrayList<FeatureSet>();
            for (FeatureSet dependency : dependencies) {
                LibraryTargetHolder target = libraryTargets.get(dependency);
                if (target != null) {
                    depTargets.add(target);
                    continue;
                }
                if (dependency.isDummy()) {
                    LibraryTargetHolder externalLibraryTarget;
                    Home externalHome;
                    Set<DependencyRef> refs = this.getFeatureDependencies(nfeature);
                    DependencyRef dependencyRef = null;
                    for (DependencyRef ref : refs) {
                        if (!ref.getName().equals(dependency.getName())) continue;
                        dependencyRef = ref;
                        break;
                    }
                    if (dependencyRef != null && !dependencyRef.getVersionRanges().isEmpty()) {
                        FeatureSet depFeature = this.getFeatureDependency(dependencyRef, home.getFederatedInstalledFeatures(FederatedRelationship.CHAINED_DEPENDENCY, false));
                        if (depFeature == null) {
                            GdrException ex = new GdrException("Could not locate home which contained external feature set " + dependency);
                            _log.throwing(FeatureSetHelper.class.getName(), "getLibraryTargetDependencies", ex);
                            throw ex;
                        }
                        dependency = depFeature;
                    }
                    if ((externalHome = home.getFeatureSetFederatedHome(dependency, FederatedRelationship.CHAINED_DEPENDENCY)) == null) {
                        GdrException ex = new GdrException("Could not locate home which contained external feature set " + dependency);
                        _log.throwing(FeatureSetHelper.class.getName(), "getLibraryTargetDependencies", ex);
                        throw ex;
                    }
                    Map<FeatureSet, LibraryTargetHolder> externalHomeLibraryTargets = federatedLibraryTargets.get(externalHome);
                    if (externalHomeLibraryTargets == null) {
                        externalHomeLibraryTargets = new LinkedHashMap<FeatureSet, LibraryTargetHolder>();
                        federatedLibraryTargets.put(externalHome, externalHomeLibraryTargets);
                    }
                    if ((externalLibraryTarget = externalHomeLibraryTargets.get(dependency)) == null) {
                        Collection<DistributionTarget> distributionTargets;
                        FeatureSet externalInstalledFeature = this.getClonedExternalFeature(externalHome.getInstalledFeature(new QuickReference(dependency.getName(), dependency.getVersion())));
                        if (externalInstalledFeature == null) {
                            GdrException ex = new GdrException("Could not locate feature set " + dependency + " in federated home " + externalHome.getHomePath());
                            _log.throwing(FeatureSetHelper.class.getName(), "getLibraryTargetDependencies", ex);
                            throw ex;
                        }
                        FeatureSelectionTarget externalHomeTarget = federatedHomeSelectionTargets.get(externalHome);
                        if (externalHomeTarget == null) {
                            Set<FeatureSet> externalHomeFeatures = this.getClonedExternalFeatures(externalHome.getInstalledFeatures());
                            externalHomeFeatures.addAll(HomeHelper.getExternalDummyFeatures(externalHome.getInstalledDistributions()));
                            externalHomeTarget = FeatureSelectionTargetFactory.getFeatureSelectionTarget(externalHomeFeatures, null);
                            federatedHomeSelectionTargets.put(externalHome, externalHomeTarget);
                        }
                        if ((distributionTargets = externalHome.getDistributionTargetsForFeature(externalInstalledFeature)).isEmpty()) {
                            GdrException ex = new GdrException("Could not locate distribution which contained external feature set " + feature + " in home " + externalHome);
                            _log.throwing(FeatureSetHelper.class.getName(), "getLibraryTargetDependencies", ex);
                            throw ex;
                        }
                        DirectoryMap externalDirectoryMap = distributionTargets.iterator().next().getDirectoryMap();
                        LinkedHashSet<LibraryTargetHolder> externalTargetHolders = this.getLibraryTargetDependencies(externalHomeTarget, externalInstalledFeature, externalHome, serviceHolder, externalHomeLibraryTargets, externalDirectoryMap, federatedHomeSelectionTargets, federatedLibraryTargets);
                        Set<Component> components = this.getInstalledComponents(externalInstalledFeature, externalHome, serviceHolder);
                        externalLibraryTarget = new LibraryTargetHolder(externalInstalledFeature, externalTargetHolders, components, externalDirectoryMap, externalHome);
                        externalHomeLibraryTargets.put(externalInstalledFeature, externalLibraryTarget);
                        for (LibraryTargetHolder holder : externalTargetHolders) {
                            externalHomeLibraryTargets.put(holder.getFeature(), holder);
                        }
                    }
                    depTargets.add(externalLibraryTarget);
                    libraryTargets.put(dependency, externalLibraryTarget);
                    continue;
                }
                if (dependency.getStatus().isInstalled()) {
                    dep.add(dependency);
                    Set<Component> components = this.getInstalledComponents(dependency, home, serviceHolder);
                    LinkedHashSet<LibraryTargetHolder> transDeps = this.getLibraryTargetDependencies(selectionTarget, dependency, home, serviceHolder, libraryTargets, dirMap, federatedHomeSelectionTargets, federatedLibraryTargets);
                    target = new LibraryTargetHolder(dependency, transDeps, components, dirMap, home);
                    libraryTargets.put(dependency, target);
                    depTargets.add(target);
                    continue;
                }
                _log.warning("Unable to locate feature dependency " + dependency + " for feature " + feature);
            }
            if (dep.isEmpty()) continue;
            dependencyStack.push(feature);
            for (FeatureSet d : dep) {
                dependencyStack.push(d);
            }
        }
        return depTargets;
    }

    private Set<Component> getInstalledComponents(FeatureSet feature, Home home, ServiceHolder serviceHolder) throws GdrException, IOException, DataHandlerException {
        LinkedHashSet<Component> components = null;
        if (feature.getStatus().isInstalled()) {
            Collection<DistributionTarget> distTargets = home.getDistributionTargetsForFeature(feature);
            if (distTargets == null || distTargets.isEmpty()) {
                throw new GdrException("Unable to locate distribution for installed feature: " + feature);
            }
            Distribution distribution = distTargets.iterator().next().getDistribution();
            components = new LinkedHashSet<Component>();
            List<ComponentReference> compRefs = feature.getComponentReferences();
            if (compRefs != null && !compRefs.isEmpty()) {
                for (ComponentReference ref : compRefs) {
                    if (!ref.getStatus().isInstalled()) continue;
                    Component component = ComponentHelper.getInstance(this.getClassLoader()).getComponentArchiveFromShipHome(home.getInventoryDirectoryPath(), (Reference)ref);
                    component.setComponentTargets(this.getComponentTargets(Mode.INSTALL, component, distribution.getDirectoryMap(), serviceHolder));
                    components.add(component);
                }
            }
        }
        return components;
    }

    public Set<DependencyRef> getFeatureDependencies(FeatureSet feature) {
        Dependency dependency;
        LinkedHashSet<DependencyRef> deps = new LinkedHashSet<DependencyRef>();
        if (feature != null && (dependency = feature.getDependency()) != null) {
            DependencyRef dRef = dependency.getRequires();
            if (dRef != null) {
                deps.add(dRef);
            }
            this.getDependencies(deps, dependency.getAnd());
            this.getDependencies(deps, dependency.getOr());
        }
        return deps;
    }

    private void getDependencies(Collection<DependencyRef> deps, ConditionalOp op) {
        if (deps != null && op != null) {
            List ors;
            List ands;
            List requires = op.getRequires();
            if (requires != null && !requires.isEmpty()) {
                deps.addAll(requires);
            }
            if ((ands = op.getAnd()) != null && !ands.isEmpty()) {
                for (ConditionalOp and : ands) {
                    this.getDependencies(deps, and);
                }
            }
            if ((ors = op.getOr()) != null && !ors.isEmpty()) {
                for (ConditionalOp or : ors) {
                    this.getDependencies(deps, or);
                }
            }
        }
    }

    public FeatureSet getFeatureDependency(DependencyRef ref, Set<FeatureSet> featureSets) throws GdrException, IOException, DataHandlerException {
        FeatureSet depFeature = null;
        if (ref != null) {
            List ranges;
            LinkedHashSet<FeatureSet> upgradesAndReplaces;
            String name = ref.getName();
            boolean versionSet = ref.isSetVersion();
            if (versionSet) {
                String version = ref.getVersion();
                for (FeatureSet f : featureSets) {
                    if (name.equals(f.getName())) {
                        if (version.equals(f.getVersion())) {
                            depFeature = f;
                        } else if ((f.hasReplaces() || f.isUpgrades()) && f.isSingleton()) {
                            upgradesAndReplaces = new LinkedHashSet<FeatureSet>();
                            if (f.hasReplaces()) {
                                upgradesAndReplaces.addAll(f.getReplaces());
                            }
                            if (f.isUpgrades()) {
                                upgradesAndReplaces.addAll(f.getUpgrades());
                            }
                            for (FeatureSet oldFeature : upgradesAndReplaces) {
                                if (!version.equals(oldFeature.getVersion())) continue;
                                depFeature = f;
                                break;
                            }
                        }
                    }
                    if (depFeature == null) continue;
                    break;
                }
            }
            if (depFeature == null && (ranges = ref.getVersionRanges()) != null && !ranges.isEmpty()) {
                for (FeatureSet f : featureSets) {
                    if (name.equals(f.getName())) {
                        if (VersionHelper.isVersionWithinRanges((com.oracle.cie.common.Version)new com.oracle.cie.common.Version(f.getVersion()), (List)ranges)) {
                            depFeature = f;
                        } else if ((f.hasReplaces() || f.isUpgrades()) && f.isSingleton()) {
                            upgradesAndReplaces = new LinkedHashSet();
                            if (f.hasReplaces()) {
                                upgradesAndReplaces.addAll(f.getReplaces());
                            }
                            if (f.isUpgrades()) {
                                upgradesAndReplaces.addAll(f.getUpgrades());
                            }
                            for (FeatureSet oldFeature : upgradesAndReplaces) {
                                if (!VersionHelper.isVersionWithinRanges((com.oracle.cie.common.Version)new com.oracle.cie.common.Version(oldFeature.getVersion()), (List)ranges)) continue;
                                depFeature = f;
                                break;
                            }
                        }
                    }
                    if (depFeature == null) continue;
                    break;
                }
            }
            if (!versionSet && depFeature == null) {
                GdrException ex = new GdrException("Unable to deterministically resolve feature dependency for \"" + ref + "\". The version of the feature referenced may need to be explicitly defined in the distribution definition or feature set.");
                _log.throwing(FeatureSetHelper.class.getName(), "getFeatureDependency", ex);
                throw ex;
            }
        }
        return depFeature;
    }

    public void validateFeatureInclude(Set<FeatureSet> featureSets, Set<Component> components) throws GdrException {
        for (FeatureSet feature : featureSets) {
            for (FeatureLibrary featLibrary : feature.getLibraries()) {
                HashSet<FeatureSet> cycleCheck = new HashSet<FeatureSet>();
                HashMap<String, TreeSet<String>> featureIncludes = this.getLibraryDependency(featLibrary, feature, featureSets, components, cycleCheck);
                ArrayList<FeatureLibraryInclude> cleanLibraryIncludes = new ArrayList<FeatureLibraryInclude>();
                for (FeatureLibraryInclude libraryInclude : featLibrary.getIncludes()) {
                    boolean isValid = false;
                    TreeSet<String> validVersions = featureIncludes.get(libraryInclude.getName());
                    String msg = "Unable to locate feature library include named: \"" + libraryInclude.getName() + " " + (libraryInclude.getVersion() != null ? libraryInclude.getVersion() : "") + "\" in library \"" + (Object)((Object)featLibrary) + "\" in featureset \"" + feature + "\". ";
                    if (validVersions != null) {
                        for (String version : validVersions) {
                            if (StringUtil.isNullOrEmpty((String)libraryInclude.getVersion())) {
                                isValid = true;
                                break;
                            }
                            if (!version.startsWith(libraryInclude.getVersion()) && !libraryInclude.getVersion().startsWith(version)) continue;
                            isValid = true;
                            break;
                        }
                        if (!isValid) {
                            msg = msg + "Invalid versions for " + libraryInclude.getName() + ", available versions are: " + validVersions + ".";
                        }
                    }
                    if (!isValid) {
                        if (libraryInclude.isOptional().booleanValue() || libraryInclude.isGlobal().booleanValue()) continue;
                        _log.warning(msg);
                        continue;
                    }
                    _log.finest("Correctly validated feature library include:" + libraryInclude.getName() + libraryInclude.getVersion() + " in library " + (Object)((Object)featLibrary));
                    cleanLibraryIncludes.add(libraryInclude);
                }
                if (!cleanLibraryIncludes.isEmpty()) {
                    _log.fine("Validated feature library :" + featLibrary.getName() + featLibrary.getVersion() + " in featureset " + feature);
                    continue;
                }
                _log.warning("Library " + (Object)((Object)featLibrary) + " does not contain any valid library includes.");
            }
        }
    }

    public void validateLibraryLocations(Set<FeatureSet> featureSets, Set<Component> components, DirectoryMap dirMap, Mode mode) throws GdrException {
        try {
            String productHome;
            LibraryType type;
            HashMap<Component, String> componentHomes = new HashMap<Component, String>();
            HashMap<FeatureSet, String> featureSetHomes = new HashMap<FeatureSet, String>();
            HashSet<String> libraryLocations = new HashSet<String>();
            for (Component component : components) {
                if (component.getGdrVersion() == null) {
                    ComponentHelper.getInstance(this.getClassLoader()).expandLibrary(component);
                    component.setGdrVersion(Version.getVersion());
                }
                for (Library library : component.getLibraries()) {
                    type = LibraryType.getLibraryType(library.getType());
                    productHome = "";
                    LibraryTarget target = new LibraryTarget(component, library, dirMap, null);
                    productHome = target.getProductHome(mode);
                    if (StringUtil.isNullOrEmpty((String)productHome) && !type.isNone() && !library.getVisibility().equals("none")) {
                        GdrException ex = new GdrException("Could not calculate product home for library " + (Object)((Object)library) + " in component " + component + ". Please use a valid symbol.");
                        _log.throwing(FeatureSetHelper.class.getName(), "validateLibraryLocations", ex);
                        throw ex;
                    }
                    if (!componentHomes.containsKey(component) && !StringUtil.isNullOrEmpty((String)productHome)) {
                        componentHomes.put(component, productHome);
                    }
                    if (type.isNone() || library.getVisibility().equals("none")) continue;
                    JarLibraryHandler libHandler = (JarLibraryHandler)type.getHandler();
                    for (String libLocation : libHandler.getComponentJarLocations(library, component)) {
                        libLocation = productHome + File.separator + libLocation;
                        if (!libraryLocations.contains(libLocation)) {
                            libraryLocations.add(libLocation);
                            continue;
                        }
                        GdrException ex = new GdrException("Library " + library.getName() + " from component " + component + " conflicts with another library at location " + libLocation);
                        _log.throwing(FeatureSetHelper.class.getName(), "validateLibraryLocations", ex);
                        throw ex;
                    }
                }
            }
            for (FeatureSet feature : featureSets) {
                for (FeatureLibrary featureLibrary : feature.getLibraries()) {
                    type = LibraryType.getLibraryType(featureLibrary.getType());
                    productHome = "";
                    productHome = !StringUtil.isNullOrEmpty((String)featureLibrary.getSymbol()) ? DistributionHelper.getInstance(this.getClassLoader()).getRootDirsForSymbol(dirMap, featureLibrary.getSymbol()).iterator().next() : this.calculateFeatureLibHome(feature, featureSets, componentHomes, featureSetHomes);
                    if (StringUtil.isNullOrEmpty((String)productHome)) {
                        GdrException ex = new GdrException("Could not calculate product home for library " + (Object)((Object)featureLibrary) + " in featureset " + feature + ". Please use a valid symbol.");
                        _log.throwing(FeatureSetHelper.class.getName(), "validateLibraryLocations", ex);
                        throw ex;
                    }
                    if (productHome.startsWith("dummy-")) {
                        _log.warning("Could not calculate product home for library " + (Object)((Object)featureLibrary) + " in featureset " + feature + " due to this feature only depending on external feature sets. To avoid this warning please define an explicit symbol for this library.");
                    }
                    if (!featureSetHomes.containsKey(feature) && !StringUtil.isNullOrEmpty((String)productHome)) {
                        featureSetHomes.put(feature, productHome);
                    }
                    JarLibraryHandler libHandler = (JarLibraryHandler)type.getHandler();
                    for (String libLocation : libHandler.getFeaturesetJarLocations(featureLibrary, feature)) {
                        libLocation = productHome + File.separator + libLocation;
                        if (!libraryLocations.contains(libLocation)) {
                            libraryLocations.add(libLocation);
                            continue;
                        }
                        GdrException ex = new GdrException("Library " + featureLibrary.getName() + " from FeatureSet " + feature + " conflicts with another library at location " + libLocation);
                        _log.throwing(FeatureSetHelper.class.getName(), "validateLibraryLocations", ex);
                        throw ex;
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
            GdrException ex = new GdrException((Throwable)e);
            _log.throwing(FeatureSetHelper.class.getName(), "validateLibraryLocations", ex);
            throw ex;
        }
        catch (NoSuchMethodException e) {
            GdrException ex = new GdrException((Throwable)e);
            _log.throwing(FeatureSetHelper.class.getName(), "validateLibraryLocations", ex);
            throw ex;
        }
        catch (InvocationTargetException e) {
            GdrException ex = new GdrException((Throwable)e);
            _log.throwing(FeatureSetHelper.class.getName(), "validateLibraryLocations", ex);
            throw ex;
        }
        catch (IllegalAccessException e) {
            GdrException ex = new GdrException((Throwable)e);
            _log.throwing(FeatureSetHelper.class.getName(), "validateLibraryLocations", ex);
            throw ex;
        }
        catch (InstantiationException e) {
            GdrException ex = new GdrException((Throwable)e);
            _log.throwing(FeatureSetHelper.class.getName(), "validateLibraryLocations", ex);
            throw ex;
        }
        catch (IOException e) {
            GdrException ex = new GdrException((Throwable)e);
            _log.throwing(FeatureSetHelper.class.getName(), "validateLibraryLocations", ex);
            throw ex;
        }
        catch (DataHandlerException e) {
            GdrException ex = new GdrException((Throwable)e);
            _log.throwing(FeatureSetHelper.class.getName(), "validateLibraryLocations", ex);
            throw ex;
        }
    }

    private String calculateFeatureLibHome(FeatureSet feature, Set<FeatureSet> featureSets, Map<Component, String> componentHomes, Map<FeatureSet, String> featureSetHomes) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException, LibraryHandlerException, GdrException, IOException, DataHandlerException {
        if (featureSetHomes.containsKey(feature)) {
            return featureSetHomes.get(feature);
        }
        String productHome = null;
        if (feature.isDummy()) {
            productHome = "dummy-" + feature.getName() + "-" + feature.getVersion();
        } else {
            for (ComponentReference compRef : feature.getComponentReferences()) {
                Component comp = ComponentHelper.getInstance(this.getClassLoader()).getComponent(componentHomes.keySet(), compRef);
                if (!componentHomes.containsKey(comp)) continue;
                productHome = componentHomes.get(comp);
            }
            if (productHome == null) {
                for (DependencyRef ref : this.getFeatureDependencies(feature)) {
                    FeatureSet depFeature = this.getFeatureDependency(ref, featureSets);
                    if (depFeature == null) {
                        GdrException ex = new GdrException("Could not locate feature dependency " + ref + " that the featureset " + feature + " depends on.");
                        _log.throwing(FeatureSetHelper.class.getName(), "calculateFeatureLibHome", ex);
                        throw ex;
                    }
                    productHome = this.calculateFeatureLibHome(depFeature, featureSets, componentHomes, featureSetHomes);
                    if (StringUtil.isNullOrEmpty((String)productHome) || productHome.startsWith("dummy-")) continue;
                    break;
                }
            }
        }
        return productHome;
    }

    public void setFeatureLibrariesSize(Set<FeatureSet> featureSets, Set<Component> components) throws GdrException {
        for (FeatureSet feature : featureSets) {
            for (FeatureLibrary featLibrary : feature.getLibraries()) {
                if (LibraryType.getLibraryType(featLibrary.getType()).isManifest()) continue;
                HashSet<FeatureSet> cycleCheck = new HashSet<FeatureSet>();
                HashMap<String, HashMap<String, Long>> libraries = new HashMap<String, HashMap<String, Long>>();
                libraries = this.getLibraryDependencySize(featLibrary, feature, featureSets, components, cycleCheck, libraries);
                long size = 0L;
                for (FeatureLibraryInclude include : featLibrary.getIncludes()) {
                    HashMap<String, Long> versions;
                    String libVersion = include.getVersion() == null && ComponentHelper.getShortenedVersion(feature.getVersion()) != null ? ComponentHelper.getShortenedVersion(feature.getVersion()) : include.getVersion();
                    if (!libraries.containsKey(include.getName()) || (versions = libraries.get(include.getName())).get(libVersion) == null) continue;
                    size += versions.get(libVersion).longValue();
                }
                if (LibraryType.getLibraryType(featLibrary.getType()) == LibraryType.none || LibraryVisibility.getLibraryVisibility(featLibrary.getVisibility()) == LibraryVisibility.none) continue;
                featLibrary.setSize(size);
            }
        }
    }

    public long getFeatureLibrariesSize(FeatureSet feature) {
        long size = 0L;
        for (FeatureLibrary fLib : feature.getLibraries()) {
            Set<String> locations = fLib.getLocation();
            if (locations.isEmpty()) {
                size += fLib.getSize();
                continue;
            }
            size += fLib.getSize() * (long)locations.size();
        }
        return size;
    }

    private HashMap<String, TreeSet<String>> getLibraryDependency(FeatureLibrary featLibrary, FeatureSet feature, Set<FeatureSet> featureSets, Set<Component> components, Set<FeatureSet> cycleCheck) throws GdrException {
        HashMap<String, TreeSet<String>> featureIncludes = new HashMap<String, TreeSet<String>>();
        cycleCheck.add(feature);
        for (ComponentReference compRef : feature.getComponentReferences()) {
            Component component = ComponentHelper.getInstance(this.getClassLoader()).getComponent(components, compRef);
            if (component == null) continue;
            for (Library compLibrary : component.getLibraries()) {
                TreeSet<String> versions = featureIncludes.get(compLibrary.getName());
                if (versions == null) {
                    versions = new TreeSet();
                }
                if (compLibrary.getVersion() == null) {
                    versions.add(ComponentHelper.getShortenedVersion(component.getVersion()));
                } else {
                    versions.add(compLibrary.getVersion());
                }
                if (!featLibrary.getType().equals(compLibrary.getType()) && !LibraryType.getLibraryType(compLibrary.getType()).isNone()) continue;
                featureIncludes.put(compLibrary.getName(), versions);
            }
        }
        for (FeatureLibrary fLib : feature.getLibraries()) {
            TreeSet<String> versions = (TreeSet<String>)featureIncludes.get(fLib.getName());
            if (versions == null) {
                versions = new TreeSet<String>();
            }
            String version = fLib.getVersion() == null ? ComponentHelper.getShortenedVersion(feature.getVersion()) : fLib.getVersion();
            if (featLibrary.equals((Object)fLib) || !featLibrary.getType().equals(fLib.getType())) continue;
            versions.add(version);
            featureIncludes.put(fLib.getName(), versions);
        }
        Set<DependencyRef> dependencyRefs = this.getFeatureDependencies(feature);
        if (dependencyRefs != null && !dependencyRefs.isEmpty()) {
            for (DependencyRef depRef : dependencyRefs) {
                try {
                    FeatureSet dep = this.getFeatureDependency(depRef, featureSets);
                    if (dep == null || cycleCheck.contains(dep)) continue;
                    featureIncludes.putAll(this.getLibraryDependency(featLibrary, dep, featureSets, components, cycleCheck));
                }
                catch (IOException e) {
                    throw new GdrException((Throwable)e);
                }
                catch (DataHandlerException e) {
                    throw new GdrException((Throwable)e);
                }
            }
        }
        return featureIncludes;
    }

    private HashMap<String, HashMap<String, Long>> getLibraryDependencySize(FeatureLibrary featLibrary, FeatureSet feature, Set<FeatureSet> featureSets, Set<Component> components, Set<FeatureSet> cycleCheck, HashMap<String, HashMap<String, Long>> libraries) throws GdrException {
        cycleCheck.add(feature);
        for (ComponentReference compRef : feature.getComponentReferences()) {
            Component component = ComponentHelper.getInstance(this.getClassLoader()).getComponent(components, compRef);
            if (component == null) continue;
            for (Library compLibrary : component.getLibraries()) {
                HashMap<String, Long> versions = libraries.get(compLibrary.getName());
                String version = null;
                if (versions == null) {
                    versions = new HashMap();
                }
                if (versions.get(version = compLibrary.getVersion() == null ? ComponentHelper.getShortenedVersion(component.getVersion()) : compLibrary.getVersion()) == null) {
                    versions.put(version, compLibrary.getSize());
                } else if (compLibrary.getSize() > versions.get(version)) {
                    versions.put(version, compLibrary.getSize());
                }
                if (!featLibrary.getType().equals(compLibrary.getType()) && !LibraryType.getLibraryType(compLibrary.getType()).isNone() && !compLibrary.getVisibility().equals("none")) continue;
                libraries.put(compLibrary.getName(), versions);
            }
        }
        for (FeatureLibrary fLib : feature.getLibraries()) {
            HashMap<String, Long> versions = libraries.get(fLib.getName());
            if (versions == null) {
                versions = new HashMap();
            }
            String version = fLib.getVersion() == null ? ComponentHelper.getShortenedVersion(feature.getVersion()) : fLib.getVersion();
            if (featLibrary.equals((Object)fLib) || !featLibrary.getType().equals(fLib.getType())) continue;
            versions.put(version, fLib.getSize());
            libraries.put(fLib.getName(), versions);
        }
        Set<DependencyRef> dependencyRefs = this.getFeatureDependencies(feature);
        if (dependencyRefs != null && !dependencyRefs.isEmpty()) {
            for (DependencyRef depRef : dependencyRefs) {
                try {
                    FeatureSet dep = this.getFeatureDependency(depRef, featureSets);
                    if (dep == null || cycleCheck.contains(dep)) continue;
                    libraries.putAll(this.getLibraryDependencySize(featLibrary, dep, featureSets, components, cycleCheck, libraries));
                }
                catch (DataHandlerException | IOException e) {
                    throw new GdrException(e);
                }
            }
        }
        return libraries;
    }

    public Set<String> findUnusedSymbols(Set<FeatureSet> featureSets, DirectoryMap directoryMap, Map<FeatureSet, Collection<Component>> componentsMap) {
        LinkedHashMap<MappingSymbol, String> symbolsMap = new LinkedHashMap<MappingSymbol, String>();
        for (Mapping mapping : directoryMap.getMappings()) {
            List<MappingSymbol> symbols = mapping.getMappingSymbols();
            for (MappingSymbol mappingSymbol : symbols) {
                symbolsMap.put(mappingSymbol, mappingSymbol.getSymbol());
            }
        }
        for (FeatureSet featureSet : featureSets) {
            Collection<Component> components = componentsMap.get(featureSet);
            if (components == null) continue;
            for (Component comp : components) {
                Collection<ComponentTarget> targets = comp.getComponentTargets();
                block4: for (ComponentTarget target : targets) {
                    for (MappingSymbol mappingSymbol : symbolsMap.keySet()) {
                        if (!mappingSymbol.matches(target.getSymbol())) continue;
                        symbolsMap.remove(mappingSymbol);
                        continue block4;
                    }
                }
            }
        }
        HashSet<String> symbolsList = new HashSet<String>(symbolsMap.values());
        for (String symbol : symbolsList) {
            _log.log(Level.WARNING, "Install symbol " + symbol + " in distribution is not referenced by any component.");
        }
        return symbolsList;
    }

    public Components createFeatureSetComponents(Collection<Reference> componentReferences, boolean choice) {
        Components components = new Components();
        if (componentReferences != null && !componentReferences.isEmpty()) {
            ArrayList<ComponentReference> compRefs = new ArrayList<ComponentReference>();
            for (Reference reference : componentReferences) {
                ComponentReference ref = reference instanceof ComponentReference ? (ComponentReference)reference : new ComponentReference(reference.getName(), reference.getVersion());
                compRefs.add(ref);
            }
            components.setComponentReferences(compRefs);
        }
        if (choice) {
            components.setConstraint(CHOICE_CONSTRAINT);
        }
        return components;
    }

    public List<FeatureSet> swapSupersededFeatureSets(Collection<FeatureSet> featureSets) {
        ArrayList<FeatureSet> swapped = new ArrayList<FeatureSet>();
        if (featureSets != null && !featureSets.isEmpty()) {
            for (FeatureSet featureSet : featureSets) {
                if (featureSet.isSuperseded()) {
                    swapped.add(featureSet.getSuperseded());
                    continue;
                }
                swapped.add(featureSet);
            }
            for (FeatureSet featureSet : featureSets) {
                if (!featureSet.hasReplaces()) continue;
                swapped.removeAll(featureSet.getReplaces());
            }
        }
        return swapped;
    }

    public List<FeatureSet> swapUpgradedFeatureSets(Collection<FeatureSet> featureSets) {
        ArrayList<FeatureSet> swapped = new ArrayList<FeatureSet>();
        if (featureSets != null && !featureSets.isEmpty()) {
            for (FeatureSet featureSet : featureSets) {
                if (featureSet.isUpgrades()) {
                    swapped.addAll(featureSet.getUpgrades());
                    continue;
                }
                swapped.add(featureSet);
            }
        }
        return swapped;
    }

    public long getRequiredSpace(Home home, Set<FeatureSet> selectedFeatures, Set<Component> selectedComponents) {
        long size = 0L;
        try {
            this.setFeatureLibrariesSize(selectedFeatures, selectedComponents);
        }
        catch (GdrException gdrException) {
            // empty catch block
        }
        if (selectedFeatures != null && !selectedFeatures.isEmpty()) {
            Set<FeatureSet> installedFeatures = home.getInstalledFeatures();
            for (FeatureSet feature : selectedFeatures) {
                String name = feature.getName();
                String version = feature.getVersion();
                boolean installed = false;
                for (FeatureSet existing : installedFeatures) {
                    if (!existing.getName().equals(name) || !existing.getVersion().equals(version)) continue;
                    installed = true;
                    break;
                }
                if (installed) continue;
                List<FeatureLibrary> libraries = feature.getLibraries();
                for (FeatureLibrary library : libraries) {
                    size += library.getSize();
                }
            }
        }
        return size;
    }

    public Collection<FeatureSet> getUpgradeInstalledFesturesToRemove(Collection<FeatureSet> features, Collection<FeatureSet> installedFeatures) {
        boolean installed = false;
        HashSet<FeatureSet> featuresToRemove = new HashSet<FeatureSet>();
        if (features != null) {
            for (FeatureSet featureSet : features) {
                if (!featureSet.isUpgradeInstalled()) continue;
                if (installedFeatures != null) {
                    for (FeatureSet installedFeature : installedFeatures) {
                        if (!featureSet.getName().equals(installedFeature.getName())) continue;
                        installed = true;
                    }
                }
                if (installed) continue;
                featuresToRemove.add(featureSet);
            }
        }
        return featuresToRemove;
    }

    public List<ComponentReference> getMatchingComponentRefs(String name, Set<ComponentReference> componentReferences) {
        return this.getMatchingComponentRefs(name, null, componentReferences);
    }

    public List<ComponentReference> getMatchingComponentRefs(String name, String version, Set<ComponentReference> componentReferences) {
        ArrayList<ComponentReference> matches = new ArrayList<ComponentReference>();
        if (name != null && componentReferences != null) {
            for (ComponentReference comp : componentReferences) {
                if (!name.equals(comp.getName()) || !StringUtil.isNullOrEmpty((String)version, (boolean)true) && !version.equals(comp.getVersion())) continue;
                matches.add(comp);
            }
        }
        return matches;
    }
}

