/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.generation;

import com.oracle.cie.gdr.generation.GenerationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum GenerationProperty {
    GENERIC_NAME("Name", GenerationType.GENERIC),
    GENERIC_VERSION("Version", GenerationType.GENERIC),
    COMPONENT_SYMBOL("Symbol", GenerationType.COMPONENT),
    COMPONENT_PAYLOAD("Payload", GenerationType.COMPONENT),
    COMPONENT_SINGLETON("Singleton", GenerationType.COMPONENT),
    COMPONENT_POMGEN("Pom-Gen", GenerationType.COMPONENT),
    COMPONENT_BOOTSTRAP("Bootstrap", GenerationType.COMPONENT),
    COMPONENT_REPLICABLE("Replicable", GenerationType.COMPONENT),
    COMPONENT_LIBRARY_NAME("Library-name", GenerationType.COMPONENT),
    COMPONENT_LIBRARY_TYPE("Library-Type", GenerationType.COMPONENT),
    COMPONENT_LIBRARY_ENTRIES("Library-Entries", GenerationType.COMPONENT),
    COMPONENT_DESCRIPTION("Description", GenerationType.COMPONENT),
    COMPONENT_DESCRIPTION_KEY("Description-Key", GenerationType.COMPONENT),
    COMPONENT_VARIABLES("Variables", GenerationType.COMPONENT),
    COMPONENT_PLATFORMS("Platforms", GenerationType.COMPONENT),
    COMPONENT_LOCALES("Locales", GenerationType.COMPONENT),
    COMPONENT_STRINGSUBS_FILES("Stringsubs-Files", GenerationType.COMPONENT),
    COMPONENT_STRINGSUBS_CHANGE_PAIRS("Stringsubs-Change-Pairs", GenerationType.COMPONENT),
    FEATURESET_DISPLAY_NAME("Display-Name", GenerationType.FEATURESET),
    FEATURESET_DISPLAT_NAME_KEY("Display-Name-Key", GenerationType.FEATURESET),
    FEATURESET_DESCRIPTION("Description", GenerationType.FEATURESET),
    FEATURESET_lIBRARY_NAME("Library-Name", GenerationType.FEATURESET),
    FEATURESET_LIBRARY_TYPE("Library-Type", GenerationType.FEATURESET),
    FEATURESET_lIBRARY_INCLUDES("Library-Includes", GenerationType.FEATURESET),
    FEATURESET_LIBRARY_LOCATION("Library-Location", GenerationType.FEATURESET),
    FEATURESET_LIBRARY_VISIBILITY("Library-Visibility", GenerationType.FEATURESET),
    FEATURESET_LIBRARY_SUPRESS_VERSION("Library-Suppress-Version", GenerationType.FEATURESET),
    FEATURESET_LIBRARY_SUPPRESS_PREFIX("Library-Suppress-Prefix", GenerationType.FEATURESET),
    FEATURESET_LIBRARY_IGNORE_VERSION("Library-Ignore-Version", GenerationType.FEATURESET),
    FEATURESET_MULTI_VERSION("Multi-Version", GenerationType.FEATURESET),
    FEATURESET_CONSUMPTION_TYPE("Consumption-Type", GenerationType.FEATURESET),
    FEATURESET_THIRD_PARTY("Third-Party", GenerationType.FEATURESET),
    FEATURESET_TYPE("Type", GenerationType.FEATURESET),
    FEATURESET_SUB_TYPE("Sub-Type", GenerationType.FEATURESET),
    FEATURESET_SINGLETON("Singleton", GenerationType.FEATURESET),
    FEATURESET_POMGEN("Pom-Gen", GenerationType.FEATURESET),
    FEATURESET_DEPENDENCIES("Dependencies", GenerationType.FEATURESET),
    FEATURESET_DESCRIPTION_KEY("Description-Key", GenerationType.FEATURESET),
    FEATURESET_COMPONENTS("Components", GenerationType.FEATURESET),
    DISTRIBUTION_INFO_GENERATE_DEFAULT_ORAPARAM("Generate-Default-Oraparam", GenerationType.DISTRIBUTION_INFO),
    DISTRIBUTION_INFO_PLATFORMS("Platforms", GenerationType.DISTRIBUTION_INFO),
    DISTRIBUTION_INFO_SECTIONS("Sections", GenerationType.DISTRIBUTION_INFO),
    DISTRIBUTION_INFO_SECTION("Section", GenerationType.DISTRIBUTION_INFO),
    DISTRIBUTION_INFO_SECTION_ADD("Section-Add", GenerationType.DISTRIBUTION_INFO),
    DISTRIBUTION_INFO_PRODUCT_FAMILIES("Product-Families", GenerationType.DISTRIBUTION_INFO),
    DISTRIBUTION_INFO_SHIPHOME_PROPERTIES("Shiphome-Properties", GenerationType.DISTRIBUTION_INFO),
    DISTRIBUTION_EXTERNAL_NAME("External-Name", GenerationType.DISTRIBUTION),
    DISTRIBUTION_EXTERNAL_NAME_KEY("External-Name-Key", GenerationType.DISTRIBUTION),
    DISTRIBUTION_EXTERNAL_SHORT_NAME("External-Short-Name", GenerationType.DISTRIBUTION),
    DISTRIBUTION_EXTERNAL_SHORT_NAME_KEY("External-Short-Name-Key", GenerationType.DISTRIBUTION),
    DISTRIBUTION_DESCRIPTION_KEY("Description-Key", GenerationType.DISTRIBUTION),
    DISTRIBUTION_FEATURESET_GROUPS("Feature-Set-Groups", GenerationType.DISTRIBUTION),
    DISTRIBUTION_DIRECTORY_MAPPINGS("Directory-Mappings", GenerationType.DISTRIBUTION),
    DISTRIBUTION_MAPPING_ROOT("Root-Mapping", GenerationType.DISTRIBUTION),
    DISTRIBUTION_INTERNAL_FEATURESET_GROUP_FEATURES("Internal-FeatureSet-Group-Features", GenerationType.DISTRIBUTION),
    DISTRIBUTION_INTERNAL_DIRECTORY_MAPPINGS("Internal-Directory-Mappings", GenerationType.DISTRIBUTION),
    DISTRIBUTION_EXTERNAL_VERSION("External-Version", GenerationType.DISTRIBUTION);

    private static Map<String, GenerationProperty> _distributionProperties;
    private static Map<String, GenerationProperty> _componentProperties;
    private static Map<String, GenerationProperty> _distributionInfoProperties;
    private static Map<String, GenerationProperty> _featureSetProperties;
    private String name;
    private GenerationType type;

    private GenerationProperty(String name, GenerationType type) {
        this.name = name;
        this.type = type;
    }

    public GenerationType getGenerationType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public static GenerationProperty getGenerationProperty(String propertyName, GenerationType type) {
        GenerationProperty generationProperty = null;
        switch (type) {
            case COMPONENT: {
                generationProperty = GenerationProperty.getGenerationProperty(_componentProperties, propertyName);
                break;
            }
            case FEATURESET: {
                generationProperty = GenerationProperty.getGenerationProperty(_featureSetProperties, propertyName);
                break;
            }
            case DISTRIBUTION_INFO: {
                generationProperty = GenerationProperty.getGenerationProperty(_distributionInfoProperties, propertyName);
                break;
            }
            case DISTRIBUTION: {
                generationProperty = GenerationProperty.getGenerationProperty(_distributionProperties, propertyName);
                break;
            }
        }
        if (generationProperty == null) {
            new IllegalArgumentException("The generation type provided is not supported: " + (Object)((Object)type));
        }
        return generationProperty;
    }

    private static GenerationProperty getGenerationProperty(Map<String, GenerationProperty> properties, String property) {
        if (!properties.containsKey(property.toLowerCase())) {
            throw new IllegalArgumentException("The generation property is not supported: " + property);
        }
        return properties.get(property.toLowerCase());
    }

    public static List<GenerationProperty> values(GenerationType type) {
        ArrayList<GenerationProperty> properties = null;
        switch (type) {
            case COMPONENT: {
                properties = new ArrayList<GenerationProperty>(_componentProperties.values());
                break;
            }
            case FEATURESET: {
                properties = new ArrayList<GenerationProperty>(_featureSetProperties.values());
                break;
            }
            case DISTRIBUTION_INFO: {
                properties = new ArrayList<GenerationProperty>(_distributionInfoProperties.values());
                break;
            }
            case DISTRIBUTION: {
                properties = new ArrayList<GenerationProperty>(_distributionProperties.values());
                break;
            }
        }
        if (properties == null) {
            new IllegalArgumentException("The generation type provided is not supported: " + (Object)((Object)type));
        }
        return properties;
    }

    static {
        _distributionProperties = new HashMap<String, GenerationProperty>();
        _componentProperties = new HashMap<String, GenerationProperty>();
        _distributionInfoProperties = new HashMap<String, GenerationProperty>();
        _featureSetProperties = new HashMap<String, GenerationProperty>();
        block7: for (GenerationProperty propety : GenerationProperty.values()) {
            switch (propety.getGenerationType()) {
                case COMPONENT: {
                    _componentProperties.put(propety.getName().toLowerCase(), propety);
                    continue block7;
                }
                case FEATURESET: {
                    _featureSetProperties.put(propety.getName().toLowerCase(), propety);
                    continue block7;
                }
                case DISTRIBUTION_INFO: {
                    _distributionInfoProperties.put(propety.getName().toLowerCase(), propety);
                    continue block7;
                }
                case DISTRIBUTION: {
                    _distributionProperties.put(propety.getName().toLowerCase(), propety);
                    continue block7;
                }
                case GENERIC: {
                    _componentProperties.put(propety.getName().toLowerCase(), propety);
                    _featureSetProperties.put(propety.getName().toLowerCase(), propety);
                    _distributionInfoProperties.put(propety.getName().toLowerCase(), propety);
                    _distributionProperties.put(propety.getName().toLowerCase(), propety);
                    continue block7;
                }
                default: {
                    new IllegalArgumentException("The generation type provided is not supported: " + (Object)((Object)propety));
                }
            }
        }
    }
}

