/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.generation;

import com.oracle.cie.gdr.external.builder.BuilderException;
import com.oracle.cie.gdr.external.builder.BuilderReference;
import com.oracle.cie.gdr.external.builder.FeatureLibraryIncludeBuilder;
import com.oracle.cie.gdr.external.builder.impl.BuilderReferenceImpl;
import com.oracle.cie.gdr.external.builder.impl.FeatureLibraryIncludeBuilderImpl;
import com.oracle.cie.gdr.generation.GenerationConfig;
import com.oracle.cie.gdr.generation.GenerationProperty;
import com.oracle.cie.gdr.generation.GenerationType;
import com.oracle.cie.gdr.libraries.LibraryType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FeatureSetGenerationConfig
extends GenerationConfig {
    private List<BuilderReference> _dependencies;
    private List<FeatureLibraryIncludeBuilder> _libraryIncludes;
    private List<BuilderReference> _components;

    public FeatureSetGenerationConfig(String defaultName, Map<String, String> props) throws BuilderException {
        super(defaultName, props);
        if (this._dependencies == null) {
            this._dependencies = new ArrayList<BuilderReference>();
        }
        if (this._libraryIncludes == null) {
            this._libraryIncludes = new ArrayList<FeatureLibraryIncludeBuilder>();
        }
        if (this._components == null) {
            this._components = new ArrayList<BuilderReference>();
        }
    }

    @Override
    protected GenerationType getGenerationType() {
        return GenerationType.FEATURESET;
    }

    @Override
    protected String validateGenerationProperty(String property, String value) throws BuilderException {
        String validValue = value.toLowerCase();
        try {
            switch (GenerationProperty.getGenerationProperty(property, this.getGenerationType())) {
                case FEATURESET_MULTI_VERSION: 
                case FEATURESET_POMGEN: 
                case FEATURESET_THIRD_PARTY: 
                case FEATURESET_SINGLETON: 
                case FEATURESET_LIBRARY_SUPRESS_VERSION: 
                case FEATURESET_LIBRARY_IGNORE_VERSION: 
                case FEATURESET_LIBRARY_SUPPRESS_PREFIX: {
                    if (!validValue.matches("true|false")) {
                        throw new BuilderException("Invalid " + property + " attribute value, a boolean value is expected.");
                    }
                    break;
                }
                case FEATURESET_CONSUMPTION_TYPE: {
                    if (!validValue.matches("restricted|unrestricted")) {
                        throw new BuilderException("Invalid " + property + " attribute value. Expected values are: restricted or unrestricted.");
                    }
                    break;
                }
                case FEATURESET_LIBRARY_TYPE: {
                    if (!validValue.matches(LibraryType.manifest.name().toLowerCase() + "|" + LibraryType.runtime.name().toLowerCase() + "|" + LibraryType.client.name().toLowerCase() + "|" + LibraryType.mergedJar.name().toLowerCase())) {
                        throw new BuilderException("Invalid " + property + " attribute value. Expected values are: manifest, runtime, interface, client or mergedjar.");
                    }
                    if (validValue.equalsIgnoreCase("mergedJar")) {
                        validValue = "mergedJar";
                    }
                    break;
                }
                case FEATURESET_DEPENDENCIES: {
                    this.parseDependencies(value);
                    break;
                }
                case FEATURESET_LIBRARY_VISIBILITY: {
                    if (!validValue.matches("public|internal")) {
                        throw new BuilderException("Invalid " + property + " attribute value. Expected values are: public or internal.");
                    }
                    break;
                }
                case FEATURESET_lIBRARY_INCLUDES: {
                    this.parseLibraryIncludes(value);
                    break;
                }
                case FEATURESET_COMPONENTS: {
                    this.parseComponents(value);
                    break;
                }
                default: {
                    validValue = value;
                    break;
                }
            }
        }
        catch (BuilderException e) {
            throw new BuilderException("Error while processing FEATURE-SET property: \n" + property + "=" + value, e);
        }
        return validValue;
    }

    private void parseComponents(String value) throws BuilderException {
        String[] compNameVersion;
        this._components = new ArrayList<BuilderReference>();
        for (String compNameVer : compNameVersion = value.split(",")) {
            String[] compVer = compNameVer.split(":");
            if (compVer.length != 2) {
                throw new BuilderException("Invalid Feature component declaration. Expected value is componentName:Version but it was: " + compNameVer);
            }
            this._components.add(new BuilderReferenceImpl(compVer[0], compVer[1]));
        }
    }

    public String getMultiVersion() {
        return this.getGenerationProperty(GenerationProperty.FEATURESET_MULTI_VERSION);
    }

    public String getPomGen() {
        return this.getGenerationProperty(GenerationProperty.FEATURESET_POMGEN);
    }

    public String getSingleton() {
        return this.getGenerationProperty(GenerationProperty.FEATURESET_SINGLETON);
    }

    public String getThirdParty() {
        return this.getGenerationProperty(GenerationProperty.FEATURESET_THIRD_PARTY);
    }

    public String getConsumptionType() {
        return this.getGenerationProperty(GenerationProperty.FEATURESET_CONSUMPTION_TYPE);
    }

    public String getLibraryName() {
        return this.getGenerationProperty(GenerationProperty.FEATURESET_lIBRARY_NAME);
    }

    public String getLibraryType() {
        return this.getGenerationProperty(GenerationProperty.FEATURESET_LIBRARY_TYPE);
    }

    public String getLibrarySuppressPrefix() {
        return this.getGenerationProperty(GenerationProperty.FEATURESET_LIBRARY_SUPPRESS_PREFIX);
    }

    public String getLibrarySuppressVersion() {
        return this.getGenerationProperty(GenerationProperty.FEATURESET_LIBRARY_SUPRESS_VERSION);
    }

    public String getLibraryLocation() {
        return this.getGenerationProperty(GenerationProperty.FEATURESET_LIBRARY_LOCATION);
    }

    public String getLibraryIgnoreVersion() {
        return this.getGenerationProperty(GenerationProperty.FEATURESET_LIBRARY_IGNORE_VERSION);
    }

    public String getLibraryVisibility() {
        return this.getGenerationProperty(GenerationProperty.FEATURESET_LIBRARY_VISIBILITY);
    }

    public String getDisplayName() {
        return this.getGenerationProperty(GenerationProperty.FEATURESET_DISPLAY_NAME);
    }

    public String getDisplayNameKey() {
        return this.getGenerationProperty(GenerationProperty.FEATURESET_DISPLAT_NAME_KEY);
    }

    public String getDescription() {
        return this.getGenerationProperty(GenerationProperty.FEATURESET_DESCRIPTION);
    }

    public String getDescriptionKey() {
        return this.getGenerationProperty(GenerationProperty.FEATURESET_DESCRIPTION_KEY);
    }

    public String getType() {
        return this.getGenerationProperty(GenerationProperty.FEATURESET_TYPE);
    }

    public String getSubType() {
        return this.getGenerationProperty(GenerationProperty.FEATURESET_SUB_TYPE);
    }

    public List<BuilderReference> getDependencies() {
        return this._dependencies;
    }

    public List<FeatureLibraryIncludeBuilder> getLibraryIncludes() {
        return this._libraryIncludes;
    }

    public List<BuilderReference> getComponents() {
        return this._components;
    }

    private String parseLibraryIncludes(String value) throws BuilderException {
        this._libraryIncludes = new ArrayList<FeatureLibraryIncludeBuilder>();
        Map<String, Object> includesMap = this.parsePropertiesToMap(value);
        for (Map.Entry<String, Object> entry : includesMap.entrySet()) {
            FeatureLibraryIncludeBuilderImpl includeBuilder = new FeatureLibraryIncludeBuilderImpl(entry.getKey());
            if (entry.getValue() != null) {
                block15: for (Map.Entry property : ((Map)entry.getValue()).entrySet()) {
                    String[] nameValue = ((String)property.getKey()).split(":");
                    if (nameValue.length != 2) {
                        throw new BuilderException("Invalid library include property declaration:\"" + (String)property.getKey() + "\".Expected format: \"PropertyName:Value\"");
                    }
                    if (!nameValue[1].toLowerCase().matches("true|false")) {
                        throw new BuilderException("Invalid property value in include property declaration:\"" + (String)property.getKey() + "\". Expected a boolean value");
                    }
                    switch (nameValue[0].toLowerCase()) {
                        case "ignore-type": {
                            includeBuilder.setIgnoreType(Boolean.valueOf(nameValue[1]));
                            continue block15;
                        }
                        case "ignore-version": {
                            includeBuilder.setIgnoreVersion(Boolean.valueOf(nameValue[1]));
                            continue block15;
                        }
                        case "optional": {
                            includeBuilder.setOptional(Boolean.valueOf(nameValue[1]));
                            continue block15;
                        }
                        case "explode": {
                            includeBuilder.setExplode(Boolean.valueOf(nameValue[1]));
                            continue block15;
                        }
                        case "global": {
                            includeBuilder.setGlobal(Boolean.valueOf(nameValue[1]));
                            continue block15;
                        }
                    }
                    throw new BuilderException("Unrecognized property for library include:\"" + nameValue[0]);
                }
            }
            this._libraryIncludes.add(includeBuilder);
        }
        return null;
    }

    private void parseDependencies(String depencies) throws BuilderException {
        this._dependencies = new ArrayList<BuilderReference>();
        Object errorString = null;
        Set<String> dependenciesSet = this.createSetFromString(depencies, ",");
        for (String dependency : dependenciesSet) {
            String rangeString;
            String[] nameVersion = dependency.split(":");
            if (nameVersion.length < 2 || nameVersion.length > 3) {
                throw new BuilderException("The name:version[:version-range] string provided was not in the expected format : " + dependency);
            }
            if (nameVersion[1].contains("-")) {
                throw new BuilderException("The name:version[:version-range] string provided was not in the expected format : " + dependency);
            }
            BuilderReferenceImpl dependencyReference = new BuilderReferenceImpl(nameVersion[0], nameVersion[1]);
            if (nameVersion.length > 2 && (rangeString = nameVersion[2]).contains("-")) {
                String[] ranges = rangeString.split("-");
                if (ranges.length != 2) {
                    throw new BuilderException("The name:version[:version-range] string provided was not in the expected format : " + dependency);
                }
                if (ranges[0].endsWith("+")) {
                    dependencyReference.setVersionRangeMinInclusive(true);
                    ranges[0] = ranges[0].substring(0, ranges[0].length() - 1);
                }
                if (ranges[1].endsWith("+")) {
                    dependencyReference.setVersionRangeMaxInclusive(true);
                    ranges[1] = ranges[1].substring(0, ranges[1].length() - 1);
                }
                dependencyReference.setVersionRangeMin(ranges[0]);
                dependencyReference.setVersionRangeMax(ranges[1]);
            }
            this._dependencies.add(dependencyReference);
        }
    }
}

