/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.generation;

import com.oracle.cie.gdr.external.builder.BuilderException;
import com.oracle.cie.gdr.external.builder.SectionBuilder;
import com.oracle.cie.gdr.external.builder.impl.SectionBuilderImpl;
import com.oracle.cie.gdr.generation.GenerationConfig;
import com.oracle.cie.gdr.generation.GenerationProperty;
import com.oracle.cie.gdr.generation.GenerationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DistributionInfoGenerationConfig
extends GenerationConfig {
    private Map<String, SectionBuilder> _sections;
    private Map<String, List<String>> _shiphomeProps;

    public DistributionInfoGenerationConfig(String defaultName, Map<String, String> props) throws BuilderException {
        super(defaultName, props);
        if (this._sections == null) {
            this._sections = new HashMap<String, SectionBuilder>();
        }
        if (this._shiphomeProps == null) {
            this._shiphomeProps = new HashMap<String, List<String>>();
        }
        this.validateSections();
    }

    private void validateSections() throws BuilderException {
        Set<String> sectionsDefined = this.createSetFromString(this.getGenerationProperty(GenerationProperty.DISTRIBUTION_INFO_SECTIONS), ",");
        for (Map.Entry<String, SectionBuilder> entry : this._sections.entrySet()) {
            if (!sectionsDefined.contains(entry.getKey())) {
                throw new BuilderException("Section \"" + entry.getKey() + "\" was not defined in \"Sections\" property");
            }
            sectionsDefined.remove(entry.getKey());
        }
        if (!sectionsDefined.isEmpty()) {
            for (String string : sectionsDefined) {
                this._sections.put(string, new SectionBuilderImpl(string));
            }
        }
    }

    @Override
    protected GenerationType getGenerationType() {
        return GenerationType.DISTRIBUTION_INFO;
    }

    @Override
    public void overrideGenerationPropery(String key, String value) throws BuilderException {
        String[] propertyKeySection = key.split("\\.");
        if (propertyKeySection.length > 1) {
            this.parseSection(propertyKeySection[0], propertyKeySection[1], value);
        } else {
            super.overrideGenerationPropery(key, value);
        }
    }

    private void parseSection(String propertyName, String sectionName, String value) throws BuilderException {
        if (this._sections == null) {
            this._sections = new HashMap<String, SectionBuilder>();
        }
        if (!propertyName.equalsIgnoreCase(GenerationProperty.DISTRIBUTION_INFO_SECTION.getName()) && !propertyName.equalsIgnoreCase(GenerationProperty.DISTRIBUTION_INFO_SECTION_ADD.getName())) {
            throw new BuilderException("Failure while trying to create a " + (Object)((Object)this.getGenerationType()) + "  due to the property \"" + propertyName + "." + sectionName + "\" with value \"" + value + "\" is not recognized");
        }
        boolean sectionAdd = propertyName.equalsIgnoreCase(GenerationProperty.DISTRIBUTION_INFO_SECTION_ADD.getName());
        SectionBuilder section = this._sections.get(sectionName);
        if (section == null) {
            section = new SectionBuilderImpl(sectionName);
        }
        HashMap<String, List<String>> secProperties = new HashMap<String, List<String>>();
        this.parseProperies(value, secProperties);
        for (Map.Entry property : secProperties.entrySet()) {
            section.addProperty((String)property.getKey(), ((List)property.getValue()).toArray(new String[((List)property.getValue()).size()]), sectionAdd);
        }
        this._sections.put(sectionName, section);
    }

    private void parseProperies(String value, Map<String, List<String>> properties) throws BuilderException {
        Map<String, Object> mappingsMap = this.parsePropertiesToMap(value);
        for (Map.Entry<String, Object> entry : mappingsMap.entrySet()) {
            ArrayList<Object> values = new ArrayList();
            if (entry.getValue() != null) {
                values = new ArrayList(((Map)entry.getValue()).keySet());
            }
            properties.put(entry.getKey(), values);
        }
    }

    public List<String> getProductFamilies() {
        return this.createListFromString(this.getGenerationProperty(GenerationProperty.DISTRIBUTION_INFO_PRODUCT_FAMILIES), ",");
    }

    public List<String> getPlatforms() {
        return this.createListFromString(this.getGenerationProperty(GenerationProperty.DISTRIBUTION_INFO_PLATFORMS), ",");
    }

    public Map<String, List<String>> getShiphomeProperties() {
        return this._shiphomeProps;
    }

    public String getGenerateDefaultOraparam() {
        return this.getGenerationProperty(GenerationProperty.DISTRIBUTION_INFO_GENERATE_DEFAULT_ORAPARAM);
    }

    public List<SectionBuilder> getSections() {
        return new ArrayList<SectionBuilder>(this._sections.values());
    }

    @Override
    protected String validateGenerationProperty(String property, String value) throws BuilderException {
        String validValue = value.toLowerCase();
        try {
            switch (GenerationProperty.getGenerationProperty(property, this.getGenerationType())) {
                case DISTRIBUTION_INFO_GENERATE_DEFAULT_ORAPARAM: {
                    if (!validValue.matches("true|false")) {
                        throw new BuilderException("Invalid \"" + property + "\" attribute value, a boolean value is expected");
                    }
                    break;
                }
                case DISTRIBUTION_INFO_SHIPHOME_PROPERTIES: {
                    this._shiphomeProps = new HashMap<String, List<String>>();
                    this.parseProperies(value, this._shiphomeProps);
                    break;
                }
                default: {
                    validValue = value;
                    break;
                }
            }
        }
        catch (BuilderException e) {
            throw new BuilderException("Error while processing DISTRIBUTION-INFO property: \n" + property + "=" + value, e);
        }
        return validValue;
    }
}

