/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.generation;

import com.oracle.cie.gdr.external.builder.BuilderException;
import com.oracle.cie.gdr.external.builder.FeatureSetReferenceBuilder;
import com.oracle.cie.gdr.external.builder.impl.FeatureSetReferenceBuilderImp;
import com.oracle.cie.gdr.generation.GenerationConfig;
import com.oracle.cie.gdr.generation.GenerationProperty;
import com.oracle.cie.gdr.generation.GenerationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DistributionGenerationConfig
extends GenerationConfig {
    private Map<String, List<FeatureSetReferenceBuilder>> _featureSetGroups;
    private Map<String, Set<String>> _directorySymbols;

    public DistributionGenerationConfig(String defaultName, Map<String, String> props) throws BuilderException {
        super(defaultName, props);
        if (this._featureSetGroups == null) {
            this._featureSetGroups = new HashMap<String, List<FeatureSetReferenceBuilder>>();
        }
        if (this._directorySymbols == null) {
            this._directorySymbols = new HashMap<String, Set<String>>();
        }
    }

    @Override
    protected GenerationType getGenerationType() {
        return GenerationType.DISTRIBUTION;
    }

    public String getExternalName() {
        return this.getGenerationProperty(GenerationProperty.DISTRIBUTION_EXTERNAL_NAME);
    }

    public String getExternalNameKey() {
        return this.getGenerationProperty(GenerationProperty.DISTRIBUTION_EXTERNAL_NAME_KEY);
    }

    public String getExternalShortName() {
        return this.getGenerationProperty(GenerationProperty.DISTRIBUTION_EXTERNAL_SHORT_NAME);
    }

    public String getExternalShortNameKey() {
        return this.getGenerationProperty(GenerationProperty.DISTRIBUTION_EXTERNAL_SHORT_NAME_KEY);
    }

    public String getExternalVersion() {
        return this.getGenerationProperty(GenerationProperty.DISTRIBUTION_EXTERNAL_VERSION);
    }

    public String getDesciptionKey() {
        return this.getGenerationProperty(GenerationProperty.DISTRIBUTION_DESCRIPTION_KEY);
    }

    public List<String> getRootMappingSymbols() {
        return this.createListFromString(this.getGenerationProperty(GenerationProperty.DISTRIBUTION_MAPPING_ROOT), ",");
    }

    public Map<String, List<FeatureSetReferenceBuilder>> getFeatureSetGroups() {
        return this._featureSetGroups;
    }

    public Map<String, Set<String>> getDirectorySymbols() {
        return this._directorySymbols;
    }

    @Override
    protected String validateGenerationProperty(String property, String value) throws BuilderException {
        try {
            switch (GenerationProperty.getGenerationProperty(property, this.getGenerationType())) {
                case DISTRIBUTION_FEATURESET_GROUPS: 
                case DISTRIBUTION_INTERNAL_FEATURESET_GROUP_FEATURES: {
                    this.parseFeaturesetGroups(value);
                    break;
                }
                case DISTRIBUTION_INTERNAL_DIRECTORY_MAPPINGS: 
                case DISTRIBUTION_DIRECTORY_MAPPINGS: {
                    this.parseDirectoryMapping(value);
                    break;
                }
            }
        }
        catch (BuilderException e) {
            throw new BuilderException("Error while processing DISTRIBUTION property: \n" + property + "=" + value, e);
        }
        return value;
    }

    private void parseDirectoryMapping(String value) throws BuilderException {
        if (this._directorySymbols == null) {
            this._directorySymbols = new HashMap<String, Set<String>>();
        }
        Map<String, Object> mappingsMap = this.parsePropertiesToMap(value);
        for (Map.Entry<String, Object> entry : mappingsMap.entrySet()) {
            Set<String> values = this._directorySymbols.get(entry.getKey());
            if (values == null) {
                values = new LinkedHashSet<String>();
                this._directorySymbols.put(entry.getKey(), values);
            }
            if (entry.getValue() != null) {
                values.addAll(((Map)entry.getValue()).keySet());
            }
            this._directorySymbols.put(entry.getKey(), values);
        }
    }

    private void parseFeaturesetGroups(String value) throws BuilderException {
        if (this._featureSetGroups == null) {
            this._featureSetGroups = new HashMap<String, List<FeatureSetReferenceBuilder>>();
        }
        Map<String, Object> featureGropMap = this.parsePropertiesToMap(value);
        for (Map.Entry<String, Object> entry : featureGropMap.entrySet()) {
            if (entry.getKey().split(":").length != 2) {
                throw new BuilderException("Invalid featureset group declaration:\"" + entry.getKey() + "\".Expected format: \"FeatureSetGroupName:FeatureSetGroupDisplay-Name\"");
            }
            if (entry.getValue() == null) continue;
            ArrayList<FeatureSetReferenceBuilderImp> featSetRefBuilderList = new ArrayList<FeatureSetReferenceBuilderImp>();
            for (Map.Entry entryRef : ((Map)entry.getValue()).entrySet()) {
                String[] nameVersion = ((String)entryRef.getKey()).split(":");
                if (nameVersion.length != 2) {
                    throw new BuilderException("Invalid featureset reference declaration:\"" + (String)entryRef.getKey() + "\".Expected format: \"Feature-Name:Feature_version\"");
                }
                FeatureSetReferenceBuilderImp featureReference = new FeatureSetReferenceBuilderImp(nameVersion[0], nameVersion[1]);
                if (entryRef.getValue() != null) {
                    block16: for (Map.Entry property : ((Map)entryRef.getValue()).entrySet()) {
                        String[] nameValue = ((String)property.getKey()).split(":");
                        if (nameValue.length != 2) {
                            throw new BuilderException("Invalid featureset reference property declaration:\"" + (String)property.getKey() + "\".Expected format: \"PropertyName:Value\"");
                        }
                        if (!nameValue[1].toLowerCase().matches("true|false")) {
                            throw new BuilderException("Invalid property value in featureset reference declaration:\"" + (String)property.getKey() + "\". Expected a boolean value");
                        }
                        switch (nameValue[0].toLowerCase()) {
                            case "external": {
                                featureReference.setExternal(nameValue[1]);
                                continue block16;
                            }
                            case "required": {
                                featureReference.setRequired(nameValue[1]);
                                continue block16;
                            }
                            case "selected": {
                                featureReference.setSelected(nameValue[1]);
                                continue block16;
                            }
                            case "visible": {
                                featureReference.setVisible(nameValue[1]);
                                continue block16;
                            }
                            case "generic": {
                                featureReference.setGeneric(nameValue[1]);
                                continue block16;
                            }
                        }
                        throw new BuilderException("Unrecognized property for featureset reference:\"" + nameValue[0]);
                    }
                }
                featSetRefBuilderList.add(featureReference);
            }
            this._featureSetGroups.put(entry.getKey(), featSetRefBuilderList);
        }
    }
}

