/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.cloud;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.gdr.dao.pld.ProductLayers;
import com.oracle.cie.gdr.external.cloud.CloudException;
import com.oracle.cie.gdr.external.cloud.ProductLayer;
import com.oracle.cie.gdr.external.cloud.ProductLayersDefinitionFactory;
import com.oracle.cie.gdr.external.cloud.ProductLayersVersionResolver;
import com.oracle.cie.gdr.external.cloud.impl.ProductLayerImpl;
import com.oracle.cie.gdr.helpers.ProductLayersDefinitionHelper;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;

public class ProductLayersDefinitionUtil {
    private List<URL> _repoRepoUrls;
    private File _localCacheRepo;
    private Properties _properties;

    public ProductLayersDefinitionUtil(List<URL> remoteRepoUrls, File localCacheRepo, Properties properties) {
        this._repoRepoUrls = remoteRepoUrls;
        this._localCacheRepo = localCacheRepo;
        this._properties = properties == null ? new Properties() : properties;
    }

    public List<ProductLayer> getProductLayerDependencies(String layerName, String layerVersion, final ProductLayersVersionResolver versionResolver) throws CloudException {
        LinkedHashMap<ProductLayersDefinitionHelper.ProductLayerKey, com.oracle.cie.gdr.dao.pld.ProductLayer> productLayerMap;
        if (StringUtil.isNullOrEmpty((String)layerName)) {
            throw new CloudException("The layer name provided was null or empty.");
        }
        if (StringUtil.isNullOrEmpty((String)layerVersion)) {
            throw new CloudException("The layer version provided was null or empty.");
        }
        String qualifiedVersion = this.getQualifiedVersion(layerName, layerVersion, versionResolver);
        ProductLayer targetLayer = ProductLayersDefinitionFactory.getProductLayer(layerName, qualifiedVersion, this._repoRepoUrls, this._localCacheRepo, this._properties);
        ProductLayers highLevelProductLayers = ProductLayersDefinitionHelper.getInstance().getWrappedProductLayer(((ProductLayerImpl)targetLayer).getProductLayer());
        try {
            productLayerMap = ProductLayersDefinitionHelper.getInstance().getProductLayerDependencies(layerName, layerVersion, highLevelProductLayers, new ProductLayersDefinitionHelper.ProductLayersResolver(){

                @Override
                public ProductLayers resolve(ProductLayersDefinitionHelper.ProductLayerKey key) throws GdrException {
                    String depQualifiedVersion = ProductLayersDefinitionUtil.this.getQualifiedVersion(key.getName(), key.getVersion(), versionResolver);
                    ProductLayer depTargetLayer = ProductLayersDefinitionFactory.getProductLayer(key.getName(), depQualifiedVersion, ProductLayersDefinitionUtil.this._repoRepoUrls, ProductLayersDefinitionUtil.this._localCacheRepo, ProductLayersDefinitionUtil.this._properties);
                    return ProductLayersDefinitionHelper.getInstance().getWrappedProductLayer(((ProductLayerImpl)depTargetLayer).getProductLayer());
                }
            });
        }
        catch (GdrException e) {
            throw new CloudException("Failed to get product layer dependencies for " + layerName + " " + layerVersion, e);
        }
        ArrayList<ProductLayer> productLayers = new ArrayList<ProductLayer>();
        for (com.oracle.cie.gdr.dao.pld.ProductLayer productLayer : productLayerMap.values()) {
            productLayers.add(ProductLayersDefinitionFactory.getProductLayer(productLayer));
        }
        return productLayers;
    }

    private String getQualifiedVersion(String name, String version, ProductLayersVersionResolver versionResolver) throws CloudException {
        String qualifiedVersion = version;
        if (versionResolver != null && !DependencyManagementFactory.getInstance().getVersion(version).hasQualifier()) {
            qualifiedVersion = versionResolver.getProductLayerVersion(name, version);
        }
        return qualifiedVersion;
    }
}

