/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.builder.impl;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.dbd.FeatureSetGroup;
import com.oracle.cie.gdr.dao.dbd.Mapping;
import com.oracle.cie.gdr.dao.dbd.RootMapping;
import com.oracle.cie.gdr.external.builder.BuilderException;
import com.oracle.cie.gdr.external.builder.DistributionBuilder;
import com.oracle.cie.gdr.external.builder.FeatureSetGroupBuilder;
import com.oracle.cie.gdr.external.builder.impl.FeatureSetGroupBuilderImpl;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DistributionBuilderImpl
implements DistributionBuilder {
    private Distribution _distribution;
    private List<FeatureSetGroup> _cachedfeatureSetGroup;
    private List<Mapping> _cacheMappings;
    private RootMapping _rootMapping = null;

    public DistributionBuilderImpl(String name, String version) throws BuilderException {
        if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            throw new BuilderException("The distribution name was null or empty.");
        }
        if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
            throw new BuilderException("The distribution version was null or empty.");
        }
        this._distribution = new Distribution(name, version);
    }

    @Override
    public String getName() {
        return this._distribution.getName();
    }

    @Override
    public String getVersion() {
        return this._distribution.getVersion();
    }

    @Override
    public String getExternalName() {
        return this._distribution.getExternalName();
    }

    @Override
    public String getExternalNameKey() {
        return this._distribution.getExternalNameKey();
    }

    @Override
    public String getExternalVersion() {
        return this._distribution.getExternalVersion();
    }

    @Override
    public String getExternalShortName() {
        return this._distribution.getExternalShortName();
    }

    @Override
    public String getExternalShortNameKey() {
        return this._distribution.getExternalShortNameKey();
    }

    @Override
    public String getDescriptionKey() {
        return this._distribution.getDescriptionKey();
    }

    @Override
    public void setName(String name) {
        this._distribution.setName(name);
    }

    @Override
    public void setVersion(String version) {
        this._distribution.setVersion(version);
    }

    @Override
    public void setExternalName(String externalName) {
        this._distribution.setExternalName(externalName);
    }

    @Override
    public void setExternalNameKey(String externalNameKey) {
        this._distribution.setExternalNameKey(externalNameKey);
    }

    @Override
    public void setExternalVersion(String externalVersion) {
        this._distribution.setExternalVersion(externalVersion);
    }

    @Override
    public void setExternalShortName(String externalShortName) {
        this._distribution.setExternalShortName(externalShortName);
    }

    @Override
    public void setExternalShortNameKey(String externalShortNameKey) {
        this._distribution.setExternalShortNameKey(externalShortNameKey);
    }

    @Override
    public void setDescriptionKey(String descriptionKey) {
        this._distribution.setDescriptionKey(descriptionKey);
    }

    @Override
    public void addMapping(String directory, List<String> symbols) {
        if (this._cacheMappings == null) {
            this._cacheMappings = new ArrayList<Mapping>();
        }
        Mapping mapping = new Mapping(directory);
        mapping.setSymbols(symbols.toArray(new String[symbols.size()]));
        this._cacheMappings.add(mapping);
    }

    @Override
    public void setRootMapping(List<String> symbols) {
        if (this._rootMapping == null) {
            this._rootMapping = new RootMapping();
        }
        this._rootMapping.setSymbols(symbols.toArray(new String[symbols.size()]));
    }

    @Override
    public FeatureSetGroupBuilder addFeatureSetGroup(String name, String displayName) {
        FeatureSetGroupBuilderImpl featureSetGroup = new FeatureSetGroupBuilderImpl(name, displayName);
        this.addFeatureSetGroup(featureSetGroup);
        return featureSetGroup;
    }

    private void addFeatureSetGroup(FeatureSetGroupBuilder featureSetGroup) {
        if (this._cachedfeatureSetGroup == null) {
            this._cachedfeatureSetGroup = new ArrayList<FeatureSetGroup>();
        }
        this._cachedfeatureSetGroup.add(featureSetGroup.getFeatureSetGroup());
    }

    @Override
    public void save(File directory) throws BuilderException {
        if (directory == null) {
            throw new BuilderException("The specified save location was null.");
        }
        if (directory.exists() && !directory.isDirectory()) {
            throw new BuilderException("The specified save location was not a directory " + directory);
        }
        this.prepareToSave();
        File distributionDir = new File(directory, DistributionHelper.getInstance().getPath());
        distributionDir.mkdirs();
        File distributionFile = new File(distributionDir, DistributionHelper.getInstance().getDistributionFileName(this._distribution));
        try {
            DistributionHelper.getInstance().save((IDataHandlerWrapper)this._distribution, distributionFile);
        }
        catch (DataHandlerException e) {
            throw new BuilderException("Failed to save distribution file to " + distributionFile, e);
        }
    }

    protected void prepareToSave() {
        if (this._cachedfeatureSetGroup != null && !this._cachedfeatureSetGroup.isEmpty()) {
            this._distribution.setFeatureSetGroups(this._cachedfeatureSetGroup);
        }
        if (this._cacheMappings != null && !this._cacheMappings.isEmpty() || this._rootMapping != null) {
            DirectoryMap directoryMap = new DirectoryMap();
            directoryMap.setMappings(this._cacheMappings);
            directoryMap.setRootMapping(this._rootMapping);
            this._distribution.setDirectoryMap(directoryMap);
        }
    }
}

