/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external;

import com.oracle.cie.gdr.external.BaseInventory;
import com.oracle.cie.gdr.external.GdrInventory;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.InventoryUtil;
import com.oracle.cie.gdr.external.OracleHomeInventory;
import com.oracle.cie.gdr.external.OracleHomeUtil;
import com.oracle.cie.gdr.external.impl.GdrInventoryFactory;
import com.oracle.cie.gdr.external.impl.OracleHomeInventoryFactory;
import com.oracle.cie.gdr.external.impl.RepositoryInventoryFactory;
import com.oracle.cie.gdr.services.TopLevelDirectoryService;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InventoryFactory {
    private static GdrInventoryFactory gdrInventoryFactory = new GdrInventoryFactory();
    private static OracleHomeInventoryFactory oracleHomeInventoryFactory = new OracleHomeInventoryFactory();
    private static RepositoryInventoryFactory repositoryInventoryFactory = new RepositoryInventoryFactory();
    private static final Logger _log = Logger.getLogger(InventoryFactory.class.getName());

    public static GdrInventory getGdrInventory(File metaDataHome) throws InventoryException {
        return gdrInventoryFactory.createInventory(metaDataHome);
    }

    public static GdrInventory getGdrInventory(Path metaDataHome) throws InventoryException {
        return gdrInventoryFactory.createInventory(metaDataHome);
    }

    public static GdrInventory getGdrInventory() throws InventoryException {
        String adeViewRoot = System.getenv(TopLevelDirectoryService.ADE_VIEW_ROOT);
        if (null == adeViewRoot) {
            throw new InventoryException("The gdr inventory can not be created with an undefined ADE_VIEW_ROOT");
        }
        try {
            return gdrInventoryFactory.createInventory(TopLevelDirectoryService.getGdrLabelTopLevelDirectory(new File(adeViewRoot)));
        }
        catch (Exception exception) {
            _log.log(Level.SEVERE, "A problem occurred when loading the gdr inventory.", exception);
            throw new InventoryException(exception);
        }
    }

    public static OracleHomeInventory getOracleHomeInventory(File homeDir) throws InventoryException {
        return oracleHomeInventoryFactory.createInventory(homeDir);
    }

    public static OracleHomeInventory getOracleHomeInventory(Path homeDir) throws InventoryException {
        return oracleHomeInventoryFactory.createInventory(homeDir);
    }

    public static InventoryUtil getInventoryUtil(File homeDir) throws InventoryException {
        return new InventoryUtil(homeDir);
    }

    public static InventoryUtil getInventoryUtil(Path homePath) throws InventoryException {
        return new InventoryUtil(homePath);
    }

    public static OracleHomeUtil getOracleHomeUtil(File homeDir) throws InventoryException {
        return new OracleHomeUtil(homeDir);
    }

    public static BaseInventory getRepositoryInventory(List<URL> urls, String username, String password) throws InventoryException {
        return repositoryInventoryFactory.createInventory(urls, username, password);
    }

    public static BaseInventory getRepositoryInventory(List<URL> urls, String username, String password, File localCacheRepo) throws InventoryException {
        return repositoryInventoryFactory.createInventory(urls, username, password, localCacheRepo);
    }

    public static BaseInventory getRepositoryInventory(List<URL> urls, String username, String password, File localCacheRepo, Properties properties) throws InventoryException {
        return repositoryInventoryFactory.createInventory(urls, username, password, localCacheRepo, properties);
    }

    public static BaseInventory getRepositoryInventory(List<URL> urls, String username, String password, File localCacheRepo, File propertiesLocation) throws InventoryException {
        return repositoryInventoryFactory.createInventory(urls, username, password, localCacheRepo, propertiesLocation);
    }
}

