/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.deinstallation;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.DistributionLoader;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.deinstallation.DeInstallationSession;
import com.oracle.cie.gdr.deinstallation.DeInstallationValidator;
import com.oracle.cie.gdr.dependency.FeatureSelectionTarget;
import com.oracle.cie.gdr.external.DeInstallerSession;
import com.oracle.cie.gdr.installation.ReferenceCounter;
import com.oracle.cie.gdr.session.DistributionSession;
import com.oracle.cie.gdr.session.DistributionSessionImpl;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;

public class DistributionDeInstallationSession
extends DeInstallationSession
implements DeInstallerSession,
DistributionSession {
    protected DistributionSession _distributionSession;

    public DistributionDeInstallationSession(File homeDir, Reference distributionReference) throws GdrException, IOException, DataHandlerException {
        super(homeDir);
        this._distributionSession = new DistributionSessionImpl(this.getHome(), this.getMetaDataHome(), distributionReference, Mode.DEINSTALL);
    }

    @Override
    public DistributionLoader getDistributionLoader() {
        return this._distributionSession.getDistributionLoader();
    }

    @Override
    public FeatureSelectionTarget getFeatureSelectionTarget() {
        return this._distributionSession.getFeatureSelectionTarget();
    }

    @Override
    public Set<FeatureSet> getSelectedFeatures() {
        return this._distributionSession.getSelectedFeatures();
    }

    @Override
    public void setSelectedFeatures(Set<Reference> featureRefs) throws GdrException, DependencyException {
        this._distributionSession.setSelectedFeatures(featureRefs);
    }

    @Override
    public void validateDeInstallation() throws DependencyException {
        Set<FeatureSet> selectedFeatures = this.getUninstallableFeatures();
        DeInstallationValidator.validate(this.getDistributionLoader(), selectedFeatures, this.getHome());
    }

    public Set<FeatureSet> getUninstallableFeatures() {
        Set<FeatureSet> selectedFeatures = this.getSelectedFeatures();
        Iterator<FeatureSet> it = selectedFeatures.iterator();
        while (it.hasNext()) {
            FeatureSet featureSet = it.next();
            if (ReferenceCounter.getReferenceCount(this.getHomeDir(), ReferenceCounter.RefType.featuresets, featureSet.getName(), featureSet.getVersion()) <= 1) continue;
            it.remove();
        }
        return selectedFeatures;
    }
}

