/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.rgy;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.DataHandlerHelper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.rgy.DistributionInfo;
import com.oracle.cie.gdr.dao.rgy.SessionInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class Registry
extends AbstractDataHandlerWrapper {
    public Registry(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public String getHome() {
        return this.getStringAttribute("home");
    }

    public void setHome(String home) {
        this.setAttribute("home", home);
    }

    public int getPlatform() {
        return (Integer)this.getNumberAttribute("platform", Integer.class);
    }

    public void setPlatform(int platform) {
        this.setAttribute("platform", platform);
    }

    public int getSessions() {
        return (Integer)this.getNumberAttribute("sessions", Integer.class, 0);
    }

    public void setSessions(int sessions) {
        this.setAttribute("sessions", sessions);
    }

    public List<DistributionInfo> getDistributions() {
        return DataHandlerHelper.getWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("distributions"), (String)"distribution", DistributionInfo.class);
    }

    public void setDistributions(List<DistributionInfo> distributions) {
        DataHandlerHelper.setWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("distributions", true), (String)"distribution", distributions);
    }

    public void addDistribution(DistributionInfo distribution) {
        this.getSingleOccuranceComplexValue("distributions", true).addComplexValue("distribution", distribution.getDataHandler());
    }

    public DistributionInfo addDistribution(Distribution distribution, SessionInfo sessionInfo, boolean excludeDups) {
        int index;
        List<DistributionInfo> current;
        DistributionInfo ref = new DistributionInfo(this.getObjectClassLoader(), distribution.getName(), distribution.getVersion());
        if (excludeDups && (current = this.getDistributions()) != null && (index = current.indexOf(ref)) > -1) {
            return current.get(index);
        }
        if (sessionInfo != null) {
            ref.addSession(sessionInfo);
        }
        this.addDistribution(ref);
        return ref;
    }

    public void removeDistribution(DistributionInfo distribution) {
        List<DistributionInfo> dists;
        if (distribution != null && (dists = this.getDistributions()) != null && !dists.isEmpty()) {
            Iterator<DistributionInfo> it = dists.iterator();
            while (it.hasNext()) {
                DistributionInfo ref = it.next();
                if (!ref.equals(distribution)) continue;
                it.remove();
                break;
            }
            this.setDistributions(dists);
        }
    }

    public void removeDistribution(Distribution distribution) {
        this.removeDistribution(new DistributionInfo(this.getObjectClassLoader(), distribution.getName(), distribution.getVersion()));
    }

    public boolean isEmpty() {
        List<DistributionInfo> distributions = this.getDistributions();
        if (distributions != null && !distributions.isEmpty()) {
            for (DistributionInfo dinfo : distributions) {
                if (!dinfo.getStatus().isInstalled()) continue;
                return false;
            }
        }
        return true;
    }

    public String getGuid() {
        String guid = this.getStringAttribute("guid");
        if (guid == null || guid.isEmpty()) {
            guid = UUID.randomUUID().toString();
            this.setGuid(guid);
        }
        return guid;
    }

    public void setGuid(String guid) {
        this.setAttribute("guid", guid);
    }

    public List<String> getFederatedHomes() {
        ArrayList<String> federatedHomes = new ArrayList<String>();
        String[] homes = this.getSingleOccurrenceChildStringSimpleValueArray("federated-homes", "federated-home");
        if (homes != null && homes.length > 0) {
            federatedHomes.addAll(Arrays.asList(homes));
        }
        return federatedHomes;
    }

    public void setFederatedHomes(List<String> homes) {
        this.setSingleOccurrenceChildSimpleValue("federated-homes", "federated-home", homes != null ? homes.toArray(new String[homes.size()]) : null);
    }

    public Registry copy() {
        return new Registry(this.getDataHandler().copy());
    }
}

