/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.rgy;

import com.oracle.cie.common.dao.DataHandlerHelper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.rgy.BaseInfoReference;
import com.oracle.cie.gdr.dao.rgy.ComponentInfo;
import com.oracle.cie.gdr.helpers.RegistryHelper;
import java.util.List;

public class FeatureInfo
extends BaseInfoReference {
    public FeatureInfo(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public FeatureInfo(ClassLoader classLoader) {
        this(RegistryHelper.getInstance(classLoader).create("feature-info"));
    }

    public FeatureInfo(ClassLoader classLoader, String name, String version) {
        this(classLoader);
        this.setName(name);
        this.setVersion(version);
    }

    public boolean isSingleton() {
        return this.getBooleanAttribute("singleton");
    }

    public void setSingleton(boolean singleton) {
        this.setAttribute("singleton", singleton);
    }

    public List<ComponentInfo> getComponents() {
        return DataHandlerHelper.getWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("components"), (String)"component", ComponentInfo.class);
    }

    public void setComponents(List<ComponentInfo> components) {
        DataHandlerHelper.setWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("components", true), (String)"component", components);
    }

    public void addComponent(ComponentInfo component) {
        this.getSingleOccuranceComplexValue("components", true).addComplexValue("component", component.getDataHandler());
    }

    public void addComponent(Component component) {
        ComponentInfo ref = new ComponentInfo(this.getObjectClassLoader(), component.getName(), component.getVersion());
        this.addComponent(ref);
    }

    public void addComponents(List<Component> components, boolean excludeDups) {
        if (excludeDups) {
            List<ComponentInfo> current = this.getComponents();
            for (Component component : components) {
                ComponentInfo ref = new ComponentInfo(this.getObjectClassLoader(), component.getName(), component.getVersion());
                if (current != null && current.contains(ref)) continue;
                this.addComponent(ref);
            }
        } else {
            for (Component component : components) {
                this.addComponent(component);
            }
        }
    }

    public void removeComponents(List<Component> components) {
        List<ComponentInfo> current;
        if (components != null && !components.isEmpty() && (current = this.getComponents()) != null && !current.isEmpty()) {
            int origSize = current.size();
            for (Component component : components) {
                current.remove(new ComponentInfo(this.getObjectClassLoader(), component.getName(), component.getVersion()));
            }
            if (current.size() < origSize) {
                this.setComponents(current);
            }
        }
    }

    public FeatureInfo copy() {
        return new FeatureInfo(this.getDataHandler().copy());
    }
}

