/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.ftr;

import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.dao.cmn.LibraryResolvers;
import com.oracle.cie.gdr.dao.cmn.Manifest;
import com.oracle.cie.gdr.dao.cmn.MergedJarClasspath;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.ftr.FeatureLibraryInclude;
import com.oracle.cie.gdr.dao.pom.PomArtifact;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FeatureLibrary
extends Reference {
    private static final String LOCATION_SEPARATOR = ",";
    private long _size;

    public FeatureLibrary(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public FeatureLibrary() {
        this(FeatureSetHelper.getInstance().create("library-type"));
    }

    public FeatureLibrary(String name, String type) {
        this();
        this.setName(name);
        this.setType(type);
    }

    public String getType() {
        return this.getStringAttribute("type");
    }

    public void setType(String type) {
        this.setAttribute("type", type);
    }

    public Set<String> getLocation() {
        HashSet<String> locations = new HashSet<String>();
        String location = this.getStringAttribute("location");
        if (location != null) {
            if (!location.contains(LOCATION_SEPARATOR)) {
                locations.add(location);
            } else {
                for (String loc : location.split(LOCATION_SEPARATOR)) {
                    locations.add(loc);
                }
            }
        }
        return locations;
    }

    public void setLocation(String location) {
        this.setAttribute("location", location);
    }

    public String getVisibility() {
        return this.getStringAttribute("visibility");
    }

    public void setVisibility(String visibility) {
        this.setAttribute("visibility", visibility);
    }

    public Boolean getSuppressVersion() {
        return this.getBooleanAttribute("suppress-version");
    }

    public void setSuppressVersion(boolean suppressVersion) {
        this.setAttribute("suppress-version", suppressVersion);
    }

    public Boolean getSuppressPrefix() {
        return this.getBooleanAttribute("suppress-prefix");
    }

    public void setSuppressPrefix(boolean suppressPrefix) {
        this.setAttribute("suppress-prefix", suppressPrefix);
    }

    public Boolean getPomGen() {
        return this.getBooleanAttribute("pom-gen");
    }

    public void setPomGen(boolean pomGen) {
        this.setAttribute("pom-gen", pomGen);
    }

    public Boolean getHK2Gen() {
        return this.getBooleanAttribute("hk2-gen");
    }

    public void setHK2Gen(boolean hk2Gen) {
        this.setAttribute("hk2-gen", hk2Gen);
    }

    public String getHK2Location() {
        return this.getStringAttribute("hk2-location");
    }

    public Boolean getOverwriteHigherVersion() {
        return this.getBooleanAttribute("overwrite-higher-version");
    }

    public String getSuppressManifestProperties() {
        return this.getStringAttribute("suppress-manifest-properties");
    }

    public void setSymbol(String symbol) {
        this.setAttribute("symbol", symbol);
    }

    public String getSymbol() {
        return this.getStringAttribute("symbol");
    }

    public String getExtension() {
        return this.getStringAttribute("extension");
    }

    public List<FeatureLibraryInclude> getIncludes() {
        return this.getComplexValueWrappedList("include", FeatureLibraryInclude.class);
    }

    public void setIncludes(List<FeatureLibraryInclude> includes) {
        this.setComplexValueWrappedList("include", includes);
    }

    public Manifest getManifest() {
        return (Manifest)((Object)this.getSingleOccuranceComplexValueWrapped("manifest", Manifest.class));
    }

    public LibraryResolvers getLibraryResolvers() {
        return (LibraryResolvers)((Object)this.getSingleOccuranceComplexValueWrapped("resolvers", LibraryResolvers.class));
    }

    public MergedJarClasspath getClasspathJars() {
        return (MergedJarClasspath)((Object)this.getSingleOccuranceComplexValueWrapped("merged-jar-classpath", MergedJarClasspath.class));
    }

    public PomArtifact getDefaultPomOverride() {
        return (PomArtifact)this.getSingleOccuranceComplexValueWrapped("default-pom-override", PomArtifact.class);
    }

    public Boolean getIgnoreType() {
        return this.getBooleanAttribute("ignore-type");
    }

    public void setIgnoreType(Boolean ignoreType) {
        this.setAttribute("ignore-type", ignoreType);
    }

    public Boolean getIgnoreVersion() {
        return this.getBooleanAttribute("ignore-version");
    }

    public void setIgnoreVersion(Boolean ignoreVersion) {
        this.setAttribute("ignore-version", ignoreVersion);
    }

    public boolean matches(String type, String name, String version) {
        String libType = this.getType();
        String libName = this.getName();
        String libVer = this.getVersion();
        return type != null && type.equals(libType) && name != null && name.equals(libName) && (version == null && libVer == null || version != null && version.equals(libVer));
    }

    @Override
    public int hashCode() {
        String thisName = this.getName();
        String thisVersion = this.getVersion();
        String thisType = this.getType();
        int result = thisName != null ? thisName.hashCode() : 0;
        result = 31 * result + (thisVersion != null ? thisVersion.hashCode() : 0);
        result = 31 * result + (thisType != null ? thisType.hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FeatureLibrary that = (FeatureLibrary)((Object)o);
        String thisName = this.getName();
        String thisVersion = this.getVersion();
        String thisType = this.getType();
        String thatName = that.getName();
        String thatVersion = that.getVersion();
        String thatType = that.getType();
        return !((thisName == null ? thatName != null : !thisName.equals(thatName)) || (thisVersion == null ? thatVersion != null : !thisVersion.equals(thatVersion)) || (thisType == null ? thatType != null : !thisType.equals(thatType)));
    }

    public long getSize() {
        return this._size;
    }

    public void setSize(long size) {
        this._size = size;
    }
}

