/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.cpd;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.dao.cpd.FileModifier;
import com.oracle.cie.gdr.dao.cpd.Mapping;
import com.oracle.cie.gdr.dao.cpd.Rule;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.services.RepositoryArtifact;
import java.util.List;

public class File
extends AbstractDataHandlerWrapper
implements Mapping,
RepositoryArtifact,
Comparable<File> {
    protected boolean _force;

    public File(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public File() {
        super(ComponentHelper.getInstance().create("file"));
    }

    @Override
    public String getSource() {
        return this.getStringAttribute("source");
    }

    @Override
    public void setSource(String source) {
        this.setAttribute("source", source);
    }

    @Override
    public String getDest() {
        return this.getStringAttribute("dest");
    }

    @Override
    public void setDest(String dest) {
        this.setAttribute("dest", dest);
    }

    @Override
    public String getId() {
        return this.getStringAttribute("id");
    }

    @Override
    public void setId(String id) {
        this.setAttribute("id", id);
    }

    public String getSymlink() {
        return this.getStringAttribute("symlink");
    }

    public void setSymlink(String symlink) {
        this.setAttribute("symlink", symlink);
    }

    public String getOsFamily() {
        return this.getStringAttribute("os-family");
    }

    public void setOsFamily(String osFamily) {
        this.setAttribute("os-family", osFamily);
    }

    public String getAction() {
        return this.getStringAttribute("action");
    }

    public void setAction(String action) {
        this.setAttribute("action", action);
    }

    public String getJarEntry() {
        return this.getStringAttribute("jarentry");
    }

    public void setJarEntry(String jarentry) {
        this.setAttribute("jarentry", jarentry);
    }

    public long getSize() {
        return (Long)this.getNumberAttribute("size", Long.class, 0L);
    }

    public void setSize(long size) {
        this.setAttribute("size", size);
    }

    public List<FileModifier> getModifiers() {
        return this.getComplexValueWrappedList("modifier", FileModifier.class);
    }

    public void setModifiers(List<FileModifier> modifiers) {
        this.setComplexValueWrappedList("modifier", modifiers);
    }

    public String getMode() {
        return this.getStringAttribute("mode");
    }

    public void setMode(String mode) {
        this.setAttribute("mode", mode);
    }

    public List<Rule> getRules() {
        return this.getComplexValueWrappedList("rule", Rule.class);
    }

    public void setRules(List<Rule> rules) {
        this.setComplexValueWrappedList("rule", rules);
    }

    public boolean isPack() {
        return this.getBooleanAttribute("pack");
    }

    public void setPack(boolean pack) {
        this.getDataHandler().setAttributeValue("pack", (Object)pack);
    }

    @Override
    public String getGroup() {
        return this.getStringAttribute("group");
    }

    @Override
    public void setGroup(String group) {
        this.setAttribute("group", group);
    }

    @Override
    public String getArtifact() {
        return this.getStringAttribute("artifact");
    }

    @Override
    public void setArtifact(String artifact) {
        this.setAttribute("artifact", artifact);
    }

    @Override
    public String getVersion() {
        return this.getStringAttribute("version");
    }

    @Override
    public void setVersion(String version) {
        this.setAttribute("version", version);
    }

    @Override
    public boolean isIgnoreVersionKeywords() {
        return this.getBooleanAttribute("ignore-version-keywords");
    }

    @Override
    public void setIgnoreVersionKeywords(boolean ignore) {
        this.setAttribute("ignore-version-keywords", ignore);
    }

    @Override
    public String getBaseVersion() {
        return this.getStringAttribute("baseVersion");
    }

    @Override
    public void setBaseVersion(String version) {
        this.setAttribute("baseVersion", version);
    }

    @Override
    public String getClassifier() {
        String classifier = this.getStringAttribute("classifier");
        if (classifier != null && classifier.trim().length() < 1) {
            classifier = null;
        }
        return classifier;
    }

    @Override
    public void setClassifier(String classifier) {
        this.setAttribute("classifier", classifier);
    }

    @Override
    public String getType() {
        String type = this.getStringAttribute("type");
        if (type != null && type.trim().length() < 1) {
            type = null;
        }
        return type;
    }

    @Override
    public void setType(String type) {
        this.setAttribute("type", type);
    }

    public Boolean getPatchable() {
        return (Boolean)this.getDataHandler().getAttributeValue("patchable");
    }

    public void setPatchable(boolean patchable) {
        this.setAttribute("patchable", patchable);
    }

    public Boolean getForce() {
        return this._force;
    }

    public void setForce(boolean force) {
        this._force = force;
    }

    public String getChecksum() {
        return this.getStringAttribute("checksum");
    }

    public void setChecksum(String checksum) {
        this.setAttribute("checksum", checksum);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !File.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        File file = (File)o;
        String thisDest = this.getDest();
        String theirDest = file.getDest();
        return !(thisDest == null ? theirDest != null : !thisDest.equals(theirDest));
    }

    public int hashCode() {
        String dest = this.getDest();
        return dest != null ? dest.hashCode() : 0;
    }

    @Override
    public int compareTo(File o) {
        if (this.getSource() != null && o != null && o.getSource() != null) {
            return this.getSource().compareTo(o.getSource());
        }
        return 0;
    }
}

