/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.cpd;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.Wildcard;

public class BaseSelection
extends AbstractDataHandlerWrapper {
    protected String _name = this.getStringAttribute("name");
    protected String _regex;
    protected String _wildcard;
    protected String _pathMatcher;
    protected String _pathMatcherSyntax;
    protected boolean _nameSet = !StringUtil.isNullOrEmpty((String)this._name, (boolean)true);
    protected boolean _regexSet;
    protected boolean _wildcardSet;
    protected boolean _pathMatcherSet;
    protected Wildcard _wildcardObj;
    protected Wildcard _pathMatcherWildcard;

    protected BaseSelection(IDataHandler dataHandler) {
        super(dataHandler);
        this._regex = this.getStringAttribute("regex");
        this._regexSet = !StringUtil.isNullOrEmpty((String)this._regex, (boolean)true);
        this._wildcard = this.getStringAttribute("wildcard");
        this._wildcardSet = !StringUtil.isNullOrEmpty((String)this._wildcard, (boolean)true);
        this._pathMatcher = this.getStringAttribute("path-matcher");
        this._pathMatcherSet = !StringUtil.isNullOrEmpty((String)this._pathMatcher, (boolean)true);
        this._pathMatcherSyntax = this.getStringAttribute("path-matcher-syntax");
    }

    public String getRegex() {
        return this._regex;
    }

    public void setRegex(String regex) {
        this._regex = regex;
        this._regexSet = !StringUtil.isNullOrEmpty((String)this._regex, (boolean)true);
        this.setAttribute("regex", regex);
    }

    public String getWildcard() {
        return this._wildcard;
    }

    public void setWildcard(String wildcard) {
        this._wildcard = wildcard;
        this._wildcardSet = !StringUtil.isNullOrEmpty((String)this._wildcard, (boolean)true);
        this.setAttribute("wildcard", wildcard);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
        this._nameSet = !StringUtil.isNullOrEmpty((String)this._name, (boolean)true);
        this.setAttribute("name", name);
    }

    public String getPathMatcher() {
        return this._pathMatcher;
    }

    public void setPathMatcher(String pathMatcher) {
        this._pathMatcher = pathMatcher;
        this._pathMatcherSet = !StringUtil.isNullOrEmpty((String)this._pathMatcher, (boolean)true);
        this.setAttribute("path-matcher", pathMatcher);
    }

    public String getPathMatcherSyntax() {
        return this._pathMatcherSyntax;
    }

    public void setPathMatcherSyntax(String pathMatcherSyntax) {
        this._pathMatcherSyntax = pathMatcherSyntax;
        this.setAttribute("path-matcher-syntax", pathMatcherSyntax);
    }

    public boolean matches(String value) {
        if (value == null) {
            return false;
        }
        if (this._nameSet) {
            return value.equals(this.getName());
        }
        if (this._regexSet) {
            return value.matches(this.getRegex().trim());
        }
        if (this._wildcardSet) {
            if (this._wildcardObj == null) {
                this._wildcardObj = new Wildcard(this.getWildcard());
            }
            return this._wildcardObj.matches(value);
        }
        if (this._pathMatcherSet) {
            if (this._pathMatcherWildcard == null) {
                this._pathMatcherWildcard = new Wildcard(this.getPathMatcher(), this.getPathMatcherSyntax());
            }
            return this._pathMatcherWildcard.matches(value);
        }
        return false;
    }

    public boolean isEmpty() {
        return StringUtil.isNullOrEmpty((String)this.getName(), (boolean)true) && StringUtil.isNullOrEmpty((String)this.getWildcard(), (boolean)true) && StringUtil.isNullOrEmpty((String)this.getRegex(), (boolean)true) && StringUtil.isNullOrEmpty((String)this.getPathMatcher(), (boolean)true);
    }

    public int hashCode() {
        String name = this.getName();
        String wildcard = this.getWildcard();
        String regex = this.getRegex();
        String pathMatcher = this.getPathMatcher();
        String pathMatcherSyntax = this.getPathMatcherSyntax();
        int result = regex != null ? regex.hashCode() : 0;
        result = 31 * result + (wildcard != null ? wildcard.hashCode() : 0);
        result = 31 * result + (name != null ? name.hashCode() : 0);
        result = 31 * result + (pathMatcher != null ? pathMatcher.hashCode() : 0);
        result = 31 * result + (pathMatcherSyntax != null ? pathMatcherSyntax.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !o.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return false;
        }
        BaseSelection baseSelect = (BaseSelection)((Object)o);
        String name = this.getName();
        String theirName = baseSelect.getName();
        String wildcard = this.getWildcard();
        String theirWildcard = baseSelect.getWildcard();
        String regex = this.getRegex();
        String theirRegex = baseSelect.getRegex();
        String pathMatcher = this.getPathMatcher();
        String theirPathMatcher = this.getPathMatcher();
        String pathMatcherSyntax = this.getPathMatcherSyntax();
        String theirPathMatcherSyntax = this.getPathMatcherSyntax();
        if (name != null && theirName != null && !name.equals(theirName)) {
            return false;
        }
        if (wildcard != null && theirWildcard != null && !wildcard.equals(theirWildcard)) {
            return false;
        }
        if (regex != null && theirRegex != null && !regex.equals(theirRegex)) {
            return false;
        }
        if (pathMatcher != null && theirPathMatcher != null && !pathMatcher.equals(theirPathMatcher)) {
            return false;
        }
        return pathMatcherSyntax == null || theirPathMatcherSyntax == null || pathMatcherSyntax.equals(theirPathMatcherSyntax);
    }
}

