/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.bic;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.dao.bic.File;
import com.oracle.cie.gdr.helpers.BuildIntegrityHelper;
import java.util.List;

public class Directory
extends AbstractDataHandlerWrapper {
    public Directory() {
        this(BuildIntegrityHelper.getInstance().create("directory"));
    }

    public Directory(String dest, String regex, String wildcard, boolean force) {
        this(BuildIntegrityHelper.getInstance().create("directory"));
        this.setLocation(dest);
    }

    public String getLocation() {
        return this.getStringAttribute("location");
    }

    private void setLocation(String location) {
        this.setAttribute("location", location);
    }

    public Directory(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public List<File> getFiles() {
        return this.getComplexValueWrappedList("file", File.class);
    }

    public void setFiles(List<File> file) {
        this.setComplexValueWrappedList("file", file);
    }

    public List<Directory> getDirectories() {
        return this.getComplexValueWrappedList("directory", Directory.class);
    }

    public String getStatus() {
        return this.getStringAttribute("status");
    }

    private void setStatus(String status) {
        this.setAttribute("status", status);
    }

    public void setDirectories(List<Directory> directory) {
        this.setComplexValueWrappedList("directory", directory);
    }

    public void addFile(File file) {
        this.getDataHandler().addComplexValue("file", file.getDataHandler());
    }

    public void addDirectory(Directory dir) {
        this.getDataHandler().addComplexValue("directory", dir.getDataHandler());
    }
}

