/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.carbdiff.integrity;

import com.oracle.cie.common.util.DiffReport;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.carbdiff.CarbDiffException;
import com.oracle.cie.gdr.carbdiff.CarbDiffHandler;
import com.oracle.cie.gdr.carbdiff.CarbDiffUtils;
import com.oracle.cie.gdr.carbdiff.DefaultCarbDiffHandler;
import com.oracle.cie.gdr.carbdiff.DefaultContentFilterer;
import com.oracle.cie.gdr.carbdiff.FileDiffResolver;
import com.oracle.cie.gdr.carbdiff.FileMapFilterer;
import com.oracle.cie.gdr.carbdiff.integrity.BuildIntegrityResolver;
import com.oracle.cie.gdr.dao.bic.Artifact;
import com.oracle.cie.gdr.dao.bic.BuildIntegrity;
import com.oracle.cie.gdr.dao.bic.BuildIntegrityInfo;
import com.oracle.cie.gdr.dao.bic.FileMap;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.pad.TextFileDiffFilter;
import com.oracle.cie.gdr.packaging.PackagerComponentTarget;
import com.oracle.cie.gdr.services.ServiceHolder;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class BuildIntegrityHandler
implements CarbDiffHandler {
    private Logger _log = Logger.getLogger(DefaultCarbDiffHandler.class.getName());
    protected File _deltaCarbDestination;
    protected FileMapFilterer _fileMapFilterer;
    protected TextFileDiffFilter _textFileDiffFilter;
    protected DefaultContentFilterer _textFileDiffFilterer;
    protected List<com.oracle.cie.gdr.dao.cpd.FileMap> _deltaFileMaps = new ArrayList<com.oracle.cie.gdr.dao.cpd.FileMap>();
    protected Component _baseComponent;
    protected Component _modifiedComponent;
    protected DiffReport _report;
    protected FileDiffResolver _fileDiffResolver;
    protected BuildIntegrity _buildIntegrity;

    public BuildIntegrityHandler(File deltaCarbDestination, Component baseComponent, Component modifiedComponent) {
        this._deltaCarbDestination = deltaCarbDestination;
        this._baseComponent = baseComponent;
        this._modifiedComponent = modifiedComponent;
    }

    @Override
    public boolean diff(File baseCarb, File carb) throws CarbDiffException {
        try {
            return this.diff(CarbDiffUtils.getComponentFromCarb(baseCarb), CarbDiffUtils.getComponentFromCarb(carb));
        }
        catch (Exception e) {
            throw new CarbDiffException("Failed to perform carb diff of " + baseCarb + " vs. " + carb, e);
        }
    }

    @Override
    public boolean diff(Component baseComponent, Component modifiedComponent) throws CarbDiffException {
        if (baseComponent == null) {
            throw new CarbDiffException("The base component specified was null.");
        }
        if (modifiedComponent == null) {
            throw new CarbDiffException("The modified component specified was null.");
        }
        this._fileDiffResolver = new BuildIntegrityResolver(this._buildIntegrity);
        this._fileDiffResolver.setTextFileDiffFilter(this._textFileDiffFilter);
        this._fileDiffResolver.setDiffReport(this._report);
        try {
            this._log.info("Starting diff on base carb " + baseComponent + " and patched carb " + modifiedComponent);
            if (this._fileMapFilterer != null) {
                this._fileDiffResolver.setBaseFilteredArchives(this._fileMapFilterer.getFilteredArchives());
                if (this._fileMapFilterer.getIncludedManifest() != null && !this._fileMapFilterer.getIncludedManifest().isEmpty()) {
                    this._fileDiffResolver.setIncludedManifest(this._fileMapFilterer.getIncludedManifest());
                }
                this._fileDiffResolver.setPatchedFilteredArchives(this._fileMapFilterer.getFilteredArchives());
            }
            if (baseComponent.getFileMaps().size() < modifiedComponent.getFileMaps().size()) {
                int newFileMaps = modifiedComponent.getFileMaps().size() - baseComponent.getFileMaps().size();
                ArrayList<com.oracle.cie.gdr.dao.cpd.FileMap> baseComponentFileMaps = new ArrayList<com.oracle.cie.gdr.dao.cpd.FileMap>();
                baseComponentFileMaps.addAll(baseComponent.getFileMaps());
                for (int i = 0; i < newFileMaps; ++i) {
                    com.oracle.cie.gdr.dao.cpd.FileMap singleFileMap = new com.oracle.cie.gdr.dao.cpd.FileMap();
                    singleFileMap.setExpanded(true);
                    baseComponentFileMaps.add(singleFileMap);
                }
                baseComponent.setFileMaps(baseComponentFileMaps);
            }
            BuildIntegrityInfo buildIntegrityInfo = new BuildIntegrityInfo();
            Iterator<com.oracle.cie.gdr.dao.cpd.FileMap> i = modifiedComponent.getFileMaps().iterator();
            Iterator<com.oracle.cie.gdr.dao.cpd.FileMap> j = baseComponent.getFileMaps().iterator();
            while (i.hasNext() && j.hasNext()) {
                com.oracle.cie.gdr.dao.cpd.FileMap modifiedFileMap = i.next();
                com.oracle.cie.gdr.dao.cpd.FileMap baseFileMap = j.next();
                Map<String, FileTarget> patchFileTargets = this.getFileTargets(modifiedComponent, modifiedFileMap, this._fileMapFilterer != null ? this._fileMapFilterer.getForcedFiles() : new ArrayList());
                Map<String, FileTarget> releaseFileTargets = this.getFileTargets(baseComponent, baseFileMap, this._fileMapFilterer != null ? this._fileMapFilterer.getForcedFiles() : new ArrayList());
                Collection<FileTarget> deltaFileTargets = this._fileDiffResolver.diffFiles(releaseFileTargets, patchFileTargets);
                this.addBuildIntegrityDetails(deltaFileTargets, buildIntegrityInfo);
                if (deltaFileTargets == null || deltaFileTargets.isEmpty()) continue;
                com.oracle.cie.gdr.dao.cpd.FileMap deltaFileMap = new com.oracle.cie.gdr.dao.cpd.FileMap(modifiedFileMap.getDataHandler().copy());
                deltaFileMap.clear();
                deltaFileMap.setExpanded(false);
                deltaFileMap.setFileTargets(deltaFileTargets);
                this._deltaFileMaps.add(deltaFileMap);
            }
            List<BuildIntegrityInfo> buildIntegrityInfos = this._buildIntegrity.getBuildIntegrityInfos();
            buildIntegrityInfos.add(buildIntegrityInfo);
            this._buildIntegrity.setBuildIntegrityInfos(buildIntegrityInfos);
            if (this._deltaFileMaps == null || this._deltaFileMaps.isEmpty()) {
                return true;
            }
        }
        catch (Exception exception) {
            this._log.severe("Failed to diff on base carb " + baseComponent + " and patched carb " + modifiedComponent);
            throw new CarbDiffException(exception);
        }
        return false;
    }

    private void addBuildIntegrityDetails(Collection<FileTarget> fileTargets, BuildIntegrityInfo buildIntegrityInfo) {
        buildIntegrityInfo.setBaseArtifact(this.createArtifact(this._baseComponent));
        buildIntegrityInfo.setModifiedArtifact(this.createArtifact(this._modifiedComponent));
        this.addFiles(buildIntegrityInfo, fileTargets);
    }

    private void addFiles(BuildIntegrityInfo biInfo, Collection<FileTarget> targets) {
        FileMap fileMap = biInfo.getFileMap();
        if (biInfo.getFileMap() == null) {
            fileMap = new FileMap();
        }
        LinkedHashMap<String, com.oracle.cie.gdr.dao.bic.File> files = new LinkedHashMap<String, com.oracle.cie.gdr.dao.bic.File>();
        for (FileTarget target : targets) {
            files.put(target.getDest(), new com.oracle.cie.gdr.dao.bic.File(target.getDest(), target.getStatus()));
        }
        fileMap.setFiles(new ArrayList<com.oracle.cie.gdr.dao.bic.File>(((HashMap)files).values()));
        biInfo.setFileMap(fileMap);
    }

    private Artifact createArtifact(Component component) {
        Artifact artifact = new Artifact();
        artifact.setArtifactId(component.getName());
        artifact.setGroupId("com.oracle.cie.gdr.carb");
        artifact.setVersion(component.getVersion());
        return artifact;
    }

    private Map<String, FileTarget> getFileTargets(Component component, com.oracle.cie.gdr.dao.cpd.FileMap fileMap, List<String> forcedFiles) throws GdrException {
        HashMap<String, FileTarget> fileTargetMap = new HashMap<String, FileTarget>();
        List<FileTarget> fileTargets = new PackagerComponentTarget(component, fileMap, new ServiceHolder(), Mode.PACKAGE_SHIPHOME).getFileTargets();
        if (fileTargets != null && !fileTargets.isEmpty()) {
            for (FileTarget ft : fileTargets) {
                if (!forcedFiles.isEmpty() && forcedFiles.contains(ft.getDest())) {
                    ft.setForced(true);
                }
                fileTargetMap.put(ft.getDest(), ft);
            }
        }
        return fileTargetMap;
    }

    @Override
    public List<com.oracle.cie.gdr.dao.cpd.FileMap> getDeltaFileMaps() {
        return this._deltaFileMaps;
    }

    protected File getDestination() {
        return this._deltaCarbDestination;
    }

    public FileMapFilterer getFileMapFilterer() {
        return this._fileMapFilterer;
    }

    @Override
    public void setFileMapFilterer(FileMapFilterer fileMapFilterer) {
        this._fileMapFilterer = fileMapFilterer;
    }

    @Override
    public void setTextFileDiffFilter(TextFileDiffFilter textFileDiffFilter) {
        this._textFileDiffFilter = textFileDiffFilter;
    }

    @Override
    public void setDiffReport(DiffReport report) {
        this._report = report;
    }

    @Override
    public void setIncludeParentClass(boolean includeParentClass) {
    }

    public BuildIntegrity getBuildIntegrity() {
        return this._buildIntegrity;
    }

    public void setBuildIntegrity(BuildIntegrity buildIntegrity) {
        this._buildIntegrity = buildIntegrity;
    }

    @Override
    public List<FileTarget> getFileTargetsToDelete() {
        return null;
    }

    @Override
    public boolean hasFilesToDelete() {
        return false;
    }
}

