/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.carbdiff.handlers;

import com.oracle.cie.common.util.DiffReport;
import com.oracle.cie.common.util.JarDiff;
import com.oracle.cie.common.util.JarHelper;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.logging.Logger;

public class PropertiesDiffHandler
implements JarDiff.DiffHandler {
    private static Logger _log = Logger.getLogger(PropertiesDiffHandler.class.getName());
    private DiffReport _report;

    public PropertiesDiffHandler(DiffReport report) {
        this._report = report;
    }

    public boolean isHandled(File jarFile, String entryName) {
        if (entryName.endsWith(".properties") || entryName.endsWith("_WL_GENERATED") && jarFile.isFile()) {
            _log.finest(entryName + " is handled by PropertiesDiffHandler.");
            return true;
        }
        return false;
    }

    public boolean isHandled(JarHelper jarHandler, String entryName) {
        return this.isHandled(jarHandler.getJar(), entryName);
    }

    private boolean isHandled(JarFile jarFile, String entryName) {
        return this.isHandled(new File(jarFile.getName()), entryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean diff(String entryName, File file1, File file2) throws Exception {
        Properties baseProps = new Properties();
        Properties patchedProps = new Properties();
        FileReader baseReader = null;
        InputStreamReader patchedReader = null;
        try {
            baseReader = new FileReader(file1);
            patchedReader = new FileReader(file2);
            baseProps.load(baseReader);
            patchedProps.load(patchedReader);
        }
        finally {
            if (baseReader != null) {
                baseReader.close();
            }
            if (patchedReader != null) {
                patchedReader.close();
            }
        }
        if (!baseProps.equals(patchedProps)) {
            boolean isDifferent = false;
            StringBuilder added = new StringBuilder();
            StringBuilder removed = new StringBuilder();
            StringBuilder diff = new StringBuilder();
            for (Map.Entry<Object, Object> property : patchedProps.entrySet()) {
                if (!baseProps.containsKey(property.getKey())) {
                    isDifferent = true;
                    if (added.length() > 0) {
                        added.append(",");
                    }
                    added.append(property.getKey() + "=" + property.getValue());
                    continue;
                }
                if (!baseProps.get(property.getKey()).equals(property.getValue())) {
                    isDifferent = true;
                    if (diff.length() > 0) {
                        diff.append(",");
                    }
                    diff.append(property.getKey() + "=" + property.getValue());
                }
                baseProps.remove(property.getKey());
            }
            if (!baseProps.isEmpty()) {
                isDifferent = true;
                for (Map.Entry<Object, Object> property : baseProps.entrySet()) {
                    if (removed.length() > 0) {
                        removed.append(",");
                    }
                    removed.append(property.getKey() + "=" + property.getValue());
                }
            }
            if (isDifferent) {
                _log.finest("Comparing " + file1.getCanonicalPath() + " vs " + file2.getCanonicalPath() + " using PropertiesDiffHandler has found diffs");
            }
            if (this._report != null && isDifferent) {
                String diffString = "";
                if (added.length() > 0) {
                    diffString = diffString + "Added properties: " + added.toString();
                }
                if (diff.length() > 0) {
                    diffString = diffString + "Diff properties: " + diff.toString();
                }
                if (removed.length() > 0) {
                    diffString = diffString + "Removed properties: " + removed.toString();
                }
                this._report.addDiff(entryName, diffString, null);
            }
            return isDifferent;
        }
        return false;
    }

    public void setDiffReport(DiffReport report) {
        this._report = report;
    }
}

