/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.carbdiff;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.impl.VersionImpl;
import com.oracle.cie.gdr.carbdiff.CarbDiffUtils;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.pad.ArtifactInfoOverride;
import com.oracle.cie.gdr.dao.pad.PatchArtifactDefinition;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RestHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.PatchConfigAction;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchMetadataWritingException;
import oracle.glcm.opatch.common.helpers.PatchDeployHelper;
import oracle.glcm.opatch.common.impl.PatchDeployArtifactImpl;
import oracle.glcm.opatch.common.impl.dao.PatchDeployDAO;

public class PatchDeployProcessor {
    private static final Logger _logger = Logger.getLogger(PatchDeployProcessor.class.getName());
    private static PatchDeployProcessor _patchDeployProcessor = new PatchDeployProcessor();

    private PatchDeployProcessor() {
    }

    public static PatchDeployProcessor getInstance() {
        return _patchDeployProcessor;
    }

    public File mergePatchDeploys(PatchArtifactDefinition pad, String baseBug, List<Repository> remoteRepositories, Set<Reference> changedComponents, RestHandler restHandler, File destination, String uid) throws GdrException {
        File patchDeploy = null;
        PatchDeployArtifactImpl mergedPatchDeploy = null;
        PatchDeployArtifactImpl singlePatchDeploy = null;
        try {
            for (ArtifactInfoOverride artifactInfo : pad.getCarbInfos()) {
                boolean isChanged = false;
                Artifact patchedArtifact = artifactInfo.getPatchedArtifact().getArtifact("carb");
                if (changedComponents != null) {
                    for (Reference componentRef : changedComponents) {
                        if (!patchedArtifact.getName().equals(componentRef.getName()) || !patchedArtifact.getVersion().getBaseVersion().equals(componentRef.getVersion())) continue;
                        isChanged = true;
                        break;
                    }
                }
                if (!isChanged) continue;
                File patchedArtifactFile = restHandler.retrieveArtifact(patchedArtifact, remoteRepositories, true);
                patchDeploy = CarbDiffUtils.getPatchDeployFromCarb(patchedArtifactFile);
                if (patchDeploy == null) {
                    try {
                        patchDeploy = PatchDeployHelper.getInstance().generateDefault(destination);
                    }
                    catch (PatchMetadataLoadingException | PatchMetadataWritingException e) {
                        throw new GdrException(e);
                    }
                }
                if (patchDeploy == null) continue;
                singlePatchDeploy = new PatchDeployArtifactImpl(patchDeploy.getAbsolutePath());
                if (mergedPatchDeploy == null) {
                    mergedPatchDeploy = new PatchDeployArtifactImpl(null);
                    if (singlePatchDeploy.getBackportPatchNotes().getBackportPatchNote() != null && singlePatchDeploy.getBackportPatchNotes().getBackportPatchNote() != null && !singlePatchDeploy.getBackportPatchNotes().getBackportPatchNote().isEmpty()) {
                        mergedPatchDeploy.setBackportPatchNotes(singlePatchDeploy.getBackportPatchNotes());
                    }
                    if (singlePatchDeploy.getBackportReadmePostinstall().getBackportReadmePostinstall() != null && singlePatchDeploy.getBackportReadmePostinstall().getBackportReadmePostinstall() != null && !singlePatchDeploy.getBackportReadmePostinstall().getBackportReadmePostinstall().isEmpty()) {
                        mergedPatchDeploy.setBackportReadmePostinstall(singlePatchDeploy.getBackportReadmePostinstall());
                    }
                    if (singlePatchDeploy.getBackportReadmePreinstall().getBackportReadmePreinstall() != null && singlePatchDeploy.getBackportReadmePreinstall().getBackportReadmePreinstall() != null && !singlePatchDeploy.getBackportReadmePreinstall().getBackportReadmePreinstall().isEmpty()) {
                        mergedPatchDeploy.setBackportReadmePreinstall(singlePatchDeploy.getBackportReadmePreinstall());
                    }
                    mergedPatchDeploy.setInstanceShutdown("Y");
                } else {
                    if (mergedPatchDeploy.getBackportPatchNotes() != null && mergedPatchDeploy.getBackportPatchNotes().getBackportPatchNote() != null && singlePatchDeploy.getBackportPatchNotes() != null && singlePatchDeploy.getBackportPatchNotes().getBackportPatchNote() != null) {
                        this.merge(mergedPatchDeploy.getBackportPatchNotes().getBackportPatchNote(), singlePatchDeploy.getBackportPatchNotes().getBackportPatchNote());
                    } else if (singlePatchDeploy.getBackportPatchNotes() != null && singlePatchDeploy.getBackportPatchNotes().getBackportPatchNote() != null) {
                        mergedPatchDeploy.setBackportPatchNotes(singlePatchDeploy.getBackportPatchNotes());
                    }
                    if (mergedPatchDeploy.getBackportReadmePostinstall() != null && mergedPatchDeploy.getBackportReadmePostinstall().getBackportReadmePostinstall() != null && singlePatchDeploy.getBackportReadmePostinstall() != null && singlePatchDeploy.getBackportReadmePostinstall().getBackportReadmePostinstall() != null) {
                        this.merge(mergedPatchDeploy.getBackportReadmePostinstall().getBackportReadmePostinstall(), singlePatchDeploy.getBackportReadmePostinstall().getBackportReadmePostinstall());
                    } else if (singlePatchDeploy.getBackportReadmePostinstall() != null && singlePatchDeploy.getBackportReadmePostinstall().getBackportReadmePostinstall() != null) {
                        mergedPatchDeploy.setBackportReadmePostinstall(singlePatchDeploy.getBackportReadmePostinstall());
                    }
                    if (mergedPatchDeploy.getBackportReadmePreinstall() != null && mergedPatchDeploy.getBackportReadmePreinstall().getBackportReadmePreinstall() != null && singlePatchDeploy.getBackportReadmePreinstall() != null && singlePatchDeploy.getBackportReadmePreinstall().getBackportReadmePreinstall() != null) {
                        this.merge(mergedPatchDeploy.getBackportReadmePreinstall().getBackportReadmePreinstall(), singlePatchDeploy.getBackportReadmePreinstall().getBackportReadmePreinstall());
                    } else if (singlePatchDeploy.getBackportReadmePreinstall() != null && singlePatchDeploy.getBackportReadmePreinstall().getBackportReadmePreinstall() != null) {
                        mergedPatchDeploy.setBackportReadmePreinstall(singlePatchDeploy.getBackportReadmePreinstall());
                    }
                }
                if (StringUtil.isNullOrEmpty((String)singlePatchDeploy.getInstanceShutdown()) || singlePatchDeploy.getInstanceShutdown().equalsIgnoreCase("Y")) {
                    mergedPatchDeploy.setInstanceShutdown("Y");
                }
                if (singlePatchDeploy.getPatchConfigAction() != null && !singlePatchDeploy.getPatchConfigAction().isEmpty()) {
                    for (PatchConfigAction action : singlePatchDeploy.getPatchConfigAction()) {
                        action.setComponentName(artifactInfo.getPatchedArtifact().getArtifactId());
                        action.setComponentVersion(new VersionImpl(artifactInfo.getPatchedArtifact().getVersion()).getBaseVersion());
                        if (mergedPatchDeploy.getPatchConfigAction() == null || mergedPatchDeploy.getPatchConfigAction().isEmpty()) {
                            mergedPatchDeploy.setPatchUptimeOption(action.getPatchUptimeOption());
                        } else {
                            mergedPatchDeploy.setPatchUptimeOption(this.getMoreRestrictve(mergedPatchDeploy.getPatchUptimeOption(), action.getPatchUptimeOption()));
                        }
                        mergedPatchDeploy.getPatchConfigAction().add(action);
                    }
                    continue;
                }
                if (StringUtil.isNullOrEmpty((String)mergedPatchDeploy.getPatchUptimeOption())) {
                    mergedPatchDeploy.setPatchUptimeOption(singlePatchDeploy.getPatchUptimeOption());
                    continue;
                }
                mergedPatchDeploy.setPatchUptimeOption(this.getMoreRestrictve(mergedPatchDeploy.getPatchUptimeOption(), singlePatchDeploy.getPatchUptimeOption()));
            }
            if (mergedPatchDeploy != null) {
                mergedPatchDeploy.setUpid(uid);
                mergedPatchDeploy.setPatchId(baseBug);
                File mergedPatchDeployFile = new File(destination, "patchDeploy.xml");
                mergedPatchDeploy.save(mergedPatchDeployFile.getAbsolutePath());
                return mergedPatchDeployFile;
            }
        }
        catch (Exception anyException) {
            throw new GdrException((Throwable)anyException);
        }
        return null;
    }

    private void merge(Collection<String> baseValues, Collection<String> valuesToAppend) {
        baseValues.addAll(valuesToAppend);
    }

    private int getPrecedenceOrder(String patchUptimeOption) {
        int precedenceOrder = -1;
        precedenceOrder = patchUptimeOption == null ? -1 : (patchUptimeOption.equals("NOT_SUPPORTED") ? 0 : (patchUptimeOption.equals("FMW_ROLLING_SESSION") ? 1 : (patchUptimeOption.equals("FMW_ROLLING_ORACLE_HOME") ? 2 : (patchUptimeOption.equals("FMW_ONLINE") ? 3 : -1))));
        return precedenceOrder;
    }

    private String getMoreRestrictve(String patchUptimeOption1, String patchUptimeOption2) {
        if (this.getPrecedenceOrder(patchUptimeOption1) == -1) {
            return "NOT_SUPPORTED";
        }
        if (this.getPrecedenceOrder(patchUptimeOption1) > this.getPrecedenceOrder(patchUptimeOption2)) {
            return patchUptimeOption2;
        }
        if (this.getPrecedenceOrder(patchUptimeOption1) < this.getPrecedenceOrder(patchUptimeOption2)) {
            return patchUptimeOption1;
        }
        return patchUptimeOption1;
    }

    public File getSinglePatchDeploy(Component component, Collection<Component> extensions) throws GdrException {
        _logger.entering(this.getClass().getName(), "getSinglePatchDeploy", new Object[]{component, extensions});
        File patchDeploy = null;
        if (component != null && (extensions == null || extensions.isEmpty())) {
            _logger.finest("Searching for patch deploy in component " + component.toString() + " with no extensions.");
            patchDeploy = new File(component.getCompDefLocation().getParentFile(), "patchDeploy.xml");
            if (!patchDeploy.exists()) {
                patchDeploy = null;
            }
        }
        if (component != null && extensions != null && !extensions.isEmpty()) {
            _logger.finest("Searching for patch deploy in component " + component.toString() + " with extensions.");
            patchDeploy = new File(component.getCompDefLocation().getParentFile(), "patchDeploy.xml");
            ArrayList<File> patchDeploys = new ArrayList<File>();
            if (patchDeploy.exists()) {
                patchDeploys.add(patchDeploy);
            }
            for (Component extComp : extensions) {
                patchDeploy = new File(extComp.getCompDefLocation().getParentFile(), "patchDeploy.xml");
                if (!patchDeploy.exists()) continue;
                if (!patchDeploys.isEmpty()) {
                    _logger.severe("Multiple patch deploys were found and only 1 is allowed.");
                    throw new GdrException("Only 1 patch deploy is allowed per component and extensions. Component " + component.toString() + " has more than 1.");
                }
                patchDeploys.add(patchDeploy);
            }
            patchDeploy = !patchDeploys.isEmpty() ? (File)patchDeploys.iterator().next() : null;
        }
        _logger.exiting(this.getClass().getName(), "getSinglePatchDeploy", patchDeploy);
        return patchDeploy;
    }

    public void validatePatchDeploy(File patchDeploy) throws GdrException {
        _logger.entering(this.getClass().getName(), "validatePatchDeploy", patchDeploy);
        try {
            PatchDeployDAO patchDeployDAO = new PatchDeployDAO(patchDeploy.getAbsolutePath());
            patchDeployDAO.convertToString();
        }
        catch (Exception anyException) {
            throw new GdrException((Throwable)anyException);
        }
        _logger.exiting(this.getClass().getName(), "validatePatchDeploy", patchDeploy);
    }
}

