/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.carbdiff;

import com.oracle.cie.common.util.FileUtils;
import com.oracle.cie.common.util.JarDiff;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.pad.FilePattern;
import com.oracle.cie.gdr.dao.pad.FileType;
import com.oracle.cie.gdr.dao.pad.TextFileDiffFilter;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;

public class DefaultContentFilterer
implements JarDiff.FileContentFilterer {
    private TextFileDiffFilter _textFileDiffFilter;
    private static final String _nonReplaceableFiles = ".*.class";

    public DefaultContentFilterer(TextFileDiffFilter textFileDiffFilter) {
        this._textFileDiffFilter = textFileDiffFilter;
    }

    public boolean canFilter(String entryName) {
        if (this._textFileDiffFilter.getFiles() != null) {
            for (FilePattern fileTextDiff : this._textFileDiffFilter.getFiles()) {
                if (!fileTextDiff.matches(entryName)) continue;
                return true;
            }
        }
        if (this._textFileDiffFilter.getFileTypes() != null) {
            for (FileType fileTypeTextDiff : this._textFileDiffFilter.getFileTypes()) {
                if (!fileTypeTextDiff.matches(entryName)) continue;
                return true;
            }
        }
        return false;
    }

    public File filterPattern(File file, String entry) throws IOException {
        String fileTypeRegex = "";
        if (this._textFileDiffFilter.getFiles() != null) {
            for (FilePattern fileTextDiff : this._textFileDiffFilter.getFiles()) {
                if (!fileTextDiff.matches(file.getPath())) continue;
                fileTypeRegex = fileTypeRegex + "(" + Pattern.compile(fileTextDiff.getSimpleRegex()) + ")|";
            }
        }
        if (this._textFileDiffFilter.getFileTypes() != null) {
            for (FileType fileTypeTextDiff : this._textFileDiffFilter.getFileTypes()) {
                if (!fileTypeTextDiff.matches(entry)) continue;
                fileTypeRegex = fileTypeRegex + "(" + Pattern.compile(fileTypeTextDiff.getRegex()) + ")|";
            }
        }
        if (!StringUtil.isNullOrEmpty((String)fileTypeRegex) && !entry.matches(_nonReplaceableFiles)) {
            fileTypeRegex = fileTypeRegex.substring(0, fileTypeRegex.length() - 1);
            file = FileUtils.replacePattern((File)file, (Pattern)Pattern.compile(fileTypeRegex));
        }
        return file;
    }
}

