/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.pch.Patch;
import com.oracle.cie.gdr.dao.rgy.Registry;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class DummyHome {
    private static final Logger _log = Logger.getLogger(DummyHome.class.getName());
    private Map<Path, Registry> _registryCache = new HashMap<Path, Registry>();
    private Map<Path, Set<Patch>> _cachedPatches = new HashMap<Path, Set<Patch>>();
    private Map<Path, Set<ComponentReference>> _cachedBootstrapComponents = new HashMap<Path, Set<ComponentReference>>();
    private static DummyHome _instance = new DummyHome();

    private DummyHome() {
    }

    public static DummyHome getInstance() {
        if (_instance == null) {
            _instance = new DummyHome();
        }
        return _instance;
    }

    public Registry getRegistry(Path homePath) {
        Registry registry = this._registryCache.get(homePath);
        if (registry == null) {
            try {
                return Home.getHome(homePath).getRegistry();
            }
            catch (DataHandlerException | GdrException | IOException e) {
                e.printStackTrace();
            }
        }
        return registry;
    }

    public void setRegistry(Path homeDir, Registry registry) {
        this._registryCache.put(homeDir, registry);
    }

    public void savePatch(Path homeDir, Patch patch) {
        Set<Patch> catchedPatches = this._cachedPatches.get(homeDir);
        if (catchedPatches == null) {
            catchedPatches = new HashSet<Patch>();
        }
        catchedPatches.add(patch);
        this._cachedPatches.put(homeDir, catchedPatches);
    }

    public Set<Patch> getCachedPatches(Path homeDir) {
        Set<Patch> catchedPatches = this._cachedPatches.get(homeDir);
        if (catchedPatches == null) {
            catchedPatches = new HashSet<Patch>();
        }
        return catchedPatches;
    }

    public void saveBootstrapComponents(Path homeDir, Set<ComponentReference> componentRefs) {
        Set<ComponentReference> catcheComponentRefs = this._cachedBootstrapComponents.get(homeDir);
        if (catcheComponentRefs == null) {
            catcheComponentRefs = new HashSet<ComponentReference>();
        }
        catcheComponentRefs.addAll(componentRefs);
        this._cachedBootstrapComponents.put(homeDir, catcheComponentRefs);
    }

    public Set<ComponentReference> getCachedBootstrapComponents(Path homeDir) {
        Set<ComponentReference> catcheComponentRefs = this._cachedBootstrapComponents.get(homeDir);
        if (catcheComponentRefs == null) {
            catcheComponentRefs = new HashSet<ComponentReference>();
        }
        return catcheComponentRefs;
    }

    public boolean hasCachedBootstrapComponents(Path homeDir) {
        return this._cachedBootstrapComponents.containsKey(homeDir);
    }

    public static void clearInstance() {
        _instance = null;
    }
}

