/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency;

import com.oracle.cie.dependency.ConditionHelper;
import com.oracle.cie.dependency.EKey;
import com.oracle.cie.dependency.TEdge;
import com.oracle.cie.dependency.TVertex;
import com.oracle.cie.dependency.VKey;
import com.oracle.cie.dependency.graph.DirectedGraph;
import com.oracle.cie.dependency.graph.VisitorAdaptor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

class InstalledConditionResolver
extends VisitorAdaptor<VKey, TVertex, EKey, TEdge, DirectedGraph<VKey, TVertex, EKey, TEdge>> {
    private DirectedGraph<VKey, TVertex, EKey, TEdge> _graph;
    private List<TVertex> _multipleChoiceOrs;
    private boolean _ableToResolveCondition;

    public InstalledConditionResolver(DirectedGraph<VKey, TVertex, EKey, TEdge> graph, PrintStream traceOut) {
        super(traceOut);
        this._graph = graph;
        this._multipleChoiceOrs = new ArrayList<TVertex>();
    }

    public boolean wasAbleToResolveCondition() {
        return this._ableToResolveCondition;
    }

    @Override
    public void preOp(DirectedGraph<VKey, TVertex, EKey, TEdge> graph) {
        if (this._graph != graph) {
            throw new IllegalArgumentException("Graph is not the one this visitor was created with!!!");
        }
        this._multipleChoiceOrs.clear();
        this._ableToResolveCondition = false;
    }

    @Override
    public boolean preVisit(TEdge edge, TVertex vertex) {
        super.preVisit(edge, vertex);
        VKey vKey = (VKey)vertex.getKey();
        if (vKey.getType() == VKey.VType.OR_COND && ConditionHelper.isMultipleInstChoiceOr(this._graph, vertex)) {
            this._multipleChoiceOrs.add(vertex);
        }
        this.trace("Number of ORs with multiple options: " + this._multipleChoiceOrs.size());
        return (edge == null || vKey.getInstalledState() == VKey.InstalledState.COND_PREREQ_CANDIDATE) && ConditionHelper.hasCandidateInstPrereqs(this._graph, vertex);
    }

    @Override
    public void postVisit(TEdge edge, TVertex vertex) {
        super.postVisit(edge, vertex);
        VKey vKey = (VKey)vertex.getKey();
        if (vKey.getType() == VKey.VType.OR_COND) {
            this._multipleChoiceOrs.remove(vertex);
        }
        this.trace("Number of ORs with multiple options: " + this._multipleChoiceOrs.size());
        if (vKey.getInstalledState() == VKey.InstalledState.COND_PREREQ_CANDIDATE) {
            switch (vKey.getType()) {
                case AND_COND: {
                    this.setAndVertexItemState(vertex);
                    break;
                }
                case OR_COND: {
                    this.setOrVertexItemState(vertex);
                }
            }
        }
    }

    private void setAndVertexItemState(TVertex vertex) {
        VKey vKey = (VKey)vertex.getKey();
        assert (vKey.getType() == VKey.VType.AND_COND && vKey.getInstalledState() == VKey.InstalledState.COND_PREREQ_CANDIDATE);
        ArrayList<TVertex> condConflicts = new ArrayList<TVertex>();
        boolean hasCondPrereq = false;
        for (TEdge outEdge : this._graph.getOutgoingEdges(vertex)) {
            TVertex outV = (TVertex)outEdge.getDest();
            VKey outVKey = (VKey)outV.getKey();
            if (((EKey)outEdge.getKey()).getType() == EKey.EType.CONFLICTS) {
                this.trace("Processing conflict " + outVKey);
                if (outVKey.getInstalledState() != VKey.InstalledState.COND_CONFL_CANDIDATE) continue;
                condConflicts.add(outV);
                continue;
            }
            this.trace("Processing prerequisite " + outVKey);
            if (outVKey.getInstalledState() != VKey.InstalledState.COND_PREREQ_CANDIDATE) continue;
            this.trace("Found conditinally satisfied option " + vKey);
            hasCondPrereq = true;
            break;
        }
        if (!hasCondPrereq && (condConflicts.isEmpty() || this._multipleChoiceOrs.isEmpty())) {
            this._ableToResolveCondition = true;
            vKey.setInstalledState(VKey.InstalledState.INSTALLED);
            this.trace(vKey + " is resolved");
            for (TVertex confl : condConflicts) {
                VKey conflKey = (VKey)confl.getKey();
                this.trace("Marked " + conflKey + " as " + (Object)((Object)VKey.InstalledState.CONFLICTS_WITH_INSTALLED));
                conflKey.setInstalledState(VKey.InstalledState.CONFLICTS_WITH_INSTALLED);
            }
        } else {
            this.trace(vKey + " is unresolved");
        }
    }

    private void setOrVertexItemState(TVertex vertex) {
        VKey vKey = (VKey)vertex.getKey();
        assert (vKey.getType() == VKey.VType.OR_COND && vKey.getInstalledState() == VKey.InstalledState.COND_PREREQ_CANDIDATE);
        ArrayList<TVertex> condConflicts = new ArrayList<TVertex>();
        boolean resolved = false;
        boolean hasCondPrereq = false;
        block8: for (TEdge outEdge : this._graph.getOutgoingEdges(vertex)) {
            TVertex outV = (TVertex)outEdge.getDest();
            VKey outVKey = (VKey)outV.getKey();
            if (((EKey)outEdge.getKey()).getType() == EKey.EType.CONFLICTS) {
                this.trace("Processing conflict " + outVKey);
                switch (outVKey.getInstalledState()) {
                    case CONFLICTS_WITH_INSTALLED: {
                        resolved = true;
                        continue block8;
                    }
                    case COND_CONFL_CANDIDATE: {
                        condConflicts.add(outV);
                        continue block8;
                    }
                }
                continue;
            }
            this.trace("Processing prerequisite " + outVKey);
            switch (outVKey.getInstalledState()) {
                case INSTALLED: {
                    resolved = true;
                    break;
                }
                case COND_PREREQ_CANDIDATE: {
                    hasCondPrereq = true;
                    break;
                }
            }
        }
        if (!resolved && this._multipleChoiceOrs.isEmpty() && !hasCondPrereq && condConflicts.size() == 1) {
            this.trace(vKey + " is resolved because there was single unconditionally reached conflict remaining.");
            resolved = true;
            VKey conflKey = (VKey)((TVertex)condConflicts.get(0)).getKey();
            this.trace("Marked " + conflKey + " as " + (Object)((Object)VKey.InstalledState.CONFLICTS_WITH_INSTALLED));
            conflKey.setInstalledState(VKey.InstalledState.CONFLICTS_WITH_INSTALLED);
            vKey.setInstalledState(VKey.InstalledState.INSTALLED);
        }
        if (resolved) {
            this._ableToResolveCondition = true;
            vKey.setInstalledState(VKey.InstalledState.INSTALLED);
            this.trace(vKey + " is resolved");
        } else {
            this.trace(vKey + " is unresolved.");
        }
    }
}

