/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency;

import com.oracle.cie.dependency.ConditionHelper;
import com.oracle.cie.dependency.EKey;
import com.oracle.cie.dependency.TEdge;
import com.oracle.cie.dependency.TVertex;
import com.oracle.cie.dependency.VKey;
import com.oracle.cie.dependency.graph.DirectedGraph;
import com.oracle.cie.dependency.graph.VisitorAdaptor;
import java.io.PrintStream;

class InstalledCondCandMarker
extends VisitorAdaptor<VKey, TVertex, EKey, TEdge, DirectedGraph<VKey, TVertex, EKey, TEdge>> {
    private DirectedGraph<VKey, TVertex, EKey, TEdge> _graph;

    public InstalledCondCandMarker(DirectedGraph<VKey, TVertex, EKey, TEdge> graph, PrintStream traceOut) {
        super(traceOut);
        this._graph = graph;
    }

    @Override
    public void preOp(DirectedGraph<VKey, TVertex, EKey, TEdge> graph) {
        if (this._graph != graph) {
            throw new IllegalArgumentException("Graph is not the one this visitor was created with!!!");
        }
    }

    @Override
    public boolean preVisit(TEdge edge, TVertex vertex) {
        super.preVisit(edge, vertex);
        VKey vKey = (VKey)vertex.getKey();
        if (vKey.getInstalledState() == VKey.InstalledState.COND_PREREQ_CANDIDATE) {
            assert (vKey.getType() == VKey.VType.AND_COND || vKey.getType() == VKey.VType.OR_COND);
            vKey.setInstalledState(VKey.InstalledState.COND_PREREQ);
            for (TEdge outE : this._graph.getOutgoingEdges(vertex)) {
                VKey outVKey = (VKey)((TVertex)outE.getDest()).getKey();
                if (((EKey)outE.getKey()).getType() != EKey.EType.CONFLICTS || outVKey.getInstalledState() != VKey.InstalledState.COND_CONFL_CANDIDATE) continue;
                outVKey.setInstalledState(VKey.InstalledState.COND_CONFL);
            }
        }
        return (edge == null || vKey.getInstalledState() == VKey.InstalledState.COND_PREREQ) && ConditionHelper.hasCandidateInstPrereqs(this._graph, vertex);
    }
}

