/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.system.bundle;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import oracle.opatch.system.bundle.BundleXMLException;
import oracle.opatch.system.bundle.BundleXMLValidationException;
import oracle.opatch.system.bundle.jaxb.Bundle;
import org.xml.sax.SAXException;

public class BundleHelper {
    private static final BundleHelper thisObj = new BundleHelper();
    private final Schema schema;
    private final JAXBContext jbc;

    private BundleHelper() {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            this.schema = sf.newSchema(this.getClass().getResource("/oracle/opatch/system/bundle/xsd/bundle.xsd"));
        }
        catch (SAXException e) {
            throw new BundleXMLException("Bundle Schema is invalid", e);
        }
        try {
            this.jbc = JAXBContext.newInstance((String)"oracle.opatch.system.bundle.jaxb", (ClassLoader)this.getClass().getClassLoader());
        }
        catch (JAXBException e) {
            throw new BundleXMLException("Failed to get JAXB context", e);
        }
    }

    public static BundleHelper getInstance() {
        return thisObj;
    }

    public Bundle readBundle(File xmlFile, boolean validate) throws BundleXMLValidationException {
        try {
            return this.readBundle(this.getFileContent(xmlFile), validate);
        }
        catch (IOException e) {
            throw new BundleXMLValidationException(null, e);
        }
    }

    public Bundle readBundle(InputStream stream, boolean validate) throws BundleXMLValidationException {
        try {
            return this.readBundle(this.getContent(stream), validate);
        }
        catch (IOException e) {
            throw new BundleXMLValidationException(null, e);
        }
    }

    public Bundle readBundle(String content, boolean validate) throws BundleXMLValidationException {
        Object obj;
        if (validate) {
            Validator v = this.schema.newValidator();
            try {
                v.validate(new StreamSource(new StringReader(content)));
            }
            catch (SAXException ex) {
                throw new BundleXMLValidationException("Error validating bundle", ex);
            }
            catch (IOException ex) {
                throw new BundleXMLValidationException("Error reading bundle", ex);
            }
        }
        Unmarshaller unmarshal = null;
        try {
            unmarshal = this.jbc.createUnmarshaller();
        }
        catch (JAXBException ex) {
            throw new BundleXMLException("Error creating unmarshaller", ex);
        }
        try {
            JAXBElement root = unmarshal.unmarshal((Source)new StreamSource(new StringReader(content)), Bundle.class);
            obj = root.getValue();
        }
        catch (JAXBException ex) {
            throw new BundleXMLValidationException("Error unmarshalling bundle", (Exception)((Object)ex));
        }
        if (!(obj instanceof Bundle)) {
            throw new BundleXMLException("Error: The file does not contain valid bundle XML!", null);
        }
        return (Bundle)obj;
    }

    private String getFileContent(File file) throws IOException {
        assert (file != null);
        assert (file.isFile());
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line + "\n");
        }
        br.close();
        return sb.toString();
    }

    private String getContent(InputStream is) throws IOException {
        assert (is != null);
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line + "\n");
        }
        br.close();
        return sb.toString();
    }
}

