/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.utils;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class Util {
    private static final Logger _logger = Logger.getLogger(Util.class.getName());
    private static final String SUFFIX = "}";
    private static final String PREFIX = "{";
    private static final String B_SLASH = "\"";
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";

    public static boolean equals(String str1, String str2) {
        return Util.equals(str1, str2, false);
    }

    public static boolean equals(String str1, String str2, boolean ignoreCase) {
        if (str1 != null) {
            return ignoreCase ? str1.equalsIgnoreCase(str2) : str1.equals(str2);
        }
        return false;
    }

    public static boolean isNullOrBlank(String str, boolean trim) {
        return str == null || (trim ? str.trim() : str).length() == 0;
    }

    public static boolean isEmpty(Collection c) {
        return c == null || c.isEmpty();
    }

    public static boolean isEmpty(Map m) {
        return m == null || m.isEmpty();
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isFileExists(String file) {
        if (Util.isNullOrBlank(file, true)) {
            return false;
        }
        return Files.exists(NioHelper.getInstance().getPath(file.trim(), new String[0]), new LinkOption[0]);
    }

    public static boolean isFileExists(String file, boolean isDir) {
        if (Util.isNullOrBlank(file, true)) {
            return false;
        }
        Path path = NioHelper.getInstance().getPath(file.trim(), new String[0]);
        boolean retVal = Files.exists(path, new LinkOption[0]);
        retVal = isDir ? retVal && Files.isDirectory(path, new LinkOption[0]) : retVal && Files.isRegularFile(path, new LinkOption[0]);
        return retVal;
    }

    public static String[] getStringArray(String value) {
        return Util.getStringArray(value, false);
    }

    public static String[] getStringArray(String value, boolean stripQuotes) {
        if (value == null) {
            return new String[0];
        }
        if ((value = value.trim()).startsWith(PREFIX) && value.endsWith(SUFFIX)) {
            value = value.substring(1, value.length() - 1);
        }
        String[] stringList = value.split(",");
        if (stripQuotes) {
            for (int i = 0; i < stringList.length; ++i) {
                stringList[i] = Util.stripQuotes(stringList[i]);
            }
        }
        return stringList;
    }

    public static String stripQuotes(String s) {
        if (s.startsWith(B_SLASH) && s.endsWith(B_SLASH)) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String getString(Collection<String> c) {
        if (Util.isEmpty(c)) {
            return "";
        }
        return Util.getString(c.toArray(new String[0]));
    }

    public static String getString(String[] c) {
        if (Util.isEmpty(c)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : c) {
            sb.append(s).append(",");
        }
        String retVal = sb.toString();
        return retVal.substring(0, retVal.lastIndexOf(","));
    }

    public static String getInputString(String[] c) {
        return PREFIX + Util.getString(c) + SUFFIX;
    }

    public static Properties getProperties(String file) throws IOException {
        if (!Util.isFileExists(file)) {
            return new Properties();
        }
        Properties props = new Properties();
        try (FileInputStream fs = null;){
            fs = new FileInputStream(file);
            props.load(fs);
        }
        return props;
    }

    public static File[] getXMLFiles(String dir) {
        Object[] xmls;
        if (Util.isFileExists(dir, true) && !Util.isEmpty(xmls = new File(dir).listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname != null && pathname.isFile() && pathname.getName().endsWith(".xml");
            }
        }))) {
            return xmls;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEmptyFile(String file) {
        if (!Util.isFileExists(file)) {
            return true;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            if (fis.read() != -1) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static File getTempDir() {
        return new File(System.getProperty(JAVA_IO_TMPDIR));
    }

    public static File getCanonicalFile(String path) {
        if (Util.isNullOrBlank(path, true)) {
            throw new IllegalArgumentException("getCanonicalPath: null or empty path");
        }
        File f = new File(path.trim());
        try {
            return f.getCanonicalFile();
        }
        catch (Exception e) {
            return f.getAbsoluteFile();
        }
    }

    public static String getCanonicalPath(String path) {
        return Util.getCanonicalFile(path).getPath();
    }

    public static long getDiskFree(String path) {
        if (path == null || ComdevHelper.isUNCPath((String)path)) {
            return 0L;
        }
        long usable = 0L;
        File f = new File(path).getAbsoluteFile();
        File parent = f.getParentFile();
        while (!f.exists() && parent != null) {
            f = parent;
            parent = f.getParentFile();
        }
        if (f.exists()) {
            usable = f.getUsableSpace();
        }
        _logger.finest("path=" + path + " f=" + f + " usable=" + usable);
        return usable;
    }

    public static String getNextGenReleaseVersion() {
        return "13.9.5.0.0";
    }
}

