/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.inputs.impl;

import com.oracle.cie.nextgen.common.NLS;
import com.oracle.cie.nextgen.common.inputs.apis.Variable;
import com.oracle.cie.nextgen.common.inputs.apis.Variables;
import com.oracle.cie.nextgen.common.inputs.enums.OperationModeType;
import com.oracle.cie.nextgen.common.inputs.enums.ValueSourceType;
import com.oracle.cie.nextgen.common.inputs.helpers.InputsUtil;
import com.oracle.cie.nextgen.common.inputs.impl.InputHandlerException;
import com.oracle.cie.nextgen.common.inputs.impl.OUIInputs;
import com.oracle.cie.nextgen.common.inputs.impl.VariableImpl;
import com.oracle.cie.nextgen.common.inputs.parser.VariablesParser;
import com.oracle.cie.nextgen.common.utils.Util;
import com.oracle.xmlns.oui.variables.VariablesType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class OUIVariables
extends OUIInputs
implements Variables {
    private static final Logger _logger = Logger.getLogger(OUIVariables.class.getName());
    private Map<String, Map<String, Variable>> _ouiVariables;

    public OUIVariables() {
        VariablesParser.reset();
    }

    @Override
    public void configure(String variablesXml) {
        VariablesParser.reset();
        try {
            VariablesParser.getInstance().configure(variablesXml);
        }
        catch (InputHandlerException e) {
            _logger.finest(e.getMessage());
        }
    }

    @Override
    public boolean processCommandLine(Map<String, String> varMap, boolean ignoreInvalidArgs) throws InputHandlerException {
        return this.processCommandLine(varMap, ignoreInvalidArgs, false);
    }

    @Override
    public boolean processCommandLine(Map<String, String> varMap, boolean ignoreInvalidArgs, boolean isHelp) throws InputHandlerException {
        try {
            if (varMap == null) {
                varMap = new HashMap<String, String>(0);
            }
            this.clearError();
            VariablesParser parser = VariablesParser.getInstance();
            this.isCaseSensitive = parser.isCaseSensitive();
            this._passedInputs = new HashSet<String>(varMap.keySet());
            if (!isHelp) {
                this.checkMutuvallyExclusiveVariables();
                if (!Util.isEmpty(this._invalidDistinctInputs)) {
                    this.addErrorMsg(NLS.getMsg("variables.mutuvally.exclusive", Util.getString(this._invalidDistinctInputs)));
                }
            }
            this._ouiVariables = parser.getVariables();
            if (!isHelp) {
                this.validateVariables(varMap);
            }
        }
        catch (Exception e) {
            throw new InputHandlerException(e);
        }
        return Util.isEmpty(this.getErrorMessages());
    }

    private void validateVariables(Map<String, String> varMap) {
        if (!this.isCaseSensitive) {
            for (String prefix : this._ouiVariables.keySet()) {
                this.addCaseMap(this._ouiVariables.get(prefix).keySet());
            }
        }
        boolean success = true;
        for (String variable : varMap.keySet()) {
            if (this.setValue(variable, varMap.get(variable), ValueSourceType.CMD)) continue;
            success = false;
        }
        if (!success) {
            this.addErrorMessages();
        }
    }

    private void checkMutuvallyExclusiveVariables() throws InputHandlerException {
        Map<String, Set<String>> uniqueGroups;
        if (this._invalidDistinctInputs == null) {
            this._invalidDistinctInputs = new HashSet();
        }
        if (!Util.isEmpty(uniqueGroups = VariablesParser.getInstance().getUniqueGroups())) {
            for (String group : uniqueGroups.keySet()) {
                Set<String> variables;
                Set<String> meVariables = uniqueGroups.get(group);
                if (!this.isCaseSensitive) {
                    this.addCaseMap(meVariables);
                }
                if (Util.isEmpty(variables = InputsUtil.getInterSection(meVariables, this.getDeclaredKeys(this._passedInputs))) || variables.size() <= 1) continue;
                this._invalidDistinctInputs.addAll(variables);
            }
        }
    }

    private boolean setValue(String variable, String value, ValueSourceType sourceType) {
        VariableImpl var;
        if (!InputsUtil.isComponentVariable(variable) && (var = (VariableImpl)this.getVariable(variable)) != null) {
            var.setValueSource(sourceType);
            return this.setValue(var, InputsUtil.getValueObject(value, var.getDataType()));
        }
        this._invalidInputs.add(variable);
        return false;
    }

    private boolean setValue(String variable, Object value) {
        VariableImpl var;
        if (!InputsUtil.isComponentVariable(variable) && (var = (VariableImpl)this.getVariable(variable)) != null) {
            var.setValueSource(ValueSourceType.API);
            return this.setValue(var, value);
        }
        this._invalidInputs.add(variable);
        return false;
    }

    private boolean setValue(Variable var, Object value) {
        _logger.finest(" Setting Input handler variable : " + var.getName() + " : " + (var.isSecure() ? "######" : value));
        if (value == null) {
            this._valueMissing.add(var.getName());
        } else {
            try {
                var.setValue(value);
                if (var.validate()) {
                    return true;
                }
                this.addErrorMsg(var.getErrorMessage());
            }
            catch (Exception e) {
                this._invalidValues.add(var.getName());
            }
        }
        return false;
    }

    @Override
    public boolean setVariable(String variable, Object value) {
        this.clearError();
        boolean success = this.setValue(variable, value);
        if (!success) {
            this.addErrorMessages();
        }
        return success;
    }

    @Override
    public boolean setVariables(Map<String, Object> variables) {
        this.clearError();
        boolean success = true;
        for (String key : variables.keySet()) {
            if (this.setValue(key, variables.get(key))) continue;
            success = false;
        }
        if (!success) {
            this.addErrorMessages();
        }
        return success;
    }

    @Override
    public boolean updateVariable(String variable, String value) {
        this.clearError();
        boolean success = this.setValue(variable, value, ValueSourceType.API);
        if (!success) {
            this.addErrorMessages();
        }
        return success;
    }

    @Override
    public boolean updateVariables(Map<String, String> variables) {
        this.clearError();
        boolean success = true;
        for (String key : variables.keySet()) {
            if (this.setValue(key, variables.get(key), ValueSourceType.API)) continue;
            success = false;
        }
        if (!success) {
            this.addErrorMessages();
        }
        return success;
    }

    public boolean invalidVariablesExists() {
        return !Util.isEmpty(this._invalidInputs);
    }

    private void addErrorMessages() {
        this.addInvalidMsg("variables.invalid", "variables.value.missing", "variables.invalid.value");
    }

    @Override
    public Variable getVariable(String name) {
        if (!Util.isEmpty(this._ouiVariables)) {
            for (String type : this._ouiVariables.keySet()) {
                Map<String, Variable> vars = this.getValidVariables(type);
                if (!this.isCaseSensitive) {
                    name = this.getDeclaredKey(name);
                }
                if (!vars.containsKey(name)) continue;
                return vars.get(name);
            }
        }
        return null;
    }

    @Override
    public Map<String, Variable> getValidVariables() {
        if (!Util.isEmpty(this._ouiVariables)) {
            HashMap<String, Variable> vars = new HashMap<String, Variable>();
            for (String type : this._ouiVariables.keySet()) {
                vars.putAll(this.getValidVariables(type));
            }
            return vars;
        }
        return new HashMap<String, Variable>(0);
    }

    @Override
    public Map<String, Variable> getInstallerVariables() {
        return this.getValidVariables(VariablesType.INSTALLER.name());
    }

    @Override
    public Map<String, Variable> getProductVariables() {
        return this.getValidVariables(VariablesType.PRODUCT.name());
    }

    @Override
    public Map<String, Variable> getComponentVariables() {
        return this.getValidVariables(VariablesType.COMPONENT.name());
    }

    @Override
    public boolean validateMandatoryVariables(OperationModeType operation) {
        try {
            this.clearError();
            Set<String> mandatoryVars = VariablesParser.getInstance().getMandatoryVariables(operation.getMode());
            if (Util.isEmpty(mandatoryVars)) {
                return true;
            }
            for (String var : mandatoryVars) {
                if (this.getVariable(var).isValueSet()) continue;
                this._valueMissing.add(var);
            }
        }
        catch (InputHandlerException e) {
            _logger.finest(e.getMessage());
        }
        if (!Util.isEmpty(this._valueMissing)) {
            String msg = NLS.getMsg("variables.mandatory.missing", Util.getString(this._valueMissing));
            this.addErrorMsg(msg);
            _logger.finest(msg);
            return false;
        }
        return true;
    }

    private Map<String, Variable> getValidVariables(String type) {
        if (!Util.isEmpty(this._ouiVariables) && this._ouiVariables.containsKey(type)) {
            return Collections.unmodifiableMap(this._ouiVariables.get(type));
        }
        return new HashMap<String, Variable>(0);
    }

    @Override
    public void unsetVariable(String name) {
        VariableImpl var = (VariableImpl)this.getVariable(name);
        if (var != null) {
            var.setValueSource(ValueSourceType.API);
            var.setValue(null);
        }
    }

    @Override
    public Map<String, String> getHelpDetails() {
        if (Util.isEmpty(this._ouiVariables)) {
            return new HashMap<String, String>(0);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String prefix : this._ouiVariables.keySet()) {
            Map<String, Variable> variables = this._ouiVariables.get(prefix);
            for (Map.Entry<String, Variable> variable : variables.entrySet()) {
                String help = variable.getValue().getHelp();
                if (Util.isNullOrBlank(help, true)) continue;
                map.put(variable.getKey(), help);
            }
        }
        return Collections.unmodifiableMap(map);
    }
}

