/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.ini;

import com.oracle.cie.nextgen.common.NLS;
import com.oracle.cie.nextgen.common.ini.IniObject;
import com.oracle.cie.nextgen.common.ini.IniParsingException;

public class IniPair
extends IniObject {
    private String m_sName;
    private String m_sValue;
    private static final String EQUAL = "=";
    private boolean m_bValueFinal = true;
    private boolean m_bPreserveFormat = false;
    private static final String RHS_TERMINATOR = " \\";
    private static final char ENV_VAR_SEPARATOR = '%';
    private static final String DOUBLE_PERCENT_SIGN = "%%";
    private static final String SINGLE_PERCENT_SIGN = "%";

    public IniPair(String name, String value) throws IniParsingException {
        this(name, value, false);
    }

    public IniPair(String name, String value, boolean bPreserveFormat) throws IniParsingException {
        this(name, value, bPreserveFormat, 0);
    }

    public IniPair(String name, String value, boolean bPreserveFormat, int lineNumber) throws IniParsingException {
        this.m_sName = name.trim();
        this.m_sValue = value.trim();
        this.m_bPreserveFormat = bPreserveFormat;
        this.setStartLineNumber(lineNumber);
        this.updateValue();
    }

    public String getName() {
        return this.m_sName;
    }

    public String getValue() {
        return this.m_sValue;
    }

    public void setValue(String sValue) {
        this.m_sValue = sValue.trim();
    }

    public boolean isValueFinal() {
        return this.m_bValueFinal;
    }

    public void addValueLine(String value) throws IniParsingException {
        if (this.m_bValueFinal) {
            return;
        }
        this.m_sValue = this.m_sValue + value;
        this.updateValue();
    }

    private void updateValue() throws IniParsingException {
        if (this.m_sValue.endsWith(RHS_TERMINATOR)) {
            this.m_bValueFinal = false;
            this.m_sValue = !this.m_bPreserveFormat ? this.m_sValue.substring(0, this.m_sValue.length() - RHS_TERMINATOR.length()) : this.m_sValue + IniObject.NEW_LINE;
        } else {
            this.m_bValueFinal = true;
            if (!this.m_bPreserveFormat) {
                this.m_sValue = this.instantiateEnvVars(this.m_sValue);
            }
        }
    }

    private String instantiateEnvVars(String sText) throws IniParsingException {
        StringBuffer sbOutput = new StringBuffer();
        int len = sText.length();
        for (int i = 0; i < len; ++i) {
            String sEnvVarName;
            int idx1 = sText.indexOf(37, i);
            if (idx1 == -1) {
                sbOutput.append(sText.substring(i));
                break;
            }
            if (idx1 == sText.indexOf(DOUBLE_PERCENT_SIGN, i)) {
                sbOutput.append(sText.substring(i, idx1 + 1));
                i = idx1 + 1;
                continue;
            }
            int idx2 = sText.indexOf(37, idx1 + 1);
            if (idx2 == -1) {
                sEnvVarName = sText.substring(idx1);
                throw new IniParsingException(NLS.getMsg("S_ENV_VAR_NOT_FOUND", sEnvVarName));
            }
            sbOutput.append(sText.substring(i, idx1));
            sEnvVarName = sText.substring(idx1 + 1, idx2);
            String sEnvVarValue = System.getenv(sEnvVarName);
            if (sEnvVarValue == null) {
                throw new IniParsingException(NLS.getMsg("S_ENV_VAR_NOT_FOUND", sEnvVarName));
            }
            sbOutput.append(sEnvVarValue);
            i = idx2;
        }
        return sbOutput.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_sName);
        sb.append(EQUAL);
        sb.append(this.m_sValue);
        return sb.toString();
    }
}

