/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.platform;

import com.oracle.cie.gdr.platform.InfoHolder;
import java.util.Collection;
import java.util.HashSet;

public class GroupInfoHolder
implements InfoHolder {
    private int _id;
    private String _name;
    private boolean _topLevel;
    private Collection<Integer> _platforms;
    private Collection<Integer> _groups;

    public GroupInfoHolder(int id, String name) {
        this(id, name, false);
    }

    public GroupInfoHolder(int id, String name, boolean topLevel) {
        this._id = id;
        this._name = name;
        this._topLevel = topLevel;
        this._platforms = new HashSet<Integer>();
        this._groups = new HashSet<Integer>();
    }

    @Override
    public int getId() {
        return this._id;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public boolean isTopLevel() {
        return this._topLevel;
    }

    public Collection<Integer> getPlatforms() {
        return this._platforms;
    }

    public void addPlatform(int id) {
        this._platforms.add(id);
    }

    public boolean hasPlatform(int id) {
        return this._platforms.contains(id);
    }

    public void addGroup(int id) {
        this._groups.add(id);
    }

    public Collection<Integer> getGroups() {
        return this._groups;
    }

    public boolean hasGroup(int id) {
        return this._groups.contains(id);
    }
}

