/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.nio;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;

public class NioCopy {
    public static void copy(Path source, Path dest) throws IOException {
        NioCopy.copy(source, dest, false, true);
    }

    public static void copy(Path source, Path dest, DirectoryStream.Filter<Path> filter) throws IOException {
        NioCopy.copy(source, dest, false, true, filter);
    }

    public static void copy(Path source, Path dest, boolean copyAttributes, boolean followLinks) throws IOException {
        NioCopy.copy(source, dest, copyAttributes, followLinks, null);
    }

    public static void copy(Path source, Path dest, boolean copyAttributes, boolean followLinks, DirectoryStream.Filter<Path> filter) throws IOException {
        if (!Files.exists(source, new LinkOption[0])) {
            throw new FileNotFoundException("The source file does not exist: " + source);
        }
        if (Files.isDirectory(source, new LinkOption[0])) {
            if (Files.exists(dest, new LinkOption[0]) && !Files.isDirectory(dest, new LinkOption[0])) {
                throw new IOException("The specified destination is not a directory: " + dest);
            }
            NioCopyFileVisitor fileVisitor = new NioCopyFileVisitor(source, dest, copyAttributes, followLinks, filter);
            AbstractSet fileVisitOptions = followLinks ? EnumSet.of(FileVisitOption.FOLLOW_LINKS) : new HashSet();
            Files.walkFileTree(source, fileVisitOptions, Integer.MAX_VALUE, fileVisitor);
        } else {
            NioCopy.copyFile(source, dest, copyAttributes, followLinks);
        }
    }

    public static void copyFile(Path source, Path dest) throws IOException {
        NioCopy.copyFile(source, dest, false, true);
    }

    public static void copyFile(Path source, Path dest, boolean copyAttributes, boolean followLinks) throws IOException {
        NioCopy.copyFile(source, dest, NioCopy.getFileCopyOptions(true, copyAttributes, followLinks));
    }

    public static void copyFile(Path source, Path dest, List<CopyOption> copyOptions) throws IOException {
        DosFileAttributeView attrs;
        if (source == null) {
            throw new NullPointerException("The source provided was null.");
        }
        if (dest == null) {
            throw new NullPointerException("The dest provided was null.");
        }
        Path parent = dest.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        Files.copy(source, dest, copyOptions != null ? copyOptions.toArray(new CopyOption[0]) : new CopyOption[]{});
        if (copyOptions != null && !copyOptions.contains(StandardCopyOption.COPY_ATTRIBUTES) && ComdevHelper.isWindows() && (attrs = Files.getFileAttributeView(dest, DosFileAttributeView.class, new LinkOption[0])) != null) {
            attrs.setReadOnly(false);
        }
    }

    public static void copyFile(InputStream source, Path dest) throws IOException {
        NioCopy.copyFile(source, dest, NioCopy.getInputStreamCopyOptions(true));
    }

    public static void copyFile(InputStream source, Path dest, List<CopyOption> copyOptions) throws IOException {
        if (source == null) {
            throw new NullPointerException("The source provided was null.");
        }
        if (dest == null) {
            throw new NullPointerException("The dest provided was null.");
        }
        Path parent = dest.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        NioHelper.getInstance().copy(source, dest, copyOptions != null ? copyOptions.toArray(new CopyOption[0]) : new CopyOption[]{});
    }

    public static List<CopyOption> getFileCopyOptions(boolean replaceExisting, boolean copyAttributes, boolean followLinks) {
        ArrayList<CopyOption> copyOptions = new ArrayList<CopyOption>();
        if (replaceExisting) {
            copyOptions.add(StandardCopyOption.REPLACE_EXISTING);
        }
        if (copyAttributes) {
            copyOptions.add(StandardCopyOption.COPY_ATTRIBUTES);
        }
        if (!followLinks) {
            copyOptions.add(LinkOption.NOFOLLOW_LINKS);
        }
        return copyOptions;
    }

    public static List<CopyOption> getInputStreamCopyOptions(boolean replaceExisting) {
        return NioCopy.getFileCopyOptions(replaceExisting, false, true);
    }

    static class NioCopyFileVisitor
    implements FileVisitor<Path> {
        private final Path _source;
        private final Path _dest;
        private final boolean _copyAttributes;
        private final boolean _followLinks;
        private final DirectoryStream.Filter<Path> _filter;

        NioCopyFileVisitor(Path source, Path dest, boolean copyAttributes, boolean followLinks, DirectoryStream.Filter<Path> filter) {
            this._source = source.isAbsolute() ? source : source.toAbsolutePath();
            this._dest = dest.isAbsolute() ? dest : dest.toAbsolutePath();
            this._copyAttributes = copyAttributes;
            this._followLinks = followLinks;
            this._filter = filter;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            CopyOption[] copyOptionArray;
            if (this._filter != null && !this._filter.accept(dir)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            if (this._copyAttributes) {
                CopyOption[] copyOptionArray2 = new CopyOption[1];
                copyOptionArray = copyOptionArray2;
                copyOptionArray2[0] = StandardCopyOption.COPY_ATTRIBUTES;
            } else {
                copyOptionArray = new CopyOption[]{};
            }
            CopyOption[] options = copyOptionArray;
            try {
                Files.copy(dir, this._dest.resolve(this._source.relativize(dir.toAbsolutePath()).toString()), options);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (this._filter != null && !this._filter.accept(file)) {
                return FileVisitResult.CONTINUE;
            }
            NioCopy.copyFile(file, this._dest.resolve(this._source.relativize(file.toAbsolutePath()).toString()), this._copyAttributes, this._followLinks);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            throw exc;
        }
    }
}

