/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.di;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.di.Property;
import com.oracle.cie.gdr.utils.OraparamException;
import java.util.List;

public class PlatformSpecific
extends AbstractDataHandlerWrapper {
    public PlatformSpecific(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public String getName() {
        return this.getStringAttribute("name");
    }

    public List<Property> getProperties() {
        return this.getComplexValueWrappedList("property", Property.class);
    }

    public void validate() throws OraparamException {
        List<Property> properties = this.getProperties();
        if (StringUtil.isNullOrEmpty((String)this.getName())) {
            throw new OraparamException("Platform name must not be empty. " + (Object)((Object)this));
        }
        if (this.getName().equals("ALL_PLATFORMS")) {
            throw new OraparamException("Platform name ALL_PLATFORMS is invalid in this context.");
        }
        if (properties != null) {
            for (Property property : properties) {
                property.validate();
            }
        }
    }
}

