/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.util;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.framework.core.oplan.IOUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanUserException;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.util.BootstrapHelper;
import com.oracle.glcm.patch.auto.db.util.BootstrapParams;
import com.oracle.glcm.patch.auto.db.util.BootstrapPlugin;
import com.oracle.glcm.patch.auto.db.util.BootstrapResult;
import com.oracle.glcm.patch.auto.db.utils.BootstrapConstants;
import com.oracle.glcm.patch.auto.db.utils.BootstrapUtil;
import com.oracle.glcm.patch.auto.session.PatchInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.BasePatchFactory;
import oracle.glcm.opatch.common.api.ContentType;
import oracle.glcm.opatch.common.api.InvalidPatchMetadataException;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchNotFoundException;
import oracle.glcm.opatch.common.helpers.PatchHelper;
import oracle.opatchauto.core.patchanalyzer.PatchAnalyzer;

public class PerlBootstrapPlugin
implements BootstrapPlugin {
    private Logger _logger = Logger.getLogger(PerlBootstrapPlugin.class.getName());

    @Override
    public BootstrapResult execute(BootstrapParams bootstrapParams) {
        BootstrapResult bootstrapResult = new BootstrapResult();
        bootstrapResult.setPluginType(BootstrapResult.PluginType.PERL);
        bootstrapResult.setResult(BootstrapResult.Status.SUCCESS);
        try {
            Properties prop = new Properties();
            String perlPatchPath = this.preparePerlPath(bootstrapParams);
            this._logger.info("PerlPath  is " + perlPatchPath);
            String perlExecutable = BootstrapHelper.getPerlLibPath(bootstrapParams.getBaseLocation(), bootstrapParams.isRemotePatching());
            if (null != perlPatchPath) {
                prop.setProperty(BootstrapConstants.IS_PERL_PATCH.getValue(), "true");
                perlExecutable = perlPatchPath + File.separator + "bin" + File.separator + "perl";
            } else {
                prop.setProperty(BootstrapConstants.IS_PERL_PATCH.getValue(), "false");
            }
            prop.setProperty(BootstrapConstants.PERL_PATH.getValue(), perlExecutable);
            String propertyLocation = System.getProperty(BootstrapConstants.OPATCHAUTO_PATCHWORK_PATH.getValue()) + File.separator + BootstrapConstants.BOOTSTRAP_PROPERTIES.getValue();
            BootstrapUtil.storePropertiesFile((Properties)prop, (String)propertyLocation, (boolean)true);
        }
        catch (Exception ex) {
            this._logger.severe(ex.getMessage());
            bootstrapResult.setResult(BootstrapResult.Status.FAILED);
            bootstrapResult.setErrorCode(72145);
            bootstrapResult.setErrorMessage(ex.getMessage());
        }
        this._logger.info("Completed perl bootstrapping with result " + bootstrapResult);
        return bootstrapResult;
    }

    private String preparePerlPath(BootstrapParams bootstrapParams) throws OPatchAutoException {
        List<File> patchLocations;
        String perlLocation = null;
        PatchInfo patchInfo = bootstrapParams.getPatchInfo();
        if (null != patchInfo && null != (patchLocations = this.getPerlPatches(patchInfo, bootstrapParams.getHomes(), bootstrapParams.getInvPtrLocation()))) {
            if (BootstrapParams.OperationType.APPLY.equals((Object)bootstrapParams.getOperationType())) {
                Iterator<File> iterator = patchLocations.iterator();
                if (iterator.hasNext()) {
                    File patchLocation = iterator.next();
                    File perlPatchLocation = this.getPerlPathFromPatch(patchLocation.toPath(), null != patchInfo.getPatchId());
                    this._logger.info("The location of the perl folder in the patch is " + perlPatchLocation);
                    if (null != perlPatchLocation) {
                        perlLocation = this.copyAndInstantiatePerl(perlPatchLocation, bootstrapParams.getCredential(), bootstrapParams.getBaseLocation());
                        return perlLocation;
                    }
                    this._logger.severe("There is no perl package present in the patch");
                    throw new OPatchAutoException("There is no perl package present in the patch for " + patchLocation, new Object[0]);
                }
            } else {
                File perlPatchLocation = new File(bootstrapParams.getBaseLocation(), "perl");
                perlLocation = this.copyAndInstantiatePerl(perlPatchLocation, bootstrapParams.getCredential(), bootstrapParams.getBaseLocation());
                return perlLocation;
            }
        }
        return perlLocation;
    }

    private File getPerlPathFromPatch(Path patchPath, boolean isRollbackIds) throws OPatchAutoException {
        File perlPath = null;
        try (DirectoryStream<Path> filePaths = Files.newDirectoryStream(patchPath, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path currentPath) {
                return currentPath.toFile().isDirectory() || currentPath.getFileName().toString().endsWith(".zip");
            }
        });){
            for (Path path : filePaths) {
                if (path.getFileName().toString().toLowerCase().contains(ContentType.PERL.getValue().toLowerCase())) {
                    if (!isRollbackIds && (isRollbackIds || !path.getParent().getFileName().toString().equals("files"))) continue;
                    perlPath = path.toFile();
                } else if (path.getFileName().toString().endsWith(".zip") || null == (perlPath = this.getPerlPathFromPatch(path, isRollbackIds))) continue;
                break;
            }
        }
        catch (IOException e) {
            throw new OPatchAutoException("Exception while reading the patch files for " + patchPath, new Object[0]);
        }
        return perlPath;
    }

    private String copyAndInstantiatePerl(File perlPath, Credential credential, String home) throws OPatchAutoException {
        String currentUser = System.getProperty("user.name");
        if (!StringUtil.isNullOrEmpty((String)currentUser, (boolean)true) && "root".equalsIgnoreCase(currentUser)) {
            currentUser = DBPatchingHelper.getHomeOwner((String)home);
        }
        byte[] password = null;
        if (null != credential) {
            password = OPatchAutoHelper.toBytes((char[])credential.getPassword());
        }
        String patchWorkLocation = System.getProperty(BootstrapConstants.OPATCHAUTO_PATCHWORK_PATH.getValue());
        String bootstrapFolder = new File(patchWorkLocation).getParentFile().getAbsolutePath();
        File dbPerlFolder = new File(bootstrapFolder + File.separator + "perl");
        if (perlPath.getName().endsWith(".zip")) {
            String scriptPath = home + File.separator + DBCommonPatchingConstants.OPATCH_AUTO_BIN_DIR + "ZipUnzip.pl unzip ";
            String command = home + DBCommonPatchingConstants.PERL_RELATIVE_PATH + scriptPath + perlPath + " " + dbPerlFolder.getParentFile().getAbsolutePath();
            GISystemCall.ExecReturn ret = GISystemCall.process((String)command, (String)currentUser, (Credential)credential);
            if (!ret.isOK()) {
                throw new OPatchAutoException("Failed to unzip files on path." + perlPath.getAbsolutePath() + "Error::" + ret.getErrorMessage(), new Object[0]);
            }
        } else {
            try {
                this._logger.info("Copying.... " + perlPath + " to " + dbPerlFolder);
                String copyCommand = "cp -r " + perlPath + " " + dbPerlFolder;
                GISystemCall.ExecReturn ret = GISystemCall.process((String)copyCommand, (String)currentUser, (Credential)credential);
                if (!ret.isOK()) {
                    throw new OPatchAutoException("Exception while copying " + perlPath + " to " + dbPerlFolder + " because " + ret.getErrorMessage(), new Object[0]);
                }
            }
            catch (PatchPlanUserException e) {
                throw new OPatchAutoException("Exception while changing permission of  " + dbPerlFolder + " because " + e.getMessage(), new Object[0]);
            }
        }
        IOUtils.chmodAllFilesOfDirectory((File)dbPerlFolder, (String)"755", (String)currentUser, (byte[])password);
        this.instantiatePerl(dbPerlFolder.getParent().toString(), dbPerlFolder.toPath());
        this._logger.info("Instantiation of perl files is done");
        return dbPerlFolder.getAbsolutePath();
    }

    private List<File> getPerlPatches(PatchInfo patchInfo, List<String> homes, String invPtrLoc) throws OPatchAutoException {
        ArrayList<String> patches = new ArrayList<String>();
        boolean isRollbackWithIDs = false;
        String patchPath = null;
        if (!StringUtil.isNullOrEmpty((String)patchInfo.getPatchLocation())) {
            patchPath = patchInfo.getPatchLocation();
            patches.add(patchPath);
        } else if (!StringUtil.isNullOrEmpty((String)patchInfo.getPatchBaseDirectory())) {
            patchPath = patchInfo.getPatchBaseDirectory();
            File phBaseDirFile = new File(patchPath);
            if (phBaseDirFile.isDirectory()) {
                File[] patchLocs;
                for (File patchPathFile : patchLocs = phBaseDirFile.listFiles()) {
                    if (!patchPathFile.isDirectory()) continue;
                    patches.add(patchPathFile.getAbsolutePath());
                }
            }
        } else if (!StringUtil.isNullOrEmpty((String)patchInfo.getPatchId())) {
            patchPath = patchInfo.getPatchId();
            if (patchPath.trim().equals("PATCH_INFO_NOT_REQ")) {
                this._logger.info("Patch location not updated for " + patchPath);
                return null;
            }
            isRollbackWithIDs = true;
            patches.addAll(Arrays.asList(patchPath.split(",")));
        }
        this._logger.info("The patch path is " + patchPath);
        return this.getPerlPatches(patches, isRollbackWithIDs, homes, invPtrLoc);
    }

    private String getPerlPatchID(String oracleHome, List<Patch> installedpatchList, String patchId) {
        String perlpatchID = null;
        List patchIDList = new ArrayList<String>();
        PatchAnalyzer analyzer = new PatchAnalyzer();
        if (analyzer.isSystemPatch(patchId, oracleHome)) {
            patchIDList = analyzer.getSubPatchIDsForSystemPatchID(patchId, oracleHome);
        } else {
            patchIDList.add(patchId);
        }
        this._logger.info("Patch ID list to verify:" + patchIDList);
        if (installedpatchList != null && !installedpatchList.isEmpty()) {
            block0: for (Patch patch : installedpatchList) {
                this._logger.info("Installed patch ID:" + patch.getPatchId());
                if (!patchIDList.contains(patchId)) continue;
                for (PatchInventory pi : patch.getPatchInventories()) {
                    if (!pi.getPatchChara().getContentType().getValue().equalsIgnoreCase(ContentType.PERL.getValue())) continue;
                    this._logger.info("Patch " + patch.getPatchId() + " is a perl patch.");
                    perlpatchID = patchId;
                    continue block0;
                }
            }
        }
        return perlpatchID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getPerlPatchLocationFromRollbackId(String home, String invPtrLoc, String patchId, List<Patch> installedpatchList) throws OPatchAutoException {
        String patchLocation = null;
        this._logger.info("Verifying if the patch id " + patchId + " is perl patch and if already installed on home " + home);
        final String perlPatchID = this.getPerlPatchID(home, installedpatchList, patchId);
        if (perlPatchID == null) return patchLocation;
        if (perlPatchID.isEmpty()) return patchLocation;
        Path patchStorageDirectoryPath = new File(DBPatchingUtil.getPatchStorageDirectoryPath((String)home)).toPath();
        try (DirectoryStream<Path> filePaths = Files.newDirectoryStream(patchStorageDirectoryPath, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path currentPath) {
                return currentPath.toFile().isDirectory() && currentPath.toFile().getName().startsWith(perlPatchID);
            }
        });){
            Iterator<Path> iterator = filePaths.iterator();
            if (!iterator.hasNext()) return patchLocation;
            Path path = iterator.next();
            File patchStoragePath = path.toFile();
            String string = patchStoragePath.getAbsolutePath();
            return string;
        }
        catch (IOException e) {
            this._logger.severe("Exception while accessing the " + DBPatchingUtil.getPatchStorageDirectoryPath((String)home) + " : " + e.getMessage());
            throw new OPatchAutoException(Integer.toString(72148), new Object[]{home});
        }
    }

    private List<File> getPerlPatches(List<String> patches, boolean rollbackWithIds, List<String> homes, String invPtrLoc) throws OPatchAutoException {
        List<Object> perlPatches = new ArrayList();
        perlPatches = rollbackWithIds ? this.getPerlPatchesForID(patches, homes, invPtrLoc) : this.getPerlPatchesForLocation(patches);
        return perlPatches;
    }

    private List<File> getPerlPatchesForLocation(List<String> patches) throws OPatchAutoException {
        ArrayList<File> perlPatches = new ArrayList<File>();
        for (String patchInfo : patches) {
            try {
                Patch patch = BasePatchFactory.instance().createPatch(new File(patchInfo).getAbsolutePath());
                if (null == patch) continue;
                for (PatchInventory pi : patch.getPatchInventories()) {
                    if (!pi.getPatchChara().getContentType().getValue().equalsIgnoreCase(ContentType.PERL.getValue())) continue;
                    this._logger.info("Patch " + patch.getPatchId() + " is a perl patch.");
                    perlPatches.add(new File(patchInfo));
                }
            }
            catch (PatchNotFoundException e) {
                this._logger.severe("Exception while loading the patch for validating perl patching as the patch type is invalid: " + e.getMessage());
                throw new OPatchAutoException(Integer.toString(72146), new Object[]{patchInfo});
            }
            catch (PatchMetadataLoadingException e) {
                this._logger.severe("Exception while loading the patch meta data: " + e.getMessage());
                throw new OPatchAutoException(Integer.toString(72146), new Object[]{patchInfo});
            }
            catch (InvalidPatchMetadataException e) {
                this._logger.severe("Exception while loading the patch for validating perl patching as the patch meta data is invalid : " + e.getMessage());
                throw new OPatchAutoException(Integer.toString(72146), new Object[]{patchInfo});
            }
        }
        return perlPatches;
    }

    private List<File> getPerlPatchesForID(List<String> patches, List<String> homes, String invPtrLoc) throws OPatchAutoException {
        ArrayList<File> perlPatches = new ArrayList<File>();
        List<Patch> installedPatchList = null;
        if (homes == null) {
            return perlPatches;
        }
        for (String home : homes) {
            installedPatchList = this.getInstalledpatches(home);
            for (String patchInfo : patches) {
                String perlPatchLoc = this.getPerlPatchLocationFromRollbackId(home, invPtrLoc, patchInfo, installedPatchList);
                if (null == perlPatchLoc) continue;
                perlPatches.add(new File(perlPatchLoc));
            }
        }
        return perlPatches;
    }

    private List<Patch> getInstalledpatches(String home) {
        List installedpatches = null;
        try {
            installedpatches = PatchHelper.getPatchesInOH((String)home);
        }
        catch (InvalidPatchMetadataException | PatchMetadataLoadingException | PatchNotFoundException e) {
            this._logger.warning("Failed to get installed patches for home " + home + " due to " + e.getLocalizedMessage());
        }
        return installedpatches;
    }

    private void instantiatePerl(String perlHome, Path perlPathDir) throws OPatchAutoException {
        try (DirectoryStream<Path> filePaths = Files.newDirectoryStream(perlPathDir);){
            for (Path path : filePaths) {
                if (path.toFile().isDirectory()) {
                    this.instantiatePerl(perlHome, path);
                    continue;
                }
                String content = new String(Files.readAllBytes(path));
                if (!content.contains("%ORACLE_HOME%")) continue;
                content = content.replaceAll("%ORACLE_HOME%", perlHome);
                Files.write(path, content.getBytes(), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new OPatchAutoException("Exception while instantiating files under  " + perlPathDir, new Object[0]);
        }
    }
}

