/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.util;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.framework.sdk.util.PatchPlanUtils;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPHomeInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionCookie;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.db.util.BootstrapParams;
import com.oracle.glcm.patch.auto.db.utils.BootstrapConstants;
import com.oracle.glcm.patch.auto.db.utils.BootstrapUtil;
import com.oracle.helper.util.WalletHelper;
import dbmodel.common.OUIComponent;
import dbmodel.common.OracleHome;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;
import oracle.dbsysmodel.driver.sdk.productdriver.LocalInfo;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.ops.mgmt.trace.Trace;
import oracle.sysman.oii.oiii.OiiiVersion;

public class BootstrapHelper {
    private static Logger _logger = Logger.getLogger(BootstrapHelper.class.getName());
    public static final String PERL_PATH = File.separator + "perl" + File.separator + "bin" + File.separator + "perl ";
    private static final String LOG_FILENAME_DATE_FORMAT = "yyyy-MM-dd_hh-mm-ssa";
    private static final String DEFAULT_OOP = "DEFAULT_OOP";
    private static final String SHARD_REMOTE = "-shardremote";

    public static boolean isOOPPatchingSession(List<String> mainArgList) {
        boolean isOOPPatchingSession = false;
        if (mainArgList.indexOf("-outofplace") > 0 || mainArgList.indexOf("-prepare-clone") > 0 || mainArgList.indexOf("-switch-clone") > 0) {
            isOOPPatchingSession = true;
        }
        return isOOPPatchingSession;
    }

    public static String searchBundleXML(File patchDir) throws OPatchAutoException {
        String bundleXMLpath = null;
        ArrayList<String> bundlexmlList = new ArrayList<String>();
        BootstrapHelper.search(patchDir, bundlexmlList);
        if (bundlexmlList.size() > 1) {
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72082), (Object[])new Object[0]), 236);
        }
        if (bundlexmlList.size() == 1) {
            bundleXMLpath = bundlexmlList.get(0);
        }
        _logger.info("Bundle xml file location::" + bundleXMLpath);
        return bundleXMLpath;
    }

    private static void search(File patchDir, ArrayList<String> bundleXMLList) throws OPatchAutoException {
        if (patchDir.isDirectory()) {
            if (patchDir.canRead()) {
                for (File tempFile : patchDir.listFiles()) {
                    if (tempFile.isDirectory()) {
                        BootstrapHelper.search(tempFile, bundleXMLList);
                        continue;
                    }
                    if (!"bundle.xml".equals(tempFile.getName().toLowerCase())) continue;
                    bundleXMLList.add(tempFile.getAbsoluteFile().toString());
                }
            } else {
                throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)"68142", (Object[])new Object[0]), new Object[]{patchDir});
            }
        }
    }

    public static String getValue(List<String> mainArgs, String argument) {
        int argIndex = mainArgs.indexOf(argument);
        String argVal = null;
        if (argIndex != -1) {
            if (argIndex >= mainArgs.size()) {
                return null;
            }
            argVal = mainArgs.get(argIndex + 1);
            argVal = argVal.replaceAll("^\"|\"$", "");
            argVal = argVal.trim();
        }
        return argVal;
    }

    public static void initLogFactory(String logDir, String logLevel) {
        String log = BootstrapHelper.getDefaultLogFileLocation(logDir, "bootstrap");
        LogFactory logFactory = LogFactory.getFactory();
        logFactory.setupLogging(log, logLevel, true, new String[0]);
    }

    public static String getDefaultLogFileLocation(String logDir, String fileName) {
        return logDir.trim() + File.separator + "opatchautodb" + File.separator + fileName + OPatchAutoHelper.getCurrentDateTimeStamp((String)LOG_FILENAME_DATE_FORMAT) + ".log";
    }

    public static String getDefaultLogDir(String home) {
        return home.trim() + File.separator + "cfgtoollogs" + File.separator + "opatchautodb";
    }

    public static String getPerlLibPath(String baseLoc, boolean isRemotenode) throws IOException {
        String perlLibPath = BootstrapUtil.removeTrailingFileSeperator((String)baseLoc) + PERL_PATH;
        String perlExecutable = System.getenv("OPATCHAUTO_PERL_PATH");
        if (!StringUtil.isNullOrEmpty((String)perlExecutable)) {
            perlLibPath = perlExecutable;
        } else if (isRemotenode) {
            perlLibPath = BootstrapUtil.removeTrailingFileSeperator((String)BootstrapHelper.getRemoteNodePerlLibPath(baseLoc)) + PERL_PATH;
        }
        return perlLibPath;
    }

    private static String getRemoteNodePerlLibPath(String baseLoc) throws IOException {
        String remoteNodeperlLibPath = baseLoc + File.separator + "OPatch" + File.separator + "auto" + File.separator + "dbsessioninfo" + File.separator + "perllibpath.txt";
        File remoteNodeperlLibFile = new File(remoteNodeperlLibPath);
        String perllibpath = baseLoc;
        if (remoteNodeperlLibFile.exists()) {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(remoteNodeperlLibFile));
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                perllibpath = line;
            }
            reader.close();
        }
        return perllibpath;
    }

    public static String readFileContents(String filePath) throws IOException {
        String value = null;
        if (new File(filePath).exists()) {
            try (BufferedReader inputFile = new BufferedReader(new FileReader(filePath));){
                value = inputFile.readLine();
                inputFile.close();
            }
        }
        return value;
    }

    public static boolean isVersionEqualOrlater(String versionToCompare, String baseVersion) {
        OiiiVersion versionToCompareObj = new OiiiVersion(versionToCompare);
        OiiiVersion baseVersionObj = new OiiiVersion(baseVersion);
        return versionToCompareObj.equals(baseVersionObj) || versionToCompareObj.laterThan(baseVersionObj);
    }

    public static PatchActionExecutorContainer deserializeContainer(String containerPath) throws OPatchAutoException {
        File containerFile = new File(containerPath);
        if (!containerFile.exists() || !containerFile.isFile()) {
            throw new OPatchAutoException("68068", new Object[0]);
        }
        PatchActionExecutorContainer container = new PatchActionExecutorContainer();
        try {
            FileInputStream fis = new FileInputStream(containerFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            container = (PatchActionExecutorContainer)ois.readObject();
            ois.close();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new OPatchAutoException("68070", new Object[]{e.getMessage()});
        }
        return container;
    }

    public static int execute(ArrayList<String> cmds, boolean reportError) throws OPatchAutoException {
        ProcessBuilder pb = new ProcessBuilder(cmds);
        int retValue = -1;
        try {
            Process process = pb.start();
            retValue = process.waitFor();
            InputStreamReader rader = new InputStreamReader(process.getErrorStream());
            BufferedReader br = new BufferedReader(rader);
            StringBuffer errorOutput = new StringBuffer();
            String line = "";
            while ((line = br.readLine()) != null) {
                errorOutput.append(line);
                errorOutput.append("\n");
            }
            InputStreamReader rader1 = new InputStreamReader(process.getInputStream());
            BufferedReader br1 = new BufferedReader(rader1);
            StringBuffer executionOutput = new StringBuffer();
            String line1 = "";
            while ((line1 = br1.readLine()) != null) {
                executionOutput.append(line1);
                executionOutput.append("\n");
            }
            if (!StringUtil.isNullOrEmpty((String)errorOutput.toString(), (boolean)true)) {
                _logger.info("Script execution output :: " + errorOutput.toString());
            }
            if (!StringUtil.isNullOrEmpty((String)executionOutput.toString(), (boolean)true)) {
                _logger.info("Script execution result output :: " + executionOutput.toString());
            }
            if (retValue != 0 && reportError) {
                if (reportError) {
                    Reporting.report((String)executionOutput.toString());
                } else if (!StringUtil.isNullOrEmpty((String)executionOutput.toString())) {
                    Reporting.report((String)OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72049), (Object[])new Object[]{executionOutput.toString()}));
                } else if (!StringUtil.isNullOrEmpty((String)errorOutput.toString())) {
                    Reporting.report((String)OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72049), (Object[])new Object[]{errorOutput.toString()}));
                }
            }
        }
        catch (Throwable t) {
            _logger.severe("Script execution failed due to ," + t.getMessage());
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72049), (Object[])new Object[0]), new Object[0]);
        }
        return retValue;
    }

    public static void handleOOPNoteMsg(List<String> mainArgList, String crsVer, Properties patchingInfoProperty) {
        if (mainArgList.indexOf("-inplace") < 0) {
            if (mainArgList.contains("-oh")) {
                String ohList = BootstrapHelper.getValue(mainArgList, "-oh");
                if (BootstrapHelper.containsDBTwentyHome(ohList.split(","))) {
                    Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"OPatchauto.OOP.Default.message", (Object[])new Object[0]));
                    patchingInfoProperty.setProperty(DEFAULT_OOP, String.valueOf(true));
                }
            } else if (BootstrapHelper.isVersionEqualOrlater(crsVer, "20.0.0.0.0")) {
                Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"OPatchauto.OOP.Default.message", (Object[])new Object[0]));
                patchingInfoProperty.setProperty(DEFAULT_OOP, String.valueOf(true));
            }
        }
    }

    public static boolean containsDBNineteenHome(String[] homeList) {
        ArrayList<String> ohList = new ArrayList<String>();
        for (String home : homeList) {
            ohList.add(home.trim());
        }
        for (String home : ohList) {
            List homes = OUIDriver.getLocalInfo();
            for (OracleHome oh : homes) {
                _logger.fine("oh: " + oh.getPath());
                if (!BootstrapUtil.removeTrailingFileSeperator((String)home).equalsIgnoreCase(BootstrapUtil.removeTrailingFileSeperator((String)oh.getPath()))) continue;
                List ouiComp = oh.getTopLevelOUI();
                String ver = ((OUIComponent)ouiComp.get(0)).getVersion();
                _logger.fine("version: " + ver);
                if (!BootstrapHelper.isVersionEqualOrlater(ver, "19.0.0.0.0")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsDBTwentyHome(String[] homeList) {
        ArrayList<String> ohList = new ArrayList<String>();
        for (String home : homeList) {
            ohList.add(home.trim());
        }
        for (String home : ohList) {
            List homes = OUIDriver.getLocalInfo();
            for (OracleHome oh : homes) {
                _logger.fine("oh: " + oh.getPath());
                if (!BootstrapUtil.removeTrailingFileSeperator((String)home).equalsIgnoreCase(BootstrapUtil.removeTrailingFileSeperator((String)oh.getPath()))) continue;
                List ouiComp = oh.getTopLevelOUI();
                String ver = ((OUIComponent)ouiComp.get(0)).getVersion();
                _logger.fine("version: " + ver);
                if (!BootstrapHelper.isVersionEqualOrlater(ver, "20.0.0.0.0")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean ignoreWallet(List<String> mainArgList) {
        int indexOfRemote = mainArgList.indexOf(SHARD_REMOTE);
        _logger.info("indexOfRemote: " + indexOfRemote);
        String currentUser = System.getProperty("user.name");
        _logger.info("currentUser: " + currentUser);
        return indexOfRemote == -1 && currentUser.equals("root");
    }

    public static String getVersion(String homePath) {
        LocalInfo _localInfo = BootstrapHelper.createLocalInfo();
        try {
            homePath = new File(homePath).getCanonicalPath();
        }
        catch (IOException e) {
            homePath = new File(homePath).getAbsolutePath();
        }
        String ver = "";
        String oracleHome = "";
        for (OracleHome oh : _localInfo.getOracleHomes()) {
            try {
                oracleHome = new File(oh.getPath()).getCanonicalPath();
            }
            catch (IOException e) {
                oracleHome = new File(oh.getPath()).getAbsolutePath();
            }
            if (!homePath.equals(oracleHome)) continue;
            ver = ((OUIComponent)oh.getTopLevelOUI().get(0)).getVersion();
            break;
        }
        return ver;
    }

    public static List<String> getValidHomes(List<String> ohList) {
        List homes = new ArrayList();
        ArrayList<String> validHomes = new ArrayList<String>();
        homes = null == ohList ? OUIDriver.getLocalInfo() : OUIDriver.getLocalInfo(ohList);
        for (OracleHome oh : homes) {
            List ouiComp = oh.getTopLevelOUI();
            String version = ((OUIComponent)ouiComp.get(0)).getVersion();
            _logger.fine("Version of home " + oh.getPath() + " is " + version);
            if (!DBPatchingUtil.isDBVersionTweleveOrLater((String)version)) continue;
            validHomes.add(oh.getPath());
        }
        return validHomes;
    }

    public static LocalInfo createLocalInfo() {
        LocalInfo _localInfo = new LocalInfo();
        _localInfo.setOracleHomes(OUIDriver.getLocalInfo());
        for (OracleHome oh : _localInfo.getOracleHomes()) {
            _logger.config("Found local home at " + oh.getPath());
        }
        return _localInfo;
    }

    public static void enableSRVMTrace(String logDir) {
        if (_logger.isLoggable(Level.FINEST)) {
            Trace.traceEnabled((boolean)true);
            Trace.setTraceLevel((int)5);
            String logFileName = BootstrapHelper.getDefaultLogFileLocation(logDir, "systemconfig_srvmtrace_");
            boolean ret = Trace.configure((boolean)false, (boolean)false, (boolean)true, (boolean)true, (String)logFileName, (boolean)true);
            Trace.enableLogging((String)logFileName);
            _logger.fine("Enabled SRVMTrace : " + ret);
        }
    }

    public static Credential getWalletInformation(File walletLocation, char[] walletPassword) throws OPatchAutoException {
        Credential credential = null;
        credential = WalletHelper.getCredentialForLocalHost((File)walletLocation, (char[])walletPassword);
        return credential;
    }

    public static String getBashCmd() {
        String bash = "";
        if (new File(DBCommonPatchingConstants.BIN_PATH + File.separator + "bash").exists()) {
            bash = DBCommonPatchingConstants.BIN_PATH + File.separator + "bash";
        } else if (new File(DBCommonPatchingConstants.USR_BIN_PATH + File.separator + "bash").exists()) {
            bash = DBCommonPatchingConstants.USR_BIN_PATH + File.separator + "bash";
        } else {
            int ret = GISystemCall.runTimeExecution((String)"which bash");
            if (ret == 0) {
                bash = "bash";
            }
        }
        return bash;
    }

    public static void cleanSudoSession() throws OPatchAutoException {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(BootstrapHelper.getBashCmd());
        cmds.add("-c");
        cmds.add(BootstrapHelper.getSudoCmd() + " -k");
        int retValue = BootstrapHelper.execute(cmds, false);
        if (retValue != 0) {
            _logger.info("Command execution failed for sudo -k");
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72054), (Object[])new Object[0]), new Object[0]);
        }
    }

    public static String getSudoCmd() throws OPatchAutoException {
        String sudo = "";
        if (new File(DBCommonPatchingConstants.BIN_PATH + File.separator + "sudo").exists()) {
            sudo = DBCommonPatchingConstants.BIN_PATH + File.separator + "sudo";
        } else if (new File(DBCommonPatchingConstants.USR_BIN_PATH + File.separator + "sudo").exists()) {
            sudo = DBCommonPatchingConstants.USR_BIN_PATH + File.separator + "sudo";
        } else if (new File(DBCommonPatchingConstants.USR_LOCAL_BIN_PATH + File.separator + "sudo").exists()) {
            sudo = DBCommonPatchingConstants.USR_LOCAL_BIN_PATH + File.separator + "sudo";
        } else {
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add(BootstrapHelper.getBashCmd());
            cmds.add("-c");
            cmds.add("which sudo");
            int ret = BootstrapHelper.execute(cmds, false);
            if (ret == 0) {
                sudo = "sudo";
            } else {
                throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72032), (Object[])new Object[0]), new Object[0]);
            }
        }
        _logger.info("Sudo path::" + sudo);
        return sudo;
    }

    public static void setPatchworkProperty(String customConfigDir) throws OPatchAutoException {
        String bootStrapPath = customConfigDir + DBCommonPatchingConstants.CONFIG_DBTMP_DIR + "bootstrap_" + DBPatchingHelper.getHostNameWithoutDomain((String)OPatchAutoHelper.getOPatchAutoHost());
        String patchWorkPath = bootStrapPath + File.separator + "patchwork";
        Properties patchingInfoProperty = new Properties();
        patchingInfoProperty.setProperty(BootstrapConstants.PATCHWORK_DIR.getValue(), patchWorkPath);
        String fileLocation = System.getProperty("OPatch.PATCH_INFO_LOCATION");
        BootstrapUtil.storePropertiesFile((Properties)patchingInfoProperty, (String)fileLocation, (boolean)true);
    }

    public static String getBootstrapHome(BootstrapParams.OperationType operationType, boolean isSwitch, String gridHome, String ohList, String baseLocation, boolean isRemoteSession, PatchActionExecutorContainer container) throws OPatchAutoException {
        String clonedHome;
        String bootstrapHome = gridHome;
        boolean isSwitchSession = false;
        boolean hasGridHome = false;
        if (isRemoteSession) {
            if (container != null) {
                if (container.getPatchActionParameterValue(DBProductParameterConstants.OOP_SWITCH_SESSION.getValue()) != null) {
                    isSwitchSession = (Boolean)container.getPatchActionParameterValue(DBProductParameterConstants.OOP_SWITCH_SESSION.getValue());
                }
                if (isSwitchSession && container.getPatchActionParameterValue(DBProductParameterConstants.HAS_CRS_PATCHING.getValue()) != null) {
                    hasGridHome = (Boolean)container.getPatchActionParameterValue(DBProductParameterConstants.HAS_CRS_PATCHING.getValue());
                }
            }
        } else {
            boolean bl = isSwitchSession = BootstrapParams.OperationType.APPLY.equals((Object)operationType) && isSwitch;
            if (isSwitchSession) {
                gridHome = PatchPlanUtils.removeFileSeperatorAtEnd((String)gridHome);
                if (!StringUtil.isNullOrEmpty((String)ohList)) {
                    if (ohList.toLowerCase().contains(gridHome.toLowerCase())) {
                        hasGridHome = true;
                    }
                } else if (DBPatchingHelper.compareFilePath((String)baseLocation, (String)gridHome)) {
                    hasGridHome = true;
                }
            }
        }
        _logger.info("Is switchSession: " + isSwitchSession + " & get cloned home : " + hasGridHome);
        if (hasGridHome && !StringUtil.isNullOrEmpty((String)(clonedHome = BootstrapHelper.getClonedHome(gridHome)))) {
            bootstrapHome = clonedHome;
        }
        _logger.info("The final bootstrap path is  " + bootstrapHome);
        return bootstrapHome;
    }

    public static String getClonedHome(String gridHome) throws OPatchAutoException {
        String clonedHome = "";
        String oopSessionInfoFilePath = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE;
        oopSessionInfoFilePath = oopSessionInfoFilePath.replace("$HOST_NAME", DBPatchingHelper.getHostNameWithoutDomain((String)OPatchAutoHelper.getOPatchAutoHost()));
        File oopSessionInfoFile = new File(gridHome + oopSessionInfoFilePath);
        _logger.finest("The oop session file path is  " + oopSessionInfoFile.getAbsolutePath());
        if (oopSessionInfoFile.exists()) {
            OOPSessionInfoHandler oopSessionInfoHandler = OOPSessionInfoHandler.getInstance();
            OOPSessionCookie cookie = oopSessionInfoHandler.initializeCookie(oopSessionInfoFile);
            List homeInfoList = cookie.getOOPSessionInfo(DBPatchingHelper.getHostNameWithoutDomain((String)DBPatchingHelper.getLocalHost())).getHomeInfoList();
            for (OOPHomeInfo homeInfo : homeInfoList) {
                if (!DBPatchingHelper.compareFilePath((String)gridHome, (String)homeInfo.getOriginalHome())) continue;
                clonedHome = homeInfo.getCloneHome();
                break;
            }
        }
        return clonedHome;
    }

    public static String getPatchWorkDirectory() throws OPatchAutoException, IOException {
        String patchWorkDirectory = "";
        Properties prop = new Properties();
        String patchingInfoLocation = System.getProperty("OPatch.PATCH_INFO_LOCATION");
        if (!StringUtil.isNullOrEmpty((String)patchingInfoLocation) && (prop = BootstrapUtil.loadPropertiesFile((String)patchingInfoLocation)).containsKey(BootstrapConstants.PATCHWORK_DIR.getValue())) {
            patchWorkDirectory = prop.getProperty(BootstrapConstants.PATCHWORK_DIR.getValue());
        }
        return patchWorkDirectory;
    }

    public static void createDirectory(String home, String directory, Credential credential, String permissions) throws OPatchAutoException {
        String mkdirCmd = "mkdir -p -m  " + permissions + " " + directory;
        String owner = credential != null ? credential.getUsername() : DBPatchingHelper.getHomeOwner((String)home);
        File oraInst = new File(home, "oraInst.loc");
        String group = OUIDriver.checkFileGroup((File)oraInst);
        String chownCmd = " chown -R " + owner + ":" + group + " " + directory + "  > /dev/null";
        boolean exists = new File(directory).exists();
        if (credential == null) {
            String currentUser;
            if (!exists) {
                BootstrapHelper.runBashCommand(mkdirCmd);
            }
            if ((currentUser = System.getProperty("user.name")).equals("root")) {
                BootstrapHelper.runBashCommand(chownCmd);
            }
        } else if (ClusterInformationLoader.isGridHome((String)home)) {
            String sudoCmd = "echo '" + new String(credential.getPassword()) + "'" + " | " + BootstrapHelper.getSudoCmd() + " -S -u root ";
            if (!exists) {
                BootstrapHelper.runBashCommand(sudoCmd + mkdirCmd);
            }
            BootstrapHelper.runBashCommand(sudoCmd + chownCmd);
        } else if (!exists) {
            BootstrapHelper.runBashCommand(mkdirCmd);
        }
    }

    public static int runBashCommand(String cmd) throws OPatchAutoException {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(BootstrapHelper.getBashCmd());
        cmds.add("-c");
        cmds.add(cmd);
        int retValue = BootstrapHelper.execute(cmds, false);
        return retValue;
    }
}

